<?php
namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifySellDetailController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\Export;

class SellDetailController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 商品销量
    public function goodsSales(Request $request)
    {
        // 验证数据
        $verify_data = new VerifySellDetailController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['sede_order_number']) || !empty($search_data['goo_bra_id']) || !empty($search_data['goo_cate_id']) || !empty($search_data['sede_goo_id']) || !empty($search_data['shop_id']) || !empty($search_data['chun_id']) || !empty($search_data['sede_orla_id']) || !empty($search_data['ware_freight_space']) || !empty($search_data['goo_goods_encode']) || !empty($search_data['chun_chty_id']) || !empty($search_data['chin_zoning'])) {

            $list_data = DB::table('sell_detail as sede')
                ->leftjoin('goods as goo','goo.goo_id','=','sede.sede_goo_id')
                ->leftjoin('channel_unit as chun','chun.chun_id','=','sede.sede_client_id')
                ->leftjoin('warehouse as w','w.ware_id','=','sede.sede_ware_id')
                ->leftjoin('channel_info as chin','chin.chin_chun_id','=','sede.sede_client_id')
                ->where('sede_cid',$user_info->adm_cid)
                ->where('sede_superior_shop_id',$shop_id)
                ->where('sede_client_type',2)
                ->where('sede_goo_state','!=',2)    //商品状态1正常2删除3回收的商品4换货商品
                ->where(function($query) use($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                        $query->whereBetween('sede_create_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                    }else{
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])){
                            $query->where('sede_create_time','>=',$search_data['start_time']);
                        }else{
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('sede_create_time','<=',$search_data['end_time'].' 23:59:59');
                            }
                        }
                    }
                }) //创建时间
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_order_number'])) {
                        $query->where('sede_order_number','like','%'. $search_data['sede_order_number'].'%');
                    }
                }) //单号编号
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_bra_id'])) {
                        $query->where('goo_bra_id', $search_data['goo_bra_id']);
                    }
                }) //品牌名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_cate_id'])) {
                        $query->where('goo_cate_id', $search_data['goo_cate_id']);
                    }
                }) //品类名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_goo_id'])) {
                        $query->where('sede_goo_id', $search_data['sede_goo_id']);
                    }
                }) //商品名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['shop_id'])) {
                        $query->where('sede_service_shop_id', $search_data['shop_id']);
                    }
                }) //门店名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_id'])) {
                        $query->where('chun_id', $search_data['chun_id']);
                    }
                }) //客户单位
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_orla_id'])) {
                        $query->where('sede_orla_id', $search_data['sede_orla_id']);
                    }
                }) //订单标签
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['ware_freight_space'])) {
                        $query->where('ware_freight_space','like','%'. $search_data['ware_freight_space'].'%');
                    }
                }) //仓位名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_goods_encode'])) {
                        $query->where('goo_goods_encode','like','%'. $search_data['goo_goods_encode'].'%');
                    }
                }) //产品编码
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_chty_id'])) {
                        $query->where('chun_chty_id','like',$search_data['chun_chty_id']);
                    }
                }) //单位类型
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chin_zoning'])) {
                        $query->where('chin_zoning','like', '%'.$search_data['chin_zoning'].'%');
                    }
                }) //业务划区
                ->select('sede_id', 'sede_create_time', 'sede_order_number', 'sede_create_id',
                    'goo_bra_name', 'goo_cate_name', 'goo_name', 'chun_chty_id', 'chun_unit_name',
                    'sede_service_shop_id', 'chun_adm_id', 'sede_goo_quantity', 'sede_goo_price',
                    'sede_amount_price', 'sede_plus_minus', 'chun_search_letter', 'sede_orla_id',
                     'ware_freight_space', 'goo_goods_encode', 'sede_remarks', 'sede_order_type')
                ->orderBy('sede_id','desc')
                ->paginate($this->show_count);
            $list_items = $list_data->items();

            $sum_type = 2;
            $sum_data = DB::table('sell_detail as sede')
                ->leftjoin('goods as goo','goo.goo_id','=','sede.sede_goo_id')
                ->leftjoin('channel_unit as chun','chun.chun_id','=','sede.sede_client_id')
                ->leftjoin('warehouse as w','w.ware_id','=','sede.sede_ware_id')
                ->leftjoin('channel_info as chin','chin.chin_chun_id','=','sede.sede_client_id')
                ->where('sede_cid',$user_info->adm_cid)
                ->where('sede_superior_shop_id',$shop_id)
                ->where('sede_client_type',2)
                ->where(function($query) use($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                        $query->whereBetween('sede_create_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                    }else{
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])){
                            $query->where('sede_create_time','>=',$search_data['start_time']);
                        }else{
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('sede_create_time','<=',$search_data['end_time'].' 23:59:59');
                            }
                        }
                    }
                }) //创建时间
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_order_number'])) {
                        $query->where('sede_order_number','like','%'. $search_data['sede_order_number'].'%');
                    }
                }) //单号编号
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_bra_id'])) {
                        $query->where('goo_bra_id', $search_data['goo_bra_id']);
                    }
                }) //品牌名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_cate_id'])) {
                        $query->where('goo_cate_id', $search_data['goo_cate_id']);
                    }
                }) //品类名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_goo_id'])) {
                        $query->where('sede_goo_id', $search_data['sede_goo_id']);
                    }
                }) //商品名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['shop_id'])) {
                        $query->where('sede_service_shop_id', $search_data['shop_id']);
                    }
                }) //门店名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_id'])) {
                        $query->where('chun_id', $search_data['chun_id']);
                    }
                }) //客户单位
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_orla_id'])) {
                        $query->where('sede_orla_id', $search_data['sede_orla_id']);
                    }
                }) //订单标签
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['ware_freight_space'])) {
                        $query->where('ware_freight_space','like','%'. $search_data['ware_freight_space'].'%');
                    }
                }) //仓位名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_goods_encode'])) {
                        $query->where('goo_goods_encode','like','%'. $search_data['goo_goods_encode'].'%');
                    }
                }) //产品编码
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_chty_id'])) {
                        $query->where('chun_chty_id','like',$search_data['chun_chty_id']);
                    }
                }) //单位类型
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chin_zoning'])) {
                        $query->where('chin_zoning','like', '%'.$search_data['chin_zoning'].'%');
                    }
                }) //业务划区
                ->first(array(
                    \DB::raw('SUM(sede_goo_quantity) as sum_count'),
                    \DB::raw('SUM(sede_amount_price) as sum_price')
                ));
            

            if ($list_items) {
                foreach ($list_items as $key => $value) {
                    $shop_store_id[] = $value->sede_service_shop_id;  //门店id
                    $chty_id[] = $value->chun_chty_id; //单位类型id
                    $adm_id[] = $value->chun_adm_id;   //业务员id
                    $adm_id[] = $value->sede_create_id; //录单人id
                    $orla_id[] = $value->sede_orla_id; //订单标签id
                }
                // 查找单位类型
                $type_info = DB::table('channel_type')
                    ->whereIn('chty_id',$chty_id)
                    ->select('chty_id','chty_name')
                    ->get();
                // 查找业务员
                $adm_info = DB::table('admin')
                    ->whereIn('adm_id',$adm_id)
                    ->select('adm_id','adm_name')
                    ->get();
                // 查找门店
                $shop_info = DB::table('shop')
                    ->whereIn('shop_id',$shop_store_id)
                    ->select('shop_id','shop_store_name')
                    ->get();
                // 查找订单标签
                $orla_info = DB::table('order_label')
                    ->whereIn('orla_id',$orla_id)
                    ->select('orla_id','orla_name')
                    ->get();
            } else {
                $type_info = [];
                $adm_info = [];
                $shop_info = [];
                $orla_info = [];
            }

            $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
            $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data_info['total'] = $list_data->total();               //总数据个数
            $data_info['current_number'] = $this->show_count;        //一页显示多少个
            $data_info['type_info'] = $type_info;                    //单位类型数据
            $data_info['adm_info'] = $adm_info;                      //业务员/录单人数据
            $data_info['shop_info'] = $shop_info;                    //门店数据
            $data_info['orla_info'] = $orla_info;                    //订单标签数据
            $data_info['sum_count'] = empty($sum_data->sum_count)?0:$sum_data->sum_count;   //返回总数量
            $data_info['sum_price'] = empty($sum_data->sum_price)?0:$sum_data->sum_price;   //返回总金额
        } else {
            $list_items = [];
            $sum_type = 1; //隐藏
        }
        $data_info['sum_type'] = $sum_type;   //返回总数量
        $data_info['data'] = $list_items;   //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
    }

    // 商品销量
    public function goodsSales2(Request $request)
    {
        // 验证数据
        $verify_data = new VerifySellDetailController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $search_data = $request->all();

        if(!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['ord_order_number']) || !empty($search_data['ord_create_id']) || !empty($search_data['goo_bra_id']) || !empty($search_data['goo_cate_id']) || !empty($search_data['orgo_goo_id']) || !empty($search_data['shop_id']) || !empty($search_data['chun_id']))
        {
            $list_data = DB::table('order_goods as g')
                ->leftjoin('order as o','g.orgo_ord_id','=','o.ord_id')
                ->leftjoin('goods as goo','g.orgo_goo_id','=','goo.goo_id')
                ->leftjoin('channel_unit as u','o.ord_client_id','=','u.chun_id')
                ->where('ord_cid',$user_info->adm_cid)
                ->where('ord_superior_shop_id',$shop_id)
                ->where('ord_type',2)
                ->where('orgo_state', '!=', 2) //商品状态1.正常 2.删除3回收的商品
                ->where(function($query) use($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                        $query->whereBetween('ord_create_time',[$search_data['start_time'],$search_data['end_time']]);
                    }else{
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])){
                            $query->where('ord_create_time','>=',$search_data['start_time']);
                        }else{
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('ord_create_time','<=',$search_data['end_time']);
                            }
                        }
                    }
                }) //创建时间
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number','like','%'. $search_data['ord_order_number'].'%');
                    }
                }) //单号编号
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['ord_create_id'])) {
                        $query->where('ord_create_id', $search_data['ord_create_id']);
                    }
                }) //录单人员
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_bra_id'])) {
                        $query->where('goo_bra_id', $search_data['goo_bra_id']);
                    }
                }) //品牌名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_cate_id'])) {
                        $query->where('goo_cate_id', $search_data['goo_cate_id']);
                    }
                }) //品类名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['orgo_goo_id'])) {
                        $query->where('orgo_goo_id', $search_data['orgo_goo_id']);
                    }
                }) //商品名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['shop_id'])) {
                        $query->where('ord_shop_id', $search_data['shop_id']);
                    }
                }) //门店名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_id'])) {
                        $query->where('chun_id', $search_data['chun_id']);
                    }
                }) //客户单位
                ->select('orgo_id', 'orgo_goo_name', 'orgo_goo_quantity', 'orgo_goo_price', 'ord_create_time', 
                         'ord_order_number', 'ord_create_id', 'goo_bra_name', 'goo_bra_id', 'goo_cate_name',
                         'goo_cate_id','ord_actual_price','orgo_goo_id','chun_unit_name','chun_chty_id',
                         'chun_adm_id','ord_shop_id','chun_id','ord_delete','orgo_goo_exchange','ord_service_type')
                ->orderBy('orgo_id', 'desc')
                ->paginate($this->show_count);
            $list_items = $list_data->items();

            $sum_type = 2;
            $sum_data = DB::table('order_goods as g')
                    ->leftjoin('order as o','g.orgo_ord_id','=','o.ord_id')
                    ->leftjoin('goods as goo','g.orgo_goo_id','=','goo.goo_id')
                    ->leftjoin('channel_unit as u','o.ord_client_id','=','u.chun_id')
                    ->where('ord_cid',$user_info->adm_cid)
                    ->where('ord_superior_shop_id',$shop_id)
                    ->where('ord_type',2)
                    ->where(function($query) use($search_data) {
                        //如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                            $query->whereBetween('ord_create_time',[$search_data['start_time'],$search_data['end_time']]);
                        }else{
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])){
                                $query->where('ord_create_time','>=',$search_data['start_time']);
                            }else{
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('ord_create_time','<=',$search_data['end_time']);
                                }
                            }
                        }
                    }) //创建时间
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_order_number'])) {
                            $query->where('ord_order_number','like','%'. $search_data['ord_order_number'].'%');
                        }
                    }) //单号编号
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['ord_create_id'])) {
                            $query->where('ord_create_id', $search_data['ord_create_id']);
                        }
                    }) //录单人员
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['goo_bra_id'])) {
                            $query->where('goo_bra_id', $search_data['goo_bra_id']);
                        }
                    }) //品牌名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['goo_cate_id'])) {
                            $query->where('goo_cate_id', $search_data['goo_cate_id']);
                        }
                    }) //品类名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['orgo_goo_id'])) {
                            $query->where('orgo_goo_id', $search_data['orgo_goo_id']);
                        }
                    }) //商品名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['shop_id'])) {
                            $query->where('ord_shop_id', $search_data['shop_id']);
                        }
                    }) //门店名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['chun_id'])) {
                            $query->where('chun_id', $search_data['chun_id']);
                        }
                    }) //客户单位
                    ->first(array(
                            \DB::raw('SUM(orgo_goo_quantity) as sum_count'),
                            \DB::raw('SUM(ord_actual_price) as sum_price')
                        ));
            $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
            $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data_info['total'] = $list_data->total();               //总数据个数
            $data_info['data'] = $list_items;                        //返回数据
        }else{
            $list_data = [];
            $data_info = [];
            $list_items = '';
            $sum_type = 1; //隐藏

        }
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $shop_store_id[] = $value->ord_shop_id;  //门店id
                $chty_id[] = $value->chun_chty_id; //单位类型id
                $adm_id[] = $value->chun_adm_id;   //业务员id
                $adm_id[] = $value->ord_create_id; //录单人id
            }
            // 查找单位类型
            $type_info = DB::table('channel_type')
                    ->whereIn('chty_id',$chty_id)
                    ->get(['chty_id','chty_name']);
            // 查找业务员
            $adm_info = DB::table('admin')
                    ->whereIn('adm_id',$adm_id)
                    ->get(['adm_id','adm_name']);
            // 查找门店
            $shop_info = DB::table('shop')
                    ->whereIn('shop_id',$shop_store_id)
                    ->get(['shop_id','shop_store_name']);

        }else{
            $type_info = [];
            $adm_info = [];
            $shop_info = [];
        }

        
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['type_info'] = $type_info;                	 //单位类型数据
        $data_info['adm_info'] = $adm_info;                      //业务员/录单人数据
        $data_info['shop_info'] = $shop_info;                	 //门店数据
        $data_info['sum_type'] = $sum_type;   //返回总数量
        $data_info['sum_count'] = empty($sum_data->sum_count)?0:$sum_data->sum_count;   //返回总数量
        $data_info['sum_price'] = empty($sum_data->sum_price)?0:$sum_data->sum_price;   //返回总金额

        
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 商品销量导出
    public function export(Request $request)
    {
        $search_data = $request->all();
        if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['sede_order_number']) || !empty($search_data['goo_bra_id']) || !empty($search_data['goo_cate_id']) || !empty($search_data['sede_goo_id']) || !empty($search_data['shop_id']) || !empty($search_data['chun_id']) || !empty($search_data['sede_orla_id']) || !empty($search_data['ware_freight_space']) || !empty($search_data['goo_goods_encode']) || !empty($search_data['chun_chty_id']) || !empty($search_data['chin_zoning'])) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

            $list_data = DB::table('sell_detail as sede')
                ->leftjoin('goods as goo','goo.goo_id','=','sede.sede_goo_id')
                ->leftjoin('channel_unit as chun','chun.chun_id','=','sede.sede_client_id')
                ->leftjoin('warehouse as w','w.ware_id','=','sede.sede_ware_id')
                ->leftjoin('channel_info as chin','chin.chin_chun_id','=','sede.sede_client_id')
                ->where('sede_cid',$user_info->adm_cid)
                ->where('sede_superior_shop_id',$shop_id)
                ->where('sede_client_type',2)
                ->where('sede_goo_state','!=',2)    //商品状态1正常2删除3回收的商品4换货商品
                ->where(function($query) use($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                        $query->whereBetween('sede_create_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                    }else{
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])){
                            $query->where('sede_create_time','>=',$search_data['start_time']);
                        }else{
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('sede_create_time','<=',$search_data['end_time'].' 23:59:59');
                            }
                        }
                    }
                }) //创建时间
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_order_number'])) {
                        $query->where('sede_order_number','like','%'. $search_data['sede_order_number'].'%');
                    }
                }) //单号编号
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_bra_id'])) {
                        $query->where('goo_bra_id', $search_data['goo_bra_id']);
                    }
                }) //品牌名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_cate_id'])) {
                        $query->where('goo_cate_id', $search_data['goo_cate_id']);
                    }
                }) //品类名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_goo_id'])) {
                        $query->where('sede_goo_id', $search_data['sede_goo_id']);
                    }
                }) //商品名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['shop_id'])) {
                        $query->where('sede_service_shop_id', $search_data['shop_id']);
                    }
                }) //门店名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_id'])) {
                        $query->where('chun_id', $search_data['chun_id']);
                    }
                }) //客户单位
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['sede_orla_id'])) {
                        $query->where('sede_orla_id', $search_data['sede_orla_id']);
                    }
                }) //订单标签
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['ware_freight_space'])) {
                        $query->where('ware_freight_space','like','%'. $search_data['ware_freight_space'].'%');
                    }
                }) //仓位名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['goo_goods_encode'])) {
                        $query->where('goo_goods_encode','like','%'. $search_data['goo_goods_encode'].'%');
                    }
                }) //产品编码
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_chty_id'])) {
                        $query->where('chun_chty_id','like',$search_data['chun_chty_id']);
                    }
                }) //单位类型
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chin_zoning'])) {
                        $query->where('chin_zoning','like', '%'.$search_data['chin_zoning'].'%');
                    }
                }) //业务划区
                ->select('sede_create_time', 'sede_order_number', 'sede_create_id', 'goo_bra_name', 'goo_cate_name', 'goo_name', 'goo_goods_encode', 'sede_goo_quantity', 'chun_chty_id', 'chun_unit_name', 'sede_service_shop_id', 'chun_adm_id', 'sede_goo_price', 'sede_amount_price')
                ->orderBy('sede_id','desc')
                ->get();
            $data = json_decode(json_encode($list_data),true);
            // dump($data);exit;
            if (!empty($data)) {
                foreach ($data as $key => $value) {
                    $shop_store_id[] = $value['sede_service_shop_id'];  //门店id
                    $chty_id[] = $value['chun_chty_id']; //单位类型id
                    $adm_id[] = $value['chun_adm_id'];   //业务员id
                    $adm_id[] = $value['sede_create_id']; //录单人id
                    // $orla_id[] = $value['sede_orla_id']; //订单标签id
                }
                $shop_store_id = array_unique($shop_store_id);
                $chty_id = array_unique($chty_id);
                $adm_id = array_unique($adm_id);
                // $orla_id = array_unique($orla_id);

                // 查找单位类型
                $type_info = DB::table('channel_type')->whereIn('chty_id',$chty_id)->pluck('chty_name','chty_id');
                // dump($type_info);exit;
                // 查找门店
                $shop_info = DB::table('shop')->whereIn('shop_id',$shop_store_id)->pluck('shop_store_name','shop_id');
                // 查找业务员/录单人
                $adm_info = DB::table('admin')->whereIn('adm_id',$adm_id)->pluck('adm_name','adm_id');
                // 查找订单标签
                // $orla_info = DB::table('order_label')->whereIn('orla_id',$orla_id)->pluck('orla_id','orla_name');

                foreach ($data as $key => $value) {
                    // 单位类型名称
                    if (isset($type_info[$value['chun_chty_id']])) {
                        $data[$key]['chun_chty_id'] = $type_info[$value['chun_chty_id']];
                    } else {
                        $data[$key]['chun_chty_id'] = '';
                    }
                    // 门店名称
                    if (isset($shop_info[$value['sede_service_shop_id']])) {
                        $data[$key]['sede_service_shop_id'] = $shop_info[$value['sede_service_shop_id']];
                    } else {
                        $data[$key]['sede_service_shop_id'] = '';
                    }
                    // 业务员姓名
                    if (isset($adm_info[$value['chun_adm_id']])) {
                        $data[$key]['chun_adm_id'] = $adm_info[$value['chun_adm_id']];
                    } else {
                        $data[$key]['chun_adm_id'] = '';
                    }
                    // 录单人姓名
                    if ($adm_info[$value['sede_create_id']]) {
                        $data[$key]['sede_create_id'] = $adm_info[$value['sede_create_id']];
                    } else {
                        $data[$key]['sede_create_id'] = '';
                    }
                    // 单价除100
                    $data[$key]['sede_goo_price'] = $data[$key]['sede_goo_price'] / 100;
                    // 合计金额除100
                    $data[$key]['sede_amount_price'] = $data[$key]['sede_amount_price'] / 100;
                }
            } else {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'暂无导出数据']);
            }

            $pathName = storage_path()."/app/public/excel";//获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName,0775,true);
                chmod($pathName,0775);
            }
            $streamFileRand = time() . rand(10000,99999).'.xls';//
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' .$streamFileRand;

            $where['action_name'] = '销售';
            $where['field_name'] = ['创建时间', '单号', '录单人员', '品牌名称', '品类名称', '商品名称', '检索编号', '销售数量', '单位类型', '单位名称', '门店名称', '业务人员', '单价', '合计'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $data      //导出数据
            );

            // 判断文件是否存在 存在则成功  不存在则失败
            if(file_exists($pathName)) {
                return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'storage/excel/'.$streamFileRand]);
            }else{
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'导出失败']);
            }
        }else{
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'请输入搜索条件']);
        }
    }

    // 客户销量
    public function clientSales(Request $request)
    {
        // 验证数据
        $verify_data = new VerifySellDetailController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('channel_sales as s')
            ->leftjoin('channel_unit as u','s.chsa_client_id','=','u.chun_id')
            ->where('chsa_cid',$user_info->adm_cid)
            ->where('chsa_superior_shop_id',$shop_id)
            ->where('chsa_type',2)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chsa_create_time'])) {
                    $query->where('chsa_create_time','like', $search_data['chsa_create_time'].'%');
                }
            }) //创建时间
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chsa_chty_id'])) {
                    $query->where('chsa_chty_id', $search_data['chsa_chty_id']);
                }
            }) //单位类型
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chsa_client_id'])) {
                    $query->where('chsa_client_id', $search_data['chsa_client_id']);
                }
            }) //客户单位
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chun_adm_id'])) {
                    $query->where('chun_adm_id', $search_data['chun_adm_id']);
                }
            }) //业务员
            ->select('chsa_id', 'chsa_create_time', 'chsa_type', 'chsa_chty_id', 'chun_unit_name',
                     'chun_adm_id', 'chsa_ord_number', 'chsa_sales_number', 'chsa_total_price')
            ->orderBy('chsa_id', 'desc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $chty_id[] = $value->chsa_chty_id; //单位类型id
                $adm_id[] = $value->chun_adm_id; //业务员id
            }
            // 查找单位类型
            $type_info = DB::table('channel_type')
                    ->whereIn('chty_id',$chty_id)
                    ->get(['chty_id','chty_name']);
            // 查找业务员
            $adm_info = DB::table('admin')
                    ->whereIn('adm_id',$adm_id)
                    ->get(['adm_id','adm_name']);
        }else{
            $type_info = [];
            $adm_info = [];
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                		 //返回数据
        $data_info['type_info'] = $type_info;                	 //单位类型数据
        $data_info['adm_info'] = $adm_info;                		 //业务员/录单人数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 门店销量
    public function shopSales(Request $request)
    {
        // 验证数据
        $verify_data = new VerifySellDetailController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('shop_sales as acset')
            ->where('shoa_cid',$user_info->adm_cid)
            ->where('shoa_superior_shop_id',$shop_id)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shoa_create_time'])) {
                    $query->where('shoa_create_time','like', '%' . $search_data['shoa_create_time'].'%');
                }
            }) //创建时间
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shoa_type'])) {
                    $query->where('shoa_type', $search_data['shoa_type']);
                }
            }) //门店类型
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shoa_shop_id'])) {
                    $query->where('shoa_shop_id', $search_data['shoa_shop_id']);
                }
            }) //门店名称
            ->select('shoa_id', 'shoa_create_time', 'shoa_type', 'shoa_shop_id', 'shoa_ord_number',
                     'shoa_sales_number', 'shoa_total_price')
            ->orderBy('shoa_id', 'desc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $shoa_shop_id[] = $value->shoa_shop_id; //单位类型id
            }
            // 查找单位类型
            $shop_info = DB::table('shop')
                    ->whereIn('shop_id',$shoa_shop_id)
                    ->get(['shop_id','shop_name']);
        }else{
            $shop_info = [];
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                		 //返回数据
        $data_info['shop_info'] = $shop_info;                	 //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 下拉搜索商品
    public function searchGoods(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        $data_info = DB::table('goods')
            ->where('goo_cid',$user_info->adm_cid)
            ->where('goo_superior_shop_id',$shop_id)
            ->where('goo_delete',1)
            ->where('goo_state',1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['search_data'])) {
                    $query->where('goo_name','like', '%'. $search_data['search_data'].'%');
                }
            }) //商品名称
            ->get(['goo_id', 'goo_name']);

        return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
    }
}
