<?php
namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifyPaymentBillController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Models\Api\AccountingSettlement;

class PaymentBillController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPaymentBillController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        if(!empty($search_data['acpa_original_number']) || !empty($search_data['chun_unit_name']) || !empty($search_data['acpa_acti_id']) | !empty($search_data['acpa_settle_id']) || !empty($search_data['acpa_type']) || !empty($search_data['acpa_chty_id']) || !empty($search_data['chun_phone']) || !empty($search_data['acpa_remark']) || !empty($search_data['start_time']) || !empty($search_data['end_time'])){
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            $list_data = DB::table('accounts_payable as p')
                ->leftJoin('channel_unit as u', 'p.acpa_client_id', '=', 'u.chun_id')
                ->where('acpa_cid',$user_info->adm_cid)
                ->where('acpa_shop_superior_id',$shop_id)
                ->where('acpa_state',1) //只查询出未核销的
                ->where('acpa_belongs_id','=',0)
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_original_number'])) {
                        $query->where('acpa_original_number', 'like', '%'.$search_data['acpa_original_number'].'%' );
                    }
                }) //单号
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_type'])) {
                        $query->where('acpa_type', $search_data['acpa_type'] );
                    }
                }) //单据类型 1.预付款 2.采购账单
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_chty_id'])) {
                        $query->where('acpa_chty_id', $search_data['acpa_chty_id'] );
                    }
                }) //单位类型
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_unit_name'])) {
                        $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%' );
                    }
                }) //单位名称
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['chun_phone'])) {
                        $query->where('chun_phone', 'like', '%'.$search_data['chun_phone'].'%' );
                    }
                }) //客户电话
                ->where(function($query) use($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                        $query->whereBetween('acpa_settle_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                    }else{
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])){
                            $query->where('acpa_settle_time','>=',$search_data['start_time']);
                        }else{
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('acpa_settle_time','<=',$search_data['end_time'].' 23:59:59');
                            }
                        }
                    }
                }) //结款时间
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_settle_id'])) {
                        $query->where('acpa_settle_id', $search_data['acpa_settle_id']);
                    }
                }) //结款人
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_acti_id'])) {
                        $query->where('acpa_acti_id', $search_data['acpa_acti_id']);
                    }
                }) //会计科目
                ->where(function($query) use($search_data) {
                    if (!empty($search_data['acpa_remark'])) {
                        $query->where('acpa_remark', 'like', '%'.$search_data['acpa_remark'].'%');
                    }
                }) //备注
                ->select('acpa_id', 'acpa_original_number', 'acpa_type', 'chun_unit_name', 'acpa_settle_price', 
                         'acpa_settle_time', 'acpa_acti_id', 'acpa_actual_price', 'acpa_state', 'acpa_settle_id', 
                         'chun_name', 'chun_phone', 'acpa_chty_id', 'acpa_remark','acpa_create_time','acpa_yet_receipt','acpa_original_id','acpa_number_id','acpa_zero_price','acpa_plus_minus')
                ->orderBy('acpa_id', 'desc')
                ->paginate($this->show_count);
            $list_items = $list_data->items();
            if ($list_items) {
                foreach ($list_items as $key => $value) {
                    $settle_id[] = $value->acpa_settle_id; //结款人id
                    $acti_id[] = $value->acpa_acti_id; //科目管理id
                    $chty_id[] = $value->acpa_chty_id; //单位类型id
                    if(empty($value->acpa_number_id)){
                        $list_items[$key]->acpa_original_id = 0;
                    } 
                    unset($list_items[$key]->acpa_number_id);
                }

                $positive = DB::table('accounts_payable as p')
                    ->leftJoin('channel_unit as u', 'p.acpa_client_id', '=', 'u.chun_id')
                    ->where('acpa_cid',$user_info->adm_cid)
                    ->where('acpa_shop_superior_id',$shop_id)
                    ->where('acpa_state',1) //只查询出未核销的
                    ->where('acpa_statistics_type',1)
                    ->where('acpa_plus_minus',1)//金额正值
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_original_number'])) {
                            $query->where('acpa_original_number', 'like', '%'.$search_data['acpa_original_number'].'%' );
                        }
                    }) //单号
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_type'])) {
                            $query->where('acpa_type', $search_data['acpa_type'] );
                        }
                    }) //单据类型 1.预付款 2.采购账单
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_chty_id'])) {
                            $query->where('acpa_chty_id', $search_data['acpa_chty_id'] );
                        }
                    }) //单位类型
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['chun_unit_name'])) {
                            $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%' );
                        }
                    }) //单位名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['chun_phone'])) {
                            $query->where('chun_phone', 'like', '%'.$search_data['chun_phone'].'%' );
                        }
                    }) //客户电话
                    ->where(function($query) use($search_data) {
                        //如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                            $query->whereBetween('acpa_settle_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                        }else{
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])){
                                $query->where('acpa_settle_time','>=',$search_data['start_time']);
                            }else{
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('acpa_settle_time','<=',$search_data['end_time'].' 23:59:59');
                                }
                            }
                        }
                    }) //结款时间
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_settle_id'])) {
                            $query->where('acpa_settle_id', $search_data['acpa_settle_id']);
                        }
                    }) //结款人
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_acti_id'])) {
                            $query->where('acpa_acti_id', $search_data['acpa_acti_id']);
                        }
                    }) //会计科目
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_remark'])) {
                            $query->where('acpa_remark', 'like', '%'.$search_data['acpa_remark'].'%');
                        }
                    }) //备注
                    ->select(DB::raw('sum(acpa_settle_price) as acpa_settle_price,sum(acpa_actual_price) as acpa_actual_price,sum(acpa_yet_receipt) as acpa_yet_receipt,sum(acpa_zero_price) as acpa_zero_price'))
                    ->first();

                $minus = DB::table('accounts_payable as p')
                    ->leftJoin('channel_unit as u', 'p.acpa_client_id', '=', 'u.chun_id')
                    ->where('acpa_cid',$user_info->adm_cid)
                    ->where('acpa_shop_superior_id',$shop_id)
                    ->where('acpa_state',1) //只查询出未核销的
                    ->where('acpa_statistics_type',1)
                    ->where('acpa_plus_minus',2)//金额正值
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_original_number'])) {
                            $query->where('acpa_original_number', 'like', '%'.$search_data['acpa_original_number'].'%' );
                        }
                    }) //单号
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_type'])) {
                            $query->where('acpa_type', $search_data['acpa_type'] );
                        }
                    }) //单据类型 1.预付款 2.采购账单
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_chty_id'])) {
                            $query->where('acpa_chty_id', $search_data['acpa_chty_id'] );
                        }
                    }) //单位类型
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['chun_unit_name'])) {
                            $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%' );
                        }
                    }) //单位名称
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['chun_phone'])) {
                            $query->where('chun_phone', 'like', '%'.$search_data['chun_phone'].'%' );
                        }
                    }) //客户电话
                    ->where(function($query) use($search_data) {
                        //如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                            $query->whereBetween('acpa_settle_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                        }else{
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])){
                                $query->where('acpa_settle_time','>=',$search_data['start_time']);
                            }else{
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('acpa_settle_time','<=',$search_data['end_time'].' 23:59:59');
                                }
                            }
                        }
                    }) //结款时间
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_settle_id'])) {
                            $query->where('acpa_settle_id', $search_data['acpa_settle_id']);
                        }
                    }) //结款人
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_acti_id'])) {
                            $query->where('acpa_acti_id', $search_data['acpa_acti_id']);
                        }
                    }) //会计科目
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['acpa_remark'])) {
                            $query->where('acpa_remark', 'like', '%'.$search_data['acpa_remark'].'%');
                        }
                    }) //备注
                    ->select(DB::raw('sum(acpa_settle_price) as acpa_settle_price,sum(acpa_actual_price) as acpa_actual_price,sum(acpa_yet_receipt) as acpa_yet_receipt,sum(acpa_zero_price) as acpa_zero_price'))
                    ->first();

                $acpa_settle_price = $positive->acpa_settle_price - $minus->acpa_settle_price;//实际金额
                $acpa_yet_receipt = $positive->acpa_yet_receipt - $minus->acpa_yet_receipt;//已收金额
                $acpa_zero_price = $positive->acpa_zero_price - $minus->acpa_zero_price;//抹零金额
                // $actual_price = $positive->acpa_actual_price - $minus->acpa_actual_price;//结算金额
                // 欠收 = 结算金额 - 已收 - 抹零
                $bad_crop = ($acpa_settle_price - $acpa_yet_receipt - $acpa_zero_price) / 100;

                // 查找结款人
                $adm_info = DB::table('admin')
                        ->whereIn('adm_id',$settle_id)
                        ->get(['adm_id','adm_name']);

                // 查找会计科目
                $account_info = DB::table('account_title')
                        ->whereIn('acti_id',$acti_id)
                        ->get(['acti_id','acti_course_title']);

                // 查找单位类型
                $type_info = DB::table('channel_type')
                        ->whereIn('chty_id',$chty_id)
                        ->get(['chty_id','chty_name']);
            }else{
                $adm_info = [];
                $account_info = [];
                $type_info = [];
                $bad_crop = 0;
            }

            $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
            $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data_info['total'] = $list_data->total();               //总数据个数
            $data_info['current_number'] = $this->show_count;        //一页显示多少个
            $data_info['data'] = $list_items;                        //返回数据
            $data_info['adm_info'] = $adm_info;                      //结款人数据
            $data_info['account_info'] = $account_info;              //会计科目数据
            $data_info['type_info'] = $type_info;                    //单位类型数据
            $data_info['bad_crop_price'] = $bad_crop;                //统计金额
        }else{
            $data_info['data'] = [];
        }

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
    }

    // 预付款
    public function paymentMoney(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPaymentBillController;
        $error_message = $verify_data->paymentMoneyValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if($request['type'] == 1){
             return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'YFK'.rand(10,99).time().rand(10000,99999)]);
        }
        if (empty($request['acpa_actual_price'])) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'金额不能为0！']);
        }

        // 当前科目的期末余额
        $acti_closing_account = DB::table('account_title')
                ->where('acti_id',$request['acpa_acti_id'])
                ->value('acti_closing_account');
        if ($request['acpa_actual_price'] * 100 > $acti_closing_account) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'当前科目余额不足，无法创建预付款！']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        DB::beginTransaction();
        // 生成应付账单
        $createBill = ReceivableBill::addAccounts(
            $user_info, //用户信息
            1, //类型：1.预付款 2.采购账单
            0, //应收账款id
            0, //原始id(无)
            $request['acpa_original_number'], //应收账款单号/原始号(账单编号)
            2, //客户类型：1.门店零售 2.来往单位
            $request['acpa_client_id'], //会员id/来往单位id
            $request['acpa_client_name'], //来往单位名称
            $request['acpa_actual_price'] * 100, //结算金额
            $request['acpa_settle_time'], //结款时间
            $request['acpa_acti_id'], //会计科目id
            $request['acpa_actual_price'] * 100, //实际金额
            0, //抹零金额
            1,  //状态：1.未核销 2.已核销
            1,  //应收账单id是否是自己 1.不是 2.是
            '',  //备注
            0   //已收金额
        );

        // 添加结款明细记录
        $acset_res = AccountingSettlement::add(
            $user_info,                 // [用户信息]
            8,                          // 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收
            $createBill,                // [与单据类型对应的id]
            $request['acpa_original_number'], // [与单据类型对应的单号]
            2,                     // [买家类型1门店零售2来往单位]
            $request['acpa_client_id'],       // [会员/客户id]
            $request['acpa_client_name'],     // [来往单位名称]
            $request['acpa_acti_id'],         // [会计科目id]
            2,                                // [类型1收入2支出]
            $request['acpa_actual_price']  * 100,// [实际金额](此次的实收金额)
            0,                                // [合计金额](此次的应收金额)
            0,                                // [欠收金额](此次结款后还应收金额)
            0,                                // [抹零金额]
            ''                                // [备注]
        );

        if($createBill && $acset_res){
            Common::addLog($user_info, getRealIp($request), '应付账款','预付款',$request['acpa_original_number'].'预收款新建成功');
            DB::commit();
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'新建预付款成功']);
        }else{
            DB::rollBack();
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'新建预付款失败']);
        }
    }

    // 付款记录详情
    public function details(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPaymentBillController;
        $error_message = $verify_data->detailsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $payable_data = DB::table('accounts_payable')
                    ->where('acpa_id',$request['acpa_id'])
                    ->first(['acpa_create_time', 'acpa_original_number', 'acpa_type', 'acpa_client_name', 'acpa_settle_price',
                             'acpa_actual_price', 'acpa_yet_receipt', 'acpa_zero_price', 
                             'acpa_plus_minus', 'acpa_original_id']);
        if(empty($payable_data)){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'当前应付账款不存在']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 预付款详情
        if($request['type'] == 1){
            $find_data = DB::table('accounts_details as d')
                ->leftJoin('accounts_payable as p', 'p.acpa_id', '=', 'd.acde_advance_id')
                ->where('acpa_id',$request['acpa_id'])
                ->get(['acde_acset_id']);
            $find_data = json_decode(json_encode($find_data),true);
            $acde_acset_id = array_column($find_data, 'acde_acset_id');
    
            $record_data = DB::table('accounting_settlement as a')
                    ->leftJoin('admin as b', 'b.adm_id', '=', 'a.acset_adm_id')
                    ->leftJoin('account_title as c', 'c.acti_id', '=', 'a.acset_acti_id')
                    ->where('acset_adm_cid', $user_info->adm_cid)
                    ->where('acset_superior_shop_id', $shop_id)
                    ->whereIn('acset_id', $acde_acset_id)
                    ->get(['acset_number', 'acset_original_number', 'acset_payment_type','acset_state',
                    'adm_name', 'acset_actual_price', 'acset_create_time', 'acset_with_time', 'acti_course_title']);
        }else{
            switch ($payable_data->acpa_type) {
                case 1://1预付款
                    $acset_type = 8;
                    break;
                case 2:// 2采购账单
                    $acset_type = 4;
                    break;
            }
            // 账单收款记录
            $record_data = DB::table('accounting_settlement as a')
                    ->leftJoin('admin as b', 'b.adm_id', '=', 'a.acset_adm_id')
                    ->leftJoin('account_title as c', 'c.acti_id', '=', 'a.acset_acti_id')
                    ->where('acset_adm_cid', $user_info->adm_cid)
                    ->where('acset_superior_shop_id', $shop_id)
                    ->where('acset_type', $acset_type)//  单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款
                    ->where('acset_original_id', $payable_data->acpa_original_id)
                    ->get(['acset_number', 'acset_original_number', 'acset_payment_type','acset_state',
                    'adm_name', 'acset_actual_price', 'acset_create_time', 'acset_with_time', 'acti_course_title']);
        }
        
        $data['record_data'] = $record_data;
        $data['payable_data'] = $payable_data;
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$data]);
    }

    // 查看详情页面
    public function particulars(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPaymentBillController;
        $error_message = $verify_data->particularsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $list_data = DB::table('accounts_payable as p')
            ->leftJoin('channel_unit as u', 'p.acpa_client_id', '=', 'u.chun_id')
            ->where('acpa_cid',$user_info->adm_cid)
            ->where('acpa_shop_superior_id',$shop_id)
            ->where('acpa_state',1) //只查询出未核销的
            ->where('acpa_belongs_id',$search_data['acpa_original_id'])
            ->where(function($query) use($search_data) {
                if (!empty($search_data['acpa_original_number'])) {
                    $query->where('acpa_original_number', 'like', '%'.$search_data['acpa_original_number'].'%' );
                }
            }) //单号
            ->where(function($query) use($search_data) {
                if (!empty($search_data['acpa_chty_id'])) {
                    $query->where('acpa_chty_id', $search_data['acpa_chty_id'] );
                }
            }) //单位类型
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chun_unit_name'])) {
                    $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%' );
                }
            }) //单位名称
            ->where(function($query) use($search_data) {
                if (!empty($search_data['chun_phone'])) {
                    $query->where('chun_phone', 'like', '%'.$search_data['chun_phone'].'%' );
                }
            }) //客户电话
            ->where(function($query) use($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])){
                    $query->whereBetween('acpa_settle_time',[$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                }else{
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])){
                        $query->where('acpa_settle_time','>=',$search_data['start_time']);
                    }else{
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('acpa_settle_time','<=',$search_data['end_time'].' 23:59:59');
                        }
                    }
                }
            }) //结款时间
            ->where(function($query) use($search_data) {
                if (!empty($search_data['acpa_settle_id'])) {
                    $query->where('acpa_settle_id', $search_data['acpa_settle_id']);
                }
            }) //结款人
            ->where(function($query) use($search_data) {
                if (!empty($search_data['acpa_acti_id'])) {
                    $query->where('acpa_acti_id', $search_data['acpa_acti_id']);
                }
            }) //会计科目
            ->where(function($query) use($search_data) {
                if (!empty($search_data['acpa_remark'])) {
                    $query->where('acpa_remark', 'like', '%'.$search_data['acpa_remark'].'%');
                }
            }) //备注
            ->select('acpa_id', 'acpa_original_number', 'acpa_type', 'chun_unit_name', 'acpa_settle_price', 
                     'acpa_settle_time', 'acpa_acti_id', 'acpa_actual_price', 'acpa_state', 'acpa_settle_id', 
                     'chun_name', 'chun_phone', 'acpa_chty_id', 'acpa_remark','acpa_create_time','acpa_yet_receipt')
            ->orderBy('acpa_id', 'desc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();

        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $settle_id[] = $value->acpa_settle_id; //结款人id
                $acti_id[] = $value->acpa_acti_id; //科目管理id
                $chty_id[] = $value->acpa_chty_id; //单位类型id
                if(empty($value->acpa_number_id)){
                    $list_items[$key]->acpa_original_id = 0;
                }
                unset($list_items[$key]->acpa_number_id);
            }
            // 查找结款人
            $adm_info = DB::table('admin')
                    ->whereIn('adm_id',$settle_id)
                    ->get(['adm_id','adm_name']);

            // 查找会计科目
            $account_info = DB::table('account_title')
                    ->whereIn('acti_id',$acti_id)
                    ->get(['acti_id','acti_course_title']);

        }else{
            $adm_info = [];
            $account_info = [];
        }

        $total_data = DB::table('accounts_payable')
            ->where('acpa_id',$request['acpa_id'])
            ->select('acpa_settle_price','acpa_actual_price','acpa_yet_receipt','acpa_zero_price')
            ->first();

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据
        $data_info['adm_info'] = $adm_info;                      //结款人数据
        $data_info['account_info'] = $account_info;              //会计科目数据
        $data_info['total_data'] = $total_data;                  //搜索统计数据

        // 获取当前列表下的按钮
        // $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
    }
}
