<?php
namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class NetSingleController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('admin as c', 'c.adm_id', '=', 'a.ord_create_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_type', 3)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['adm_name'])) {
                    $query->where('c.adm_name', 'like', '%'.$search_data['adm_name'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%'.$search_data['ord_order_number'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_channel_unit'])) {
                    $query->where('orcl_channel_unit', 'like', '%'.$search_data['orcl_channel_unit'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%'.$search_data['orcl_name'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_phone'])) {
                    $query->where('orcl_phone', 'like', '%'.$search_data['orcl_phone'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_car_num'])) {
                    $query->where('orcl_car_num', 'like', '%'.$search_data['orcl_car_num'].'%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_type'])) {
                    $query->where('ord_type', $search_data['ord_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_type'])) {
                    $query->where('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('a.ord_create_id', $search_data['ord_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_wor_state'])) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_payment_way'])) {
                    $query->where('ord_payment_way', $search_data['ord_payment_way']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_remark'])) {
                    $query->where('ord_remark', 'like', '%'.$search_data['ord_remark'].'%');
                }
            }) //备注
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_orla_id'])) {
                    $query->where('ord_orla_id', $search_data['ord_orla_id']);
                }
            }) //订单标签
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'].' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'].' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_order_type'])) {
                    $query->where('orcl_order_type', $search_data['orcl_order_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_order_type'])) {
                    $query->where('orcl_order_type', $search_data['orcl_order_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_other_system_number'])) {
                    $query->where('ord_other_system_number', 'like', '%'.$search_data['ord_other_system_number'].'%');
                }
            })
            ->select('ord_id', 'adm_name', 'ord_order_number', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'ord_service_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price', 'ord_delete', 'ord_collection_price', 'ord_orla_id', 'ord_plus_minus', 'ord_service_shop_id', 'ord_acti_id', 'ord_acti_row', 'orcl_order_type', 'orcl_consent_state', 'orcl_consent_type', 'orcl_reminder_state', 'ord_order_state', 'ord_other_system_number')
            ->orderBy('ord_id', 'desc')
            ->paginate($this->show_count);

        $list_items = $list_data->items();
        if ($list_items) {
            $ord_id = array_column($list_items, 'ord_id');//订单id
            $ord_orla_id = array_unique(array_column($list_items, 'ord_orla_id'));//订单标签id
            $ord_service_shop_id = array_unique(array_column($list_items, 'ord_service_shop_id'));//服务门店id
            $ord_acti_id = array_unique(array_column($list_items, 'ord_acti_id'));//活动id
            $ord_acti_row = array_unique(array_column($list_items, 'ord_acti_row'));//活动id
            // 查询商品信息
            $order_goods = DB::table('order_goods')
                ->whereIn('orgo_ord_id', $ord_id)
                ->where('orgo_state', '!=', 2)
                ->select('orgo_ord_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'orgo_goo_quantity', 'orgo_is_recycle', 'orgo_collection_price', 'orgo_state', 'orgo_can_assign_quantity', 'orgo_goo_type', 'orgo_recycle_price', 'orgo_recycle_quantity', 'orgo_tem_goo_name as tem_goo_name')
                ->get();

            // 查找操作记录
            $order_log = DB::table('order_log')
                ->whereIn('orlo_ord_id', $ord_id)
                ->orderBy('orlo_id', 'desc')
                ->select('orlo_ord_id', 'orlo_time', 'orlo_create_adm_name', 'orlo_content')
                ->get();

            // 查找所有订单回收金额
            $recycle_price = DB::table('junk_recycle')
                ->whereIn('jur_ord_id', $ord_id)
                ->where('jur_price', '!=', 0)
                ->select(DB::raw('jur_ord_id,jur_price'))
                ->get();

            // 查找订单标签
            $order_label = DB::table('order_label')
                ->whereIn('orla_id', $ord_orla_id)
                ->select('orla_id', 'orla_name')
                ->get();

            // 查找服务门店id
            $shop_name = DB::table('shop')
                ->whereIn('shop_id', $ord_service_shop_id)
                ->select('shop_id', 'shop_store_name', 'shop_type')
                ->get();

            // 查找活动名称
            $acti_name = DB::table('activity')
                ->whereIn('acti_id', $ord_acti_id)
                ->select('acti_id', 'acti_name', 'acti_activity_type')
                ->get()->toArray();
            $acti_id_data = array_column($acti_name, null, 'acti_id');
            foreach ($list_items as $key => $value) {
                if ($value->ord_acti_id) {
                    if ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '1') {//折扣
                        $data_info['find_acdi'][$value->ord_id] = DB::table('activity_discount as acdi')
                            ->where('acdi_acti_id', $value->ord_acti_id)
                            ->where('acdi_row', $value->ord_acti_row)
                            ->select('acdi_acti_id', 'acdi_discount', 'acdi_row')
                            ->first();
                    } elseif ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '2') {// 买送
                        $data_info['find_acdo'][$value->ord_id] = DB::table('activity_donate')
                            ->where('acdo_acti_id', $value->ord_acti_id)
                            ->where('acdo_row', $value->ord_acti_row)
                            ->select('acdo_acti_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                            ->first();
                    } elseif ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '3') {// 买赠
                        $data_info['find_acdos'][$value->ord_id] = DB::table('activity_donate')
                            ->where('acdo_acti_id', $value->ord_acti_id)
                            ->where('acdo_row', $value->ord_acti_row)
                            ->select('acdo_acti_id', 'acdo_purchase_quantity', 'acdo_attached_quantity', 'acdo_row')
                            ->first();
                    } elseif ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '4') {// 满减
                        $data_info['find_acdr'][$value->ord_id] = DB::table('activity_discount_reduction')
                            ->where('acdr_acti_id', $value->ord_acti_id)
                            ->where('acdr_row', $value->ord_acti_row)
                            ->select('acdr_acti_id', 'acdr_reduction_price', 'acdr_credit_price', 'acdr_row')
                            ->first();
                    } elseif ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '5') {// 现结折扣
                        $data_info['find_acdrs'][$value->ord_id] = DB::table('activity_discount_reduction')
                            ->where('acdr_acti_id', $value->ord_acti_id)
                            ->where('acdr_row', $value->ord_acti_row)
                            ->select('acdr_acti_id', 'acdr_reduction_price', 'acdr_discount', 'acdr_row')
                            ->first();
                    } elseif ($acti_id_data[$value->ord_acti_id]->acti_activity_type == '8') {// 大批量采购
                        $data_info['find_acpr'][$value->ord_id] = DB::table('activity_procurement')
                            ->where('acpr_acti_id', $value->ord_acti_id)
                            ->where('acpr_row', $value->ord_acti_row)
                            ->select('acpr_acti_id', 'acpr_recycle_quantity', 'acpr_row', 'acpr_goods_quantity')
                            ->first();
                    }
                }
                if ($value->ord_wor_state == '7') {
                    $list_items[$key]->orcl_name = substr_replace($list_items[$key]->orcl_name, '****', 3, 10);
                    $list_items[$key]->orcl_phone = substr_replace($list_items[$key]->orcl_phone, '****', 3, 8);
                    ;
                    $list_items[$key]->orcl_city = '***';
                    $list_items[$key]->orcl_county = '***';
                    $list_items[$key]->orcl_address = '***';
                }
            }
        } else {
            $order_goods = [];
            $order_log = [];
            $recycle_price = 0;
            $order_label = [];
            $shop_name = [];
            $acti_name = [];
        }

        $state_count = DB::table('order')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where('ord_type', 3)
            ->select(DB::raw('count(*) as count, ord_wor_state'))
            ->groupBy('ord_wor_state')
            ->get();
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据
        $data_info['order_goods'] = $order_goods;                //订单商品数据
        $data_info['state_count'] = $state_count;
        $data_info['recycle_price'] = $recycle_price;            //订单回收金额
        $data_info['order_log'] = $order_log;                    //操作记录
        $data_info['order_label'] = $order_label;                //订单标签
        $data_info['shop_name'] = $shop_name;                //门店名称
        $data_info['acti_name'] = $acti_name;                //活动名称

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
