<?php
namespace App\Http\Controllers\Api\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\AccountControl\VerifyAccountingSettlementController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\AccountingSettlement;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\AccountSubject;
use Psy\VarDumper\Dumper;
use App\Http\Models\Api\YongYou;
use App\Http\Models\Api\YongYous;
use App\Http\Models\Services\AccountControl\AccountSettlement;

// 财务系统 -- 结款明细
class AccountingSettlementController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();

        if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['acset_original_number']) || !empty($search_data['acset_client_id']) || !empty($search_data['acset_adm_id']) || !empty($search_data['acti_course_title']) || !empty($search_data['acset_remark']) || !empty($search_data['start_affirm_time']) || !empty($search_data['end_affirm_time']) || !empty($search_data['max_price']) || !empty($search_data['min_price']) || !empty($search_data['acset_number']) || !empty($search_data['acset_sync_state'])) {
            // 实际金额最小钱数
            if (!empty($search_data['min_price'])) {
                $search_data['min_price'] = $search_data['min_price'] * 100;
            }
            // 实际金额最大钱数
            if (!empty($search_data['max_price'])) {
                $search_data['max_price'] = $search_data['max_price'] * 100;
            }
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            $list_data = DB::table('accounting_settlement as acset')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                ->where('acset_adm_cid', $user_info->adm_cid)
                ->where('acset_superior_shop_id', $shop_id)
                ->where(function ($query) use ($search_data) { //结款时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                        $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])) {
                            $query->where('acset_with_time', '>=', $search_data['start_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('acset_with_time', '<=', $search_data['end_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //确认时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                        $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_affirm_time'])) {
                            $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_affirm_time'])) {
                                $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //实际金额区间搜索
                    // 如果选择最小钱数并且选择最大钱数
                    if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                        $query->whereBetween('acset_price', [$search_data['min_price'], $search_data['max_price']]);
                    } else {
                        // 如果选择最小钱数
                        if (!empty($search_data['min_price'])) {
                            $query->where('acset_price', '>=', $search_data['min_price']);
                        } else {
                            // 如果选择最大钱数
                            if (!empty($search_data['max_price'])) {
                                $query->where('acset_price', '<=', $search_data['max_price']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_inex_type'])) {
                        $query->where('acset_inex_type', $search_data['acset_inex_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //单号
                    if (!empty($search_data['acset_original_number'])) {
                        $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //流水号
                    if (!empty($search_data['acset_number'])) {
                        $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //客户单位
                    if (!empty($search_data['acset_client_name'])) {
                        $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_adm_id'])) {
                        $query->where('acset_adm_id', $search_data['acset_adm_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //银行卡名称
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '!=', '3');
                    }
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '3');
                    }
                })
                ->where(function ($query) use ($search_data) { //备注
                    if (!empty($search_data['acset_remark'])) {
                        $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                    if (!empty($search_data['acset_type'])) {
                        $query->where('acset_type', $search_data['acset_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //状态：1未确认2已确认3部分确认
                    if (!empty($search_data['acset_state'])) {
                        $query->where('acset_state', $search_data['acset_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                    if (!empty($search_data['acset_sync_state'])) {
                        $query->where('acset_sync_state', $search_data['acset_sync_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //客户id
                    if (!empty($search_data['acset_client_id'])) {
                        $query->where('acset_client_id', $search_data['acset_client_id']);
                    }
                })
                ->select('acset_id', 'acset_original_number', 'acset_owe_price', 'acset_zero_price', 'acset_client_name', 'acset_price', 'acset_with_time', 'adm_name', 'acset_remark', 'acti_course_title', 'acset_inex_type', 'acset_actual_price', 'acset_state', 'acset_remit_time', 'acset_number', 'acset_type', 'acset_affirm_time', 'acset_zero_plus_minus', 'acset_sync_state', 'acset_payment_type', 'acset_acti_id', 'acset_client_id', 'acset_original_id')
                ->orderBy('acset_id', 'desc')
                ->paginate($this->show_count);
            $list_items = $list_data->items();
            // 查询门店打印模板
            $shpt_data = DB::table('shop_print_template')
                ->where('shpt_shop_id', $user_info->adm_shop_id)
                ->whereIn('shpt_print_type', [13])
                ->where('shpt_delete', 1)
                ->select('shpt_id', 'shpt_print_type', 'shpt_isdefault')
                ->get()->toArray();
            if (empty($shpt_data)) {
                $shpt_data = [];
            }
            $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
            $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data_info['total'] = $list_data->total();               //总数据个数
            $data_info['current_number'] = $this->show_count;        //一页显示多少个
            $data_info['data'] = $list_items;                       //返回数据
            $data_info['shpt_data'] = $shpt_data;                   //模板id

            if (!empty($list_items)) {
                $positive = DB::table('accounting_settlement as acset')
                    ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                    ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                    ->where('acset_adm_cid', $user_info->adm_cid)
                    ->where('acset_superior_shop_id', $shop_id)
                    ->where('acset_inex_type', 1) //输入减去支出
                    ->where(function ($query) use ($search_data) { //结款时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                            $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time']]);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])) {
                                $query->where('acset_with_time', '>=', $search_data['start_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('acset_with_time', '<=', $search_data['end_time']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //确认时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                            $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_affirm_time'])) {
                                $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_affirm_time'])) {
                                    $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //实际金额
                        // 如果选择最小钱数并且选择最大钱数
                        if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                            $query->whereBetween('acset_price', [$search_data['min_price'], $search_data['max_price']]);
                        } else {
                            // 如果选择最小钱数
                            if (!empty($search_data['min_price'])) {
                                $query->where('acset_price', '>=', $search_data['min_price']);
                            } else {
                                // 如果选择最大钱数
                                if (!empty($search_data['max_price'])) {
                                    $query->where('acset_price', '<=', $search_data['max_price']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_inex_type'])) {
                            $query->where('acset_inex_type', $search_data['acset_inex_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单号
                        if (!empty($search_data['acset_original_number'])) {
                            $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户单位
                        if (!empty($search_data['acset_client_name'])) {
                            $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //流水号
                        if (!empty($search_data['acset_number'])) {
                            $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_adm_id'])) {
                            $query->where('acset_adm_id', $search_data['acset_adm_id']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //银行卡名称
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '!=', '3');
                        }
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '3');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //备注
                        if (!empty($search_data['acset_remark'])) {
                            $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                        if (!empty($search_data['acset_type'])) {
                            $query->where('acset_type', $search_data['acset_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //1未确认2已确认3部分确认
                        if (!empty($search_data['acset_state'])) {
                            $query->where('acset_state', $search_data['acset_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                        if (!empty($search_data['acset_sync_state'])) {
                            $query->where('acset_sync_state', $search_data['acset_sync_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户id
                        if (!empty($search_data['acset_client_id'])) {
                            $query->where('acset_client_id', $search_data['acset_client_id']);
                        }
                    })
                    ->select(DB::raw('sum(acset_actual_price) as acset_actual_price'))
                    ->first();
                $minus = DB::table('accounting_settlement as acset')
                    ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                    ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                    ->where('acset_adm_cid', $user_info->adm_cid)
                    ->where('acset_superior_shop_id', $shop_id)
                    ->where('acset_inex_type', 2) //输入减去支出
                    ->where(function ($query) use ($search_data) { //结款时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                            $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])) {
                                $query->where('acset_with_time', '>=', $search_data['start_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('acset_with_time', '<=', $search_data['end_time'] . ' 23:59:59');
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //确认时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                            $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_affirm_time'])) {
                                $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_affirm_time'])) {
                                    $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //实际金额
                        // 如果选择最小钱数并且选择最大钱数
                        if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                            $query->whereBetween('acset_actual_price', [$search_data['min_price'], $search_data['max_price']]);
                        } else {
                            // 如果选择最小钱数
                            if (!empty($search_data['min_price'])) {
                                $query->where('acset_actual_price', '>=', $search_data['min_price']);
                            } else {
                                // 如果选择最大钱数
                                if (!empty($search_data['max_price'])) {
                                    $query->where('acset_actual_price', '<=', $search_data['max_price']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_inex_type'])) {
                            $query->where('acset_inex_type', $search_data['acset_inex_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单号
                        if (!empty($search_data['acset_original_number'])) {
                            $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户单位
                        if (!empty($search_data['acset_client_name'])) {
                            $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //流水号
                        if (!empty($search_data['acset_number'])) {
                            $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_adm_id'])) {
                            $query->where('acset_adm_id', $search_data['acset_adm_id']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //银行卡名称
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '!=', '3');
                        }
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '3');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //备注
                        if (!empty($search_data['acset_remark'])) {
                            $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                        if (!empty($search_data['acset_type'])) {
                            $query->where('acset_type', $search_data['acset_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //状态：1未确认2已确认3部分确认
                        if (!empty($search_data['acset_state'])) {
                            $query->where('acset_state', $search_data['acset_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                        if (!empty($search_data['acset_sync_state'])) {
                            $query->where('acset_sync_state', $search_data['acset_sync_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户id
                        if (!empty($search_data['acset_client_id'])) {
                            $query->where('acset_client_id', $search_data['acset_client_id']);
                        }
                    })
                    ->select(DB::raw('sum(acset_actual_price) as acset_actual_price'))
                    ->first();

                $recr_id = [];
                $acti_id = [];
                foreach ($list_items as $key => $value) {
                    if ($value->acset_payment_type == 3) {
                        $recr_id[] = $value->acset_acti_id;
                    } else {
                        $acti_id[] = $value->acset_acti_id;
                    }
                }

                if (!empty($acti_id)) {
                    $acti_data  = DB::table('account_title')
                        ->whereIn('acti_id', $acti_id)
                        ->pluck('acti_course_title', 'acti_id');
                }
                if (!empty($recr_id)) {
                    $recr_data = DB::table('receivable_credit')
                        ->whereIn('recr_id', $recr_id)
                        ->pluck('recr_original_number', 'recr_id');
                }

                $acset_client_id = array_unique(array_column($list_items, 'acset_client_id')); //选择的客户id，会员id/单位id
                // 查询客户单位
                $channel = DB::table('channel_unit')
                    ->whereIn('chun_id', $acset_client_id)
                    ->where('chun_shop_id', $shop_id)
                    ->where('chun_state', '1')
                    ->pluck('chun_unit_name', 'chun_id')
                    ->toArray();
                // 查询订单单号
                $acset_original_id = array_unique(array_column($list_items, 'acset_original_id'));
                $acset_original_number = array_unique(array_column($list_items, 'acset_original_number'));
                $work_order = DB::table('work_order')
                    ->where('wor_cid', $user_info->adm_cid)
                    ->where('wor_shop_id', $shop_id)
                    ->whereIn('wor_id', $acset_original_id)
                    ->whereIn('wor_number', $acset_original_number)
                    ->select('wor_id', 'wor_order_id', 'wor_order_number')
                    ->get()->toArray();
                $work_order = json_decode(json_encode($work_order), true);
                foreach ($work_order as $k => $v) {
                    $wor_order_number[$v['wor_id']] = $v['wor_order_number'];
                }
                foreach ($list_items as $key => $value) {
                    if ($value->acset_payment_type == 3) {
                        $course_title = isset($recr_data[$value->acset_acti_id]) ? $recr_data[$value->acset_acti_id] : '';
                        $list_items[$key]->acti_course_title = '预收款抵账(' . $course_title . ')';
                    } else {
                        $list_items[$key]->acti_course_title = isset($acti_data[$value->acset_acti_id]) ? $acti_data[$value->acset_acti_id] : '';
                    }
                    // 客户单位名称
                    if (isset($channel[$value->acset_client_id])) {
                        $list_items[$key]->acset_client_name = $channel[$value->acset_client_id];
                    } else {
                        $list_items[$key]->acset_client_name = $value->acset_client_name;
                    }
                    // 订单单号
                    if (isset($wor_order_number[$value->acset_original_id])) {
                        $list_items[$key]->order_number = $wor_order_number[$value->acset_original_id];
                    } else {
                        $list_items[$key]->order_number = '';
                    }
                    unset($list_items[$key]->acset_client_id);
                }

                $data_info['bad_crop_price'] = ($positive->acset_actual_price - $minus->acset_actual_price) / 100;
                $acset_id = array_column($list_items, 'acset_id'); //凭证id
                // 查询凭证借贷表信息
                $volo_data = DB::table('accounting_settlement_loan')
                    ->whereIn('acsl_acset_id', $acset_id)
                    ->select('acsl_acset_id', 'acsl_type', 'acsl_borrow_subject', 'acsl_borrow_subject_name', 'acsl_borrow_price', 'acsl_loan_subject', 'acsl_loan_subject_name', 'acsl_loan_price', 'acsl_borrow_costing', 'acsl_borrow_costing_subject', 'acsl_borrow_costing_name', 'acsl_loan_costing', 'acsl_loan_costing_subject', 'acsl_loan_costing_name')
                    ->get();
                $data_info['volo_data'] = $volo_data;                //订单商品数据
            }
        } else {
            $data_info['data'] = [];
        }

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
    }

    // 详情查看
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->infoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $find_acset = DB::table('accounting_settlement as acset')
            ->where('acset_id', $request['acset_id'])
            ->select('acset_number', 'acset_type', 'acset_price', 'acset_original_id', 'acset_original_number', 'acset_img', 'acset_remark', 'acset_actual_price', 'acset_zero_price')
            ->first();
        // acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
        if ($find_acset->acset_type == 1) { //订单收款
            $find_acset->acset_img = DB::table('order_client')
                ->where('orcl_ord_id', $find_acset->acset_original_id)
                ->value('orcl_img');
            $order_data = DB::table('order as o')
                ->leftJoin('admin as a', 'o.ord_create_id', '=', 'a.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_create_time', 'ord_order_number', 'ord_create_id', 'ord_order_price', 'ord_actual_price', 'adm_name as ord_create_name', 'ord_collection_price', 'ord_plus_minus')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == 2) { //2订单账单
            // 当前账单下的订单信息
            $order_data = DB::table('order as o')
                ->leftJoin('admin as a', 'o.ord_create_id', '=', 'a.adm_id')
                ->where('ord_orbi_id', $find_acset->acset_original_id)
                ->where('ord_collection_bill', 1)
                ->select('ord_create_time', 'ord_order_number', 'ord_create_id', 'ord_order_price', 'ord_actual_price', 'adm_name as ord_create_name', 'ord_collection_price', 'ord_plus_minus')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == 3) { //工单账单
            $order_data = DB::table('work_order as wor')
                ->leftJoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_create_id')
                ->where('wor_wobi_id', $find_acset->acset_original_id)
                ->where('wor_collection_bill', 1)
                ->select('wor_create_time as ord_create_time', 'wor_number as ord_order_number', 'wor_actual_price as ord_actual_price', 'adm_name as ord_create_name', 'wor_collection_bill as ord_collection_bill')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == 4) { //采购账单
            $order_data = DB::table('purchase_order')
                ->where('is_del', 1)
                ->where('cg_zdnumber', $find_acset->acset_original_number)
                ->select('create_time as ord_create_time', 'cg_number as ord_order_number', 'cg_amount as ord_actual_price', 'cg_creator as adm_name')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == 6) { //6预收款
            $order_data = DB::table('receivable_credit as recr')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'recr.recr_settle_id')
                ->where('recr_id', $find_acset->acset_original_id)
                ->select('recr_original_number', 'adm_name', 'recr_settle_price', 'recr_plus_minus', 'recr_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '9') { //受托代收(订单代收)
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '11') { //订单退款
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get()->toArray();
            if ($order_data) {
                foreach ($order_data as $key => $value) {
                    if ($value->ord_actual_price < 0) {
                        $order_data[$key]->ord_actual_price = abs($value->ord_actual_price);
                        $order_data[$key]->ord_plus_minus = 2;
                    } else {
                        $order_data[$key]->ord_plus_minus = 1;
                    }
                    if ($value->ord_order_price < 0) {
                        $order_data[$key]->ord_order_price = abs($value->ord_order_price);
                    }
                }
            }
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '12') { //工单代收(委托代收)
            $order_data = DB::table('work_order as wor')
                ->leftjoin('admin as adm', 'wor.wor_create_id', '=', 'adm.adm_id')
                ->where('wor_id', $find_acset->acset_original_id)
                ->select('wor_number', 'adm_name', 'wor_actual_price', 'wor_collection_price', 'wor_plus_minus', 'wor_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '13') { //订单完成后结算
            $find_acset->acset_img = DB::table('order_client')
                ->where('orcl_ord_id', $find_acset->acset_original_id)
                ->value('orcl_img');
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '14') { //非实物开单
            $order_data = DB::table('receivable_credit as recr')
                ->where('recr_id', $find_acset->acset_original_id)
                ->select('recr_original_number', 'recr_settle_price', 'recr_actual_price', 'recr_create_time', 'recr_plus_minus')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '15') { //订单冲单
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '16') { //加盟店订单收款
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '17') { //加盟店订单代收
            $order_data = DB::table('order as ord')
                ->leftjoin('admin as adm', 'ord.ord_create_id', '=', 'adm.adm_id')
                ->where('ord_id', $find_acset->acset_original_id)
                ->select('ord_order_number', 'adm_name', 'ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '18') { //工单结算
            $order_data = DB::table('work_order as wor')
                ->leftjoin('admin as adm', 'wor.wor_create_id', '=', 'adm.adm_id')
                ->where('wor_id', $find_acset->acset_original_id)
                ->select('wor_number', 'adm_name', 'wor_actual_price', 'wor_collection_price', 'wor_plus_minus', 'wor_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '19') { //旧货回收
            $order_data = DB::table('junk_recycle as jur')
                ->leftjoin('admin as adm', 'jur.jur_create_adm_id', '=', 'adm.adm_id')
                ->where('jur_id', $find_acset->acset_original_id)
                ->select('jur_number', 'adm_name', 'jur_price', 'jur_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '20') { //售后单
            $order_data = DB::table('order_after as oraf')
                ->leftjoin('admin as adm', 'oraf.oraf_create_id', '=', 'adm.adm_id')
                ->where('oraf_id', $find_acset->acset_original_id)
                ->select('oraf_number', 'adm_name', 'oraf_order_price', 'oraf_collection_price', 'oraf_create_time', 'oraf_plus_minus')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '21') { //销售出库单
            $order_data = DB::table('sell')
                ->leftjoin('admin as adm', 'sell.sell_adm_id', '=', 'adm.adm_id')
                ->where('sell_id', $find_acset->acset_original_id)
                ->select('sell_number', 'adm_name', 'sell_price', 'sell_actual_price', 'sell_create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '22') { // 采购入库单
            $order_data = DB::table('ware_inorder as wain')
                ->leftjoin('purchase_order as puor', 'puor.cg_number', '=', 'wain.cg_number')
                ->where('rk_id', $find_acset->acset_original_id)
                ->select('rk_number', 'rk_creator', 'rk_amount as cg_amount', 'wain.create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '23') { // 采购出库单
            $order_data = DB::table('ware_inorder as wain')
                ->leftjoin('purchase_order as puor', 'puor.cg_number', '=', 'wain.cg_number')
                ->where('rk_id', $find_acset->acset_original_id)
                ->select('rk_number as cg_number', 'rk_creator as cg_creator', 'rk_amount as cg_amount', 'wain.create_time')
                ->get();
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '24') { //预付款
            $order_data = DB::table('purchase_order')
                ->where('cg_id', $find_acset->acset_original_id)
                ->select('cg_number', 'cg_creator', 'cg_amount', 'create_time')
                ->get()->toArray();
            foreach ($order_data as $k => $v) {
                $order_data[$k]->cg_amount = $find_acset->acset_price;
            }
            $data['order_data'] = $order_data;
        } elseif ($find_acset->acset_type == '27') { //易损件
            // 当前账单下的订单信息
            $order_data = DB::table('order as o')
                ->leftJoin('admin as a', 'o.ord_create_id', '=', 'a.adm_id')
                ->where('ord_orbi_id', $find_acset->acset_original_id)
                ->where('ord_collection_bill', 1)
                ->select('ord_create_time', 'ord_order_number', 'ord_create_id', 'ord_order_price', 'ord_actual_price', 'adm_name as ord_create_name', 'ord_collection_price', 'ord_plus_minus')
                ->get();
            $data['order_data'] = $order_data;
        }
        $data['acset_data'] = $find_acset;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 打印
    public function print(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['acset_original_number']) || !empty($search_data['acset_client_id']) || !empty($search_data['acset_adm_id']) || !empty($search_data['acti_course_title']) || !empty($search_data['acset_remark']) || !empty($search_data['start_affirm_time']) || !empty($search_data['end_affirm_time']) || !empty($search_data['max_price']) || !empty($search_data['min_price']) || !empty($search_data['acset_number']) || !empty($search_data['acset_sync_state'])) {
            // 实际金额最小钱数
            if (!empty($search_data['min_price'])) {
                $search_data['min_price'] = $search_data['min_price'] * 100;
            }
            // 实际金额最大钱数
            if (!empty($search_data['max_price'])) {
                $search_data['max_price'] = $search_data['max_price'] * 100;
            }

            $list_data = DB::table('accounting_settlement as acset')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                ->where('acset_adm_cid', $user_info->adm_cid)
                ->where('acset_superior_shop_id', $shop_id)
                ->where(function ($query) use ($search_data) { //结款时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                        $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])) {
                            $query->where('acset_with_time', '>=', $search_data['start_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('acset_with_time', '<=', $search_data['end_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //确认时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                        $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_affirm_time'])) {
                            $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_affirm_time'])) {
                                $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //实际金额区间搜索
                    // 如果选择最小钱数并且选择最大钱数
                    if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                        $query->whereBetween('acset_price', [$search_data['min_price'], $search_data['max_price']]);
                    } else {
                        // 如果选择最小钱数
                        if (!empty($search_data['min_price'])) {
                            $query->where('acset_price', '>=', $search_data['min_price']);
                        } else {
                            // 如果选择最大钱数
                            if (!empty($search_data['max_price'])) {
                                $query->where('acset_price', '<=', $search_data['max_price']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_inex_type'])) {
                        $query->where('acset_inex_type', $search_data['acset_inex_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //单号
                    if (!empty($search_data['acset_original_number'])) {
                        $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //流水号
                    if (!empty($search_data['acset_number'])) {
                        $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //客户单位
                    if (!empty($search_data['acset_client_name'])) {
                        $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_adm_id'])) {
                        $query->where('acset_adm_id', $search_data['acset_adm_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //银行卡名称
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '!=', '3');
                    }
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '3');
                    }
                })
                ->where(function ($query) use ($search_data) { //备注
                    if (!empty($search_data['acset_remark'])) {
                        $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                    if (!empty($search_data['acset_type'])) {
                        $query->where('acset_type', $search_data['acset_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //状态：1未确认2已确认3部分确认
                    if (!empty($search_data['acset_state'])) {
                        $query->where('acset_state', $search_data['acset_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                    if (!empty($search_data['acset_sync_state'])) {
                        $query->where('acset_sync_state', $search_data['acset_sync_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //客户id
                    if (!empty($search_data['acset_client_id'])) {
                        $query->where('acset_client_id', $search_data['acset_client_id']);
                    }
                })
                ->select(['acset_id', 'acset_original_number', 'acset_owe_price', 'acset_zero_price', 'acset_client_name', 'acset_price', 'acset_with_time', 'adm_name', 'acset_remark', 'acti_course_title', 'acset_inex_type', 'acset_actual_price', 'acset_client_id'])
                ->orderBy('acset_id', 'desc')
                ->get()->toArray();
            $acset_client_id = array_unique(array_column($list_data, 'acset_client_id')); //选择的客户id，会员id/单位id
            // 查询客户单位
            $channel_name = DB::table('channel_unit')
                ->whereIn('chun_id', $acset_client_id)
                ->where('chun_shop_id', $shop_id)
                ->where('chun_state', '1')
                ->pluck('chun_unit_name', 'chun_id')
                ->toArray();
            foreach ($list_data as $key => $value) {
                // 客户单位名称
                if (isset($channel_name[$value->acset_client_id])) {
                    $list_data[$key]->acset_client_name = $channel_name[$value->acset_client_id];
                } else {
                    $list_data[$key]->acset_client_name = $value->acset_client_name;
                }
                unset($list_data[$key]->acset_client_id);
            }

            if ($list_data) {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入搜索条件']);
        }
    }

    // 导出
    public function export(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();

        if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['acset_original_number']) || !empty($search_data['acset_client_id']) || !empty($search_data['acset_adm_id']) || !empty($search_data['acti_course_title']) || !empty($search_data['acset_remark']) || !empty($search_data['start_affirm_time']) || !empty($search_data['end_affirm_time']) || !empty($search_data['max_price']) || !empty($search_data['min_price']) || !empty($search_data['acset_number']) || !empty($search_data['acset_sync_state'])) {
            // 实际金额最小钱数
            if (!empty($search_data['min_price'])) {
                $search_data['min_price'] = $search_data['min_price'] * 100;
            }
            // 实际金额最大钱数
            if (!empty($search_data['max_price'])) {
                $search_data['max_price'] = $search_data['max_price'] * 100;
            }
            $data = DB::table('accounting_settlement as acset')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                ->where('acset_adm_cid', $user_info->adm_cid)
                ->where('acset_superior_shop_id', $shop_id)
                ->where(function ($query) use ($search_data) { //结款时间
                    // 如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                        $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_time'])) {
                            $query->where('acset_with_time', '>=', $search_data['start_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_time'])) {
                                $query->where('acset_with_time', '<=', $search_data['end_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //确认时间
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                        $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['start_affirm_time'])) {
                            $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['end_affirm_time'])) {
                                $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //实际金额区间搜索
                    // 如果选择最小钱数并且选择最大钱数
                    if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                        $query->whereBetween('acset_price', [$search_data['min_price'], $search_data['max_price']]);
                    } else {
                        // 如果选择最小钱数
                        if (!empty($search_data['min_price'])) {
                            $query->where('acset_price', '>=', $search_data['min_price']);
                        } else {
                            // 如果选择最大钱数
                            if (!empty($search_data['max_price'])) {
                                $query->where('acset_price', '<=', $search_data['max_price']);
                            }
                        }
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_inex_type'])) {
                        $query->where('acset_inex_type', $search_data['acset_inex_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //单号
                    if (!empty($search_data['acset_original_number'])) {
                        $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //流水号
                    if (!empty($search_data['acset_number'])) {
                        $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //客户单位
                    if (!empty($search_data['acset_client_name'])) {
                        $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //结款人
                    if (!empty($search_data['acset_adm_id'])) {
                        $query->where('acset_adm_id', $search_data['acset_adm_id']);
                    }
                })
                ->where(function ($query) use ($search_data) { //银行卡名称
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '!=', '3');
                    }
                    if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                        $query->where('acset_acti_id', $search_data['acti_course_title'])
                            ->where('acset_payment_type', '3');
                    }
                })
                ->where(function ($query) use ($search_data) { //备注
                    if (!empty($search_data['acset_remark'])) {
                        $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                    if (!empty($search_data['acset_type'])) {
                        $query->where('acset_type', $search_data['acset_type']);
                    }
                })
                ->where(function ($query) use ($search_data) { //1未确认2已确认3部分确认
                    if (!empty($search_data['acset_state'])) {
                        $query->where('acset_state', $search_data['acset_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                    if (!empty($search_data['acset_sync_state'])) {
                        $query->where('acset_sync_state', $search_data['acset_sync_state']);
                    }
                })
                ->where(function ($query) use ($search_data) { //客户id
                    if (!empty($search_data['acset_client_id'])) {
                        $query->where('acset_client_id', $search_data['acset_client_id']);
                    }
                })
                ->select(['acset_original_number', 'acset_original_id', 'acset_client_name', 'adm_name', 'acset_with_time', 'acset_price', 'acti_course_title', 'acset_actual_price', 'acset_owe_price', 'acset_zero_price', 'acset_remark', 'acset_type', 'acset_inex_type', 'acset_client_id'])
                ->orderBy('acset_id', 'desc')
                ->get()->toArray();
            $data = json_decode(json_encode($data), true);
            if (empty($data)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合搜索条件的数据！']);
            }
            $acset_client_id = array_unique(array_column($data, 'acset_client_id')); //选择的客户id，会员id/单位id
            // 查询客户单位
            $channel_name = DB::table('channel_unit')
                ->whereIn('chun_id', $acset_client_id)
                ->where('chun_shop_id', $shop_id)
                ->where('chun_state', '1')
                ->pluck('chun_unit_name', 'chun_id')
                ->toArray();
            // 查询订单单号
            $acset_original_id = array_unique(array_column($data, 'acset_original_id'));
            $acset_original_number = array_unique(array_column($data, 'acset_original_number'));
            $work_order = DB::table('work_order')
                ->where('wor_cid', $user_info->adm_cid)
                ->where('wor_shop_id', $shop_id)
                ->whereIn('wor_id', $acset_original_id)
                ->whereIn('wor_number', $acset_original_number)
                ->select('wor_id', 'wor_order_id', 'wor_order_number')
                ->get()->toArray();
            $work_order = json_decode(json_encode($work_order), true);
            foreach ($work_order as $k => $v) {
                $wor_order_number[$v['wor_id']] = $v['wor_order_number'];
            }
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }
            foreach ($data as $key => $value) {
                if ($value['acset_type'] == 4 || $value['acset_inex_type'] == 2) {
                    $data[$key]['acset_price'] = '-' . $value['acset_price'] / 100; //合计金额
                    $data[$key]['acset_actual_price'] = '-' . $value['acset_actual_price'] / 100; //实际金额
                    $data[$key]['acset_owe_price'] = '-' . $value['acset_owe_price'] / 100; //欠收金额
                    $data[$key]['acset_zero_price'] = '-' . $value['acset_zero_price'] / 100; //欠收金额
                } else {
                    $data[$key]['acset_price'] = $value['acset_price'] / 100; //合计金额
                    $data[$key]['acset_actual_price'] = $value['acset_actual_price'] / 100; //实际金额
                    $data[$key]['acset_owe_price'] = $value['acset_owe_price'] / 100; //欠收金额
                    $data[$key]['acset_zero_price'] = $value['acset_zero_price'] / 100; //欠收金额
                }
                // 客户单位名称
                if (isset($channel_name[$value['acset_client_id']])) {
                    $data[$key]['acset_client_name'] = $channel_name[$value['acset_client_id']];
                } else {
                    $data[$key]['acset_client_name'] = $value['acset_client_name'];
                }
                // 订单单号
                if (isset($wor_order_number[$value['acset_original_id']])) {
                    $data[$key]['acset_original_id'] = $wor_order_number[$value['acset_original_id']];
                } elseif ($value['acset_type'] == '1' || $value['acset_type'] == '9' || $value['acset_type'] == '11' || $value['acset_type'] == '13' || $value['acset_type'] == '17') {
                    $data[$key]['acset_original_id'] = $value['acset_original_number'];
                } else {
                    $data[$key]['acset_original_id'] = '';
                }
                unset($data[$key]['acset_client_id']);
                unset($data[$key]['acset_type']);
                unset($data[$key]['acset_inex_type']);
            }
            $streamFileRand = '结款明细' . time() . rand(1000, 9999) . '.xls';
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '结款明细';
            $where['field_name'] = [
                '单号', '订单号', '单位名称', '结款人', '结款时间', '合计金额', '会计科目', '实际金额', '欠收金额',
                '抹零金额', '备注'
            ];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $data      //导出数据
            );

            // 判断文件是否存在 存在则成功  不存在则失败
            if (file_exists($pathName)) {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入搜索条件']);
        }
    }

    // 核对更改为确认
    public function check(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->checkValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 判断当前结款明细是否存在
        $settlement_data = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->first(['acset_id', 'acset_original_number', 'acset_type', 'acset_state', 'acset_original_id', 'acset_inex_type', 'acset_actual_price', 'acset_zero_price', 'acset_acti_id', 'acset_payment_type', 'acset_merge_type', 'acset_price', 'acset_number', 'acset_zero_plus_minus', 'acset_price']);
        if (empty($settlement_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细不存在']);
        }
        if ($settlement_data->acset_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细已核对']);
        }

        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        DB::beginTransaction();

        // 结款明细核对需要做的有
        // 1. 更改状态、汇款时间、备注
        $update_data['acset_state'] = 2; //状态：1未核对2已核对
        $update_data['acset_affirm_time'] = date('Y-m-d H:i:s'); //确认时间
        $update_data['acset_remit_time'] = $request['acset_with_time']; //汇款时间
        $update_data['acset_remark'] = $request['acset_remark'] ? $request['acset_remark'] : ''; //备注
        $update_data['acset_update_time'] = date('Y-m-d H:i:s'); //更新时间
        $update_data['acset_adm_id'] = $user_info->adm_id;
        $acset_res = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->update($update_data);
        // 如果类型是订单代收
        if ($settlement_data->acset_type == 9) {
            $type = DB::table('receivable_credit')
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->where('recr_account_type', 2)
                ->value('recr_leisurely_type');
            if ($type == 1) {
                $type = 2;
            }
            if ($type == 3) {
                $type = 4;
            }
            $leisurely_data['recr_leisurely_type'] = $type;
            $leisurely_data['recr_update_time'] = date('Y-m-d H:i:s');
            //如果等于4把状态改为消核
            if ($type == 4) {
                $leisurely_data['recr_state'] = 2;
            }
            $leisurely_type = DB::table('receivable_credit')
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->where('recr_account_type', 2)
                ->update($leisurely_data);
        } else {
            $leisurely_type = true;
        }
        // 是否操作科目数据1操作  2不操作
        $deduction = 1;
        // acset_payment_type 结款类型1.抹零 2.分期结款 3.预收款抵账4正常5收款6还款
        // acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
        if ($settlement_data->acset_payment_type == 3 || $settlement_data->acset_type == 10 || $settlement_data->acset_type == 21 || $settlement_data->acset_type == 22 || $settlement_data->acset_type == 23) {
            $deduction = 2;
        }
        // $deduction 1操作科目数据  2不操作科目数据
        if ($deduction == 1) {
            // 2. 将结款明细中的金额，在对应的科目中添加/减去，是以汇款时间为准
            $acti_res = AccountSubject::Subject(
                $user_info, //用户信息
                $settlement_data->acset_inex_type, //类型：1借(汇入)2贷(汇出)
                $settlement_data->acset_actual_price, //金额
                // $settlement_data->acset_acti_id,//科目id
                !empty($request['recr_acti_id']) ? $request['recr_acti_id'] : $settlement_data->acset_acti_id, //科目id
                $request['acset_with_time'] //汇款时间
            );
            if ($acti_res['code'] == 500) {
                DB::rollBack();
                return response()->json($acti_res);
            } else {
                $acti_res = true;
            }
        } else {
            $acti_res = true;
        }
        // 订单结算核对之后修改订单状态
        if ($settlement_data->acset_type == 1) {
            // ord_state 结算状态1未结算2结算中3已结算4已代收
            $order_update = DB::table('order')
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update(['ord_state' => 3, 'ord_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $order_update = true;
        }

        $work_bill_update = true;
        // 订单账单核对完之后修改此账单下订单状态
        if ($settlement_data->acset_type == 25) {
            $orbi_id = DB::table('money_record')
                ->where('more_acset_id', $request['acset_id'])
                ->where('more_state', 2) //结款状态1未结清2已结清
                ->pluck('more_recr_id', 'more_orbi_id')
                ->toArray();
            $orbi_arr = array_flip($orbi_id);
            if (!empty($orbi_id)) {
                $orbi_data = DB::table('order_bill')
                    ->whereIn('orbi_id', $orbi_arr)
                    ->where('orbi_create_type', '!=', 4) //账单生成类型1订单账单2速电同步生成3工单账单4期初账单5采购账单
                    ->get(['orbi_create_type', 'orbi_id']);
                if (!empty($orbi_data)) {
                    foreach ($orbi_data as $key => $value) {
                        if ($value->orbi_create_type == 3) {
                            // wor_account_state 结算状态1未结算2已结算3已核销4已还款
                            $work_bill_update = DB::table('work_order')
                                ->where('wor_wobi_id', $value->orbi_id)
                                ->update(['wor_account_state' => 3, 'wor_update_time' => date('Y-m-d H:i:s')]);
                        } else {
                            $work_bill_update = DB::table('order')
                                ->where('ord_orbi_id', $value->orbi_id)
                                ->update(['ord_state' => 3, 'ord_update_time' => date('Y-m-d H:i:s')]);
                        }
                    }
                }
            }
        }
        // 3. 将应收账款中对应的数据改为核销状态
        // acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金
        // 8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15订单冲单16加盟店订单收款17加盟店订单代收18工单结算19旧货回收20售后单结算
        // recr_type 应收账款类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 6.销售账单 7.销售出库单 8非实物开单 9.账单冲红 10订单冲单
        $recr_account_type = 0;
        switch ($settlement_data->acset_type) {
            case '1':
                $recr_type = 1;
                break;
            case '2':
                $recr_type = 3;
                break;
            case '3':
                $recr_type = 4;
                break;
            case '4':
                $recr_type = 104; //采购账单对应，应付款，核销是在采购账单的结款中，没有放到结款明细中
                break;
            case '5':
                $recr_type = 6;
                break;
            case '6':
                $recr_type = 2;
                break;
            case '7': //采购入库单现金
                $recr_type = 107;
                break;
            case '8': //预付款
                $recr_type = 108;
                break;
            case '9': //订单代收
                $recr_type = 3; //订单账单
                $recr_account_type = 2; // 2受托代收（订单代收）
                break;
            case '10': //采购入库单预付款
                $recr_type = 110;
                break;
            case '11': //订单退款
                $recr_type = 3; //订单账单
                $recr_account_type = 10; //10订单退款
                break;
            case '12': //工单代收
                $recr_type = 4; //4工单账单
                $recr_account_type = 3; //3委托代收（工单代收）
                break;
            case '13': //订单完成后结算
                $recr_type = 3; //3.订单账单
                $recr_account_type = 1; //1订单收款
                break;
            case '14': //非实物开单
                $recr_type = 8; //8.非实物开单
                $recr_account_type = 0;
                break;
            case '15': //订单冲单
                $recr_type = 10; //10.订单冲单
                $recr_account_type = 0;
                break;
            case '16': //16加盟店订单收款
                $recr_type = 11; //11加盟店订单收款
                $recr_account_type = 0;
                break;
            case '17': //17加盟店订单代收
                $recr_type = 12; //12加盟店订单代收
                $recr_account_type = 0;
                break;
            case '18': //18工单结算
                $recr_type = 4; //工单账单
                $recr_account_type = 4; //4工单费用（工单收款）
                break;
            case '19': //19旧货回收
                $recr_type = 13; //旧货回收
                $recr_account_type = 16; //旧货回收
                break;
            case '20': //20售后单结算
                $recr_type = 14; //售后单
                $recr_account_type = 17; //售后单
                break;
            case '21': //21销售出库单
                $recr_type = 7; //销售出库单
                $recr_account_type = 9; //销售出库单
                break;
            case '22': //22采购单
                $recr_type = 15; //采购单
                $recr_account_type = 18; //采购单
                break;
            case '23': //23采购退货单
                $recr_type = 16; //采购退货单
                $recr_account_type = 19; //采购退货单
                break;
            case '24': //24采购款到发货(预付款)
                $recr_type = 17; //采购款到发货(预付款)
                $recr_account_type = 20; //采购款到发货(预付款)
                break;
            case '25': //批量结算
                $recr_type = 0; //批量结算
                $recr_account_type = 0; //批量结算
                break;
            case '26': //期初账单
                $recr_type = 18;
                $recr_account_type = 21;
                break;
            case '27': //易损件订单
                $recr_type = 19;
                break;
            default:
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'核对失败1']);
                break;
        }
        if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop')) && $recr_type != 7) {
            $request_voucher['subjcode'] = $request['subjcode']; //会计科目
            $request_voucher['recr_acti_id'] = $request['recr_acti_id']; //银行账号id
            if (isset($request['recr_yet_receipt']) && !empty($request['recr_yet_receipt'])) {
                // 分多次付款
                $request_voucher['voucher_price'] = $request['recr_yet_receipt']; //确认金额
            } else {
                $request_voucher['voucher_price'] = $settlement_data->acset_actual_price / 100; //结款明细金额
            }
            $settlement_data->acset_id = $request['acset_id'];
            // 调用凭证接口
            $return = AccountingSettlement::accountVoucher($user_info, (array)$settlement_data, $request_voucher); //调用u8接口
            if ($return['code'] == 500) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'凭证上传失败！']);
            }
        }
        if ($recr_type == 1) { //销售订单
            // 3.1 判断单据类型：订单结算类型的可以直接把应收账款改为核销状态
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 2) { //预收款
            // 预收款类型，核对时不更改应收款的核销状态
            // $recr_res = true;
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_state'] = 3; //状态1未核销2已核销3已收款
            // $recr_update['recr_plus_minus'] = 2;//1正值2负值
            // $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_acti_id'] = $request['recr_acti_id']; //银行卡id(银行账号)
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            // 修改结款明细的银行卡
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
        } elseif ($recr_type == 4) { //工单账单
            if ($recr_account_type == 0) {
                $sequence_res = $this->checkSequence($settlement_data->acset_original_id, $request['acset_id'], 1);
                if (!empty($sequence_res)) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行确认']);
                }
            }

            $not_price = 0;
            // 工单结算才会有2
            if ($settlement_data->acset_merge_type == 2) {
                $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
                $recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
                $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_update['recr_yet_receipt'] = $recr->recr_settle_price; //已收金额
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', 4)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->update($recr_update);

                $recr_update['recr_leisurely_type'] = 2; //0待收款 1收款待核对
                $recr_res_two = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', 3)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->update($recr_update);
                if (empty($recr_res_two)) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'核对失败2']);
                }
            } elseif ($recr_account_type != 3) {
                $account_settlement = new AccountSettlement();
                $return_data = $account_settlement->check($user_info, $settlement_data, $request->all());
                if ($return_data['code'] == 500) {
                    DB::rollBack();
                    return response()->json($return_data);
                }
                $recr_res = true;
            } else {
                $recr = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', 3)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->first(['recr_settle_price', 'recr_yet_receipt', 'recr_zero_price', 'recr_zero_plus_minus', 'recr_paid_price']);
                if ($settlement_data->acset_zero_plus_minus == 1) {
                    $not_price = $not_price - $settlement_data->acset_zero_price;
                } else {
                    $not_price = $not_price + $settlement_data->acset_zero_price;
                }
                $settle_price = $settlement_data->acset_actual_price + $recr->recr_paid_price + $not_price;
                $recr_update['recr_update_time'] = date('Y-m-d H:i:s');

                if ($settle_price == $recr->recr_settle_price || !empty($settlement_data->acset_zero_price)) {
                    $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
                    $recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
                    $recr_update['recr_paid_price'] = $recr->recr_settle_price; //已结金额
                } else {
                    $recr_update['recr_paid_price'] = $recr->recr_paid_price + $settlement_data->acset_actual_price + $not_price;
                }
                $recr_update['recr_yet_receipt'] = $recr->recr_settle_price; //已收金额
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', 3)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->update($recr_update);
            }
        } elseif ($recr_type == 8) { //非实物开单
            // 非实物开单的核对, 直接把应收账款改为核销状态
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 10) { //订单冲单
            // 订单冲单的核对, 直接把应收账款改为核销状态
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 11) { //加盟店订单收款
            // 11加盟店订单收款的核对, 直接把应收账款改为核销状态
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);

            $ord_edit_data['ord_state'] = 3; //结算状态1未结算2已结算3已核销4已收款
            $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_res = DB::table('order')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update($ord_edit_data);
        } elseif ($recr_type == 12) { //加盟店订单代收
            // 12加盟店订单代收的核对, 直接把应收账款改为核销状态
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 108) {
            // 预付款类型，核对时不更改应收款的核销状态
            $recr_res = true;
        } elseif (in_array($recr_type, [104, 107, 110])) {
            // 采购账单
            // 采购账单类型的，要判断账单是否全部结款，全部结款之后才可以把对应账单的应付款改为核销状态
            // 判断结款明细表中是否还有未核对的账单结款明细
            // 如果还有，说明当前的账单还有未核对的结款明细，不用核销应付账款中的数据
            $find_account = DB::table('accounting_settlement')
                ->where('acset_type', $settlement_data->acset_type)
                ->where('acset_original_id', $settlement_data->acset_original_id)
                ->where('acset_state', 1)
                ->first(['acset_id']);
            if ($find_account) {
                $recr_res = true;
            } else {
                switch ($recr_type) {
                    case '104': //采购账单
                        $acpa_type = 15; //1.预付款 2.采购账单 3.现结 4.采购入库单
                        break;
                    case '107': //采购入库单现结
                        $acpa_type = 3; //1.预付款 2.采购账单 3.现结 4.采购入库单
                        break;
                    case '110': //采购入库单预付款
                        $acpa_type = 4; //1.预付款 2.采购账单 3.现结 4.采购入库单
                        break;
                }
                if ($settlement_data->acset_type == 4) { //采购账单类型结款确认
                    $account_settlement = new AccountSettlement();
                    $return_data = $account_settlement->check($user_info, $settlement_data, $request->all());
                    if ($return_data['code'] == 500) {
                        DB::rollBack();
                        return response()->json($return_data);
                    }
                    $recr_res = true;
                } else {
                    // 3.2.2 如果没有，说明账单的结款明细都已核对
                    // 需要去应付账款表查询当前账单是否都已结款，
                    // 如果应付账款都已结款，可以把账单相关的应付账款改为已核销状态
                    // 3.2.3 当前账单的最后一条应付账款就是账单的最后的结款记录
                    // 如果最后一条的结款记录中的 已收金额+抹零金额=结算金额，说明已全部结款，可以改为核销状态
                    // 否则就没有全部结款，不能改为核销状态
                    // 查询应付总金额
                    $recr_data = DB::table('receivable_credit')
                        ->where('recr_type', '15')
                        ->where('recr_account_type', '22')
                        ->where('recr_original_id', $settlement_data->acset_original_id)
                        ->select('recr_settle_price', 'recr_id', 'recr_original_number')
                        ->first();
                    // 查询已付总金额
                    $accdata = DB::table('accounting_settlement')
                        ->where('acset_original_number', $recr_data->recr_original_number)
                        ->where('acset_state', '2')
                        ->select('acset_price')
                        ->get();
                    $orbi_id = DB::table('order_bill')
                        ->where('orbi_number', $recr_data->recr_original_number)
                        ->value('orbi_id');
                    // 查询账单对应的结款金额 结款明细与账单关系表
                    $more_data = DB::table('money_record')
                        ->where('more_orbi_id', $orbi_id)
                        ->select('more_this_settle_price', 'more_zero_price')
                        ->get()->toArray();
                    $more_settle_price = 0;
                    // 计算此账单的结款金额
                    foreach ($more_data as $key => $value) {
                        $more_settle_price = $more_settle_price + $value->more_this_settle_price + $value->more_zero_price;
                    }
                    $acset_price = '0';
                    foreach ($accdata as $k => $v) {
                        $acset_price = $acset_price + $v->acset_price;
                    }
                    if ($acset_price == $recr_data->recr_settle_price || $more_settle_price == $recr_data->recr_settle_price) {
                        $edit_data['recr_state'] = 2; //状态：1.未核销 2.已核销
                        $edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                        $edit_data['recr_settle_time'] = date('Y-m-d H:i:s');
                        $edit_data['recr_yet_receipt'] = $recr_data->recr_settle_price;
                        $recr_res = DB::table('receivable_credit')
                            ->where(function ($query) use ($acpa_type, $settlement_data) {
                                $query->where('recr_type', $acpa_type)
                                    ->where('recr_account_type', '22')
                                    ->where('recr_original_id', $settlement_data->acset_original_id);
                            }) //账单相关的应收账款
                            ->update($edit_data);
                    } else {
                        $recr_res = true;
                    }
                }
            }
        } elseif ($recr_type == 13) { //旧货回收
            // 旧货回收
            $recr_update['recr_yet_receipt'] = $settlement_data->acset_actual_price; //已收金额
            $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
            $recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 14) { //售后单
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_state'] = 2; //状态1未核销2已核销
            $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 7) { //销售出库单
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_state'] = 2; //状态1未核销2已核销
            $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_acti_id'] = $request['recr_acti_id']; //状态1未核销2已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_update['recr_settle_time'] = date('Y-m-d H:i:s'); //结款时间
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            // 2. 将结款明细中的金额，在对应的科目中添加/减去，是以汇款时间为准
            $acti_res = AccountSubject::Subject(
                $user_info, //用户信息
                $settlement_data->acset_inex_type, //类型：1借(汇入)2贷(汇出)
                $recr_settle_price, //金额
                $request['recr_acti_id'], //科目id(银行卡)
                $request['acset_with_time'] //汇款时间
            );
            if ($acti_res['code'] == 500) {
                DB::rollBack();
                return response()->json($acti_res);
            } else {
                $acti_res = true;
            }
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
            $sell_data['sell_update_time'] = date('Y-m-d H:i:s');
            $sell_data['sell_settlement_state'] = 3; //已结算
            $ord_res = DB::table('sell')
                ->where('sell_cid', $user_info->adm_cid)
                ->where('sell_id', $settlement_data->acset_original_id)
                ->where('sell_number', $settlement_data->acset_original_number)
                ->update($sell_data);
        } elseif ($recr_type == 15) { //采购单
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_acti_id'] = $request['recr_acti_id']; //会计科目id(银行账号)
            $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_state'] = 2; //状态1未核销2已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            $puor_data['cg_settlementype'] = 3; //结算状态1正常 待生成账单2待结算3已结算
            $puor_data['edit_time'] = date('Y-m-d H:i:s');
            $ord_res = DB::table('purchase_order')
                ->where('company_id', $user_info->adm_cid)
                ->where('cg_superior_shop_id', $shop_id)
                ->where('cg_id', $settlement_data->acset_original_id)
                ->where('cg_number', $settlement_data->acset_original_number)
                ->update($puor_data);
            // 2. 将结款明细中的金额，在对应的科目中添加/减去，是以汇款时间为准
            $acti_res = AccountSubject::Subject(
                $user_info, //用户信息
                $settlement_data->acset_inex_type, //类型：1借(汇入)2贷(汇出)
                $recr_settle_price, //金额
                $request['recr_acti_id'], //科目id
                $request['acset_with_time'] //汇款时间
            );
            if ($acti_res['code'] == 500) {
                DB::rollBack();
                return response()->json($acti_res);
            } else {
                $acti_res = true;
            }
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
        } elseif ($recr_type == 16) { //采购退货单
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_state'] = 2; //状态1未核销2已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            $puor_data['cg_settlementype'] = 3; //结算状态1正常 待生成账单2待结算3已结算
            $puor_data['edit_time'] = date('Y-m-d H:i:s');
            $ord_res = DB::table('purchase_order')
                ->where('company_id', $user_info->adm_cid)
                ->where('cg_superior_shop_id', $shop_id)
                ->where('cg_id', $settlement_data->acset_original_id)
                ->where('cg_number', $settlement_data->acset_original_number)
                ->update($puor_data);
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
            // 2. 将结款明细中的金额，在对应的科目中添加/减去，是以汇款时间为准
            $acti_res = AccountSubject::Subject(
                $user_info, //用户信息
                $settlement_data->acset_inex_type, //类型：1借(汇入)2贷(汇出)
                $recr_settle_price, //金额
                $request['recr_acti_id'], //科目id
                $request['acset_with_time'] //汇款时间
            );
            if ($acti_res['code'] == 500) {
                DB::rollBack();
                return response()->json($acti_res);
            } else {
                $acti_res = true;
            }
        } elseif ($recr_type == 17) { //采购单款到发货(预付款)
            $stase = "1";
            //查找采购单
            $purchaseresult = DB::table('purchase_order')
                ->where('cg_number', $settlement_data->acset_original_number)
                ->select('cg_id', 'cg_settlementype', 'cg_amount', 'cg_yfmoney', 'cg_moling', 'cg_state')
                ->first();
            if ($purchaseresult->cg_state == '17') {
                $inorderresult = DB::table('accounting_settlement')
                    ->where('acset_original_number', $settlement_data->acset_original_number)
                    ->where('acset_state', '1')
                    ->select('acset_id')
                    ->first();
                if (!$inorderresult) {
                    $stase = "2";
                }
            }
            if ($purchaseresult->cg_state == '11' || $purchaseresult->cg_state == '12') {
                if ($purchaseresult->cg_settlementype == '3') {
                    $inorderresult = DB::table('accounting_settlement')
                        ->where('acset_original_number', $settlement_data->acset_original_number)
                        ->where('acset_state', '1')
                        ->select('acset_id')
                        ->first();
                    if (!$inorderresult) {
                        $stase = "2";
                    }
                }
            }

            //更新本次应付记录
            $recr_resdata = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_original_id', $settlement_data->acset_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->select('recr_settle_price')->first();
            $edit_data['recr_acti_id'] = $request['recr_acti_id'];
            $edit_data['recr_settle_id'] = $user_info->adm_id;
            //$edit_data['recr_yet_receipt'] = $recr_resdata->recr_settle_price;
            $edit_data['recr_state'] = 4;
            $edit_data['recr_update_time'] = date('Y-m-d H:i:s');
            $edit_data['recr_settle_time'] = date('Y-m-d H:i:s');
            $recr_ressave = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_original_id', $settlement_data->acset_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($edit_data);
            /* unset($edit_data);
             $recr_ress = DB::table('receivable_credit')
                 ->where('recr_cid', $user_info->adm_cid)
                 ->where('recr_shop_superior_id', $shop_id)
                 ->where('recr_original_id', $purchaseresult->cg_id)
                 ->where('recr_original_number', $settlement_data->acset_original_number)
                 ->select('recr_type', 'recr_account_type')
                 ->first();
             if ($recr_ress) {
                 $edit_datas['recr_acti_id'] = $request['recr_acti_id'];
                 $edit_datas['recr_settle_id'] = $user_info->adm_id;
                 $edit_datas['recr_state'] = 3;
                 $edit_datas['recr_update_time'] = date('Y-m-d H:i:s');
                 $edit_datas['recr_settle_time'] = date('Y-m-d H:i:s');
                 $recr_ress = DB::table('receivable_credit')
                     ->where('recr_cid', $user_info->adm_cid)
                     ->where('recr_shop_superior_id', $shop_id)
                     ->where('recr_original_id', $purchaseresult->cg_id)
                     ->where('recr_original_number', $settlement_data->acset_original_number)
                     ->update($edit_datas);
             }*/

            unset($edit_data);
            //更新该采购单所有应付记录
            if ($stase == '2') {
                /* //更新预付记录状态
                 $recr_ress = DB::table('receivable_credit')
                     ->where('recr_cid', $user_info->adm_cid)
                     ->where('recr_shop_superior_id', $shop_id)
                     ->where('recr_original_number', $settlement_data->acset_original_number)
                     ->select('recr_settle_price', 'recr_id')->get();
                 foreach ($recr_ress as $k=>$v) {
                     $edit_data['recr_state'] = 2;
                     $edit_data['recr_yet_receipt'] = $v->recr_settle_price;
                     $recr_ress = DB::table('receivable_credit')
                     ->where('recr_cid', $user_info->adm_cid)
                     ->where('recr_shop_superior_id', $shop_id)
                     ->where('recr_id', $v->recr_id)
                     ->where('recr_original_number', $settlement_data->acset_original_number)
                     ->update($edit_data);
                 }


                 //更新入库记录
                 $storageresult = DB::table('ware_inorder')
                     ->where('cg_number', $settlement_data->acset_original_number)
                     ->select('rk_id', 'rk_number')
                     ->get();
                 $storageresult = json_decode(json_encode($storageresult), true);
                 foreach ($storageresult as $k=>$v) {*/
                $recr_dat = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    //->where('recr_original_id', $v['rk_id'])
                    //->where('recr_id', $recr_dat->recr_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->select('recr_settle_price', 'recr_id')->get();
                foreach ($recr_dat  as $k => $v) {
                    $editrk_data['recr_yet_receipt'] = $v->recr_settle_price;
                    $editrk_data['recr_state'] = 2;
                    $editrk_data['recr_acti_id'] = $request['recr_acti_id'];
                    $editrk_data['recr_settle_id'] = $user_info->adm_id;
                    $editrk_data['recr_update_time'] = date('Y-m-d H:i:s');
                    $editrk_data['recr_settle_time'] = date('Y-m-d H:i:s');
                    $recr_ress = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_id', $v->recr_id)
                        ->where('recr_original_number', $settlement_data->acset_original_number)
                        ->update($editrk_data);
                }

                //}
            }
            //$acset_data['acset_with_time'] = $request['acset_with_time'];
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
            $recr_res = true;
            // 生成付款单记录
            $add_data['acsd_acset_id'] = $request['acset_id'];
            $add_data['acsd_number'] = 'FK' . rand(100, 999) . time() . rand(10000, 99999);
            $add_data['acsd_type'] = 1; //类型1采购单款到发货(预付款)
            $add_data['acsd_adm_id'] = $user_info->adm_id; //创建人id
            $add_data['acsd_price'] = $request['recr_yet_receipt'] * 100; //付款金额
            $acsd_id = DB::table('accounting_settlement_details')->insert($add_data);
        } elseif ($settlement_data->acset_type == 25) { //批量结算
            $orbi_arr = DB::table('money_record')
                ->where('more_acset_id', $request['acset_id'])
                ->pluck('more_recr_id', 'more_orbi_id')
                ->toArray();
            $acset_original_id = array_keys($orbi_arr);
            foreach ($acset_original_id as $key => $value) {
                $sequence_res = $this->checkSequence($value, $request['acset_id'], 1);
                if (!empty($sequence_res)) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行确认']);
                }
            }
            $account_settlement = new AccountSettlement();
            $return_data = $account_settlement->check($user_info, $settlement_data, $request->all());
            if ($return_data['code'] == 500) {
                DB::rollBack();
                return response()->json($return_data);
            }
            $recr_res = true;
        } elseif ($recr_type == 18) { //期初账单
            //期初账单类型结款确认
            $account_settlement = new AccountSettlement();
            $return_data = $account_settlement->check($user_info, $settlement_data, $request->all());
            if ($return_data['code'] == 500) {
                DB::rollBack();
                return response()->json($return_data);
            }
            $recr_res = true;
        } elseif ($recr_type == 19) { //易损件订单
            $recr_settle_price = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->value('recr_settle_price');
            $recr_update['recr_yet_receipt'] = $recr_settle_price;
            $recr_update['recr_state'] = 2; //状态1未核销2已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            $acset_data['acset_acti_id'] = $request['recr_acti_id'];
            $acset_update_res = DB::table('accounting_settlement')
                ->where('acset_id', $request['acset_id'])
                ->update($acset_data);
            // ord_state 结算状态1未结算2结算中3已结算4已代收
            $order_update = DB::table('order')
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update(['ord_state' => 3, 'ord_update_time' => date('Y-m-d H:i:s')]);
        } else {
            if ($recr_account_type == 10 || $recr_account_type == 1) {
                // 订单退款类型核对，或者是订单完成后结算，对应的应收账款改成已核销状态，
                // 对应的订单改成已核销状态
                if ($settlement_data->acset_merge_type == 2) {
                    $type = [$recr_account_type, 2];
                } else {
                    $type = [$recr_account_type];
                }
                $find_recr_data = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->whereIn('recr_account_type', $type)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->select('recr_id', 'recr_settle_price')
                    ->get()->toArray();
                foreach ($find_recr_data as $key => $value) {
                    $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
                    $recr_update['recr_yet_receipt'] = $value->recr_settle_price; //已收金额
                    $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
                    $recr_edit_res = DB::table('receivable_credit')
                        ->where('recr_id', $value->recr_id)
                        ->update($recr_update);
                    unset($recr_update);
                }
                $ord_edit_data['ord_state'] = 3; //状态：1.未核销 2.已核销
                $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_res = DB::table('order')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_id', $settlement_data->acset_original_id)
                    ->where('ord_order_number', $settlement_data->acset_original_number)
                    ->update($ord_edit_data);
                if ($recr_edit_res && $ord_res) {
                    $recr_res = true;
                } else {
                    $recr_res = false;
                }
            } elseif ($recr_account_type == 2) {
                // $recr_res = true;
                $recr_update['recr_yet_receipt'] = $settlement_data->acset_actual_price; //已收金额
                $recr_update['recr_state'] = 2; //状态：1.未核销 2.已核销
                $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', $recr_account_type)
                    ->where('recr_original_id', $settlement_data->acset_original_id)
                    ->where('recr_original_number', $settlement_data->acset_original_number)
                    ->update($recr_update);
            } else {
                // 订单账单
                if ($recr_type == 3 && $recr_account_type == 0) {
                    $sequence_res = $this->checkSequence($settlement_data->acset_original_id, $request['acset_id'], 1);
                    if (!empty($sequence_res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行确认']);
                    }
                }
                $recr_res = false;
                if ($settlement_data->acset_type == 2) { //订单账单类型结款确认
                    $account_settlement = new AccountSettlement();
                    $return_data = $account_settlement->check($user_info, $settlement_data, $request->all());
                    if ($return_data['code'] == 500) {
                        DB::rollBack();
                        return response()->json($return_data);
                    }
                    $recr_res = true;
                }
            }
        }
        if ($acset_res && $acti_res && $recr_res && $leisurely_type && $order_update) {
            $hint = '流水号：' . $settlement_data->acset_number . '、单号：' . $settlement_data->acset_original_number . '确认成功';
            Common::addLog($user_info, getRealIp($request), '结款明细', '确认', $hint);
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'确认成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'确认失败']);
        }
    }

    // 核对顺序
    // $type 1核对  2驳回
    public function checkSequence($recr_id, $acset_id, $type)
    {
        if ($type == 1) {
            $type = '<';
        } else {
            $type = '>';
        }
        $count = DB::table('money_record as mr')
            ->leftjoin('accounting_settlement as s', 's.acset_id', '=', 'mr.more_acset_id')
            ->where('more_orbi_id', $recr_id)
            ->where('more_acset_id', $type, $acset_id)
            ->where('acset_state', '!=', 2)
            ->count();
        return $count;
    }

    // 撤销-取消核对
    public function cancelCheck(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->cancelCheckValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 判断当前结款明细是否存在
        $settlement_data = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->first([
                'acset_original_number', 'acset_type', 'acset_state', 'acset_original_id',
                'acset_inex_type', 'acset_actual_price', 'acset_remit_time', 'acset_acti_id', 'acset_payment_type', 'acset_merge_type'
            ]);
        if (empty($settlement_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细不存在']);
        }
        if ($settlement_data->acset_state == 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细尚未核对']);
        }
        // 订单结算核对之后修改订单状态
        if ($settlement_data->acset_type == 1) {
            $ord_state = DB::table('order')
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->value('ord_state');
            if ($ord_state == 3 || $ord_state == 2) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'订单结算的订单不能撤销']);
            }
        }

        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 结款明细撤销核对需要做的有
        // 1. 更改状态、汇款时间、备注
        $update_data['acset_state'] = 1; //状态：1未核对2已核对
        $update_data['acset_remit_time'] = '0000-00-00'; //汇款时间
        $update_data['acset_remark'] = $request['acset_remark'] ? $request['acset_remark'] : ''; //备注
        $update_data['acset_update_time'] = date('Y-m-d H:i:s'); //更新时间

        DB::beginTransaction();
        $acset_res = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->update($update_data);

        // 如果类型是订单代收
        if ($settlement_data->acset_type == 9) {
            $type = DB::table('receivable_credit')
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->where('recr_account_type', 2)
                ->value('recr_leisurely_type');
            // 收款
            if ($settlement_data->acset_payment_type == 5) {
                // 判断当前结款明细是否存在
                $put = DB::table('accounting_settlement')
                    ->where('acset_original_id', $settlement_data->acset_original_id)
                    ->where('acset_original_number', $settlement_data->acset_original_number)
                    ->where('acset_payment_type', 6)
                    ->first(['acset_state']);
                if (!empty($put->acset_state) && $put->acset_state == 2) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请先撤销还款']);
                }
                if (!empty($put->acset_state) && $put->acset_state == 1) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请先驳回还款']);
                }
            }
            if ($type == 2) {
                $type = 1;
            }
            if ($type == 4) {
                $type = 3;
            }
            $leisurely_data['recr_leisurely_type'] = $type;
            $leisurely_data['recr_update_time'] = date('Y-m-d H:i:s');
            // 如果等于4把状态改为消核
            if ($type == 3) {
                $leisurely_data['recr_state'] = 1;
            }
            $leisurely_type = DB::table('receivable_credit')
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->where('recr_account_type', 2)
                ->update($leisurely_data);
        } else {
            $leisurely_type = true;
        }

        // 预付款/预收款结算的不更改科目数据
        $deduction = 1; //更改科目数据
        // acset_payment_type 结款类型3.预收款抵账 不更改科目金额
        // acset_type 10采购入库单预付款
        if ($settlement_data->acset_payment_type == 3 || $settlement_data->acset_type == 10) {
            $deduction = 2; //不更改科目数据
        }

        // $deduction 1抵扣  2不抵扣
        if ($deduction == 1) {
            // 2. 将结款明细中的金额，在对应的科目中添加/减去，是以汇款时间为准
            $acti_res = AccountSubject::cancelSubject(
                $user_info, //用户信息
                $settlement_data->acset_inex_type, //类型：1借(汇入)2贷(汇出)
                $settlement_data->acset_actual_price, //金额
                $settlement_data->acset_acti_id, //科目id
                $settlement_data->acset_remit_time //汇款时间
            );
        } else {
            $acti_res = true;
        }

        // 订单结算核对之后修改订单状态
        if ($settlement_data->acset_type == 1) {
            $order_update = DB::table('order')
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update(['ord_state' => 2, 'ord_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $order_update = true;
        }

        // 订单账单核对完之后修改此账单下订单状态
        if ($settlement_data->acset_type == 2) {
            $order_bill_update = DB::table('order')
                ->where('ord_orbi_id', $settlement_data->acset_original_id)
                ->update(['ord_state' => 2, 'ord_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $order_bill_update = true;
        }

        // 3. 将应收账款中对应的数据改为未核销状态
        // acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收'
        switch ($settlement_data->acset_type) {
            case 1:
                $recr_type = 1;
                break;
            case 2:
                $recr_type = 3;
                break;
            case 3:
                $recr_type = 4;
                break;
            case 4:
                $recr_type = 104; //采购账单对应，应付款，核销是在采购账单的结款中，没有放到结款明细中
                break;
            case 5:
                $recr_type = 6;
                break;
            case 6:
                $recr_type = 2;
                break;
            case 7: //采购入库单现金
                $recr_type = 107;
                break;
            case 8: //预付款
                $recr_type = 108;
                break;
            case 9: //订单代收
                $recr_type = 203;
                break;
            case 10: //采购入库单预付款
                $recr_type = 110;
                break;
            case 11: //订单退款
                $recr_type = 211;
                break;
            case 12: //工单代收
                $recr_type = 4; //4.工单账单
                $recr_account_type = 3; //3委托代收（工单代收）
                break;
            case 13: //13订单完成后结算
                $recr_type = 213;
                break;
            case 14: //14非实物开单
                $recr_type = 8;
                break;
            case 15: //订单冲单
                $recr_type = 10;
                break;
            case 18: //18工单结算
                $recr_type = 4; //工单账单
                $recr_account_type = 4; //4工单费用（工单收款）
                break;
            default:
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消核对失败']);
                break;
        }
        if (!isset($recr_account_type)) {
            $recr_account_type = 0;
        }
        if (in_array($recr_type, [1, 3, 4, 6])) {
            $recr_update['recr_state'] = 1; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            // 如果合并代收
            if ($settlement_data->acset_merge_type == 2) {
                $recr_update['recr_leisurely_type'] = 0; //0待收款 1收款待核对
                $recr_res = DB::table('receivable_credit')
                    ->where(function ($query) use ($recr_type, $settlement_data) {
                        $query->where('recr_type', $recr_type)
                            ->where('recr_account_type', 4)
                            ->where('recr_original_id', $settlement_data->acset_original_id);
                    }) //账单相关的应收账款
                    ->orwhere(function ($query) use ($recr_type, $settlement_data) {
                        $query->where('recr_type', $recr_type)
                            ->where('recr_account_type', 4)
                            ->where('recr_belongs_id', $settlement_data->acset_original_id);
                    }) //所属账单的订单应收账款
                    ->update($recr_update);

                $recr_update['recr_leisurely_type'] = 2; //0待收款 1收款待核对
                $recr_res_two = DB::table('receivable_credit')
                    ->where(function ($query) use ($recr_type, $settlement_data) {
                        $query->where('recr_type', $recr_type)
                            ->where('recr_account_type', 3)
                            ->where('recr_original_id', $settlement_data->acset_original_id);
                    }) //账单相关的应收账款
                    ->orwhere(function ($query) use ($recr_type, $settlement_data) {
                        $query->where('recr_type', $recr_type)
                            ->where('recr_account_type', 3)
                            ->where('recr_belongs_id', $settlement_data->acset_original_id);
                    }) //所属账单的订单应收账款
                    ->update($recr_update);
                if (empty($recr_res_two)) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消核对失败']);
                }
            } else {
                // 3.1 订单结算、预收款的可以直接将对应的应收账款改为未核销状态
                // 账单中的结款明细没有全部结款，那账单对应的应收账款就可以直接改为未核销状态
                $recr_res = DB::table('receivable_credit')
                    ->where(function ($query) use ($recr_type, $settlement_data, $recr_account_type) {
                        if (!empty($recr_account_type)) {
                            $query->where('recr_type', $recr_type)
                                ->where('recr_original_id', $settlement_data->acset_original_id)
                                ->where('recr_account_type', $recr_account_type);
                        } else {
                            $query->where('recr_type', $recr_type)
                                ->where('recr_original_id', $settlement_data->acset_original_id);
                        }
                    }) //账单相关的应收账款
                    ->orwhere(function ($query) use ($recr_type, $settlement_data, $recr_account_type) {
                        if (!empty($recr_account_type)) {
                            $query->where('recr_type', $recr_type)
                                ->where('recr_belongs_id', $settlement_data->acset_original_id)
                                ->where('recr_account_type', $recr_account_type);
                        } else {
                            $query->where('recr_type', $recr_type)
                                ->where('recr_belongs_id', $settlement_data->acset_original_id);
                        }
                    }) //所属账单的订单应收账款
                    ->update($recr_update);
            }
        } elseif (in_array($recr_type, [2, 108])) {
            $recr_res = true;
        } elseif (in_array($recr_type, [104, 107, 110])) {
            switch ($recr_type) {
                case '104': //采购账单
                    $acpa_type = 2; //1.预付款 2.采购账单 3.现结 4.采购入库单
                    break;
                case '107': //采购入库单现结
                    $acpa_type = 3; //1.预付款 2.采购账单 3.现结 4.采购入库单
                    break;
                case '110': //采购入库单预付款
                    $acpa_type = 4; //1.预付款 2.采购账单 3.现结 4.采购入库单
                    break;
            }
            $acpa_update['acpa_state'] = 1; //状态：1.未核销 2.已核销
            $acpa_update['acpa_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('accounts_payable')
                ->where(function ($query) use ($acpa_type, $settlement_data) {
                    $query->where('acpa_type', $acpa_type)
                        ->where('acpa_original_id', $settlement_data->acset_original_id);
                }) //账单相关的应收账款
                ->orwhere(function ($query) use ($acpa_type, $settlement_data) {
                    $query->where('acpa_type', $acpa_type)
                        ->where('acpa_belongs_id', $settlement_data->acset_original_id);
                }) //所属账单的订单应收账款
                ->update($acpa_update);
        } elseif ($recr_type == 8) {
            // 非实物开单撤销改成未核销状态
            $recr_update['recr_state'] = 1; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', 8)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 10) {
            // 冲单撤销改成未核销状态
            $recr_update['recr_state'] = 1; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
        } elseif ($recr_type == 203) {
            // 订单代收
            $recr_res = true;
        } elseif ($recr_type == 211) {
            // 订单退款
            // 订单退款类型核对，对应的应收账款改成已核销状态，
            // 对应的订单改成已核销状态
            $recr_update['recr_state'] = 1; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_edit_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', 3)
                ->where('recr_account_type', 10)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            $ord_edit_data['ord_state'] = 4; //结算状态1未结算2已结算3已核销4已收款
            $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_res = DB::table('order')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update($ord_edit_data);
            if ($recr_edit_res && $ord_res) {
                $recr_res = true;
            } else {
                $recr_res = false;
            }
        } elseif ($recr_type == 213) {
            // 13订单完成后结算
            // 订单退款类型核对，对应的应收账款改成未核销状态，
            // 对应的订单改成已结算状态
            $recr_update['recr_state'] = 1; //状态：1.未核销 2.已核销
            $recr_update['recr_update_time'] = date('Y-m-d H:i:s');
            $recr_edit_res = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', 3)
                ->where('recr_account_type', 1)
                ->where('recr_original_id', $settlement_data->acset_original_id)
                ->where('recr_original_number', $settlement_data->acset_original_number)
                ->update($recr_update);
            $ord_edit_data['ord_state'] = 2; //结算状态1未结算2已结算3已核销4已收款
            $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_res = DB::table('order')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_id', $settlement_data->acset_original_id)
                ->where('ord_order_number', $settlement_data->acset_original_number)
                ->update($ord_edit_data);
            if ($recr_edit_res && $ord_res) {
                $recr_res = true;
            } else {
                $recr_res = false;
            }
        }
        if ($acset_res && $acti_res && $recr_res && $leisurely_type && $order_bill_update && $order_update) {
            Common::addLog($user_info, getRealIp($request), '结款明细', '取消核对', $settlement_data->acset_original_number . '取消核对成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'取消核对成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消核对失败']);
        }
    }

    // 驳回
    public function reject(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->rejectValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $acset_res = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->select('acset_type', 'acset_payment_type', 'acset_state', 'acset_original_id', 'acset_original_number', 'acset_inex_type', 'acset_number', 'acset_actual_price', 'acset_zero_price', 'acset_merge_type')
            ->first();
        if ($acset_res->acset_state == 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细已核对不能驳回']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // acset_type   结款明细单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收
        // 将结款明细的类型转换为原始账单（订单）的状态
        switch ($acset_res->acset_type) {
                // 对应应收账款字段类型
                // recr_type 类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 6.销售账单 7.销售出库单 8非实物开单 9.账单冲红 10订单冲单 11.加盟店订单收款 12.加盟店订单代收13.旧货回收14售后单15采购单16采购退货单17采购款到发货(预付款)18期初账单
                // recr_account_type 显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款 9销售出库单 10订单退款(退货单) 11发票 12价外费 13折扣金额抵货款 14.账单冲红 15.订单冲单16.旧货回收 17售后单18采购单19采购退货单20采购款到发货（预付款）21期初账单22.采购账单
            case 1: //1订单结算
                $recr_type = 1; //1.销售订单
                $recr_account_type = 1; //1订单收款
                break;
            case 2: //2订单账单
                $recr_type = 3; //3.订单账单
                $recr_account_type = 5; //5订单账单
                break;
            case 3: //3工单账单
                $recr_type = 4; //4.工单账单
                $recr_account_type = 6; //6工单账单
                break;
            case 4: //4采购账单
                $recr_type = 0;
                $recr_account_type = 0;
                $acpa_type = 2; //2.采购账单
                break;
            case 5: //5销售账单
                $recr_type = 6; //6.销售账单
                $recr_account_type = 7; //7销售账单
                break;
            case 6: //6预收款
                $recr_type = 2; //2.预收款
                $recr_account_type = 8; //8预收款
                break;
            case 7: //7采购入库单现金
                $recr_type = 0; //
                $recr_account_type = 0; //
                $acpa_type = 3; //3.现结
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'采购入库单现结不允许驳回']);
                break;
            case 8: //8预付款
                $recr_type = 0;
                $recr_account_type = 0;
                $acpa_type = 1; //1.预付款
                break;
            case 9: //9订单代收
                $recr_type = 3; //对应字段类型 3.订单账单
                $recr_account_type = 2; //2受托代收（订单代收）
                break;
            case 10: //采购入库单预付款
                $acpa_type = 4; //对应字段类型 4.采购入库单
                $recr_account_type = 0;
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'采购入库单预付款不允许驳回']);
                break;
            case 11: //订单退款
                $recr_type = 3; //订单账单
                $recr_account_type = 10; //10订单退款
                break;
            case 12: //工单代收
                $recr_type = 4; //4工单账单
                $recr_account_type = 3; //3委托代收（工单代收）
                break;
            case 13: //订单完成后结算
                $recr_type = 3; //3.订单账单
                $recr_account_type = 1; //1订单收款
                break;
            case 14: //14非实物开单
                $recr_type = 8; //8.非实物开单
                $recr_account_type = 0;
                break;
            case 15: //订单冲单
                $recr_type = 10; //订单冲单
                $recr_account_type = 0;
                break;
            case 16: //16加盟店订单收款
                $recr_type = 11; //11加盟店订单收款
                $recr_account_type = 0;
                break;
            case 17: //17加盟店订单代收
                $recr_type = 12; //12加盟店订单代收
                $recr_account_type = 0;
                break;
            case 18: //18工单结算
                $recr_type = 4; //工单账单
                $recr_account_type = 4; //4工单费用（工单收款）
                break;
            case 19: //19旧货回收
                $recr_type = 13; //旧货回收
                $recr_account_type = 16; //旧货回收
                break;
            case '20': //20售后单结算
                $recr_type = 14; //售后单
                $recr_account_type = 17; //售后单
                break;
            case '21': //21销售出库单
                $recr_type = 7; //销售出库单
                $recr_account_type = 9; //销售出库单
                break;
            case '22': //22采购
                $recr_type = 15; //采购单
                $recr_account_type = 18; //采购单
                break;
            case '23': //23采购退货单
                $recr_type = 16; //采购退货单
                $recr_account_type = 19; //采购退货单
                break;
            case '24': //24采购款到发货(预付款)
                $recr_type = 17; //采购款到发货(预付款)
                $recr_account_type = 20; //采购款到发货(预付款)
                break;
            case '25': //批量结算
                $recr_type = 0;
                $recr_account_type = 0;
                break;
            case '26': //期初账单
                $recr_type = 18;
                $recr_account_type = 21;
                break;
            default:
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败！']);
                break;
        }

        // 驳回是将原始账单（订单）驳回到生成结款明细前的一个状态
        DB::beginTransaction();
        // 查询出原始账单（订单）对应的数据
        if (in_array($acset_res->acset_type, [1, 2, 3, 5, 6, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24])) {
            // 这几个类型状态是跟应收账款相关的,查询出应收账款的数据，
            $find_original_data = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', $recr_type)
                ->where('recr_account_type', $recr_account_type)
                ->where('recr_original_id', $acset_res->acset_original_id)
                ->where('recr_original_number', $acset_res->acset_original_number)
                ->select('recr_id', 'recr_actual_price', 'recr_yet_receipt', 'recr_zero_price')
                ->first();
        } else {
            if ($acset_res->acset_type == 8) {
                // 其余的几个类型状态是跟应付账款相关的，查询出账单对应的应收账款id
                $find_original_data = DB::table('accounts_payable')
                    ->where('acpa_cid', $user_info->adm_cid)
                    ->where('acpa_shop_superior_id', $shop_id)
                    ->where('acpa_type', $acpa_type)
                    ->where('acpa_id', $acset_res->acset_original_id)
                    ->select('acpa_id', 'acpa_actual_price', 'acpa_yet_receipt', 'acpa_zero_price')
                    ->first();
            } elseif ($acset_res->acset_type != 25 && $acset_res->acset_type != 26) {
                // 其余的几个类型状态是跟应付账款相关的，查询出账单对应的应收账款id
                $find_original_data = DB::table('accounts_payable')
                    ->where('acpa_cid', $user_info->adm_cid)
                    ->where('acpa_shop_superior_id', $shop_id)
                    ->where('acpa_type', $acpa_type)
                    ->where('acpa_original_id', $acset_res->acset_original_id)
                    ->select('acpa_id', 'acpa_actual_price', 'acpa_yet_receipt', 'acpa_zero_price')
                    ->first();
            }
        }
        // 驳回处理
        switch ($acset_res->acset_type) {
            case 1: //1订单结算
                // 1系统订单2外派订单
                $orcl_order_type = DB::table('order_client')
                    ->where('orcl_ord_id', $acset_res->acset_original_id)
                    ->value('orcl_order_type');
                if ($orcl_order_type == 1) {
                    //删除订单结算的应收账款信息
                    $recr_order_del = DB::table('receivable_credit')
                        ->where('recr_id', $find_original_data->recr_id)
                        ->update(['recr_yet_receipt' => 0, 'recr_update_time' => date('Y-m-d H:i:s')]);
                } else {
                    $recr_order_del = true;
                }
                // 将订单状态改为 未结算状态
                $order_update = DB::table('order')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_id', $acset_res->acset_original_id)
                    ->where('ord_order_number', $acset_res->acset_original_number)
                    ->update(['ord_state' => 1, 'ord_update_time' => date('Y-m-d H:i:s')]);
                if (!$recr_order_del || !$order_update) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 2: //2订单账单
                // 订单账单
                if ($recr_type == 3 && $recr_account_type == 5) {
                    $sequence_res = $this->checkSequence($acset_res->acset_original_id, $request['acset_id'], 2);
                    if (!empty($sequence_res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行驳回']);
                    }
                }
                // 更改账单的应收账款金额
                $recr_edit_data['recr_actual_price'] = $find_original_data->recr_actual_price - $acset_res->acset_actual_price;
                $recr_edit_data['recr_yet_receipt'] = $find_original_data->recr_yet_receipt - $acset_res->acset_actual_price;
                $recr_edit_data['recr_zero_price'] = $find_original_data->recr_zero_price - $acset_res->acset_zero_price;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $update_recr = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', 3)
                    ->where(function ($query) use ($acset_res, $recr_account_type) {
                        if ($acset_res->acset_merge_type == 2) { //是否合并代收1不合并 2合并
                            $query->whereIn('recr_account_type', [5, 2]);
                        } else {
                            $query->where('recr_account_type', $recr_account_type);
                        }
                    }) //显示类型
                    ->where('recr_id', $find_original_data->recr_id)
                    ->update($recr_edit_data);

                // 更改订单账单的数据
                $order_bill_data = DB::table('order_bill')
                    ->where('orbi_cid', $user_info->adm_cid)
                    ->where('orbi_superior_shop_id', $shop_id)
                    ->where('orbi_id', $acset_res->acset_original_id)
                    ->first(['orbi_receive_price', 'orbi_zero_price']);
                if (!empty($order_bill_data)) {
                    // 判断订单账单的状态
                    //如果已收金额等于结款明细的实际金额那就是一次性结清
                    if ($order_bill_data->orbi_receive_price == $acset_res->acset_actual_price) {
                        $orbi_state = 1;
                    } elseif ($order_bill_data->orbi_receive_price > $acset_res->acset_actual_price) {
                        $orbi_state = 5;
                    }
                    //此账单已经抹零  并且本次驳回不是抹零那次
                    if ($order_bill_data->orbi_zero_price > 0 && $acset_res->acset_zero_price == 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请首先驳回本账单抹零结款']);
                    }
                    $update_bill = DB::update('UPDATE `faster_order_bill` SET `orbi_receive_price`=`orbi_receive_price`-' . $acset_res->acset_actual_price . ', `orbi_zero_price`=`orbi_zero_price`-' . $acset_res->acset_zero_price . ',`orbi_state`= ' . $orbi_state . ',`orbi_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `orbi_id`=?', [$acset_res->acset_original_id]);
                    if ($acset_res->acset_payment_type == 3) {
                        // 结款方式为预收款抵账的，需要把预收款的金额还回去
                        // 查询结款明细对应的预付款id
                        $rede_advance_id = DB::table('receivable_details')
                            ->where('rede_acset_id', $request['acset_id'])
                            ->value('rede_advance_id');

                        $recr_res = DB::update('UPDATE `faster_receivable_credit` SET `recr_yet_receipt`=`recr_yet_receipt`-' . $acset_res->acset_actual_price . ',`recr_state` = 3,`recr_actual_price`=`recr_actual_price`+' . $acset_res->acset_actual_price . ',`recr_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `recr_id`=?', [$rede_advance_id]);
                    } else {
                        $recr_res = true;
                    }
                } else {
                    $update_bill = true;
                    $recr_res = true;
                }
                $more_del = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->delete();
                if (!$update_recr || !$update_bill || !$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 3: //工单账单
                // 工单账单
                if ($recr_type == 4 && $recr_account_type == 6) {
                    $sequence_res = $this->checkSequence($acset_res->acset_original_id, $request['acset_id'], 2);
                    if (!empty($sequence_res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行驳回']);
                    }
                }
                $more_data = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->get(['more_recr_id', 'more_zero_price', 'more_zero_plus_minus', 'more_this_settle_price', 'more_this_plus_minus', 'more_orbi_id']);

                $time = date('Y-m-d H:i:s');
                foreach ($more_data as $key => $value) {
                    $rece_data['recr_zero_price'] = 0;
                    $rece_data['recr_zero_plus_minus'] = 1;
                    $rece_data['recr_update_time'] = $time;
                    $rece_data['recr_state'] = 1;
                    $res = DB::table('receivable_credit')
                        ->where('recr_id', $value->more_recr_id)
                        ->decrement('recr_yet_receipt', $value->more_this_settle_price, $rece_data);
                    if (empty($res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                    }
                }
                $more_del = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->delete();

                foreach ($more_data as $key => $value) {
                    $orbi = DB::table('order_bill')->where('orbi_id', $value->more_orbi_id)->first(['orbi_receive_price', 'orbi_zero_price']);
                    if ($orbi->orbi_receive_price == $value->more_this_settle_price) {
                        $orbi_data['orbi_state'] = 1;
                    } else {
                        $orbi_data['orbi_state'] = 5;
                    }

                    // 此账单已经抹零  并且本次驳回不是抹零那次
                    if ($orbi->orbi_zero_price > 0 && $value->more_zero_price == 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请首先驳回本账单抹零结款']);
                    }

                    $orbi_data['orbi_zero_price'] = 0;
                    $orbi_data['orbi_update_time'] = $time;
                    $res = DB::table('order_bill')
                        ->where('orbi_id', $value->more_orbi_id)
                        ->decrement('orbi_receive_price', $value->more_this_settle_price, $orbi_data);
                    if (empty($res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                    }
                }
                if ($acset_res->acset_payment_type == 3) {
                    // 结款方式为预收款抵账的，需要把预收款的金额还回去
                    // 查询结款明细对应的预付款id
                    $rede_advance_id = DB::table('receivable_details')
                        ->where('rede_acset_id', $request['acset_id'])
                        ->value('rede_advance_id');

                    $recr_res = DB::update('UPDATE `faster_receivable_credit` SET `recr_yet_receipt`=`recr_yet_receipt`-' . $acset_res->acset_actual_price . ',`recr_state` = 3,`recr_actual_price`=`recr_actual_price`+' . $acset_res->acset_actual_price . ',`recr_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `recr_id`=?', [$rede_advance_id]);
                } else {
                    $recr_res = true;
                }

                if (!$more_del || !$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 4: //4采购账单
                // 更改账单的应收账款金额
                $acpa_edit_data['acpa_actual_price'] = $find_original_data->acpa_actual_price - $acset_res->acset_actual_price;
                $acpa_edit_data['acpa_yet_receipt'] = $find_original_data->acpa_yet_receipt - $acset_res->acset_actual_price;
                $acpa_edit_data['acpa_zero_price'] = $find_original_data->acpa_zero_price - $acset_res->acset_actual_price;
                $acpa_edit_data['acpa_update_time'] = date('Y-m-d H:i:s');
                $update_acpa = DB::table('accounts_payable')
                    ->where('acpa_cid', $user_info->adm_cid)
                    ->where('acpa_shop_superior_id', $shop_id)
                    ->where('acpa_id', $find_original_data->acpa_id)
                    ->update($acpa_edit_data);

                // 已收金额
                $procurement_bill_data = DB::table('procurement_bill')
                    ->where('prbi_id', $acset_res->acset_original_id)
                    ->first(['prbi_receive_price']);
                // 如果已收金额等于结款明细的实际金额那就是一次性结清
                if ($procurement_bill_data->prbi_receive_price == $acset_res->acset_actual_price) {
                    $orbi_state = 1;
                } elseif ($procurement_bill_data->prbi_receive_price > $acset_res->acset_actual_price) {
                    $orbi_state = 5;
                }
                $update_bill_prbi = DB::update('UPDATE `faster_procurement_bill` SET `prbi_receive_price`=`prbi_receive_price`-' . $acset_res->acset_actual_price . ', `prbi_zero_price`=`prbi_zero_price`-' . $acset_res->acset_zero_price . ',`prbi_state`= ' . $orbi_state . ',`prbi_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `prbi_id`=?', [$acset_res->acset_original_id]);
                if (!$update_acpa || !$update_bill_prbi) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 5: //5销售账单
                // 更改账单的应收账款金额
                $recr_edit_data['recr_actual_price'] = $find_original_data->recr_actual_price - $acset_res->acset_actual_price;
                $recr_edit_data['recr_yet_receipt'] = $find_original_data->recr_yet_receipt - $acset_res->acset_actual_price;
                $recr_edit_data['recr_zero_price'] = $find_original_data->recr_zero_price - $acset_res->acset_zero_price;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $update_recr = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', 6)
                    ->where('recr_account_type', 7)
                    ->where('recr_id', $find_original_data->recr_id)
                    ->update($recr_edit_data);

                // 已收金额
                $sell_bill_data = DB::table('sell_bill')
                    ->where('sebi_id', $acset_res->acset_original_id)
                    ->first(['sebi_receive_price']);
                //如果已收金额等于结款明细的实际金额那就是一次性结清
                if ($sell_bill_data->sebi_receive_price == $acset_res->acset_actual_price) {
                    $orbi_state = 1;
                } elseif ($sell_bill_data->sebi_receive_price > $acset_res->acset_actual_price) {
                    $orbi_state = 5;
                }
                $update_bill_sebi = DB::update('UPDATE `faster_sell_bill` SET `sebi_receive_price`=`sebi_receive_price`-' . $acset_res->acset_actual_price . ', `sebi_zero_price`=`sebi_zero_price`-' . $acset_res->acset_zero_price . ',`sebi_state`= ' . $orbi_state . ',`sebi_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `sebi_id`=?', [$acset_res->acset_original_id]);

                if ($acset_res->acset_payment_type == 3) {
                    // 结款方式为预收款抵账的，需要把预收款的金额还回去
                    // 查询结款明细对应的预付款id
                    $rede_advance_id = DB::table('receivable_details')
                        ->where('rede_acset_id', $request['acset_id'])
                        ->value('rede_advance_id');

                    $recr_res = DB::update('UPDATE `faster_receivable_credit` SET `recr_yet_receipt`=`recr_yet_receipt`-' . $acset_res->acset_actual_price . ',`recr_actual_price`=`recr_actual_price`+' . $acset_res->acset_actual_price . ',`recr_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `recr_id`=?', [$rede_advance_id]);
                } else {
                    $recr_res = true;
                }

                if (!$update_recr || !$update_bill_sebi || !$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 6: //6预收款
                // 删除预收款的应收账款信息
                $recr_del = DB::table('receivable_credit')
                    ->where('recr_account_type', 8)
                    ->where('recr_id', $find_original_data->recr_id)
                    ->delete();
                if (!$recr_del) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 7: //7采购入库单现金
                $proc_update = DB::table('procurement as p')
                    ->leftjoin('procurement_goods as pg', 'pg.prgo_proc_id', '=', 'p.proc_id')
                    ->where('p.proc_acpa_id', $find_original_data->acpa_id)
                    ->update([
                        'p.proc_actual_price' => 0,
                        'p.proc_actual_count' => 0,
                        'pg.prgo_actual_number' => 0,
                        'p.proc_state' => 2
                    ]);
                if (!$proc_update) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 8: //8预付款
                // 删除应收账款信息
                $acpa_del = DB::table('accounts_payable')
                    ->where('acpa_id', $find_original_data->acpa_id)
                    ->delete();
                if (!$acpa_del) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 9: //9订单代收
                // 更改订单代收的应收账款状态
                // acset_inex_type 类型1收入2支出
                if ($acset_res->acset_inex_type == 1) {
                    // 如果是收入状态，说明是订单代收的收款,需要驳回到待收款状态
                    $recr_leisurely_type = 0;
                } else {
                    // 如果是支出状态，说明是订单代收的还款，需要驳回到待还款状态
                    $recr_leisurely_type = 2;
                }
                // 订单代收状态：0待收款 1收款待核对 2收款已核对/待还款 3还款待核对 4还款已核对
                $recr_edit_data['recr_leisurely_type'] = $recr_leisurely_type;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $update_recr = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', 3)
                    ->where('recr_account_type', 2)
                    ->where('recr_id', $find_original_data->recr_id)
                    ->update($recr_edit_data);
                // 驳回的时候，订单表的代收金额需要再加上
                $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_edit_data['ord_collection_price'] = $acset_res->acset_actual_price;
                $ord_res = DB::table('order')
                    ->where('ord_id', $acset_res->acset_original_id)
                    ->update($ord_edit_data);
                if (!$update_recr || !$ord_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 10: //采购入库单预付款
                // 更改订单代收的付账款状态
                // 采购入库表
                $find_proc = DB::table('procurement')
                    ->where('proc_id', $acset_res->acset_original_id)
                    ->where('proc_number', $acset_res->acset_original_number)
                    ->first(['proc_acpa_id']);
                // 已收金额
                $acpa_data = DB::table('accounts_payable')
                    ->where('acpa_id', $find_proc->proc_acpa_id)
                    ->first(['acpa_yet_receipt']);

                $yet_receipt = $acpa_data->acpa_yet_receipt - $acset_res->acset_actual_price;
                // 查询所使用的预付款信息
                $acpa_update = DB::table('accounts_payable')
                    ->where('acpa_id', $find_proc->proc_acpa_id)
                    ->increment('acpa_actual_price', $acset_res->acset_actual_price, ['acpa_yet_receipt' => $yet_receipt]);
                // 删除应收账款信息
                $acpa_del = DB::table('accounts_payable')
                    ->where('acpa_id', $find_original_data->acpa_id)
                    ->delete();
                if (!$acpa_del || !$acpa_update) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 11: //订单退款驳回
                // 查询是否有代收
                $find_original_data = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_account_type', 2)
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->select('recr_id', 'recr_actual_price', 'recr_yet_receipt', 'recr_zero_price')
                    ->first();
                if ($find_original_data) {
                    // 将应收账款的收款状态改为 待还款
                    $recr_edit_data['recr_leisurely_type'] = 2;
                    $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                    $recr_edit_res = DB::table('receivable_credit')
                        ->where('recr_id', $find_original_data->recr_id)
                        ->update($recr_edit_data);
                } else {
                    $recr_edit_res = true;
                }
                //将订单状态改为 未结算状态
                $order_update = DB::table('order')
                    ->where('ord_cid', $user_info->adm_cid)
                    ->where('ord_superior_shop_id', $shop_id)
                    ->where('ord_id', $acset_res->acset_original_id)
                    ->where('ord_order_number', $acset_res->acset_original_number)
                    ->update(['ord_state' => 1, 'ord_update_time' => date('Y-m-d H:i:s')]);
                if (!$recr_edit_res || !$order_update) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 12: //工单代收
                // 将应收账款的收款状态改为 待收款
                $recr_edit_data['recr_leisurely_type'] = 0;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_edit_res = DB::table('receivable_credit')
                    ->where('recr_id', $find_original_data->recr_id)
                    ->update($recr_edit_data);
                $wor_res = DB::table('work_order')
                    ->where('wor_id', $acset_res->acset_original_id)
                    ->update(['wor_update_time' => date('Y-m-d H:i:s'), 'wor_collection_price' => $acset_res->acset_actual_price]);
                if (!$recr_edit_res || !$wor_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 13: //订单完成后结算
                if ($acset_res->acset_merge_type == 2) {
                    $find_recr_data = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', 3)
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->select('recr_id', 'recr_settle_price', 'recr_account_type', 'recr_plus_minus')
                        ->get();
                    foreach ($find_recr_data as $key => $value) {
                        if ($value->recr_account_type == 2) {
                            $collection = $value;
                            $recr_edit_data['recr_yet_receipt'] = 0;
                            $recr_edit_data['recr_leisurely_type'] = 2;
                            $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                            $ord_bill =  DB::table('receivable_credit')
                                ->where('recr_id', $value->recr_id)
                                ->update($recr_edit_data);
                            $recr_del = true;
                        } elseif ($value->recr_account_type == 1) {
                            $order_collection = $value;
                            $recr_edit_data['recr_yet_receipt'] = 0;
                            $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                            $recr_del =  DB::table('receivable_credit')
                                ->where('recr_id', $value->recr_id)
                                ->update($recr_edit_data);
                            $ord_bill = true;
                        }
                    }
                    if (empty($recr_del) || empty($ord_bill)) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                    }
                    $recr_edit_res = true;
                } else {
                    // 将应收账款的已收金额改为0
                    $recr_edit_data['recr_yet_receipt'] = 0;
                    $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                    $recr_edit_res = DB::table('receivable_credit')
                        ->where('recr_id', $find_original_data->recr_id)
                        ->update($recr_edit_data);
                }

                // 将订单的状态改为 未结算状态
                $ord_edit_data['ord_state'] = 1;
                $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_res = DB::table('order')
                    ->where('ord_id', $acset_res->acset_original_id)
                    ->update($ord_edit_data);

                if (!$recr_edit_res || !$ord_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 14: //非实物开单
                // 将应收账款的数据删除
                $recr_del_res = DB::table('receivable_credit')
                    ->where('recr_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                if (!$recr_del_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 15: //订单冲单
                // 将应收账款的数据删除
                $recr_del_res = DB::table('receivable_credit')
                    ->where('recr_type', 10)
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                if (!$recr_del_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 16: //16加盟店订单收款
                // 查询加盟店订单代收核销状态
                $find_recr_state = DB::table('receivable_credit')
                    ->where('recr_type', 12)
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->value('recr_state');
                // 加盟店的订单代收已经核销
                if ($find_recr_state == 2) {
                    // 将加盟店的订单收款改成未核销状态
                    $recr_edit_data['recr_leisurely_type'] = 0;
                    $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                    $recr_res = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', 11)
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->update($recr_edit_data);
                    // 加盟店的订单代收未核销
                } else {
                    // 将加盟店的订单收款、订单代收都删除
                    $recr_res = DB::table('receivable_credit')
                        ->where('recr_type', 11)
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->delete();
                    if (!empty($find_recr_state)) {
                        // 删除加盟店的订单代收
                        $recr_del_res = DB::table('receivable_credit')
                            ->where('recr_type', 12)
                            ->where('recr_original_id', $acset_res->acset_original_id)
                            ->where('recr_original_number', $acset_res->acset_original_number)
                            ->delete();
                        // 删除加盟店的订单代收的结款明细
                        $acse_del =  DB::table('accounting_settlement')
                            ->where('acset_type', 17)
                            ->where('acset_original_id', $acset_res->acset_original_id)
                            ->where('acset_original_number', $acset_res->acset_original_number)
                            ->delete();
                    }
                    // 应收账款，结款明细删除之后，对应的订单改成未结算状态
                    $ord_res =  DB::table('order')
                        ->where('ord_id', $acset_res->acset_original_id)
                        ->where('ord_order_number', $acset_res->acset_original_number)
                        ->update(['ord_state' => 1, 'ord_update_time' => date('Y-m-d H:i:s')]);
                }
                if (!$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 17: //17加盟店订单代收
                // 将加盟店的订单收款改成未核销状态
                $recr_edit_data['recr_leisurely_type'] = 2;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', 12) //12加盟店订单代收
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->update($recr_edit_data);
                if (!$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 18: //加盟店工单驳回
                $recr_edit_data['recr_leisurely_type'] = 0;
                $recr_edit_data['recr_yet_receipt'] = 0;
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                //如果是合并代收
                if ($acset_res->acset_merge_type == 2) {
                    // 将加盟店的订单收款改成未核销状态
                    $recr_res = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', 4) //工单账单
                        ->where('recr_account_type', 4) //工单账单
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->update($recr_edit_data);
                    $recr_edit_data['recr_leisurely_type'] = 2;
                    $recr_res_two = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', 4) //工单账单
                        ->where('recr_account_type', 3) //工单账单
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->update($recr_edit_data);
                } else {
                    $recr_res = true;
                    $recr_res_two = DB::table('receivable_credit')
                        ->where('recr_cid', $user_info->adm_cid)
                        ->where('recr_shop_superior_id', $shop_id)
                        ->where('recr_type', 4) //工单账单
                        ->where('recr_account_type', $recr_account_type)
                        ->where('recr_original_id', $acset_res->acset_original_id)
                        ->where('recr_original_number', $acset_res->acset_original_number)
                        ->update($recr_edit_data);
                }
                // 应收账款，结款明细删除之后，对应的工单改成未结算状态
                $ord_res =  DB::table('work_order')
                    ->where('wor_id', $acset_res->acset_original_id)
                    ->where('wor_number', $acset_res->acset_original_number)
                    ->update(['wor_account_state' => 1, 'wor_update_time' => date('Y-m-d H:i:s')]);
                if (!$recr_res || !$recr_res_two) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 19: //旧货回收
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type) //旧货回收
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                $junk['jur_add_type'] = 2;
                $junk['jur_state'] = 1;
                $junk_res = DB::table('junk_recycle')
                    ->where('jur_id', $acset_res->acset_original_id)
                    ->where('jur_number', $acset_res->acset_original_number)
                    ->update($junk);
                if (!$recr_res || !$junk_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 20: //售后
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type)
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                if (!$recr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 21: //21销售出库单
                $sell['sell_state'] = 5; //状态1保存/待提交2提交/待审核3通过/待出库4驳回5出库（6部分出库7异常出库 暂时不用）
                $sell['sell_settlement_state'] = 1; //结算状态1未结算2已结算
                $sell['sell_update_time'] = date('Y-m-d H:i:s');
                $sell_res = DB::table('sell')
                    ->where('sell_id', $acset_res->acset_original_id)
                    ->where('sell_number', $acset_res->acset_original_number)
                    ->update($sell);
                if (!$sell_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 22: //22采购单
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type) //旧货回收
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                $puor_data['cg_state'] = 3; //状态待处理
                $puor_data['edit_time'] = date('Y-m-d H:i:s');
                $cg_number = DB::table('ware_inorder')
                    ->where('rk_id', $acset_res->acset_original_id)
                    ->where('rk_number', $acset_res->acset_original_number)
                    ->value('cg_number');
                $puor_res = DB::table('purchase_order')
                    ->where('cg_number', $cg_number)
                    ->update($puor_data);
                if (!$recr_res || !$puor_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 23: //23采购退货单
                $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_cid', $user_info->adm_cid)
                    ->where('recr_shop_superior_id', $shop_id)
                    ->where('recr_type', $recr_type) //旧货回收
                    ->where('recr_original_id', $acset_res->acset_original_id)
                    ->where('recr_original_number', $acset_res->acset_original_number)
                    ->delete();
                $puor_data['cg_state'] = 3; //状态待处理
                $puor_data['edit_time'] = date('Y-m-d H:i:s');
                $cg_number = DB::table('ware_inorder')
                    ->where('rk_id', $acset_res->acset_original_id)
                    ->where('rk_number', $acset_res->acset_original_number)
                    ->value('cg_number');
                $puor_res = DB::table('purchase_order')
                    ->where('cg_number', $cg_number)
                    ->update($puor_data);

                if (!$recr_res || !$puor_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 24: //24预付款
                //删除应付账款信息
                $acpa_del = DB::table('receivable_credit')
                    ->where('recr_id', $find_original_data->recr_id)
                    ->delete();
                if (!$acpa_del) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 25: //25批量结算
                $more_data = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->get(['more_recr_id', 'more_zero_price', 'more_zero_plus_minus', 'more_this_settle_price', 'more_this_plus_minus', 'more_orbi_id']);
                foreach ($more_data as $key => $value) {
                    $sequence_res = $this->checkSequence($value->more_orbi_id, $request['acset_id'], 2);
                    if (!empty($sequence_res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请按照账单结款顺序进行确认']);
                    }
                }

                $time = date('Y-m-d H:i:s');
                foreach ($more_data as $key => $value) {
                    $rece_data['recr_zero_price'] = 0;
                    $rece_data['recr_zero_plus_minus'] = 1;
                    $rece_data['recr_update_time'] = $time;
                    $rece_data['recr_state'] = 1;
                    $res = DB::table('receivable_credit')
                        ->where('recr_id', $value->more_recr_id)
                        ->decrement('recr_yet_receipt', $value->more_this_settle_price, $rece_data);
                    if (empty($res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                    }
                }
                $more_del = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->delete();
                foreach ($more_data as $key => $value) {
                    $orbi = DB::table('order_bill')->where('orbi_id', $value->more_orbi_id)->first(['orbi_receive_price', 'orbi_zero_price']);
                    if ($orbi->orbi_receive_price == $value->more_this_settle_price) {
                        $orbi_data['orbi_state'] = 1;
                    } else {
                        $orbi_data['orbi_state'] = 5;
                    }
                    //此账单已经抹零  并且本次驳回不是抹零那次
                    if ($orbi->orbi_zero_price > 0 && $value->more_zero_price == 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请首先驳回本账单抹零结款']);
                    }

                    $orbi_data['orbi_zero_price'] = 0;
                    $orbi_data['orbi_update_time'] = $time;
                    $res = DB::table('order_bill')
                        ->where('orbi_id', $value->more_orbi_id)
                        ->decrement('orbi_receive_price', $value->more_this_settle_price, $orbi_data);
                    if (empty($res)) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                    }
                }

                if ($acset_res->acset_payment_type == 3) {
                    // 结款方式为预收款抵账的，需要把预收款的金额还回去
                    // 查询结款明细对应的预付款id
                    $rede_advance_id = DB::table('receivable_details')
                        ->where('rede_acset_id', $request['acset_id'])
                        ->value('rede_advance_id');

                    $recr_res = DB::update('UPDATE `faster_receivable_credit` SET `recr_yet_receipt`=`recr_yet_receipt`-' . $acset_res->acset_actual_price . ',`recr_state` = 3,`recr_actual_price`=`recr_actual_price`+' . $acset_res->acset_actual_price . ',`recr_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `recr_id`=?', [$rede_advance_id]);
                } else {
                    $recr_res = true;
                }

                if (!$more_del) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
                }
                break;
            case 26: //26期初账单
                $more_data = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->first(['more_recr_id', 'more_zero_price', 'more_zero_plus_minus', 'more_this_settle_price', 'more_this_plus_minus', 'more_orbi_id']);
                $time = date('Y-m-d H:i:s');
                $rece_data['recr_zero_price'] = 0;
                $rece_data['recr_zero_plus_minus'] = 1;
                $rece_data['recr_update_time'] = $time;
                $rece_data['recr_state'] = 1;
                $res = DB::table('receivable_credit')
                    ->where('recr_id', $more_data->more_recr_id)
                    ->decrement('recr_yet_receipt', $more_data->more_this_settle_price, $rece_data);
                if (empty($res)) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                }

                $more_del = DB::table('money_record')
                    ->where('more_acset_id', $request['acset_id'])
                    ->delete();

                $orbi = DB::table('order_bill')
                    ->where('orbi_id', $more_data->more_orbi_id)
                    ->first(['orbi_receive_price', 'orbi_zero_price']);
                if ($orbi->orbi_receive_price == $more_data->more_this_settle_price) {
                    $orbi_data['orbi_state'] = 1;
                } else {
                    $orbi_data['orbi_state'] = 5;
                }

                // 此账单已经抹零  并且本次驳回不是抹零那次
                if ($orbi->orbi_zero_price > 0 && $more_data->more_zero_price == 0) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请首先驳回本账单抹零结款']);
                }

                $orbi_data['orbi_zero_price'] = 0;
                $orbi_data['orbi_update_time'] = $time;
                $res = DB::table('order_bill')
                    ->where('orbi_id', $more_data->more_orbi_id)
                    ->decrement('orbi_receive_price', $more_data->more_this_settle_price, $orbi_data);
                if ($acset_res->acset_payment_type == 3) {
                    // 结款方式为预收款抵账的，需要把预收款的金额还回去
                    // 查询结款明细对应的预付款id
                    $rede_advance_id = DB::table('receivable_details')
                        ->where('rede_acset_id', $request['acset_id'])
                        ->value('rede_advance_id');

                    $recr_res = DB::update('UPDATE `faster_receivable_credit` SET `recr_yet_receipt`=`recr_yet_receipt`-' . $acset_res->acset_actual_price . ',`recr_state` = 3,`recr_actual_price`=`recr_actual_price`+' . $acset_res->acset_actual_price . ',`recr_update_time`= "' . date('Y-m-d H:i:s') . '" WHERE `recr_id`=?', [$rede_advance_id]);
                } else {
                    $recr_res = true;
                }

                if (empty($res) || empty($recr_res)) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                }
                break;
            default:
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回处理失败！']);
                break;
        }

        // 删除驳回的结款明细数据
        $acse_del =  DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->delete();

        if ($acse_del) {
            Common::addLog($user_info, getRealIp($request), '结款明细', '驳回', $acset_res->acset_number . '驳回成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'驳回成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
        }
    }

    // 结款详情
    public function moneyDetails(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        if (empty($request['acset_id'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        $search_data = $request->all();
        $list_data = DB::table('money_record as mr')
            ->leftjoin('order_bill as ob', 'ob.orbi_id', '=', 'mr.more_orbi_id')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'ob.orbi_create_adm_id')
            ->where('more_acset_id', $request['acset_id'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orbi_number'])) {
                    $query->where('orbi_number', 'like', '%' . $search_data['orbi_number'] . '%');
                }
            })
            ->select('orbi_number', 'adm_name', 'more_state', 'orbi_actual_price as orbi_bill_price', 'orbi_plus_minus', 'more_this_settle_price')
            ->orderBy('more_id', 'desc')
            ->paginate($this->show_count);

        $info = DB::table('accounting_settlement as as')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'as.acset_adm_id')
            ->leftjoin('account_title as at', 'at.acti_id', '=', 'as.acset_acti_id')
            ->where('acset_id', $request['acset_id'])
            ->first(['acset_number', 'acset_with_time', 'adm_name', 'acset_client_id', 'acset_actual_price', 'acset_zero_price', 'acset_inex_type', 'acset_zero_plus_minus', 'acset_type', 'acti_course_title', 'acset_client_name', 'acset_payment_type', 'acset_img', 'acset_remark']);
        $info->advances = '';
        $orbi_bill_price = 0;
        if (!empty($list_data->items())) {
            foreach ($list_data->items() as $key => $value) {
                $orbi_bill_price += $value->orbi_bill_price;
            }
        }
        $info->orbi_bill_price = $orbi_bill_price;
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据
        $data_info['info'] = $info;                              //详情

        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 导出
    public function moneyExport(Request $request)
    {
        if (empty($request['acset_id'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误']);
        }

        $search_data = $request->all();
        $list_data = DB::table('money_record as mr')
            ->leftjoin('order_bill as ob', 'ob.orbi_id', '=', 'mr.more_orbi_id')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'ob.orbi_create_adm_id')
            ->where('more_acset_id', $request['acset_id'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orbi_number'])) {
                    $query->where('orbi_number', 'like', '%' . $search_data['orbi_number'] . '%');
                }
            })
            ->select('orbi_number', 'adm_name', 'more_state', 'orbi_bill_price', 'orbi_plus_minus', 'more_this_settle_price', 'more_zero_price', 'more_zero_plus_minus')
            ->orderBy('more_id', 'desc')
            ->get();

        $data['data'] = json_decode(json_encode($list_data), true);
        if (empty($data['data'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合搜索条件的数据！']);
        }

        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        foreach ($data['data'] as $key => $value) {
            if ($value['orbi_plus_minus'] == 2) {
                $data['data'][$key]['orbi_bill_price'] = '-' . $value['orbi_bill_price'] / 100; //合计金额
                $data['data'][$key]['more_this_settle_price'] = '-' . $value['more_this_settle_price'] / 100; //合计金额
            } else {
                $data['data'][$key]['orbi_bill_price'] = $value['orbi_bill_price'] / 100; //合计金额
                $data['data'][$key]['more_this_settle_price'] = $value['more_this_settle_price'] / 100; //合计金额
            }
            if ($value['more_zero_plus_minus'] == 1) {
                $data['data'][$key]['more_zero_price'] = $value['more_zero_price'] / 100; //合计金额
            } else {
                $data['data'][$key]['more_zero_price'] = '-' . $value['more_zero_price'] / 100; //合计金额
            }
            if ($value['more_state'] == 1) {
                $data['data'][$key]['more_state'] = '未结清';
            } else {
                $data['data'][$key]['more_state'] = '已结清';
            }
            unset($data['data'][$key]['orbi_plus_minus']);
            unset($data['data'][$key]['more_zero_plus_minus']);
        }

        $info = DB::table('accounting_settlement as as')
            ->leftjoin('admin as a', 'a.adm_id', '=', 'as.acset_adm_id')
            ->leftjoin('account_title as at', 'at.acti_id', '=', 'as.acset_acti_id')
            ->where('acset_id', $request['acset_id'])
            ->first(['acset_number', 'acset_with_time', 'adm_name', 'acset_client_id', 'acset_actual_price', 'acset_zero_price', 'acset_inex_type', 'acset_zero_plus_minus', 'acset_type', 'acti_course_title', 'acset_client_name', 'acset_payment_type']);
        $acc_info = [];
        $acc_info['acset_number'] = '流水号:' . $info->acset_number;
        $acc_info['acset_with_time'] = '结款时间:' . $info->acset_with_time;
        $acc_info['adm_name'] = '结款人:' . $info->adm_name;
        if ($info->acset_inex_type == 2) {
            $acc_info['acset_actual_price'] = '合计金额:-' . $info->acset_actual_price / 100;
        } else {
            $acc_info['acset_actual_price'] = '合计金额:' . $info->acset_actual_price / 100;
        }
        if ($info->acset_zero_plus_minus == 2) {
            $acc_info['acset_zero_price'] = '抹零金额:-' . $info->acset_zero_price / 100;
        } else {
            $acc_info['acset_zero_price'] = '抹零金额:' . $info->acset_zero_price / 100;
        }
        $acc_info['acset_client_name'] = '发生对象:' . $info->acset_client_name;
        $data['info'] = $acc_info;

        $streamFileRand = $info->acset_number . '-' . rand(10000, 99999) . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '结款明细';
        $where['field_name'] = ['账单编号', '创建人', '状态', '账单总额', '本期结款金额', '抹零金额'];
        // 调用导出的公共方法
        Common::headExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 生成凭证
    public function workOrderVoucher(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id1
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        ignore_user_abort();
        set_time_limit(0);

        // 查询结款明细表,状态为已确认,U8状态未同步的数据
        $find_acset_data = DB::table('accounting_settlement')
            ->where('acset_adm_cid', $user_info->adm_cid)
            ->where('acset_shop_id', $user_info->adm_shop_id)
            ->where('acset_state', 2)
            ->where('acset_sync_state', 1)
            ->where('acset_type', '!=', 26)
            ->select('acset_id', 'acset_shop_id', 'acset_with_time', 'acset_affirm_time', 'acset_actual_price', 'acset_price', 'acset_owe_price', 'acset_zero_price', 'acset_zero_plus_minus', 'acset_type', 'acset_inex_type', 'acset_acti_id', 'acset_payment_type')
            ->get()->toArray();
        foreach ($find_acset_data as $key => $value) {
            // 凭证借贷表(结算金额)
            $volo_data[0]['acsl_shop_id'] = $value->acset_shop_id; //所属门店id
            $volo_data[0]['acsl_acset_id'] = $value->acset_id;
            $volo_data[0]['acsl_type'] = 1; //类型1借方2贷方
            $volo_data[1]['acsl_shop_id'] = $value->acset_shop_id; //所属门店id
            $volo_data[1]['acsl_acset_id'] = $value->acset_id;
            $volo_data[1]['acsl_type'] = 1; //类型1借方2贷方
            // 根据银行账号id,查询出对应的名称
            $find_acti_data = DB::table('account_title')
                ->where('acti_id', $value->acset_acti_id)
                ->where('acti_shop_id', $user_info->adm_shop_id)
                ->select('acti_subject_code', 'acti_course_title')
                ->first();
            if ($value->acset_type == 1) { //订单结算,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    if ($value->acset_zero_plus_minus == '1') {
                        $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                    } else {
                        $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                    }
                }
            } elseif ($value->acset_type == 2) { //订单账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        if ($value->acset_inex_type == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        }
                    } else {
                        if ($value->acset_inex_type == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            } elseif ($value->acset_type == 3) { //工单账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        }
                    } else {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            } elseif ($value->acset_type == 4) { //采购账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应付账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        }
                    } else {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应付账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            } elseif ($value->acset_type == 6) { //6预收款,收款；借：银行存款    贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    if ($value->acset_zero_plus_minus == '1') {
                        $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                    } else {
                        $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                    }
                }
            } elseif ($value->acset_type == 9) { //9订单代收
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    }
                } else {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    }
                }
            } elseif ($value->acset_type == 11) { //11.订单退款:借应收账款,贷:库存现金或银行存款
                $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 12) { //12工单代收,收款；借：库存现金或银行存款  贷：应收账款
                if ($value->acset_zero_price == '0') {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    }
                } else {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    }
                }
            } elseif ($value->acset_type == 13) { //13订单完成后结算,收款；借：库存现金或银行退款 贷：应收账款
                if ($value->acset_zero_price == '0') {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    }
                } else {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    }
                }
            } elseif ($value->acset_type == 16) { //16.加盟店订单收款,借:库存现金或银行存款,贷:应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 17) { //17.加盟店订单代收,借:应收账款（加盟店）,贷:应收账款（委托方）
                // 收到加盟店转来代收款时，借：库存现金或银行存款  贷：应收账款（加盟店）
                $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 18) { //18工单结算-工单费用, 付款；借：库存现金或银行存款 贷：应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 19) { //19.旧货回收,借:库存商品,贷:应收账款
                $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 20) { //20.售后单结算,借:库存现金或银行存款,贷:应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    if ($value->acset_zero_plus_minus == '1') {
                        $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                    } else {
                        $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                    }
                }
            } elseif ($value->acset_type == 22) { //22.采购单,借：库存商品,贷：应付账款
                $volo_data[0]['acsl_borrow_subject'] = '220202'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 23) { //23.采购退货单,付款；借：应付账款 贷：银行存款
                if ($value->acset_zero_price == '0') {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220202'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = '220202'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    }
                } else {
                    if ($value->acset_inex_type == 2) {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = '220201'; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        if ($value->acset_zero_plus_minus == '1') {
                            $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                        }
                    }
                }
            } elseif ($value->acset_type == 24) { //24.采购款到发货(预付款)
                $volo_data[0]['acsl_borrow_subject'] = '220202'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 25) { //批量结算,借:库存商品或银行存款,贷:应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                        }
                    } else {
                        if ($value->acset_inex_type == 2) {
                            $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $value->acset_price / 100; //贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                            $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                            if ($value->acset_zero_plus_minus == '1') {
                                $volo_data[1]['acsl_loan_price'] = $value->acset_zero_price / 100; //贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            }

            $volo_data[0]['acsl_update_time'] = $value->acset_affirm_time; //更新时间
            $volo_data[1]['acsl_update_time'] = $value->acset_affirm_time; //更新时间
            $volo_id = DB::table('accounting_settlement_loan')->insert($volo_data);
        }
        if ($volo_id) {
            Common::addLog($user_info, getRealIp($request), '结款明细', '生成凭证', '生成凭证成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'生成凭证成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'生成凭证失败']);
        }
    }

    // 删除
    public function delete(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $find_vore_data = DB::table('accounting_settlement_loan as acsl')
            ->leftjoin('accounting_settlement as acset', 'acsl.acsl_acset_id', '=', 'acset.acset_id')
            ->where('acset_adm_cid', $user_info->adm_cid)
            ->where('acset_shop_id', $shop_id)
            ->where('acset_sync_state', 1)
            ->get()->toArray();
        if (empty($find_vore_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有可删除的业务凭证数据']);
        }

        // 先删除凭证借贷表数据
        $volo_res = DB::table('accounting_settlement_loan')
            ->where('acsl_shop_id', $shop_id)
            ->delete();
        if ($volo_res) {
            Common::addLog($user_info, getRealIp($request), '结款明细', '全部删除', '删除凭证成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'删除成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'删除失败']);
        }
    }

    // 结款明细同步U8
    public function sync(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        // 验证数据
        $verify_data = new VerifyAccountingSettlementController;
        $error_message = $verify_data->syncValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 判断当前结款明细是否存在
        $settlement_data = DB::table('accounting_settlement')
            ->whereIn('acset_id', $request['acset_id'])
            ->where('acset_sync_state', 1)
            ->select('acset_id', 'acset_original_number', 'acset_type', 'acset_state', 'acset_original_id', 'acset_inex_type', 'acset_actual_price', 'acset_zero_price', 'acset_acti_id', 'acset_payment_type', 'acset_merge_type', 'acset_price', 'acset_number', 'acset_zero_plus_minus', 'acset_price', 'acset_sync_state')
            ->get()->toArray();
        if (empty($settlement_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细不存在']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        if (empty($request['now_date'])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择同步U8时间']);
        }
        $now_date = $request['now_date'];

        $acset_numbers = '';
        foreach ($settlement_data as $key => $value) {
            if ($value->acset_state == '1') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'流水号：' . $value->acset_number . '，单号：' . $value->acset_original_number . '，当前结款明细尚未确认，无法同步U8']);
            }
            if ($value->acset_sync_state == '2') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'流水号：' . $value->acset_number . ',单号：' . $value->acset_original_number . '，当前凭证已同步U8']);
            }
            $acset_number[] = $value->acset_number;
            $acset_original_number[] = $value->acset_original_number;
            $request_voucher['recr_acti_id'] = $value->acset_acti_id; //银行账号id
            $request_voucher['voucher_price'] = $value->acset_actual_price / 100; //结款明细金额
            $u8_return = YongYous::apiAccountVerify($user_info, (array)$value, $request_voucher, $now_date); //调用u8接口

            $log_data['u8_return'] = $u8_return;

            if ($u8_return['code'] == 500) {
                if ($u8_return['vou_data']) {
                    // 如果凭证添加失败，凭证号自动加1
                    YongYous::insertVoucher($user_info, $u8_return['vou_data'], 1);
                }
                $acset_numbers .= '流水号：' . $value->acset_number . '，单号：' . $value->acset_original_number . '，';
            } else {
                $acset_data['acset_sync_state'] = 2;
                $acset_data['acset_update_time'] = date('Y-m-d H:i:s');
                $acset_res = DB::table('accounting_settlement')
                    ->where('acset_id', $value->acset_id)
                    ->update($acset_data);
            }
        }

        if (!empty($acset_numbers)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>$acset_numbers . '，U8财务系统凭证上传失败2！']);
        }

        $log_data['time'] = date('Y-m-d H:i:s');
        $log_data['user_info'] = $user_info;
        $log_data['acset_number'] = $acset_number;
        Common::write_record_log($log_data, 'pc/AccountingSettlementController.txt', 'sync');

        if ($acset_res) {
            Common::addLog($user_info, getRealIp($request), '结款明细', '同步U8', '流水号(' . implode(',', $acset_number) . '，单号(' . implode(',', $acset_original_number) . ')同步成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'U8财务系统凭证上传失败啦！']);
        }
    }
}
