<?php

namespace App\Factory;
use BlueCity\Core\Inc\ServiceInc;
use App\Repository\Order\ApplyOrder;
use App\Repository\Order\HelpOrder;
use App\Repository\Order\PaintOrder;
use App\Repository\Order\PowderOrder;
use App\Repository\Order\WearingOrder;

class OrderFactory
{
    public static function make($orderType)
    {
        if ($orderType == ServiceInc::SERVICE_POWDER) {
            return new PowderOrder();
        }
        if ($orderType == ServiceInc::SERVICE_WEARING) {
            return new WearingOrder();
        }
        if ($orderType == ServiceInc::SERVICE_HELP) {
            return new HelpOrder();
        }
        if ($orderType == ServiceInc::SERVICE_APPLY) {
            return new ApplyOrder();
        }
        if ($orderType == ServiceInc::SERVICE_PAINT) {
            return new PaintOrder();
        }

        return false;
    }
}
