<?php

namespace App\Jobs;

use App\Jobs\Job;
use DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Queue\ShouldQueue;

class Integral extends Job implements SelfHandling, ShouldQueue
{
    /**
     * Create a new job instance.
     *
     * @param $sn transport表的sn
     * @param $codes 本次出入库的产品码
     * @param $find_adm 操作人
     * @param $type 操作类型: transIn(入库)transOut(出库)
     *
     */
    public function __construct($sn, $codes, $type = '', $find_adm='')
    {
        $this->sn = $sn;
        $this->codes = $codes;
        $this->type = $type;
        $this->find_adm = $find_adm;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $sn = $this->sn;
        $codes = $this->codes;
        $type = $this->type;
        $find_adm = $this->find_adm;

        $code_list = array();
        $total_integral = 0;
        foreach($codes as $code) {
            if(strpos($code,'G') === 0) {
                $sql = "SELECT id from trace_relation_code WHERE code='{$code}'";
                $relation_code = DB::select($sql);
                if(!$relation_code OR count($relation_code) < 1) {
                    continue;
                }
                //关联码
                $sql = "SELECT goods_id,goods_name,goods_code,code FROM trace_2019_code WHERE relation_chain like '%,{$relation_code[0]['id']},%'";
                $find_code = DB::select($sql);
                if(count($find_code) > 0) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }else {
                $sql = "SELECT goods_id,goods_name,goods_code,code FROM trace_2019_code WHERE code='{$code}' LIMIT 1";
                $find_code = DB::select($sql);
                if(count($find_code) == 1) {
                    $code_list = array_merge($code_list, $find_code);
                }
            }
        }
        //todo 去重
        DB::beginTransaction();
        $transport = DB::table('transport')->where('sn', $sn)->first();
        $transport_id = $transport['id'];
        $channel_id_to = $transport['channel_id_to'];
        $channel_id_from = $transport['channel_id_from'];
        $company_id = $transport['company_id'];
        //分批插入，一次100条
        $addtime = date('Y-m-d H:i:s');
        $i = 0;
        $insert_array = $value_array = [];
        try {
            foreach ($code_list as $value) {
                array_push($insert_array, [
                        'transport_id' => $transport_id,
                        'goods_id' => $value['goods_id'],
                        'goods_name' => $value['goods_name'],
                        'goods_code' => $value['goods_code'],
                        'code' => $value['code'],
                        'add_time' => $addtime]
                );
                $value_array[] = $value['code'];
                $i += 1;
                if ($i == 100) {
                    $ret = DB::table('transport_info')->insert($insert_array);
                    if(!$ret) {
                        throw new ExceptionNew("insert failed");
                    }

                    //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                    if($type == 'out') {
                        //添加渠道积分
                        $sql = "SELECT sum(b.channel_integral) as integral
                                FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                                WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'',$value_array)."')";
                        $tmp_integral = DB::select($sql);
                        if(count($tmp_integral) == 1 AND $tmp_integral[0]['integral'] > 0) {
                            $total_integral += $tmp_integral[0]['integral'];
                        }

                        $sql = "UPDATE trace_2019_code 
                            SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                            WHERE company_id={$company_id} AND code in ('".implode('\',\'',$value_array)."')";
                        DB::update($sql);
                    }

                    $i = 0;
                    $insert_array = $value_array = [];
                }
            }
            if (count($insert_array) > 0) {
                $ret = DB::table('transport_info')->insert($insert_array);
                if(!$ret) {
                    throw new ExceptionNew("insert failed");
                }
                //如果是入库操作，更新code表中的transport_chain,用户提供预警查询
                if($type == 'out') {
                    //添加渠道积分
                    $sql = "SELECT sum(b.channel_integral) as integral
                                FROM trace_2019_code a LEFT JOIN trace_goods b on a.goods_id=b.goo_id
                                WHERE a.company_id={$company_id} AND a.transport_chain='' AND a.code in ('".implode('\',\'',$value_array)."')";
                    $tmp_integral = DB::select($sql);
                    if(count($tmp_integral) == 1 AND $tmp_integral[0]['integral'] > 0) {
                        $total_integral += $tmp_integral[0]['integral'];
                    }
                    $sql = "UPDATE trace_2019_code 
                            SET transport_chain = CONCAT(transport_chain,',{$channel_id_to},')
                            WHERE code in ('".implode('\',\'',$value_array)."')";
                    DB::update($sql);
                }
            }
        }catch (Exception $e) {
            DB::rollback();
            return false;
        }
        //添加渠道积分
        if($total_integral > 0) {
            $sql = "SELECT chan_integral from trace_channels where chan_id={$channel_id_to} LIMIT 1";
            $channel_row = DB::select($sql);
            if(count($channel_row) == 1) {
                $sql = "UPDATE trace_channels SET chan_integral=chan_integral+{$total_integral} where chan_id={$channel_id_to} LIMIT 1";
                DB::update($sql);
                DB::table('integral_record')->insert([
                    'inte_cid' => $company_id,
                    'inte_chan_id' => $channel_id_to,
                    'inte_userid' => 0,
                    'inte_user_phone' => '',
                    'inte_user_name' => '',
                    'inte_state' => 1,
                    'inte_integral_number' => $total_integral,
                    'inte_content' => '入库',
                    'inte_type' => 1,
                    'inte_remain_integral' => $channel_row[0]['chan_integral']+$total_integral,
                    'inte_operation_name' => $find_adm['_admin_name'],
                    'inte_operation_id' => $find_adm['_admin_id'],
                    'inte_addtime' => $addtime
                ]);
            }
        }
        $total_num = count($code_list);
        DB::table('transport')->where('id', $transport_id)->update(['total_num' => $total_num]);
        //step.3.生成操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$find_adm['_admin_id'],
            'admin_name'=>$find_adm['_admin_name'],
            'company_id'=>$company_id,
            'channel_id'=>$type == 'in'?$channel_id_to:$channel_id_from,
            'obj_table'=>'transport',
            'obj_id'=>$transport_id,
            'name'=> $type == 'in'?'入库':'出库',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        DB::commit();
    }
}
