<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class RelationCodeModel extends Model
{
    public $timestamps = false;
    protected $table = 'relation_code';
    protected $fillable=['code','max_num','company_id','channel_id','add_time','state','up_code','chain_code'];

	// 获取新大关联码
    // company_id 公司id
	public static function getMaxCode($company_id)
	{
	    if(!$company_id) {
	        return false;
        }
		$find_code = DB::table('relation_code')
           	->where('company_id','=',$company_id)
            ->orderby('id','desc')
           	->first();
		return $find_code;
	}

}
