<?php

namespace App\Http\Models\Prevention;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;
class RegionModel extends Model
{
	private $page_size=10;

	/**
	 * 区域列表
	 * @param [type] $user 用户信息
	 */
    public function Region_List($user,$page,$where){
        $Db=Db::table('region')->join('channels','channels.chan_id','=','region.reg_canid')->where(['ent_cid'=>$user['adm_cid'],'reg_del'=>1]);
    	// $Db=Db::table('region')->where(['ent_cid'=>$user['adm_cid'],'reg_del'=>1]);
        // 防窜区名称
        if(!empty($where['group_name'])){
            $Db=$Db->where('group_name','like',"%".$where['group_name']."%");
        }
        if(!empty($where['chan_enterprise_name'])){
            $Db=$Db->where('chan_enterprise_name','like',"%".$where['chan_enterprise_name']."%");
        }
        if(!empty($where['chan_name'])){
            $Db=$Db->where('chan_name','like',"%".$where['chan_name']."%");
        }
        if(!empty($where['chan_phone'])){
            $Db=$Db->where('chan_phone','like',"%".$where['chan_phone']."%");
        }
        if(!empty($where['start'])){
            $Db=$Db->where('start','=',$where['start']);
        }
    	$count=$Db->count();
		$page_count=(int)ceil($count/$this->page_size);
		$limit=($page-1)*$this->page_size;
        $data=$Db->limit($this->page_size)->offset($limit)->orderBy('id','desc')->select('id','group_name as region_name','start as state','time','reg_canid','chan_enterprise_name','chan_name','chan_phone','chan_address')->get();
		// $data=$Db->limit($this->page_size)->offset($limit)->orderBy('id','desc')->select('id','group_name as region_name','start as state','time')->get();
		foreach ($data as $key => $value){
			$arr=Db::table('region_detailed')->where(['reg_id'=>$value['id']])->orderby('id','asc')->select('chi_id')->get();
			if(!empty($arr)){
				$data[$key]['region_address']=implode(',',array_column($arr,'chi_id'));
			}else{
				$data[$key]['region_address']='';
			}
		}
		$page=['count'=>$count,'page'=>$page,'page_size'=>$this->page_size,'page_count'=>$page_count];
		return ['code'=>200,'msg'=>'success','data'=>['page'=>$page,'region_data'=>$data]];
    }

    //获取添加使用的数据   
    public function getBreed_Data($user,$token){
    	$res=Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->delete();
    	$data=Db::table('china as a')->where('a.pid',0)->join('china as b','a.id','=','b.pid')->orderBy('a.id','asc')->selectRaw("trace_a.id as for_id,trace_a.initials as letter,trace_a.name as for_name,trace_b.name as name,trace_b.id as id,1 as state")->get();
    	$arr=[];
    	foreach ($data as $key => $value){
    		$arr[$value['for_id']]['id']=$value['for_id'];
    		$arr[$value['for_id']]['name']=$value['for_name'];
    		$arr[$value['for_id']]['letter']=$value['letter'];
    		$arr[$value['for_id']]['state']=$value['state'];
    		unset($data[$key]['for_name']);
    		unset($data[$key]['letter']);
    	}
    	foreach ($data as $key => $value){
    		$arr[$value['for_id']]['son_data'][]=$value;
    		// unset($da);
    	}
    	sort($arr);
        $channel = DB::table('channels as c')->where(['chan_cid'=>$user['adm_cid'],'chan_state'=>1])->select('chan_id','chan_enterprise_name','chan_name','chan_phone','chan_province','chan_city','chan_county','chan_address')->get();
    	return ['code'=>200,'msg'=>'success','data'=>$arr,'channel'=>$channel];
    }

    //添加区域
    public function Add_Region($group,$provinces,$user,$token){
    	try{
    		// return $provinces;
    		Db::beginTransaction();
    		Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->delete();
    		//判断是否区域名重复
    		$old_group=Db::table('region')->where(['reg_del'=>1,'group_name'=>$group['group_name'],'ent_cid'=>$user['adm_cid']])->select('id')->first();
    		if(!empty($old_group)){
    			throw new Exception("区域名称重复");
    		}
    		//添加区域并获取id
    		$group_id=Db::table('region')->insertGetId($group);
    		if(!$group_id){
    			throw new Exception("添加区域失败");
    		}
            //更加区域数据获取 二维数组里的数据
            $provinces_data=Db::table('china')->whereIn('id',$provinces)->where(['pid'=>0])->select('id','name','pid')->get();
            $city_data=Db::table('china')->whereIn('id',$provinces)->where('pid','!=',0)->select('id','name','pid')->get();
            if(count($provinces) != (count($provinces_data)+count($city_data))){
                throw new Exception("存在未知的城市");
            }
            $provinces_data=array_column($provinces_data,null,'id');

            foreach ($provinces_data as $key => $val){
                foreach ($city_data as $k => $v) {
                    $provinces_data[$v['pid']]['city'][]=$city_data[$k];
                    unset($city_data[$k]);
                } 
            }
            // return $provinces_data;

    		//循环处理数组
    		$arr=[];
    		$str=0;
    		foreach ($provinces_data as $key => $val){
    			foreach ($val['city'] as $k => $v) {
    				$arr[$str]['reg_id']=$group_id;
    				$arr[$str]['pid']=$provinces_data[$key]['name'];
    				$arr[$str]['provinces_id']=$provinces_data[$key]['id'];
    				$arr[$str]['chi_id']=$v['name'];
    				$arr[$str]['time']=$group['time'];
                    $arr[$str]['region_id']=$group['region_id'];
    				$arr[$str]['my_id']=$v['id'];
    				$str++;
    			}
    		}

    		//添加区域城市
    		$res2=Db::table('region_detailed')->insert($arr);
    		if(!$res2){
    			throw new Exception("添加区域里的城市失败");
    		}

    		// 写入操作日志表里
			$content='添加区域。区域名称:'.$group['group_name'];
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防窜管理->区域设置";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,'添加',$content);
			if(!$res) throw new Exception("写入操作日志表失败");
    		Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>'添加成功'];
    	}catch(Exception $e){
    		Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
    	}
    }
    /**
     * 编辑防窜区域
     * @param [type] $group     组数据
     * @param [type] $provinces 数据
     * @param [type] $user      用户
     * @param [type] $token     token 字符串
     */
    public function Edit_Region($group,$provinces,$user,$token){
    	try{
    		// return $provinces;
    		Db::beginTransaction();
    		Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->delete();
    		$old_group=Db::table('region')->where(['id'=>$group['id'],'ent_cid'=>$user['adm_cid']])->where('start','!=',3)->select('id','group_name','region_id')->first();
    		if(empty($old_group)){
    			throw new Exception("修改失败,没有发现这个区域",1);
    		}
    		//判断区域是否重复
    		$data=Db::table('region')->where(['reg_del'=>1,'group_name'=>$group['group_name'],'ent_cid'=>$user['adm_cid']])->where('id','!=',$group['id'])->select('id')->first();
    		if(!empty($data)){
    			throw new Exception("区域名称重复");
    		}
    		$group_id=$group['id'];
    		unset($group['id']);
    		$res=Db::table('region')->where(['id'=>$group_id])->update($group);
    		if(!$res){
    			throw new Exception("编辑失败");
    		}
    		$res2=Db::table('region_detailed')->where(['reg_id'=>$group_id])->delete();
    		if(!$res2){
    			throw new Exception("编辑--更改区域城市失败");
    		}

            //更加区域数据获取 二维数组里的数据
            $provinces_data=Db::table('china')->whereIn('id',$provinces)->where(['pid'=>0])->select('id','name','pid')->get();
            $city_data=Db::table('china')->whereIn('id',$provinces)->where('pid','!=',0)->select('id','name','pid')->get();
            if(count($provinces) != (count($provinces_data)+count($city_data))){
                throw new Exception("存在未知的城市");
            }
            $provinces_data=array_column($provinces_data,null,'id');

            foreach ($provinces_data as $key => $val){
                foreach ($city_data as $k => $v) {
                    $provinces_data[$v['pid']]['city'][]=$city_data[$k];
                    unset($city_data[$k]);
                } 
            }

            //循环处理数组
            $arr=[];
            $str=0;
            foreach ($provinces_data as $key => $val){
                foreach ($val['city'] as $k => $v) {
                    $arr[$str]['reg_id']=$group_id;
                    $arr[$str]['pid']=$provinces_data[$key]['name'];
                    $arr[$str]['provinces_id']=$provinces_data[$key]['id'];
                    $arr[$str]['chi_id']=$v['name'];
                    $arr[$str]['time']=$group['update_time'];
                    $arr[$str]['region_id']=$old_group['region_id'];
                    $arr[$str]['my_id']=$v['id'];
                    $str++;
                }
            }

            //添加区域城市
            $res2=Db::table('region_detailed')->insert($arr);
            if(!$res2){
                throw new Exception("添加区域里的城市失败");
            }

    		// 写入操作日志表里
			$content='编辑区域。区域名称:'.$group['group_name'];
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防窜管理->区域设置";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,'编辑',$content);
			if(!$res) throw new Exception("写入操作日志表失败");
    		Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>'编辑成功'];
    	}catch(Exception $e){
    		Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
    	}
    }

    //获取编辑区域数据
    public function Get_Edit_Region($user,$token,$group_id){
        Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->delete();
        // $chan = DB::table('channels')->where('chan_cid',$user['adm_cid'])->pluck('chan_id');
        $chan = Db::table('region')->where(['id'=>$group_id,'ent_cid'=>$user['adm_cid'],'reg_del'=>1])->pluck('reg_canid');
        $group_name=Db::table('region')->join('channels','channels.chan_id','=','region.reg_canid')->where(['id'=>$group_id,'ent_cid'=>$user['adm_cid']])->where('start','!=',3)->select('id','group_name','reg_canid','chan_id','chan_enterprise_name')->first();
        /*if ($chan == 0) {
            // echo "string";exit;
            $group_name=Db::table('region')->where(['id'=>$group_id,'ent_cid'=>$user['adm_cid']])->where('start','!=',3)->select('id','group_name')->first();
            if(empty($group_name)){
                return ['code'=>500,'msg'=>'error','data'=>'失败，没有找到该区域数据'];
            }
            $data=Db::table('region_detailed')->where(['reg_id'=>$group_id])->selectRaw("pid,chi_id as name,provinces_id as for_id,my_id as id,2 as state")->get();
            $region=[];
            $provinces=array_unique(array_column($data,'pid'));
            sort($provinces);
            $provinces_id=array_unique(array_column($data,'for_id'));
            sort($provinces_id);
            $str='';
            foreach ($provinces as $key => $value) {
                $str.=$provinces[$key].',';
                $region[$provinces_id[$key]]['id']=$provinces_id[$key];
                $region[$provinces_id[$key]]['name']=$provinces[$key];
                $region[$provinces_id[$key]]['state']=2;
            }
            $city=array_column($data,'name');
            $str=$str.implode($city,',');

            $add_data['type']=2;
            $add_data['token']=$token;
            $add_data['goods_id']=$str;

            Db::table('temporary_goods_id')->insert($add_data);

            foreach ($data as $key => $value) {
                unset($value['pid']);
                $region[$value['for_id']]['son_data'][]=$value;
            }
            sort($region);
            $old_data=explode(',',$str);

            $data=Db::table('china as a')->where('a.pid',0)->join('china as b','a.id','=','b.pid')->orderBy('a.id','asc')->selectRaw("trace_a.id as for_id,trace_a.initials as letter,trace_a.name as for_name,trace_b.name as name,trace_b.id as id,1 as state")->get();
            $arr=[];
            foreach ($data as $key => $value){
                if(in_array($data[$key]['name'],$old_data)){
                    $data[$key]['state']=2;
                }
                $arr[$value['for_id']]['id']=$value['for_id'];
                $arr[$value['for_id']]['name']=$value['for_name'];
                $arr[$value['for_id']]['letter']=$value['letter'];
                $arr[$value['for_id']]['state']=in_array($value['for_name'],$old_data)?2:1;
                unset($data[$key]['for_name']);
                unset($data[$key]['letter']);
            }
            foreach ($data as $key => $value){
                $arr[$value['for_id']]['son_data'][]=$value;
            }
            sort($arr);
            return ['code'=>200,'msg'=>'success','data'=>['group'=>$group_name,'region'=>$region,'china'=>$arr]];
        }*/
    	// $group_name=Db::table('region')->where(['id'=>$group_id,'ent_cid'=>$user['adm_cid']])->where('start','!=',3)->select('id','group_name')->first();
    	if(empty($group_name)){
    		return ['code'=>500,'msg'=>'error','data'=>'失败，没有找到该区域数据'];
    	}
    	$data=Db::table('region_detailed')->where(['reg_id'=>$group_id])->selectRaw("pid,chi_id as name,provinces_id as for_id,my_id as id,2 as state")->get();
    	$region=[];
    	$provinces=array_unique(array_column($data,'pid'));
    	sort($provinces);
    	$provinces_id=array_unique(array_column($data,'for_id'));
    	sort($provinces_id);
    	$str='';
    	foreach ($provinces as $key => $value) {
    		$str.=$provinces[$key].',';
    		$region[$provinces_id[$key]]['id']=$provinces_id[$key];
    		$region[$provinces_id[$key]]['name']=$provinces[$key];
    		$region[$provinces_id[$key]]['state']=2;
    	}
    	$city=array_column($data,'name');
    	$str=$str.implode($city,',');

    	$add_data['type']=2;
		$add_data['token']=$token;
		$add_data['goods_id']=$str;

		Db::table('temporary_goods_id')->insert($add_data);

    	foreach ($data as $key => $value) {
    		unset($value['pid']);
    		$region[$value['for_id']]['son_data'][]=$value;
    	}
    	sort($region);
    	$old_data=explode(',',$str);

    	$data=Db::table('china as a')->where('a.pid',0)->join('china as b','a.id','=','b.pid')->orderBy('a.id','asc')->selectRaw("trace_a.id as for_id,trace_a.initials as letter,trace_a.name as for_name,trace_b.name as name,trace_b.id as id,1 as state")->get();
    	$arr=[];
    	foreach ($data as $key => $value){
    		if(in_array($data[$key]['name'],$old_data)){
    			$data[$key]['state']=2;
    		}
    		$arr[$value['for_id']]['id']=$value['for_id'];
    		$arr[$value['for_id']]['name']=$value['for_name'];
    		$arr[$value['for_id']]['letter']=$value['letter'];
    		$arr[$value['for_id']]['state']=in_array($value['for_name'],$old_data)?2:1;
    		unset($data[$key]['for_name']);
    		unset($data[$key]['letter']);
    	}
    	foreach ($data as $key => $value){
    		$arr[$value['for_id']]['son_data'][]=$value;
    	}
    	sort($arr);
        $channel = DB::table('channels')->where(['chan_cid'=>$user['adm_cid'],'chan_state'=>1])->select('chan_id','chan_enterprise_name','chan_name','chan_phone','chan_province','chan_city','chan_county','chan_address')->get();
    	return ['code'=>200,'msg'=>'success','data'=>['group'=>$group_name,'region'=>$region,'china'=>$arr,'channel'=>$channel]];
    }

    //缓存数据 并查询数据 
    public function Cache_Region($letter,$name_data=[],$token){
    	$data=Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->pluck('goods_id');
    	if(!empty($data)){
    		$data=explode(',',$data);
            if(!empty($name_data)){
                Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->update(['goods_id'=>implode($name_data,',')]);
            }
            $data=$name_data;
            sort($data);
    	}else{
            if(empty($name)){
                $arr['type']=2;
                $arr['token']=$token;
                $arr['goods_id']=implode($name_data,',');
                Db::table('temporary_goods_id')->insert($arr);
            }

            $data=$name_data;
            sort($data);
        }

    	$china=Db::table('china as a')->where(['a.pid'=>0,'a.initials'=>$letter])->join('china as b','a.id','=','b.pid')->orderBy('a.id','asc')->selectRaw("trace_a.id as for_id,trace_a.initials as letter,trace_a.name as for_name,trace_b.name as name,trace_b.id as id,1 as state")->get();
    	$arr=[];
    	if(empty($data)){
    		foreach ($china as $key => $value){
	    		$arr[$value['for_id']]['id']=$china[$key]['for_id'];
	    		$arr[$value['for_id']]['name']=$china[$key]['for_name'];
	    		$arr[$value['for_id']]['letter']=$china[$key]['letter'];
	    		$arr[$value['for_id']]['state']=$china[$key]['state'];
	    		unset($china[$key]['for_name']);
	    		unset($china[$key]['letter']);
	    	}
    	}else{
    		foreach ($china as $key => $value){
    			if(in_array($china[$key]['name'],$data)){
    				$china[$key]['state']=2;
    			}
	    		$arr[$value['for_id']]['id']=$china[$key]['for_id'];
	    		$arr[$value['for_id']]['name']=$china[$key]['for_name'];
	    		$arr[$value['for_id']]['letter']=$china[$key]['letter'];
	    		$arr[$value['for_id']]['state']=in_array($china[$key]['for_name'],$data)?2:1;
	    		unset($china[$key]['for_name']);
	    		unset($china[$key]['letter']);
	    	}
    	}
    	foreach ($china as $key => $value){
    		$arr[$value['for_id']]['son_data'][]=$value;
    		// unset($da);
    	}
    	sort($arr);
    	return ['code'=>200,'msg'=>'success','data'=>$arr];
    }

    //删除某个缓存数据
    public function Cache_Del($name,$token){
    	$data=Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->pluck('goods_id');
    	if(!empty($data)){
    		$data=explode(',',$data);
    	}else{
    		return ['code'=>200,'msg'=>'success','data'=>'no'];
    	}
        if(is_string($name)){
            if(in_array($name,$data)){
                unset($data[array_search($name,$data)]);
                $res=Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->update(['goods_id'=>implode($data,',')]);
                if($res){
                    return ['code'=>200,'msg'=>'success','data'=>'ok'];
                }
            }
            return ['code'=>200,'msg'=>'success','data'=>'no'];
        }elseif(is_array($name)){
            $data=array_diff($data,$name);
            $res=Db::table('temporary_goods_id')->where(['token'=>$token,'type'=>2])->update(['goods_id'=>implode($data,',')]);
            if($res){
                return ['code'=>200,'msg'=>'success','data'=>'ok'];
            }
        }
        return ['code'=>200,'msg'=>'success','data'=>'no'];
    	
    }

    /**
     * 更改状态
     * @param [type] $id    id
     * @param [type] $user  用户
     * @param [type] $state 1 启用  2 编辑  3删除
     */
    public function Region_State($id_data,$user,$state){
    	if(!is_array($id_data)){
			$id=$id_data;
			unset($id_data);
			$id_data[]=$id;
		}
		try{
			Db::beginTransaction();
			$Db=Db::table('region')->where(['reg_del'=>1,'ent_cid'=>$user['adm_cid']])->whereIn('id',$id_data);
			if($state==1){
				$str='启用';
				$Db=$Db->where(['start'=>2]);
			}elseif($state==2){
				$str='停用';
				$Db=$Db->where(['start'=>1]);
			}else{
				$str='删除';
			}

			$data=$Db->select('group_name','id')->get();
			if(empty($data)){
				throw new Exception("没有要".$str.'的数据');
			}
			$id=array_column($data,'id');
			//删除 和  停用 判断
			if($state==2 || $state==1){

				// throw new Exception("已绑定了防伪码。无法".$str);
			}
			if($state==1){
				$res=Db::table('region')->whereIn('id',$id)->update(['start'=>1]);
			}elseif($state==2){
				$res=Db::table('region')->whereIn('id',$id)->update(['start'=>2]);
			}else{
				$res=Db::table('region')->whereIn('id',$id)->update(['reg_del'=>2]);
			}

			// 写入操作日志表里
			$content=$str.'区域。区域名称：'.implode(array_column($data,'group_name'),',');
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防窜管理->区域设置";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>$str.'成功'];
		}catch(Exception $e){
			Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
    }

}
