<?php

namespace App\Http\Models\Prevention;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;
class PreWarningModel extends Model
{
    private $page_size=10;
    private $exports_max=1000;

    /**
     * 防窜报表
     * @param [type]  $where  条件
     * @param [type]  $user   用户
     * @param integer $state 1 正常   2 导出
     */
    public function Form_Prevention($where,$user,$state=1){
    	$Db=Db::table('code_region')->where(['com_id'=>$user['adm_cid']])->join('region','region.id','=','reg_id')->where(['reg_del'=>1]);
    	if(!empty($where['time_start'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
    		$Db=$Db->where('add_time','>=',$time);
    	}

    	if(!empty($where['time_end'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
    		$Db=$Db->where('add_time','<=',$time);
    	}
    	if(!empty($where['code_number']) || $where['code_number']===0){
    		$Db=$Db->where('region_id','like',"%".$where['code_number'].'%');
    	}

    	if(!empty($where['region_name'])){
    		$Db=$Db->where('group_name','like',"%".$where['region_name'].'%');
    	}
    	//页码数据
		if($state !== 2){
			$count=$Db->count();
			$page_count=(int)ceil($count/$where['pagesize']);
			$limit=($where['page']-1)*$where['pagesize'];
			$Db=$Db->limit($where['pagesize'])->offset($limit);
		}else{
            $Db=$Db->whereIn('code_region.id',$where['id']);
			// $Db=$Db->limit($this->exports_max);
		}
    	$data=$Db->selectRaw("date_format(add_time,'%Y-%m-%d %H:%i') as time,trace_code_region.id,region_id as code_number,num,group_name")->orderBy('id','desc')->get();
    	if($state==2){
    		return $this->Into_Out_Excel($data,$user['admin_id']);
    	}
    	$page=['count'=>$count,'page'=>$where['page'],'page_size'=>$where['pagesize'],'page_count'=>$page_count];
    	return ['code'=>200,'msg'=>'success','data'=>['page'=>$page,'data'=>$data]];
    }

    /**
     * 防窜预警列表
     * @param [type] $where 条件
     * @param [type] $user  用户
     */
    public function Early_List($where,$user,$id){
    	$Db=DB::table('region_early')->where(['com_id'=>$user['adm_cid'],'type'=>2])->join('region','region_early.region_id','=','region.id');

    	if(!empty($where['state'])){
    		$Db=$Db->where('state',$where['state']);
    	}

    	if(!empty($where['time_start'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
    		$Db=$Db->where('region_early.add_time','>=',$time);
    	}

    	if(!empty($where['time_end'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
    		$Db=$Db->where('region_early.add_time','<=',$time);
    	}
     	if(!empty($where['code_number'])){
    		$Db=$Db->where('trace_code','like',"%".$where['code_number'].'%');
    	}
    	if(!empty($where['batch_number'])){
    		$Db=$Db->where('batch_number','like',"%".$where['batch_number'].'%');
    	}
    	if(!empty($where['region_number'])){
    		$Db=$Db->where('region.region_id','like',"%".$where['region_number'].'%');
    	}
    	if(!empty($where['region_name'])){
            $Db=$Db->where('group_name','like',"%".$where['region_name'].'%');
        }
        if(!empty($where['city'])){
    		$Db=$Db->where('city','like',"%".$where['city'].'%');
    	}
    	$count=$Db->count();
		$page_count=(int)ceil($count/$where['pagesize']);
		$limit=($where['page']-1)*$where['pagesize'];
		$data=$Db->limit($where['pagesize'])->offset($limit)->selectRaw("trace_region_early.id,add_time,trace_code,batch_number,code_number,trace_region.region_id,group_name,province,city,state,remarks")->orderBy("region_early.id",'desc')->get();
        $goods = DB::table('region_early')
                ->where('id',$id)
                ->where(['com_id'=>$user['adm_cid'],'type'=>1])
                ->select('good_id')
                ->get();
		$page=['count'=>$count,'page'=>$where['page'],'page_size'=>$where['pagesize'],'page_count'=>$page_count];
    	return ['code'=>200,'msg'=>'success','data'=>['page'=>$page,'early_data'=>$data,'goods'=>$goods]];
    }

    /**
     * 处理预警
     * @param [type]  $user    用户
     * @param [type]  $id_data id
     * @param [type]  $remarks 备注
     * @param integer $state   1 处理  2 编辑
     */
    public function Handl_Early($user,$id_data,$remarks,$state=1){
    	if(!is_array($id_data)){
			$id=$id_data;
			unset($id_data);
			$id_data[]=$id;
		}
		try{
			DB::beginTransaction();
			if($state==1){
                $data=Db::table('region_early')->whereIn('id',$id_data)->where('com_id',$user['adm_cid'])->where(['state'=>1])->select('id')->get();
                if(empty($data)){
                    throw new Exception("没有要处理的防窜预警");
                }
                $id=array_column($data,'id');

				$res2=Db::table('region_early')->whereIn('id',$id)->where('com_id',$user['adm_cid'])->update(['state'=>2,'remarks'=>$remarks]);
				if(!$res2){
					throw new Exception("处理防窜预警失败");
				}
				$str='处理';
			}else{
				$res2=Db::table('region_early')->whereIn('id',$id_data)->where('com_id',$user['adm_cid'])->update(['remarks'=>$remarks]);
				if(!$res2){
					throw new Exception("编辑防窜预警失败");
				}
				$str='编辑';
			}
			
			// 写入操作日志表里
			$content=$str.'预警。备注为：'.$remarks;
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防窜管理->防窜预警";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str.'预警',$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>$str.'成功'];
		}catch(Exception $e){
			Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}

    }
    
    /**
	 *  导出
	 * @param [type] $data 数据
	 */
	public function Into_Out_Excel($data,$id){
		Excel::create('a10000'.$id, function($excel) use ($data,$id){

            $excel->sheet('a10000'.$id, function($sheet) use ($data,$id)
            {
            	$sheet->setWidth(array('A'=>20,'B'=>20,'C'=>14,'D'=>20))->setFontSize(12);
                $sheet->cell('A1','时间');
                $sheet->cell('B1','防窜批次号');
                $sheet->cell('C1','码量');
                $sheet->cell('D1','防窜区');
                if (!empty($data)){
                    foreach ($data as $key => $value) {
                        $i= $key+2;
                        $sheet->cell('A'.$i, $value['time']);
                        $sheet->cell('B'.$i, "\t".$value['code_number']."\t");
                        $sheet->cell('C'.$i, $value['num']);
                        $sheet->cell('D'.$i, $value['group_name']);
                    }
                }
            });
        })->save('xls',storage_path('excel'));
        return ['code'=>200,'msg'=>'success','data'=>'storage/excel/a10000'.$id.'.xls'];
	}
}