<?php
namespace App\Http\Models\Order;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;
use Illuminate\Support\Facades\Storage;
class OrderModel extends Model
{
	private $watershed=30;//分水岭，  锁定订单的分水岭

	//  ************此状态与 数据库状态不一致 ****************
	private $state=[1=>'创建',2=>'编辑',3=>'待申请出库',4=>'待出库',5=>'出库',6=>'签收',7=>'完成',8=>'锁定',9=>'完成',10=>'解锁',11=>'删除'];
	private $type=[1=>'新订单',2=>'编辑',3=>'待申请出库',4=>'待出库',5=>'出库',6=>'签收',7=>'完成',8=>'锁定',9=>'完成',10=>'解锁'];
	private $state_s=[5=>'出库',6=>'签收',10=>'完成'];
	private $max=500;

	/**
	 * 获取订单列表
	 * @param  [type] $where 条件
	 * @param  [type] $user  登陆用户信息
	 * @return [type]        [description]
	 */
	public function orderListMax($where,$user,$export=2){
		//获取所有的平台
		$plot=Db::table('platform')->where(['plat_cid'=>$user['adm_cid'],'plat_state'=>1])->select('plat_id','plat_name')->get();

		$user_id = $user['admin_id'];

		//定义十个状态单词
		$order_type=[1=>'one',4=>'four',5=>'five',6=>'six',8=>'eight',10=>'ten'];
		$order_data=['one'=>0,'four'=>0,'five'=>0,'six'=>0,'eight'=>0,'ten'=>0];

		$Db=Db::table('order_form as order')->where(['company_id'=>$user['adm_cid']])->where('order_state','!=',11);

		// $adm_type=Db::table('admin')->where(['adm_id'=>$user['admin_id']])->select('adm_type')->first();

		// if($adm_type['adm_type'] == 2)
		// {

		// 	$order_id = DB::table('channels as c')
  //               ->leftjoin('repertory as r','c.can_id','=','r.rep_can_id')
  //               ->leftjoin('order_ware_relation as owr','r.rep_id','=','owr.ware_id')
  //               ->where('can_linkman',$user['admin_id'])
  //               ->select('owr.order_id')
  //               ->get();

		//     foreach($order_id as $k=>$v)
		//     {
		//      	$order_info[] = $v['order_id'];
		//     }

		//     if(!empty($order_info)){		
		// 		$Db=$Db->whereIn('order.ord_id',$order_info);
		// 	}
		// }

		if(!empty($where['plat_id'])){
			$Db=$Db->where(['order.plat_id'=>$where['plat_id']]);
		}

		if(!empty($where['create_start']) && $where['create_start']!='null'){
			$time=date('Y-m-d H:i:s',strtotime($where['create_start']));
			$Db=$Db->where('create_time','>=',$time);
		}
		if(!empty($where['create_end']) && $where['create_end']!='null'){
			$time=date('Y-m-d H:i:s',strtotime($where['create_end']));
			$Db=$Db->where('create_time','<=',$time);
		}
		if(!empty($where['complete_start']) && $where['complete_start']!='null'){
			$time=date('Y-m-d H:i:s',strtotime($where['complete_start']));
			$Db=$Db->where('comple_time','>=',$time);
		}
		if(!empty($where['complete_end']) && $where['complete_end']!='null'){	
			$time=date('Y-m-d H:i:s',strtotime($where['complete_end']));	
			$Db=$Db->where('comple_time','<=',$time);
		}

		//系统单号
		if(!empty($where['system_number'])){
			$Db=$Db->where('system_number','like',"%".$where['system_number']."%");
		}

		if(!empty($where['plat_number'])){
			$Db=$Db->where('order.plat_number','like',"%".$where['plat_number']."%");
		}

		if(!empty($where['user_name'])){
			$Db=$Db->where('user_name','like',"%".$where['user_name']."%");
		}

		//实现定义一个订单id数组
		try{
			$order_id=[];
			//判断物流
			if(!empty($where['wl'])){
				$order=Db::table('wl as a')
					->where('a.wl_department','like','%'.$where['wl'].'%')
					->orwhere('a.wl_courier','like','%'.$where['wl'].'%')
					->orwhere('a.wl_user','like','%'.$where['wl'].'%')
					->orwhere('a.wl_tel','like','%'.$where['wl'].'%')
					->orwhere('a.wl_license','like','%'.$where['wl'].'%')
					->join('wl as b',function($join){
						$join->on('b.wl_id','=','a.wl_id')->where('b.wl_state','=',2);
					})->select('a.order_id as order_id')->get();
				$order_id=array_unique(array_column($order,'order_id'));
				if(empty($order_id)){throw new Exception("没有查询物流所得到的数据");}

			}
			//判断  备注
			if(!empty($where['remarks']) && $where['remarks']!='null'){
				$ord_id=Db::table('order_remarks')->where('remarks','like',"%".$where['remarks']."%")->select('order_id')->get();
				$ord=array_column($ord_id,'order_id');
				if(empty($order_id)){
					$order_id=$ord;
				}else{
					$order_id=array_unique(array_intersect($order_id,$ord));
				}
				if(empty($order_id)){throw new Exception("查询备注为空");}
			}

			//手机号
			if(!empty($where['user_tel'])){
				$Db=$Db->where('user_tel','like',$where['user_tel']."%");
			}
			//查询商品名称
			if(!empty($where['goods_name'])){
				//更改查询1  
				$data=Db::table('order_goods')->groupBy('warg_goodsid')->select('warg_goodsid as goods_id')->get();
				$id=array_column($data,'goods_id');
				$goods_id=Db::table('goods')
				->where(['goo_cid'=>$user['adm_cid']])
				->whereIn('goo_id',$id)
				->where('goo_name','like',$where['goods_name']."%")
				->select('goo_id as goods_id')
				->get();

				$id=array_column($goods_id,'goods_id');
				$warehouse_id=Db::table('order_goods')->whereIn('warg_goodsid',$id)->select('order_wid as order_id')->get();

				//获取订单id
				$orl_id=array_column($warehouse_id,'order_id');

				if(empty($order_id)){
					$order_id=$orl_id;
				}else{
					$order_id=array_unique(array_intersect($order_id,$orl_id));
				}
				if(empty($order_id)){throw new Exception("没有查询商品名称所得到的数据");}
			}
			// return $order_id;
			//根据上面条件 对订单进行筛选
			if(!empty($order_id)){
				$order=array_unique($order_id);
				$Db=$Db->whereIn('order.ord_id',$order);
			}
			//页码
			if(empty($where['page_size'])){
				$where['page_size']=5;
			}
			if(empty($where['page'])){
				$where['page']=1;
			}
			
			//判断 如果没有条件 每种状态订单的条数
			if(empty($where['plat_id']) && empty($where['create_start']) && empty($where['create_end']) && empty($where['complete_start']) && empty($where['complete_end']) && empty($where['system_number']) && empty($where['plat_number']) && empty($where['user_name']) && empty($where['wl']) && empty($where['remarks']) && empty($where['user_tel']) && empty($where['goods_name']) && empty($order_info)){
				$order_data['eight']=Db::table('order_form as order')->where(['company_id'=>$user['adm_cid']])->where('order_state','>', $this->watershed)->count();
				$state_count=Db::table('order_form as order')->where(['company_id'=>$user['adm_cid']])->groupBy('order_state')->having('order_state','<',11)->selectRaw('count(order_state) as count,order_state')->get();
				foreach ($state_count as $key => $value) {
					$order_data[$order_type[$value['order_state']]]=$value['count'];
				}
			}else{
				$count_order=$Db->select('order.order_state as state')->get();
				foreach ($count_order as $key => $value) {
					if($value['state'] > $this->watershed){
						$count_order[$key]['state'] = 8;
					}
					$order_data[$order_type[$count_order[$key]['state']]]++;
				}
			}
			if(!empty($where['state'])){
				//判断是否是锁定
				if($where['state']==8){
					$Db=$Db->where('order.order_state','>',$this->watershed);
				}else{
					$Db=$Db->where(['order.order_state'=>$where['state']]);
				}
			}

			$count=$Db->count();
			$page_count=(int)ceil($count/$where['page_size']);
			$limit=($where['page']-1)*$where['page_size'];

			//如果导出excel 则不分页展示
			if($export !== 1){
				$Db=$Db->limit($where['page_size'])->offset($limit);
			}else{
				$Db=$Db->limit($this->max);
			}
			$order_Db=$Db->Leftjoin('platform as plat','plat.plat_id','=','order.plat_id')
			->select('order.ord_id as order_id','order.system_number as system_number','plat.plat_name','order.plat_number as plat_number','order.order_state as state','order.order_money as sum_money','comple_time')
			->orderBy('ord_id','desc')
			->get();
			$page=['page'=>(int)$where['page'],'page_size'=>(int)$where['page_size'],'page_count'=>$page_count,'page_number'=>$count];
			unset($where);
			// return $order_Db;
			//循环获取商品，获取订单信息，获取客户信息  物流 等信息
			foreach ($order_Db as $key => $value){
				if($value['state'] > $this->watershed){
					$order_Db[$key]['state'] = 8;
				}
				if($value['state']>5 && $value['state']<30){
					$order_Db[$key]['signfor']=1;
					$img=Db::table('order_receipt')->where(['order_id'=>$value['order_id']])->join('admin','order_receipt.user_id','=','admin.adm_id')->orderBy('ore_id','desc')->select('receipt_img as image','admin.adm_name as name','receipt_time as save_time')->first();

					$order_Db[$key]['img']=$img;
					$image_pre='http://'.$_SERVER['HTTP_HOST'];
					$order_Db[$key]['img']['image']=$image_pre.$img['image'];
					
				}else{
					$order_Db[$key]['signfor']=2;
					$order_Db[$key]['img']=[];
				}
				if($export==2){
					//获取商品信息
					$goods=Db::table('order_goods as ware')->where(['order_wid'=>$value['order_id']])->join('goods','ware.warg_goodsid','=','goods.goo_id')->select('goods.goo_name as goods_name','goods.goo_picurl as goods_img','ware.goods_number as goods_number','goods_money as goods_money')->limit(5)->get();
				}else{
					//获取商品信息
					$goods=Db::table('order_goods as ware')->where(['order_wid'=>$value['order_id']])->join('goods','ware.warg_goodsid','=','goods.goo_id')->select('goods.goo_name as goods_name','goods.goo_picurl as goods_img','ware.goods_number as goods_number','goods_money as goods_money')->get();
				}
				
				foreach ($goods as $goods_key => $goods_value){
					$goods[$goods_key]['goods_img']=ltrim(explode(',',$goods_value['goods_img'])[0],'/');
				}
				$order_Db[$key]['goods']=$goods;
				unset($goods);
				//获取客户信息
				$user=Db::table('order_user')->where(['order_id'=>$value['order_id']])->select('oru_user_name as user_name','oru_user_tel as user_tel','oru_province as province','oru_city as city','oru_county as county','oru_address as address')->orderBy('oru_id','desc')->limit(2)->get();
				$order_Db[$key]['user']=$user;
				if(count($user)>1){
					$order_Db[$key]['user_count']=2;
				}else{
					$order_Db[$key]['user_count']=1;
				}
				unset($user);
				//获取订单历史信息
				$order_details=DB::table('order_log')->where(['order_id'=>$value['order_id']])->join('admin','admin.adm_id','=','order_log.admin_user')->select('admin.adm_name as admin_user','order_log.create_time','details')->orderBy('orc_id','desc')->limit(5)->get();
				$order_Db[$key]['order_log']=$order_details;
				unset($order_details);
				//获取备注信息
				$remarks=Db::table('order_remarks')->where(['order_id'=>$value['order_id']])->join('admin','admin.adm_id','=','order_remarks.rma_user_id')->select('admin.adm_name','order_remarks.create_time','remarks')->orderBy('rma_id','desc')->limit(5)->get();
				
				$order_Db[$key]['remarks']=$remarks;
				unset($remarks);
				
				// //获取物流信息
				$wl_data=Db::table('wl')->where(['wl_state'=>2,'order_id'=>$value['order_id']])->select('wl_type','wl_department','wl_courier','wl_user','wl_tel','wl_license')->orderBy('wl_id','desc')->limit(5)->get();
				// return $wl_data;
				$wl_content=[];
				if(!empty($wl_data)){
					// return $wl_data;
					foreach ($wl_data as $k => $wl){
						if($wl['wl_type']==1){
							$wl_content[]="运输方:".$wl['wl_department']."; 快递单号:".$wl['wl_courier'];
						}elseif($wl['wl_type']==1 || $wl['wl_type']==2){
							$wl_content[]="运输方:".$wl['wl_department'].";负责人:".$wl['wl_user'].'; 联系电话:'.$wl['wl_tel']."; 车牌号:".$wl['wl_license'];
						}
					}
				}
				$order_Db[$key]['wl']=$wl_content;
				unset($wl_content);
			}
			if($export === 1){

				if(empty($order_Db)){
					return ['code'=>500,'msg'=>'error','data'=>'数据为空不能导出'];
				}else{
					return $this->orderLoge($order_Db,$user_id);
				}
				
			}
			return ['code'=>200,'msg'=>'成功','data'=>['page'=>$page,'state_count'=>$order_data,'plot'=>$plot,'order_list'=>$order_Db]];
		}catch(Exception $e){
			if($export === 1){
				echo '11111111111111';
				return ['code'=>500,'msg'=>'error','data'=>'数据为空不能导出'];
			}else{
				return ['code'=>200,'msg'=>'成功','data'=>['page'=>1,'state_count'=>$order_data,'plot'=>$plot,'order_list'=>[],'content'=>$e->getMessage()]];
			}

		}
	}
	//导出订单
	public function orderLoge($data,$user_id){

		$str="20000".$user_id;
		Excel::create($str, function($excel) use ($data,$str){
            $excel->sheet($str, function($sheet) use ($data,$str)
            {	
            	$sheet->setWidth(array('A'=>18,'B'=>8,'C'=>8,'D'=>16,'E'=>50,'F'=>40,'G'=>50,'H'=>50))->setFontSize(12);
            	$step=1;
            	if(empty($data)){
            		$sheet->mergeCells('A'.$step.':C'.$step);
            		$sheet->cell('A'.$step,'数据为空');
            	}else{
            		foreach ($data as $key => $val){
	            		$sheet->mergeCells('A'.$step.':C'.$step);
		            	$sheet->mergeCells('D'.$step.':E'.$step);
		            	$sheet->mergeCells('F'.$step.':G'.$step);
		                $sheet->cell('A'.$step,'【系统单号】'.$val['system_number']);
		                $sheet->cell('D'.$step,'【销售平台】'.$val['plat_name']);
		                $sheet->cell('F'.$step,'【平台单号】'.$val['plat_number']);
		                $sheet->cell('H'.$step,'【状态】'.$this->type[$val['state']]);
		                $max['goods']    =count($val['goods']);
		                $max['user']     =count($val['user']);
		                $max['order_log']=count($val['order_log']);
		                $max['remarks']  =count($val['remarks']);
		                $max['wl']       =count($val['wl']);
		                $step++;
		                $count_max=max($max);

		                if($count_max>0){
		                	$sheet->cell('A'.$step,'商品名称');
		                	$sheet->cell('B'.$step,'单价');
		                	$sheet->cell('C'.$step,'数量');
		                	$sheet->cell('D'.$step,'合计金额');
		                	$sheet->cell('E'.$step,'客户信息');
		                	$sheet->cell('F'.$step,'订单信息');
		                	$sheet->cell('G'.$step,'物流信息');
		                	$sheet->cell('H'.$step,'备注');

		                	// 商品循环
		                    foreach ($val['goods'] as $k => $v){
		                    	$sheet->cell('A'.($step+$k+1),$v['goods_name']);
		                    	$sheet->cell('B'.($step+$k+1),$v['goods_money']);
		                    	$sheet->cell('C'.($step+$k+1),$v['goods_number']);
		                    }

		                    $sheet->mergeCells('D'.($step+1).':D'.($step+$count_max));
		                    $sheet->cell('D'.($step+1),$val['sum_money']);

		                    // 用户信息循环
		                    foreach ($val['user'] as $k => $v){
		                    	$sheet->cell('E'.($step+$k+1),$v['user_name'].":".$v['user_tel'].";".$v['province'].$v['city'].$v['county'].$v['address']);
		                    }

		                    // 订单信息循环
		                    foreach ($val['order_log'] as $k => $v){
		                    	$sheet->cell('F'.($step+$k+1),$v['details'].'时间:'.$v['create_time'].'。 '.$v['admin_user']);
		                    }

		                     // 物流信息
		                    foreach ($val['wl'] as $k => $v){
		                    	$sheet->cell('G'.($step+$k+1),$v);
		                    }

		                     // 备注
		                    foreach ($val['remarks'] as $k => $v){
		                    	$sheet->cell('H'.($step+$k+1),"操作人：".$v['adm_name'].' 添加时间:'.$v['create_time'].';  内容：'.$v['remarks']);
		                    }
		                    $step=($step+$count_max);
		                }
	                    $step++;
	            	}
            	}
            });
        })->save('xls',storage_path('excel'));
        return ['code'=>200,'msg'=>'success','data'=>'storage/excel/'.$str.'.xls'];
	}
	/**
	 * 签收订单
	 */
	public function Order_SignFor($file,$data,$user){
		//添加 订单收据表  添加订单信息表   判断是否有出库的商品  更改信息
		
		//判断是否存在出库
		try{
			$old_data=Db::table('order_form')->where(['ord_id'=>$data['order_id'],'company_id'=>$user['adm_cid']])->where('order_state','!=',11)->select('order_state')->first();
			if(empty($old_data)){throw new Exception("没有该订单");}

			if($old_data['order_state']>30){throw new Exception("订单被锁定");}
			if($old_data['order_state']==10){throw new Exception("订单已完成");}
			if($old_data['order_state']==4){throw new Exception("请先出库");}
			if($old_data['order_state']==1){throw new Exception("请先分单");}
			if($old_data['order_state']==6){throw new Exception("已签收,无法更改签收凭证");}

			//判断是否有订单出库
			$order_out_ware=Db::table('order_ware_relation')->where(['order_id'=>$data['order_id'],'del_state'=>1,'owt_state'=>2])->get();
			if(empty($order_out_ware)){throw new Exception("请先出库,然后在签收");}

			if($data['receipt_time'] != date('Y-m-d H:i:s',strtotime($data['receipt_time']))){
				$data['receipt_time']=date('Y-m-d H:i:s');
			}
			$imageName = "OR_".date("Ymd",time()).rand(1,9).$data['order_id'].'.png';
			if(strstr($file,",")){
                $file = explode(',',$file);
                $file = $file[1];
            }

			//上传文件
			//***** 方式一： 后期一定要换成方式二：
            $path = "uploads/order_receipt/".date("Ymd",time());

            if (!is_dir($path)){ //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            //文件名
            $data['receipt_img']=  $path."/". $imageName;

            file_put_contents($data['receipt_img'],base64_decode($file));//返回的是字节数
            $data['receipt_img']='/public/'.$data['receipt_img'];
            //***************
            


            //方式二;
            // $path = storage_path()."/order_receipt/";

            // if (!is_dir($path)){ //判断目录是否存在 不存在就创建
            //     mkdir($path,0777,true);
            // }
            // //文件名
            // $data['receipt_img']=  "storage/order_receipt/". $imageName;

            // $file_name=$path.$imageName;
            // file_put_contents($file_name,base64_decode($file));//返回的是字节数
            // **********


            $data['user_id']=$user['admin_id'];
            DB::beginTransaction();

            // 添加订单信息表
            $res=$this->addOrderState(6,$user['admin_id'],$data['order_id']);

            if(!$res){throw new Exception("添加订单信息表失败");}

            $res2=Db::table('order_receipt')->insert($data);
            if(!$res2){throw new Exception("添加订单签收表失败");}

            if($old_data['order_state']<6){
            	$res3=Db::table('order_form')->where(['ord_id'=>$data['order_id']])->update(['order_state'=>6]);
            	 if(!$res3){throw new Exception("更改订单状态失败");}
            }elseif($old_data['order_state']>6){
            	if(!$res3){throw new Exception("更改订单状态失败,订单存在未知状态");}
            }

            DB::commit();
            $image_pre='http://'.$_SERVER['HTTP_HOST'];
            return ["code"=>200,'msg'=>'成功','data'=>['path'=>$image_pre.$data['receipt_img']]];

			 // throw new Exception("文件不能为空");
		}catch (Exception $e){
			DB::rollBack();
            return ["code"=>500,'msg'=>'失败','data'=>$e->getMessage()];
        }
	}

	/**
	 * 添加订单      更改销售平台数量
	 * @param [type] $order    订单信息
	 * @param [type] $user_data 客户信息
	 * @param [type] $goods     商品信息
	 * @param [type] $user      登录用户信息
	 */
	public function addOrderDb($order,$user_data,$goods,$user,$type=1){
		try{
			//编辑 更改平台金额   添加订单信息表   写入操作日志   删除商品信息    更改数据总价
			//********   校验商品是否可用   ****
			//写入出入库记录表    
			DB::beginTransaction();

			//校验数据
			$this->check_order_data($order,$user_data);

			//因为和导入代码一致所以写入一个公共的调动方法.
			$this->commen_add_order($order,$user_data,$goods,$user,$type);
			if($type==1){
				$str='添加';
			}else{
				$str='编辑';
			}
			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>$str.'订单成功'];
	 	}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}

	//添加订单记录
	public function addOrderState($type,$user_id,$order_id){
		//以下的状态不等同于  数据库内的状态
		$data['admin_user']=$user_id;
		$data['order_id']=$order_id;
		$data['details']=$this->state[$type];
		$data['create_time']=date('Y-m-d H:i:s');
		return Db::table('order_log')->insert($data);
	}
	/**
	 *1,锁定， 2,解锁， 3,删除， 4,完成  订单 
	 * @param  [type] $order_id 订单
	 * @param  [type] $state    状态
	 * @param  [type] $user     用户信息
	 * @return [type]           
	 */
	public function editOrderState($order_id,$state,$user){
		try{
			$type=[1=>'锁定',2=>'解锁',3=>'删除',4=>'完成'];
			//锁定，判断是否成立锁定条件 ， 解锁判断是否是锁定状态，  删除判断是否锁定  
			// 更改状态 写入 订单信息表   写入 操作日志表 
			DB::beginTransaction();
			if(!is_array($order_id)){
				$str=$order_id;
				unset($order_id);
				$order_id[]=$str;
			}
			//获取订单状态
			$db_id=Db::table('order_form')->where(['company_id'=>$user['adm_cid']])->where('order_state','!=',11)->whereIn('ord_id',$order_id)->select('ord_id as order_id','order_state')->get();

			if(count($db_id) != count($order_id)){throw new Exception("提交的订单id,与数据库内的订单不符");}

			//获取修改的当前状态
			$db_order_state=array_column($db_id,'order_state');

			if($state==1){

				//查看是否存在已完成的订单
				if(in_array(10,$db_order_state)){throw new Exception("已有订单完成,无法进去其他操作");}
				//锁定
				$db_id=Db::table('order_form')->where('order_state','<',$this->watershed)->whereIn('ord_id',$order_id)->select('ord_id as order_id','system_number as order_number')->get();
				$id=array_column($db_id,'order_id');
				//获取没有锁定的订单id
				
				//进行判断和比对
				$order_ware_list=Db::table('order_ware_relation')->where(['del_state'=>1])->whereIn('order_id',$id)->select('owt_state')->get();
				
				if(!empty($order_ware_list)){
					//判断是否有订单  出库完成
					$owt_state=array_column($order_ware_list,'owt_state');
					if(in_array(2,$owt_state)){throw new Exception("锁定失败,已有订单出库");}
				}

				//获取要修改的系统单号
				$db_order_order_number=array_column($db_id,'order_number');
				if(empty($id)){
					throw new Exception("没有订单需要锁定,或者所有订单已经被锁定");
				}
				$res=Db::table('order_form')->whereIn('ord_id',$id)->increment('order_state',$this->watershed);
				if(!$res){throw new Exception("锁定订单失败");}
				$type=8;
			}elseif($state==2){
				//解锁
				//查看是否存在已完成的订单
				if(in_array(10,$db_order_state)){throw new Exception("有订单完成,无法进去其他操作");}
				//解锁
				$db_id=Db::table('order_form')->where('order_state','>',$this->watershed)->whereIn('ord_id',$order_id)->select('ord_id as order_id','system_number as order_number')->get();
				$id=array_column($db_id,'order_id');

				//获取要修改的系统单号
				$db_order_order_number=array_column($db_id,'order_number');
				if(empty($id)){
					throw new Exception("没有订单需要解锁");
				}
				$res=Db::table('order_form')->whereIn('ord_id',$id)->decrement('order_state',$this->watershed);
				if(!$res){throw new Exception("解锁订单失败");}
				$type=10;
			}elseif($state==3){
				//删除

				//查看是否存在已完成的订单
				if(in_array(10,$db_order_state)){throw new Exception("有订单完成,无法进去其他操作");}

				if(in_array(6,$db_order_state)){throw new Exception("有订单签收,无法进行删除");}
				if(in_array(5,$db_order_state)){throw new Exception("有订单出库,无法进行删除");}
				if(in_array(4,$db_order_state)){throw new Exception("有订单派出,无法进行删除");}

				//删除   需要判断是否存在被锁定的订单
				$db_id=Db::table('order_form')->where('order_state','<',$this->watershed)->whereIn('ord_id',$order_id)->select('ord_id as order_id','system_number as order_number','plat_id','order_money','create_time')->get();
				if(count($db_id) != count($order_id)){throw new Exception("删除失败,有订单被锁定");}

				$id=array_column($db_id,'order_id');

				foreach ($db_id as $key => $value){
					//根据创建时间减去订单量，减去销售量，减去销售金额
					$year=date('Y',strtotime($value['create_time']));
					$month=date('m',strtotime($value['create_time']));
					$res6=Db::table('statistic_send')->where(['sta_cid'=>$user['adm_cid'],'sta_year'=>$year,'sta_month'=>$month,'sta_type'=>2])->decrement('sta_total');
					if(!$res6){throw new Exception("减去订单总数失败");}
					if(!empty($value['plat_id'])){
						//减去平台订单数量
						$res3=Db::table('platform')->where(['plat_id'=>$value['plat_id']])->decrement('plat_money',$value['order_money']);
						if(!$res3){throw new Exception("减平台销售金额失败");}

						$res4=Db::table('platform')->where(['plat_id'=>$value['plat_id']])->decrement('plat_number');
						if(!$res4){throw new Exception("减平台销售数量失败");}
					}
					
				}

				//进行判断和比对
				$order_ware_list=Db::table('order_ware_relation')->where(['del_state'=>1])->whereIn('order_id',$id)->select('owt_state','order_out_id')->get();
				// return $order_ware_list;
				if(!empty($order_ware_list)){
					//判断是否有订单  出库完成
					$owt_state=array_column($order_ware_list,'owt_state');
					if(in_array(2,$owt_state)){throw new Exception("删除失败,已有出库单出库");}

					// 关联表删除
					$out_order_id=array_column($order_ware_list,'order_out_id');
					$res5=Db::table('order_ware_relation')->whereIn('order_id',$id)->update(['del_state'=>2]);
					if(!$res5){throw new Exception("删除订单关联表失败");}

					//    出库表删除；
					$del_out_order=Db::table('out_order')->whereIn('war_out_id',$out_order_id)->update(['del_state'=>2]);

					if(!$del_out_order){throw new Exception("删除出库表失败");}
				}
				//获取要修改的系统单号
				$db_order_order_number=array_column($db_id,'order_number');

				$res=Db::table('order_form')->whereIn('ord_id',$id)->update(['order_state'=>11]);
				if(!$res){throw new Exception("删除订单失败");}
				$type=11;
			}elseif($state==4){
				//订单完成
				// 判断是否有锁定的数据   判断是否全部出库  判断是否签收  写入信息表
				
				//判断是否签收
				if(in_array(1,$db_order_state)){throw new Exception("有新添加的订单,无法进去其他操作");}
				if(in_array(4,$db_order_state)){throw new Exception("存在没有出库的出库单，请先出库");}
				if(in_array(5,$db_order_state)){throw new Exception("没有签收,请先签收");}

				//判断订单是否都是已签收状态
				$db_id=Db::table('order_form')
				->where(['order_state'=>6])
				->where('order_state','<',$this->watershed)->whereIn('ord_id',$order_id)
				->select('ord_id as order_id','system_number as order_number')
				->get();
				if(count($db_id) != count($order_id)){throw new Exception("存在没有签收的订单");}

				$id=array_column($db_id,'order_id');

				$order_date_time['comple_time']=date("Y-m-d H:i:s");
				$order_date_time['save_user']=$user['admin_id'];
				$res9=Db::table('order_form')->whereIn('ord_id',$order_id)->update($order_date_time);
				if(!$res9){
					throw new Exception("更改完成时间失败");
					
				}

				//获取订单关联表的数据  判断是否全部出库
				$order_ware=Db::table('order_ware_relation')->where(['del_state'=>1])->whereIn('order_id',$id)->select('owt_state','order_out_id')->get();

				$owt_state=array_unique(array_column($order_ware,'owt_state'));
				if(count($owt_state)==1 && $owt_state[0]==2){
					$res=Db::table('order_form')->whereIn('ord_id',$id)->update(['order_state'=>10]);
					if(!$res){throw new Exception("更改订单完成失败");}
				}else{
					throw new Exception("有出库单未完成");
				}
				//获取要修改的 系统编号
				$db_order_order_number=array_column($db_id,'order_number');
				$type=7;
			}

			foreach ($id as $key => $val) {
				$res2=$this->addOrderState($type,$user['admin_id'],$val);
				if(!$res2){throw new Exception("写入订单信息表失败");}
			}

			//添加操作日志表
			$state_str=$this->state[$type];
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk='订单模块';
			$content=$state_str.'订单，订单系统编号为: '.implode(',',$db_order_order_number);
			$res5=Coperationa::add($user['admin_id'],$ip,$mk,$state_str,$content);
			if(!$res5){throw new Exception("添加记录活动日志表失败");}

			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>$state_str.'订单成功'];
		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}

	/**
	 * 添加订单备注
	 * @param [type] $order_id 订单
	 * @param [type] $content  添加内容
	 * @param [type] $user     用户信息
	 */
	public function RemarksAdd($order_id,$content,$user){
		// 1判断订单状态   添加备注，  添加操作日志表
		try{
		DB::beginTransaction();
		$res=Db::table('order_form')->where(['ord_id'=>$order_id,'company_id'=>$user['adm_cid']])->select('ord_id','order_state','system_number')->first();
		if(empty($res)){throw new Exception("没有该订单");}

		if($res['order_state']>30){throw new Exception("该订单已锁定");}

		if($res['order_state']==10){throw new Exception("该订单已完成");}

		$arr['order_id']=$order_id;
		$arr['rma_user_id']=$user['admin_id'];
		$arr['remarks']=$content;
		$arr['create_time']=date('Y-m-d H:i:s');

		$res2=Db::table('order_remarks')->insert($arr);
		if(!$res2){throw new Exception("添加备注失败");}

		$str=mb_substr($content,0,20);
		//添加操作日志表
		$state_str='添加备注';
		$ip=$_SERVER['REMOTE_ADDR'];
		$mk='订单模块';
		$contents='添加订单备注：'.$str;
		$res5=Coperationa::add($user['admin_id'],$ip,$mk,$state_str,$contents);
		if(!$res5){throw new Exception("添加记录活动日志表失败");}

		 DB::commit();
		 return ['code'=>200,'msg'=>'成功','data'=>'添加订单备注成功'];
		 }catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}

	/**
	 * 派单   获取仓库和商品信息
	 * @param [type] $user     用户信息
	 * @param [type] $order_id  订单号
	 */
	public function Distri_Order($user,$order_id){
		if(!is_array($order_id)){
			$str=(int)$order_id;
			unset($order_id);
			$order_id[]=$str;
		}
		$order_id=array_unique($order_id);
		try{

			$this->distr_order_commen($order_id,$user);

		}catch(Exception $e){
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
		$all_order_data=[];
		// return $order_id;
		foreach ($order_id as $key => $values){
			$values=(int)$values;
			//查询订单上数据
			//获取订单中的商品
			// return $order_id;
			$goods_data=Db::table('order_goods as ware')->rightjoin('order_form','ware.order_wid','=','order_form.ord_id')->where(['order_wid'=>$values])->join('goods','ware.warg_goodsid','=','goods.goo_id')->selectRaw("trace_goods.goo_name as goods_name,trace_goods.goo_picurl as goods_img,trace_ware.goods_number as goods_number,goo_number as number,warg_goodsid as goods_id,right(trace_order_form.system_number,18) as system_number")->get();
			

			// return $goods_data;
			$temp_key = array_column($goods_data,'goods_id');  //键值
			$goods_data = array_combine($temp_key,$goods_data);

			//判断是否存在订单商品，多此一举
			if(empty($goods_data)){
				return ['code'=>500,'msg'=>'失败','data'=>"没有商品"];
			}

			$goods_id=array_column($goods_data,'goods_id');

			//获取拥有订单商品的仓库;
			$ware_goods=Db::table('warehouse')->where(['warehouse.war_goods_state'=>1,'war_cid'=>$user['adm_cid']])->whereIn('war_goodsid',$goods_id)->join('repertory','repertory.rep_id','=','warehouse.war_rid')->where(['rep_state'=>1,'is_ok'=>1,'rep_type'=>1])->selectRaw("rep_id as ware_id,concat(rep_name,'。库存数量:',war_stock_count) as ware_name,war_goodsid as goods_id")->orderBy('war_stock_count','desc')->get();

			foreach ($ware_goods as $key => $val){
				$goods_data[$val['goods_id']]['warelist'][$key]=$val;
				unset($goods_data[$val['goods_id']]['warelist'][$key]['goods_id']);
			}

			$arr1=[];
			$arr2=[];
			// return $goods_data;
			foreach ($goods_data as $key => $val){
				$goods_data[$key]['order_id']=$values;
				$goods_data[$key]['ware_id']=0;
				if(empty($val['warelist'])){
					$goods_data[$key]['warelist']=[];
					$arr2[]=$goods_data[$key];
				}else{
					$arr1[]=$goods_data[$key];
				}

			}
			$all_order_data[]=array_merge($arr1,$arr2);
		}
		$result = array_reduce($all_order_data, 'array_merge', array());
		return ['code'=>200,'msg'=>'成功','data'=>['goods_list'=>$result]];
	}

	public function distr_order_commen($order_id,$user){
		$res=Db::table('order_form')->where('order_state','!=',11)->where(['company_id'=>$user['adm_cid']])->whereIn('ord_id',$order_id)->select('ord_id as order_id','order_state')->get();
		$order_state=array_column($res,'order_state');

		if(empty($res)){throw new Exception("没有获取到订单数据");}

		if(count($order_id) != count($res)){throw new Exception("分单订单数据与已有订单不符");}

		if(max($order_state)>30){throw new Exception("分单失败,存在被锁定订单");}

		if(in_array(4,$order_state)){throw new Exception("分单失败,已有订单分配出去");}
		if(in_array(5,$order_state)){throw new Exception("分单失败,已有订单已出库");}

		if(in_array(6,$order_state)){throw new Exception("分单失败,已有订单分配签收");}

		if(in_array(10,$order_state)){throw new Exception("分单失败,已有订单完成");}

	}

	/**
	 * 派单到仓库
	 * @param [type] $user     用户信息
	 * @param [type] $order_id 订单id
	 * @param [type] $data     商品id 和 仓库id
	 */
	public function Distri_Ware($user,$order_id,$database){
		
		$order_id=array_unique($order_id);
		$arr_order=[];
		foreach ($database['order_id'] as $key => $val){
			$arr_order[$val][$key]['goods_id']=(int)$database['goods_id'][$key];
			$arr_order[$val][$key]['ware_id']=(int)$database['ware_id'][$key];
		}
		// return $arr_order;
		// return $data;
		try{
			//校验订单id 是否符合标准;
			$this->distr_order_commen($order_id,$user);

			//写入出入库记录表
			DB::beginTransaction();
// return $arr_order;
			foreach ($arr_order as $subscript => $absolutevalue){

				//重组数组，用于后面调用
				$data['goods_id']=array_column($absolutevalue,'goods_id');
				$data['ware_id']=array_column($absolutevalue,'ware_id');

				$order_goods_id=Db::table('order_goods')->where(['order_wid'=>$subscript])->select('warg_goodsid as goods_id')->get();

				$goods_id=array_column($order_goods_id,'goods_id');

				//获取订单信息
				$order_list=Db::table('order_form')->where('order_state','!=',11)->where(['company_id'=>$user['adm_cid'],'ord_id'=>$subscript])->leftjoin('platform','order_form.plat_id','=','platform.plat_id')->select('ord_id as order_id','order_state','system_number','plat_name')->first();
				if(empty($order_list)){throw new Exception("没有这个订单");}

				// 获取订单商品
				$goods_data=Db::table('order_goods as ware')->where(['order_wid'=>$subscript])->select('warg_goodsid as goods_id','goods_number')->get();

				// return $data;
				// return count($data['goods_id']);
				if(count($goods_data) != count($data['goods_id'])){throw new Exception("分单失败,多提交或少提交商品");}

				// return $val;
				//对比
				$god_id=array_column($goods_data,'goods_id');
				$dif=array_diff($god_id,$data['goods_id']);
				// return $god_id;
				if(!empty($dif)){throw new Exception("分单失败,订单中存在没有在订单中的商品");}
				$res=$this->Distri_Order($user,$subscript);
				if($res['code'] != 200){
					return $res;
				}
				$arr=[];
				// return $res;
				foreach ($data['goods_id'] as $k => $v){
					$arr[$v]['goods_id']=(int)$v;
					$arr[$v]['ware_id']=(int)$data['ware_id'][$k];
				}
				unset($data);

	// return $arr;
				//获取商品 和商品仓库
				$goods_ware=$res['data']['goods_list'];
	// return [$goods_ware,$arr];
				foreach($goods_ware as $k => $v){
					if(empty($v['warelist'])){throw new Exception("分单失败,存在无法分配到仓库的商品,请先对更改仓库内的商品在进行添加操作");}
					
					$ware_id=array_column($v['warelist'],'ware_id');
					// return $ware_id;
					//判断是否有这个商品
					if(empty($arr[$v['goods_id']])){throw new Exception("分单失败,该仓库没有这个商品");}


					//判断这个商品提交的库，是否存在于我们给他的库里
					if(!in_array($arr[$v['goods_id']]['ware_id'],$ware_id)){throw new Exception("分单失败,该仓库没有这个商品");}

				}
				//仓库去重
				$arr2=array_unique(array_column($arr,'ware_id'));
				// return $goods_data;
				foreach ($arr as $keys => $values){
					foreach ($goods_data as $k => $v){
						if($values['goods_id']==$v['goods_id']){
							$arr[$keys]['goods_number']=$v['goods_number'];
						}
					}
				}
			// return $arr;
			
			//入库     1 添加出库单，   添加  出库商品表， 添加 订单和出库关联表   
			//          添加操作日志表    更改 订单状态;   添加  订单信息表

				$ware_order=[];
				$ware_order_list=[];
				foreach ($arr2 as $key => $val){
					foreach ($arr as $k => $v){
						if($val==$v['ware_id']){
							$ware_order[$val][$k]['goods_id']=$v['goods_id'];
							$ware_order[$val][$k]['goods_number']=$v['goods_number'];
						}
					}
					

					//添加出库单
					$ware_order_list[$val]['war_out_state']=1;
					$ware_order_list[$val]['war_type']=1;
					$ware_order_list[$val]['war_out_cid']=$user['adm_cid'];
					$ware_order_list[$val]['ware_id']=(int)$val;
					//系統单号
					$ware_order_list[$val]['war_out_order']=$order_list['system_number'];
					$ware_order_list[$val]['war_out_count']=array_sum(array_column($ware_order[$val],'goods_number'));
					$ware_order_list[$val]['war_out_user']=$user['admin_id'];
					$ware_order_list[$val]['war_out_shipper']=(int)$val;
					$ware_order_list[$val]['war_out_receiving']=' '; //收货方需要获取 订单的数据所以不填了
					$ware_order_list[$val]['war_out_createtime']=date('Y-m-d H:i:s');
					$out_order_id=Db::table('out_order')->insertGetId($ware_order_list[$val]);
					// $out_order_id=1;

					if(!$out_order_id){throw new Exception("添加出库单失败");}
					unset($ware_order_list[$val]);
					$ware_goods_list=[];

					//添加出库单商品表
					foreach ($ware_order[$val] as $ks => $vs) {
						$ware_goods_list[$ks]['warg_wid']=$out_order_id;
						$ware_goods_list[$ks]['warg_goodsid']=$vs['goods_id'];
						$ware_goods_list[$ks]['wari_real_quantity']=$vs['goods_number'];
						$ware_goods_list[$ks]['warg_type']=3;
					}
					// return $ware_goods_list;
					// $res_ware_goods=1;
					$res_ware_goods=Db::table('warehouse_goods')->insert($ware_goods_list);
					unset($ware_goods_list);
					if(!$res_ware_goods){throw new Exception("添加商品表失败");}

					//添加订单和出库关联表 
					$order_ware['order_id']=$subscript;//订单id
					$order_ware['ware_id']=(int)$val;
					$order_ware['order_out_id']=(int)$out_order_id;
					$order_ware['owt_state']=1;
					// return $order_ware;

					// $res5=1
					$res5=Db::table('order_ware_relation')->insert($order_ware);
					if(!$res5){throw new Exception("添加订单与仓库关系表失败");}
					unset($order_ware);

					// 写入操作日志表里
					$ip=$_SERVER['REMOTE_ADDR'];
					$mk="订单模块";//模块
					$str="新增";
					$content="分配订单到各个仓库,订单号:".$order_list['system_number'];
					$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
					if(!$res){throw new Exception("写入操作日志表失败");}
				}

				$res9=Db::table('order_form')->where(['ord_id'=>$subscript])->update(['order_state'=>4]);
				if(!$res9){throw new Exception("更改订单状态失败");}

				$res8=$this->addOrderState(5,$user['admin_id'],$subscript);
				if(!$res8){throw new Exception("添加订单信息表失败");}
			}

			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>''];

		}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}


	//获取订单详情
	public function OrderDetails($user,$order_id){
		$order_list=Db::table('order_form')->where('order_state','!=',11)->where(['company_id'=>$user['adm_cid'],'ord_id'=>$order_id])->leftjoin('platform','order_form.plat_id','=','platform.plat_id')->select('ord_id as order_id','order_state','customer_account as user_account','customer_user','order_form.plat_number','system_number','plat_name','order_form.plat_id')->first();

		if(empty($order_list)){
			return ['code'=>500,'msg'=>'失败','data'=>"没有这个订单"];
		}
		if($order_list['order_state']>30){
			return ['code'=>500,'msg'=>'失败','data'=>"订单被锁定无法修改"];
		}
		if($order_list['order_state'] !=1){
			return ['code'=>500,'msg'=>'失败','data'=>"订单".$this->state_s[$order_list['order_state']].",无法进行编辑,未出库未分单的订单可以进行编辑"];
		}
		//获取用户信息
		$user_list=Db::table('order_user')->where(['order_id'=>$order_id])->orderBy('oru_id','desc')->select('oru_user_name as user_name','oru_user_tel as user_tel','oru_province as province','oru_city as city','oru_county as county','oru_address as address')->first();

		//获取平台信息
		$plat=Db::table('platform')->where(['plat_cid'=>$user['adm_cid'],'plat_state'=>1])->select('plat_id','plat_name')->get();

		// 获取商品信息
		$goods_list=Db::table('order_goods as ware')->where(['order_wid'=>$order_id])->join('goods','ware.warg_goodsid','=','goods.goo_id')->select('goods.goo_id as goods_id','goods.goo_name as goods_name','ware.goods_number as goods_number','goods_money as goods_money')->get();
		$order_list['order_id']=$order_id;
		$order_list['goods_value']=0;
		$order_list['plat_ids']=(int)$order_list['plat_id'];
		unset($order_list['plat_id']);
		$data=Db::table('goods')
		->where(['goo_sta'=>1])
		->selectRaw("concat(goo_name,'/',goo_number) as value,goo_id as goods_id,goo_name as goods_name,0 as goods_number,0 as goods_money")
		->limit(5)
		->get();
		return ['code'=>200,'msg'=>'成功','data'=>['user'=>$user_list,'order'=>$order_list,'goods'=>$goods_list,'new_goods'=>$data,'plat'=>$plat]];
	}

	//上传文件 导入excel 
	public function UploadsFileImport($file,$user){

		//  获取原文件名
       $file_name=$file->getClientOriginalName();
        //  获取扩展名  如 txt 
       $ext=$file->getClientOriginalExtension();
       if(!in_array($ext,['xls','xlsx'])){
       		return ['code'=>500,'msg'=>'失败','data'=>'仅支持xls和xlsx结尾的excel文件'];
       }
        //  获取文件类型
       $type=$file->getMimeType();
        // 临时的决定路径
       $realpath=$file->getRealPath();

       //生成文件名
       $filename="order_excel_".date('Ymd').time().".".$ext;
       // 第一个参数是设置 在  storage/app 下的那个文件夹，第二个是文件名；可以有第三个参数
       // $bool=Storage::put($filename,file_get_contents($realpath),'public');
       $bool=$file->move(public_path('uploads/excel/order_excel'),$filename);
       // $file_name='E:\web\phpstudy2\PHPTutorial\WWW\md\public\uploads/excel/order_excel/AAAA201901121547277531.xlsx';
       $file_name=public_path('uploads/excel/order_excel').'/'.$filename;

// return $file_name;.
       try{
       $data=[];
	       Excel::load($file_name,function($reader) use ($user,$file_name){
	       	
	       		DB::beginTransaction();
	           $reader = $reader->getSheet(0); 
				//获取表中的数据 
				$results = $reader->toArray();
				$order_list=[];
				unset($results[0]);
				$goods=[];
				foreach ($results as $key => $value) {
					if(empty($value[1])){
						unset($results[$key]);
						continue;
					}
					$order_list[$value[1]][$key]['plat_name']   =$value[0];
					$order_list[$value[1]][$key]['plat_number'] =$value[1];
					if(!empty($value[2])){
						$goods[$value[1]][$key]['goods_name']		=$value[2];
						$goods[$value[1]][$key]['goods_number']     =(int)$value[3];
						$goods[$value[1]][$key]['goods_money']      =(float)$value[4];
					}
					$order_list[$value[1]][$key]['user_name']   =$value[5];
					$order_list[$value[1]][$key]['user_tel']    =(string)$value[8];
					$order_list[$value[1]][$key]['user_account']=$value[6];
					$order_list[$value[1]][$key]['service']     =$value[7];
					
					$order_list[$value[1]][$key]['province']    =$value[9];
					$order_list[$value[1]][$key]['city']		=$value[10];
					$order_list[$value[1]][$key]['county']		=$value[11];
					$order_list[$value[1]][$key]['address']		=$value[12];
				}
				$order_data=[];
					$goods_name=[];
					foreach ($order_list as $keys => $values) {
						$out =[];
				        foreach ($values as $key=>$value) {
				            if (!in_array($value, $out)){
				                $out[$key] = $value;
				            }
				        }
				        if(count($out)>1){throw new Exception($values[$key]['plat_name'].":订单编号：".$keys.'存在不同数据;请保证同一个的平台单号下的数据一致');}

				        $order_data[$keys]=array_pop($out);
				        $order_data[$keys]['system_number']='OR'.$user['adm_cid'].'0'.$key.$user['admin_id'].date('YmdHis').rand(1000,9999);
				        if(empty($goods[$keys])){throw new Exception("商品不能为空。订单编号：".$keys."下的商品为空。");}
				        $goods_name=array_merge($goods_name,array_column($goods[$keys],'goods_name'));
					}

					unset($order_list);
					// dd($order_data);//订单信息表
					$plat_name=array_column($order_data,'plat_name');
					$plat_mas=Db::table('platform')->where(['plat_state'=>1])->select('plat_id','plat_name')->get();
					$plat_data=array_column($plat_mas,'plat_name');
					$data=array_intersect($plat_name,$plat_data);
					if(count($data) != count($plat_name)){throw new Exception("导入数据中存在没有的销售平台");}

					$goo_name=array_unique($goods_name);
					$Db_goods_name=Db::table('goods')->where(['goo_sta'=>1])->select('goo_name as goods_name','goo_id as goods_id')->get();
					$Db_name=array_column($Db_goods_name,'goods_name');
					$data_inters=array_intersect($goo_name,$Db_name);
					// dd($goo_name);
					if(count($data_inters) != count($goo_name)){throw new Exception("导入数据中存在没有的商品");}
					//商品数据换位
					$goods_val_key=array_column($Db_goods_name,'goods_id','goods_name');

					$plat_val_key=array_column($plat_mas,'plat_id','plat_name');
					//获取订单数据
					$add_order_data=[];
					$add_user_data=[];
					$new_goods=[];
					foreach($order_data as $key => $val){
						// unset($order_data[$key]);
						//获取销售平台id	
						// unset($order_data[$key]['plat_name']);
						
						foreach ($goods[$key] as $k => $v){
							$new_goods[$key]['goods_id'][]=(int)$goods_val_key[$v['goods_name']];
							$new_goods[$key]['goods_number'][]=(int)$v['goods_number'];
							$new_goods[$key]['goods_money'][]=$v['goods_money'];
						}
						//获取订单信息 并进行校验
						$add_order_data[$key]['customer_account']=$val['user_account'];
						$add_order_data[$key]['plat_number']     =$val['plat_number'];
						$add_order_data[$key]['plat_id']         =$plat_val_key[$val['plat_name']];
						$add_order_data[$key]['system_number']   =$val['system_number'];
						$add_order_data[$key]['create_user']     =$user['admin_id'];
						$add_order_data[$key]['company_id']      =$user['adm_cid'];
						$add_order_data[$key]['order_state']     =1;
						$add_order_data[$key]['customer_user']   =$val['service'];
						$add_order_data[$key]['user_name']       =$val['user_name'];
						$add_order_data[$key]['user_tel']        =$val['user_tel'];

						//客户信息表
						$add_user_data[$key]['oru_user_name']  =$val['user_name'];
						$add_user_data[$key]['oru_user_tel']   =$val['user_tel'];
						$add_user_data[$key]['oru_province']   =$val['province'];
						$add_user_data[$key]['oru_city']       =$val['city'];
						$add_user_data[$key]['oru_county']     =$val['county'];
						$add_user_data[$key]['oru_address']    =$val['address'];
						//校验客户信息不能为空;   校验订单信息和客户信息
						$this->check_order_data($add_order_data[$key],$add_user_data[$key]);

						$this->commen_add_order($add_order_data[$key],$add_user_data[$key],$new_goods[$key],$user,$type=1);
						
					}
					unlink($file_name);
					DB::commit();
					

	        });
			return ['code'=>200,'msg'=>'成功','data'=>''];
		}catch(Exception $e){ 
			unlink($file_name);
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
   		}
	}

	/**
	 * 公共的添加订单  这样就可以调用，也可以事务处理
	 * @param  [type] $order     订单信息
	 * @param  [type] $user_data 客户信息
	 * @param  [type] $goods     商品信息
	 * @param  [type] $user      用户信息
	 * @param  [type] $type      1 添加，   2编辑
	 * @return [type]
	 */
	public function commen_add_order($order,$user_data,$goods,$user,$type=1){
		if($type==1){
				//校验订单是否存在
				if(!empty($order['plat_number'])){
					$res=Db::table('order_form')->where(['plat_number'=>$order['plat_number'],'plat_id'=>$order['plat_id']])->first();
					if($res){
						throw new Exception("该平台已经存在这个订单;平台编号:".$order['plat_number']);
					}
				}
				//校验系统单号是否重复；或者用户重复提交
				$order['system_number'];
				$res2=Db::table('order_form')->where(['system_number'=>$order['system_number']])->first();
				if($res2){throw new Exception("请不要重复提交。已存在这个系统单号");}

				//创建时间
				$order['create_time']  =date('Y-m-d H:i:s',time());

				//订单统计表--订单量+1;
				$year=date('Y');
				$month=date('m');
				$data=Db::table('statistic_send')->where(['sta_cid'=>$user['adm_cid'],'sta_year'=>$year,'sta_month'=>$month,'sta_type'=>2])->first();
				if(empty($data)){
					$res6=Db::table('statistic_send')->insert(['sta_cid'=>$user['adm_cid'],'sta_year'=>$year,'sta_month'=>$month,'sta_type'=>2,'sta_total'=>1]);
				}else{
					$res6=Db::table('statistic_send')->where(['sta_cid'=>$user['adm_cid'],'sta_year'=>$year,'sta_month'=>$month,'sta_type'=>2])->increment('sta_total');
				}
				if(!$res6){throw new Exception("添加订单总数失败");}

			}elseif($type==2){
				$old_count=Db::table('order_form')->where(['order_state'=>1,'ord_id'=>$order['order_id']])->select('order_money','system_number','plat_id','plat_number')->first();
				if(empty($old_count)){throw new Exception("无法修改订单");}
			}
			
			$data=[];
			$count=0;
			foreach ($goods['goods_id'] as $key => $value) {
				//计算总价
				$count=$count+($goods['goods_number'][$key]*$goods['goods_money'][$key]);
				$data[$key]['warg_goodsid']=$value;
				$data[$key]['goods_number']=$goods['goods_number'][$key];
				$data[$key]['goods_money']=$goods['goods_money'][$key];
			}

			//校验商品是否重复
			$goods_id_count=count($goods['goods_id']);

			$diff_count=count(array_unique($goods['goods_id']));
			if($diff_count !== $goods_id_count){throw new Exception("商品存在重复数据");}

			$res1=Db::table('goods')->where(['goo_sta'=>1,'goo_cid'=>$user['adm_cid']])->whereIn('goo_id',$goods['goods_id'])->select('goo_id as goods_id')->get();
			if(count($res1) != $goods_id_count){throw new Exception("存在不可用的商品,导致无法添加");}
			
			if($count<0){throw new Exception("订单总价低于0元");}
			if($type==2){
				if($old_count['plat_id'] != $order['plat_id']){
					$res=Db::table('order_form')->where(['plat_number'=>$order['plat_number'],'plat_id'=>$order['plat_id']])->first();
					if($res){
						throw new Exception("该平台已经存在这个订单;平台编号:".$order['plat_number']);
					}

					$res2=Db::table('platform')->where(['plat_id'=>$old_count['plat_id']])->decrement('plat_number');

					if(!empty($old_count['plat_id'])){
						$res2=Db::table('platform')->where(['plat_id'=>$old_count['plat_id']])->decrement('plat_number');
						if(!$res2){throw new Exception("更改销售平台销售量失败");}

						$res3=Db::table('platform')->where(['plat_id'=>$old_count['plat_id']])->decrement('plat_money',$count);
						if(!$res3){throw new Exception("更改销售平台金额失败");}
					}
					
					if(!empty($order['plat_id'])){
						$res2=Db::table('platform')->where(['plat_id'=>$order['plat_id']])->increment('plat_number');
						if(!$res2){throw new Exception("更改销售量失败");}
					}

					if(!empty($order['plat_id']))
					{
						$res2=Db::table('platform')->where(['plat_id'=>$order['plat_id']])->increment('plat_number');
						if(!$res2){throw new Exception("更改销售量失败");}
					}
				}
				if($old_count['plat_number'] != $order['plat_number'] || $old_count['plat_id'] != $order['plat_id']){
					$res=Db::table('order_form')->where(['plat_number'=>$order['plat_number'],'plat_id'=>$order['plat_id']])->get();
					if($res){
						throw new Exception("该平台已经存在这个订单;平台编号:".$order['plat_number']);
					}
				}
			}


			$order['order_money']=$count;

			//更改平台的订单个数和订单金额
			if($type==1){
				if(!empty($order['plat_id']))
				{
					$res2=Db::table('platform')->where(['plat_id'=>$order['plat_id']])->increment('plat_number');
					if(!$res2){throw new Exception("更改销售量失败");}
				}else{
					$order['plat_id']='';
					$order['plat_number']='';
				}
				if(!empty($order['plat_id']))
				{
					$res2=Db::table('platform')->where(['plat_id'=>$order['plat_id']])->increment('plat_number');
					if(!$res2){throw new Exception("更改销售量失败");}
				}
				//添加订单并获取订单id
				$order_id=Db::table('order_form')->insertGetId($order);
				if(!$order_id){throw new Exception("添加订单失败");}
				$user_data['order_id']=$order_id;
				$str='添加';
				$content='添加订单,系统订单号为 : '.$order['system_number'];
			}
			if($type==2){
				if($old_count['plat_id'] == $order['plat_id']){
					$count=$count-$old_count['order_money'];
				}
				//添加订单并获取订单id
				$order_id=$order['order_id'];
				unset($order['order_id']);
				if(empty($order['plat_id'])){
					$order['plat_id']='';
					$order['plat_number']='';
				}
				$res3=Db::table('order_form')->where(['ord_id'=>$order_id])->update($order);
				if($res3!=1 && $res3 != 0){throw new Exception("添加订单失败");}
				$user_data['order_id']=$order_id;
				$res4=Db::table('order_goods')->where(['order_wid'=>$order_id])->delete();
				if(!$res4){throw new Exception("更改订单商品失败");}
				$str='编辑';
				$content='添加订单,系统订单号为 : '.$old_count['system_number'];

			}
			if($count!=0){
				if(!empty($order['plat_id']))
				{
					$res3=Db::table('platform')->where(['plat_id'=>$order['plat_id']])->increment('plat_money',$count);
					if(!$res3){throw new Exception("更改销售金额失败");}
				}
			}
			//添加客户信息
			if($type==1){
				$res2=Db::table('order_user')->insert($user_data);
				if(!$res2){throw new Exception($str."客户信息失败");}
			}else{
				$old_user_data=Db::table('order_user')->where(['order_id'=>$user_data['order_id']])->orderBy('oru_id','desc')->select('oru_user_name','oru_user_tel','oru_province','oru_city','oru_county','oru_address','order_id')->first();

				$old_user_str=implode('->@<-',$old_user_data);
				$new_user_str=implode('->@<-',$user_data);
				if($new_user_str != $old_user_str){
					$res2=Db::table('order_user')->insert($user_data);
					if(!$res2){throw new Exception($str."客户信息失败");}
				}
			}
			
			foreach ($data as $key => $val) {
				$data[$key]['order_wid']=$order_id;
			}

			//添加 商品信息
			$res3=Db::table('order_goods')->insert($data);
			if(!$res3){throw new Exception($str."订单商品失败");}

			// 添加订单记录
			$res4=$this->addOrderState($type,$user['admin_id'],$order_id);
			if(!$res4){throw new Exception($str."订单记录失败");}

			$ip=$_SERVER['REMOTE_ADDR'];
			$mk='订单模块';
			$res5=Coperationa::add($user['admin_id'],$ip,$mk,$this->state[$type],$content);
			if(!$res5){throw new Exception("添加记录活动日志表失败");}
	}

	//校验订单 和客户信息
	public function check_order_data($order,$user){
		
		//校验 电话手机号，校验地址  校验平台单号
		$preg_tel="/^((0\d{2,3}-?\d{7,8})|(1[35847]\d{9}))$/";
		if(!preg_match($preg_tel,$order['user_tel'])){throw new Exception("电话\手机号码格式错误");}

		$path1='/^[\x{4e00}-\x{9fa5}]{2,12}$/u';
		if(!preg_match($path1,$user['oru_province']) || !preg_match($path1,$user['oru_city'])){throw new Exception("省/市/县最少由两个汉字组成");}

		$path1='/^([a-zA-Z]|[0-9]|[\x{4e00}-\x{9fa5}]|_){4,}$/u';
		if(!preg_match($path1,$user['oru_address'])){throw new Exception("详细地址最少由4个字符组成");}
		$preg_user="/^[\x{4e00}-\x{9fa5}]{2,4}$/u";
		if(!preg_match($preg_user,$user['oru_user_name'])){throw new Exception("客户姓名,应由2-4个中文字符组成");}

	}

}