<?php

namespace App\Http\Models\Index;

use Illuminate\Database\Eloquent\Model;
use DB;

class Technician extends Model
{
    protected $table = 'technician';
    protected $primaryKey = 'tech_id';
    public $timestamps = false;

	// 技师积分值排行
	public static function integralTop($adm_cid){
		return DB::table('technician')
        ->where('tech_cid', $adm_cid)
        ->select('tech_integral','tech_name')
        ->orderBy('tech_integral','desc')
        ->limit(10)
        ->get();
        return $list;
	}

	// 技师质保单排行
	public static function policyTop($adm_cid){
		return DB::table('technician')
        ->where('tech_cid', $adm_cid)
        ->select('tech_policy_number','tech_name')
        ->orderBy('tech_policy_number','desc')
        ->limit(10)
        ->get();
	}
}
