<?php
namespace App\Http\Models\Goods;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use App\Http\Models\Coperationa;

class Navigation extends Model
{
	private $page_size=10;
	public function Naviga_list($where,$user){
		$Db=DB::table('navigation')->where(['nav_del'=>1,'nav_cid'=>$user['adm_cid']])->where('nav_id','>',1)->join('admin','nav_user','=','adm_id');
		if(!empty($where['nav_name'])){
			$Db=$Db->where('nav_name','like',"%".$where['nav_name']."%");
		}
		if(!empty($where['time_end'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
			$Db=$Db->where('nav_addtime','<=',$time);
		}
		if(!empty($where['time_start'])){
			$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
			$Db=$Db->where('nav_addtime','>=',$time);
		}
		if(!empty($where['nav_style'])){
			$Db=$Db->where('nav_style','=',$where['nav_style']);
		}
		if(!empty($where['nav_state'])){
			$Db=$Db->where('nav_state','=',$where['nav_state']);
		}
		$count=$Db->count();
		$page_count=(int)ceil($count/$where['pagesize']);
		$limit=($where['page']-1)*$where['pagesize'];
		$Db=$Db->limit($where['pagesize'])->offset($limit);
		$data=$Db->selectRaw("nav_id,nav_name,nav_style,date_format(nav_addtime,'%Y-%m-%d %H:%i') as nav_addtime,nav_state,adm_name,nav_total,nav_genre")->orderBy('nav_id','desc')->get();
		if ($user['admin_id'] == '1'){
            $nav_cid = DB::table('admin')->where('adm_cid',$user['adm_cid'])->value('adm_cid');
        }
		$page=['count'=>$count,'page'=>$where['page'],'page_size'=>$where['pagesize'],'page_count'=>$page_count];
		if (isset($nav_cid)){

            return ['code'=>200,'msg'=>'success','data'=>['navigation'=>$data,'page'=>$page,'nav_cid'=>$nav_cid]];
        }else{
            return ['code'=>200,'msg'=>'success','data'=>['navigation'=>$data,'page'=>$page]];
        }

	}
	/**
	 * 添加
	 * @param [type] $navdata 导航数据
	 * @param [type] $data    导航列表数据
	 * @param [type] $user    用户信息
	 * @param [type] $state   1 添加  2 编辑
	 */
	public function add_Navigation($navdata,$data,$user,$state=1){
		if($state==1){
			$res=Db::table('navigation')->where(['nav_del'=>1,'nav_name'=>$navdata['nav_name'],'nav_cid'=>$user['adm_cid'],'nav_column_setup'=>$navdata['nav_column_setup']])->first(['nav_name']);
		}else{
			if($navdata['nav_id']==1){
				return ['code'=>500,'msg'=>'error','data'=>'默认导航不可更改'];
			}
			$data_s=Db::table('navigation')->where(['nav_id'=>$navdata['nav_id'],'nav_del'=>1,'nav_cid'=>$user['adm_cid']])->first(['nav_id']);
			if(!$data_s){return response()->json(['code'=>500,'msg'=>'error','data'=>'没有这个导航']);}

			$res=Db::table('navigation')->where(['nav_del'=>1,'nav_name'=>$navdata['nav_name'],'nav_cid'=>$user['adm_cid'],'nav_column_setup'=>$navdata['nav_column_setup']])->where('nav_id','!=',$navdata['nav_id'])->first(['nav_name']);
		}
		
		try{
			if($res){return ['code'=>500,'msg'=>'error','data'=>'导航名称重复'];}
			//处理导航图标
			$arr=[];
			foreach ($data['name'] as $k => $v) {
	            if (empty($data['name'][$k])) {
	                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
	            }
	            if (mb_strlen($v,'UTF8') > 6) {
	                return response()->json(['code'=>500,'msg'=>'error','data'=>'信息名称最多六个字']);
	            }
	        }
			foreach ($data['name'] as $key => $val) {
				$arr[$key]['name']   =$val;
				$arr[$key]['icon_type']=$data['icon_type'][$key];
				$arr[$key]['show']   =$data['show'][$key] ? 2 : 1;
				$arr[$key]['system_icon']=$data['system_icon'][$key];
				$arr[$key]['icon_ids'] =$data['icon_ids'][$key];
				$arr[$key]['icon_order'] =$data['icon_order'][$key];
				$arr[$key]['pic'] = CommenModel::uploadBase64Img($data['pic'][$key],'navigation/icon','public');
				if ($arr[$key]['pic'] == false) {
					$path = explode(config('app.url'),$data['pic'][$key]);
					$path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    // 新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/navigation/icon/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, public_path().$pathName);
                    // 返回路径
                    $filePath = "public". $pathName;
                    $arr[$key]['pic'] .= $filePath;
				}
				$arr[$key]['content']=$data['content'][$key];
			}
			
			DB::beginTransaction();
			$navdata['nav_icon']=json_encode($arr);
			if($state==1){
				$res2=Db::table('navigation')->insert($navdata);
                // 技师表单设置
                if ($data['wata_type'] == 1) {
                    # 系统默认表单信息
                    $wata_data = DB::table('warranty_table')
                        ->where('wata_id',$data['wata_id'])
                        ->first();
                    $wata_ids = DB::table('warranty_table')->where('wata_cid',$user['adm_cid'])->value('wata_id');
                    $wata_data['wata_cid'] = $user['adm_cid'];
                    $wata_data['wata_userid'] = $user['adm_id'];
                    $wata_data['wata_user_name'] = $user['adm_name'];
                    $wata_data['wata_stase'] = $data['wata_stase']; //状态1开启2关闭
                    $wata_data['wata_updatetime'] = date('Y-m-d H:i:s');
                    unset($wata_data['wata_id']);
                    if ($wata_ids) {
                        $wata_res = DB::table('warranty_table')->where('wata_id',$wata_ids)->update($wata_data);
                        if (!$wata_res) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑技师表单设置失败']);
                        }
                    }else{
                        $wata_id = DB::table('warranty_table')->insertGetId($wata_data);
                        if (!$wata_id) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加技师表单设置失败']);
                        }
                    }
                }
                // 消费者表单设置
                if ($data['watas_type'] == 1) {
                    # 系统默认表单信息
                    $watas_data = DB::table('warrantys_table')
                        ->where('watas_id',$data['watas_id'])
                        ->first();
                    $watas_ids = DB::table('warrantys_table')->where('watas_cid',$user['adm_cid'])->value('watas_id');
                    $watas_data['watas_cid'] = $user['adm_cid'];
                    $watas_data['watas_userid'] = $user['adm_id'];
                    $watas_data['watas_user_name'] = $user['adm_name'];
                    $watas_data['watas_stase'] = $data['watas_stase']; //状态1开启2关闭
                    $watas_data['watas_updatetime'] = date('Y-m-d H:i:s');
                    unset($watas_data['watas_id']);
                    if ($watas_ids) {
                        $watas_res = DB::table('warrantys_table')->where('watas_id',$watas_ids)->update($watas_data);
                        if (!$watas_res) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑消费者表单设置失败']);
                        }
                    }else{
                        $watas_id = DB::table('warrantys_table')->insertGetId($watas_data);
                        if (!$watas_id) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加技师表单设置失败']);
                        }
                    }
                }
				if(!$res2) throw new Exception("添加导航失败");
				$str='添加';
			}else{
				$id=$navdata['nav_id'];
				unset($navdata['nav_id']);
				$res2=Db::table('navigation')->where(['nav_id'=>$id])->update($navdata);
				$str='编辑';
				// 消费者表单设置
		        $watas = DB::table('warrantys_table')->where('watas_cid',$user['adm_cid'])->update(['watas_stase'=>$data['watas_stase']]);
		        // 技师表单设置
		        $wata = DB::table('warranty_table')->where('wata_cid',$user['adm_cid'])->update(['wata_stase'=>$data['wata_stase']]);
			}

			// 写入操作日志表里
			$content=$str.'导航。导航名称：'.$navdata['nav_name'];
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="商品管理->导航列表";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");
			DB::commit();
			return ['code'=>200,'msg'=>'success','data'=>$str.'成功'];
		}catch(Exception $e){
			Db::rollBack();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
	}
	/**
	 * 更改状态
	 * @param [type]  $nav_id id
	 * @param [type]  $user   用户信息
	 * @param integer $state  1 启用 2停用  3 删除
	 */
	public function Navi_update($nav_id,$user,$state=1){
		try{
			if(!is_array($nav_id)){
				$id=$nav_id;
				unset($nav_id);
				$nav_id[]=$id;
			}

			$Db=Db::table('navigation')->where(['nav_del'=>1,'nav_cid'=>$user['adm_cid']])->whereIn('nav_id',$nav_id);
			if($state==1){
				$str='启用';
				$Db=$Db->where(['nav_state'=>2]);
			}elseif($state==2){
				$str='停用';
				$Db=$Db->where(['nav_state'=>1]);
			}else{
				$str='删除';
			}
			$data=$Db->select('nav_id','nav_name')->get();
			if(empty($data)){
				throw new Exception("没有可以".$str.'的导航');
			}
			DB::beginTransaction();
			$nav_id=array_column($data,'nav_id');
			if($state!=1){
				//判断是否有商品绑定这个导航
				$res3=Db::table('goods')->where(['del_type'=>1,'goo_cid'=>$user['adm_cid']])->whereIn('goo_navid',$nav_id)->first(['goo_id']);
				if($res3){throw new Exception("导航已绑定商品");
				}
			}
			if($state==1){
				$res=Db::table('navigation')->whereIn('nav_id',$nav_id)->update(['nav_state'=>1]);
			}elseif($state==2){
				$res=Db::table('navigation')->whereIn('nav_id',$nav_id)->update(['nav_state'=>2]);
			}else{
				$res=Db::table('navigation')->whereIn('nav_id',$nav_id)->update(['nav_del'=>2]);
			}
			if(!$res){
				throw new Exception($str."失败");
			}
			// 写入操作日志表里
			$content=$str.'导航。导航名称：'.implode(array_column($data,'nav_name'),",");
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="商品管理->导航列表";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			DB::commit();
			return ['code'=>200,'msg'=>'success','data'=>$str.'成功'];
		}catch(Exception $e){
			Db::rollBack();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
	}
    //
    // 写入操作日志表里
			// $ip=$_SERVER['REMOTE_ADDR'];
			// $mk="我的云仓->出入库管理";//模块
			// $res=Coperationa::add($user['admin_id'],$ip,$mk,$str,$content);
			// if(!$res) throw new Exception("写入操作日志表失败");
			// DB::commit();
}