<?php
namespace App\Http\Models\Goods;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use App\Http\Models\Coperationa;
use Illuminate\Support\Facades\Storage;
class GoodsModel extends Model
{

	/**
	 * 添加订单      更改销售平台数量
	 * @param [type] $order    订单信息
	 * @param [type] $user_data 客户信息
	 * @param [type] $goods     商品信息
	 * @param [type] $user      登录用户信息
	 */
	public function addOrderDb($order,$user_data,$goods,$user,$type=1){
		try{
			//编辑 更改平台金额   添加订单信息表   写入操作日志   删除商品信息    更改数据总价
			//********   校验商品是否可用   ****
			//写入出入库记录表    
			DB::beginTransaction();

			//校验数据
			$this->check_order_data($order,$user_data);

			//因为和导入代码一致所以写入一个公共的调动方法.
			$this->commen_add_order($order,$user_data,$goods,$user,$type);
			if($type==1){
				$str='添加';
			}else{
				$str='编辑';
			}
			DB::commit();
			return ['code'=>200,'msg'=>'成功','data'=>$str.'订单成功'];
	 	}catch(Exception $e){
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
		}
	}

	//上传文件 导入excel 
	public function UploadsFileImport($file,$user){
		// 获取原文件名
		$file_name = $file->getClientOriginalName();
		// 获取原扩展名
		$ext=$file->getClientOriginalExtension();
		if(!in_array($ext,['xls','xlsx'])){
       		return ['code'=>500,'msg'=>'失败','data'=>'仅支持xls和xlsx结尾的excel文件'];
       	}
		// 获取文件类型
       	$type=$file->getMimeType();
        // 临时的决定路径
       	$realpath=$file->getRealPath();
       	//生成文件名
       	$filename="goods_excel_".date('Ymd').time().".".$ext;
       	// 第一个参数是设置 在  storage/app 下的那个文件夹，第二个是文件名；可以有第三个参数
       	// $bool=Storage::put($filename,file_get_contents($realpath),'public');
       	$bool=$file->move(public_path('uploads/excel/goods_excel'),$filename);
       	// $file_name='E:\web\phpstudy2\PHPTutorial\WWW\md\public\uploads/excel/order_excel/AAAA201901121547277531.xlsx';
       	$file_name=public_path('uploads/excel/goods_excel').'/'.$filename;
		// return $file_name;
       	try{
       		$data=[];
	       	Excel::load($file_name,function($reader) use ($user,$file_name){
	       		DB::beginTransaction();
	           	$reader = $reader->getSheet(0); 
				//获取表中的数据 
				$results = $reader->toArray();
				// var_dump($results);exit;
				$goods_list=[];
				unset($results[0]);
				$goods=[];
				foreach ($results as $key => $value) {
					if(empty($value[1])){
						unset($results[$key]);
						continue;
					}
					$goods_list[$value[1]][$key]['goo_name']    		= $value[0];
					$goods_list[$value[1]][$key]['goo_number']  		= (int)$value[1];
					$goods_list[$value[1]][$key]['technician_integral'] = $value[2];
					$goods_list[$value[1]][$key]['channel_integral']	= $value[3];
					$goods_list[$value[1]][$key]['warranty_day']		= $value[4];
					$goods_list[$value[1]][$key]['validity_period']		= $value[5];
					$goods_list[$value[1]][$key]['cla_name']			= $value[6];
					$goods_list[$value[1]][$key]['nav_name']			= $value[7];
				}
				$goods_data=[];
				$goods_name=[];
				foreach ($goods_list as $keys => $values) {
					$out =[];
			        foreach ($values as $key=>$value) {
			            if (!in_array($value, $out)){
			                $out[$key] = $value;
			                // var_dump($out[$key]);exit;
			            }
			        }
			        $goods_data[$keys]=array_pop($out);
			        if(empty($goods_list[$keys])){throw new Exception("商品不能为空。");}
			        $goods_name=array_merge($goods_name,array_column($goods_list[$keys],'goo_name'));
				}

				unset($goods_list);
				// dd($goods_data);//商品表
				$cla_name = array_column($goods_data,'cla_name');
				$cla_mas = Db::table('goo_classifi')->where(['cla_stase'=>1])->select('cla_id','cla_name')->get();
				$cla_data = array_column($cla_mas,'cla_name');
				$data=array_intersect($cla_name,$cla_data);
				if(count($data) != count($cla_name)){throw new Exception("导入数据中存在没有的品类名称");}
				$nav_name = array_column($goods_data,'nav_name');
				$nav_mas = Db::table('navigation')->where(['nav_state'=>1,'nav_del'=>1])->select('nav_id','nav_name')->get();
				$nav_data = array_column($nav_mas,'nav_name');
				$datas=array_intersect($nav_name,$nav_data);
				if(count($datas) != count($nav_name)){throw new Exception("导入数据中存在没有的导航名称");}
				$goo_name=array_unique($goods_name);
				$goods_mas = Db::table('goods')->where(['goo_sta'=>1,'del_type'=>1])->select('goo_id','goo_name')->get();
				$cla_val_key=array_column($cla_mas,'cla_id','cla_name');
				$nav_val_key=array_column($nav_mas,'nav_id','nav_name');
				// 获取数据
				$add_order_data=[];
				foreach ($goods_data as $key => $val) {
					$add_order_data[$key]['goo_name'] 			 = $val['goo_name'];
					$add_order_data[$key]['goo_number'] 		 = $val['goo_number'];
					$add_order_data[$key]['technician_integral'] = $val['technician_integral'];
					if ($val['technician_integral'] != '') {
                        $add_order_data[$key]['technician_integral'] 	= $val['bar_codenum'];
                    }else{
                        $add_order_data[$key]['technician_integral'] 	= 0;
                    }
					$add_order_data[$key]['channel_integral'] = $val['channel_integral'];
					if ($val['channel_integral'] != '') {
                        $add_order_data[$key]['channel_integral'] 	= $val['channel_integral'];
                    }else{
                        $add_order_data[$key]['channel_integral'] 	= 0;
                    }
					$add_order_data[$key]['warranty_day']    = $val['warranty_day'];
					$add_order_data[$key]['validity_period'] = $val['validity_period'];
					$add_order_data[$key]['goo_classifi'] 	= $cla_val_key[$val['cla_name']];
					$add_order_data[$key]['goo_navid']    	= $nav_val_key[$val['nav_name']];
					$add_order_data[$key]['goo_cid']        =$user['adm_cid'];
					$add_order_data[$key]['goo_type']        =$user['adm_type'];
					$this->commen_add_order($add_order_data[$key],$user,$type=1);
				}
				unlink($file_name);
				DB::commit();
	        });
			return ['code'=>200,'msg'=>'成功','data'=>''];
		}catch(Exception $e){ 
			unlink($file_name);
			DB::rollBack();
			return ['code'=>500,'msg'=>'失败','data'=>$e->getMessage()];
   		}
	}

	/**
	 * 公共的添加订单  这样就可以调用，也可以事务处理
	 * @param  [type] $order     订单信息
	 * @param  [type] $goods     商品信息
	 * @param  [type] $user      用户信息
	 * @param  [type] $type      1 添加，   2编辑
	 * @return [type]
	 */
	public function commen_add_order($goods,$user,$type=1){
		$data=[];
		$find_goo_name = DB::table('goods')
				->where('del_type', 1)
				->where('goo_cid', $user['adm_cid'])
				->where('goo_type', $user['adm_type'])
				->where('goo_name', $goods['goo_name'])
				->first();
		if ($find_goo_name) {throw new Exception("商品名称已存在");}
		
		//添加 商品信息
		$goods['goo_time'] = date('Y-m-d H:i:s');
		$res3=Db::table('goods')->insert($goods);
		if(!$res3){throw new Exception("添加商品失败");}

		//添加操作日志表
        $state_str='添加';
        $ip=$_SERVER['REMOTE_ADDR'];
        $mk='客户模块';
        $contents='添加成功';
        $res5=Coperationa::add($user['admin_id'],$ip,$mk,$state_str,$contents);
        if(!$res5){throw new Exception("添加记录活动日志表失败");}
	}

}