<?php

namespace App\Http\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Db;
use App\Http\Models\CommenModel;
use \Exception;
use App\Http\Models\Coperationa;
class AnticounterModel extends Model
{
	private $page_size=10;

	//更改预警样式
    public function Set_Anti_Style($data,$user){
    	try{
    		Db::beginTransaction();
    		$old_data=Db::table('note')->where(['not_cid'=>$user['adm_cid']])->first();
    		if(empty($old_data)){
    			$data['not_cid']=$user['adm_cid'];
    			$res=Db::table('note')->insert($data);
    		}else{
    			$res=Db::table('note')->where(['not_cid'=>$user['adm_cid']])->update($data);
    		}
            $data['note_content']=$this->replace_str($data['note_content']);
    		if(!$res){
    			throw new Exception("更改防伪设置失败");
    		}
            $pathName=public_path().'/style'.$user['adm_cid'];
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName,0775,true);
                chmod($pathName,0775);
            }
            $start="<!DOCTYPE HTML><html><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' name='viewport'><title>溯源信息</title><script type='text/javascript' src='info1/js/jquery-1.11.3.min.js'></script><script type='text/javascript' src='http://www.7cha.co/Anli/bluearp/chips/js/mobile.js'></script><link rel='stylesheet' type='text/css' href='http://www.7cha.co/Anli/bluearp/chips/css/common.css' /><style>.mainLooksBox {width: 7.5rem;display: block;margin: 0 auto;padding: 0.2rem;font-size: 0.24rem;background-color: #ffffff;min-height: 100vh;}.mainLooksBox .titles {font-size: 0.32rem;color: #666666;border-bottom: 0.02rem solid #dddddd;line-height: 0.36rem;padding-bottom: 0.1rem;margin-bottom: 0.2rem;}.mainLooksBox .titles>span {display: inline-block;border-left: 0.08rem solid #1d92c9;padding-left: 0.1rem;padding-left: 0.15rem;border-radius: 0.04rem;}.mainLooksBox span,.mainLooksBox i,.mainLooksBox em {display: inline;line-height: 1.6;}.mainLooksBox img {display: block;width: 100%;margin: 0.1rem auto;}.mainLooksBox .content_box p{line-height: 0.46rem;font-size: 0.26rem;}.mainLooksBox .content_box .text-small{font-size: 0.24rem;}.mainLooksBox .content_box .text-tiny{font-size: 0.22rem;}.mainLooksBox .content_box .text-big{font-size: 0.28rem;}.mainLooksBox .content_box .text-huge{font-size: 0.3rem;}mark.pen-red{color: red;}mark.pen-green{color:lawngreen;}mark{background-color: transparent;}.content_box blockquote{overflow: hidden;padding-right: 1.5em;padding-left: 1.5em;margin-left: 0;font-style: italic;border-left: 5px solid #ccc;}</style></head><body><div class='mainLooksBox'><p class='titles'><span>防伪查询</span></p><div id='notehtml' class='content_box'>";
            $end="</div></div></body></html>";
            $html_content=$start.$data['note_content'].$end;
            $res_html=file_put_contents($pathName.'/index.html',$html_content);
            if(!$res_html){
                throw new Exception("写入文件失败");
            }
    		// 写入操作日志表里
			$content='更改防伪设置样式。';
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防伪管理->防伪设置记录";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,'更改样式',$content);
			if(!$res) throw new Exception("写入操作日志表失败");

    		Db::commit();
    		return ['code'=>200,'msg'=>'success','data'=>'更改成功','url'=>'public/style'.$user['adm_cid'].'/index.html','content'=>$data['note_content']];
    	}catch(Exception $e){
    		Db::rollback();
    		return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
    	}
    }

    public function replace_str($data){
        $data=str_replace('{goods}',"满天星窗帘",$data);
        $data=str_replace('{code}',"500011810015498",$data);
        $data=str_replace('{num}','1',$data);
        $data=str_replace('{nums}','1',$data);
        $data=str_replace('{time}',"2019-07-22 12:00:00",$data);
        $data=str_replace('{pros}',"天津 武清区",$data);
        return $data;
    }

    /**
     * 防伪预警列表
     * @param [type] $where 条件
     * @param [type] $user  用户
     */
    public function Anti_List($where,$user){
     //    $where['number']     =(int)$request->input('number',null);
     //    $where['page']       =(int)$request->input('page',1);
    	
        $old_arr=Db::table('note')->where(['not_cid'=>$user['adm_cid']])->select('note_number')->first();
        // dd($old_arr);

        if(empty($old_arr)){
            $old_number=0;
        }else{
            $old_number=$old_arr['note_number'];
        }
        
    	$Db=Db::table('info_total')->where(['total_cid'=>$user['adm_cid']])->Leftjoin('goods','total_good_id','=','goo_id');
    	if(!empty($where['stase'])){
    		$Db=$Db->where('total_state',$where['stase']);
    	}
    	if(!empty($where['time_start'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_start']));
    		$Db=$Db->where('create_at','>=',$time);
    	}
    	if(!empty($where['time_end'])){
    		$time=date('Y-m-d H:i:s',strtotime($where['time_end']));
    		$Db=$Db->where('create_at','<=',$time);
    	}

    	if(!empty($where['code_number'])){
    		$Db=$Db->where('total_code','like',"%".$where['code_number'].'%');
    	}

    	if(!empty($where['goods_name'])){
    		$Db=$Db->where('goo_name','like',"%".$where['goods_name'].'%');
    	}
    	if(!empty($where['number'])){
    		$Db=$Db->where('total_num','>',$where['number']);
    	}else{
    		$Db=$Db->where('total_num','>',$old_number);
    	}

    	$count=$Db->count();
		$page_count=(int)ceil($count/$where['pagesize']);
		$limit=($where['page']-1)*$where['pagesize'];
		$Db=$Db->limit($where['pagesize'])->offset($limit);
	 
    	$data=$Db->select('total_id as id','create_at as addtime','total_code','goo_name','total_num','total_state','total_remarks','total_nums','total_status')->orderBy('total_id','desc')->get();
    	$page=['count'=>$count,'page'=>$where['page'],'page_size'=>$where['pagesize'],'page_count'=>$page_count];
		return ['code'=>200,'msg'=>'success','data'=>['number'=>$old_number,'info_data'=>$data,'page'=>$page]];
    }

    /**
     * 编辑
     * @param [type] $id   [description]
     * @param [type] $type [description]
     * @param [type] $user [description]
     */
    public function Update_state($id_data,$user,$remarks){
    	if(!is_array($id_data)){
			$id=$id_data;
			unset($id_data);
			$id_data[]=$id;
		}
		try{
			Db::beginTransaction();
			$data=Db::table('info_total')->whereIn('total_id',$id_data)->where(['total_state'=>1,'total_cid'=>$user['adm_cid']])->select('total_id','total_code')->get();
			if(empty($data)){
				throw new Exception("没有要处理的预警");
			}
			$id=array_column($data,'total_id');
			$res=Db::table('info_total')->whereIn('total_id',$id)->update(['total_state'=>2,'total_remarks'=>$remarks]);

			if(!$res){throw new Exception("处理预警数据失败");}

			// 写入操作日志表里
			$content='处理预警。溯源码：'.implode(array_column($data,'total_code'),',');
			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防伪管理->防伪预警";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,'处理预警',$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>'处理成功'];
		}catch(Exception $e){
			Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
    }

    public function Edit_Anti($id,$user,$remarks){
    	try{
            if(!is_array($id)){
                $tem=$id;
                unset($id);
                $id[]=$tem;
            }
			Db::beginTransaction();
			$data=Db::table('info_total')->whereIn('total_id',$id)->where(['total_cid'=>$user['adm_cid']])->select('total_id','total_code')->first();
			if(empty($data)){
				throw new Exception("没有要编辑的预警数据");
			}

			$res=Db::table('info_total')->whereIn('total_id',$id)->update(['total_remarks'=>$remarks,'update_time'=>date('Y-m-d H:i:s')]);

			if(!$res){throw new Exception("编辑预警数据失败");}

			// 写入操作日志表里
			$content='编辑预警。溯源码：'.$data['total_code'];

			$ip=$_SERVER['REMOTE_ADDR'];
			$mk="防伪管理->防伪预警";//模块
			$res=Coperationa::add($user['admin_id'],$ip,$mk,'编辑',$content);
			if(!$res) throw new Exception("写入操作日志表失败");

			Db::commit();
			return ['code'=>200,'msg'=>'success','data'=>'编辑成功'];
		}catch(Exception $e){
			Db::rollback();
			return ['code'=>500,'msg'=>'error','data'=>$e->getMessage()];
		}
    }
}