<?php

namespace App\Http\Middleware;

use Closure;
use DB;
use Session;
use Illuminate\Support\Facades\Crypt;
use App\Http\Controllers\MobileWeb\Verify\VerifyHomepageController;

class WebLogin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->webLoginValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 验证api_token
        $verify = webVerifyToken($request['userid'], $request['api_token']);
        if ($verify['code'] != 200) {
            return response()->json($verify);
        }
        return $next($request);
    }
}
