<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Crypt;
use DB;

class HasRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // 当前访问的控制器方法名
        $current_path = \Route::current()->getActionName().',';

        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        //获取当前账号所有的路径
        $auth_route = DB::table('login_temporary')
                                ->where('api_token','=',$api_token)
                                ->select('auth_routes','adm_cid')
                                ->first();
        if($auth_route['adm_cid'] !== 1)
        {
            $com_expiretime = DB::table('company')->where('com_id',$auth_route['adm_cid'])->select('com_expiretime')->first();
            if($com_expiretime['com_expiretime'] < date('Y-m-d H:i:s'))
            {
                return response()->json(["code"=>500,'msg'=>'error','data'=>'此企业已到期,请联系管理员']);
            }
        }
        $auth_routes = json_decode($auth_route['auth_routes']);
		$passdata = DB::table('privileges')
                                ->where('pri_id','=','268')
                                ->select('pri_id','pri_fid','pri_funname','pri_acna','pri_funna','tit_pic')
                                ->first();
		$passdatas = DB::table('privileges')
                                ->where('pri_id','=','269')
                                ->select('pri_id','pri_fid','pri_funname','pri_acna','pri_funna','tit_pic')
                                ->first();
		$auth_routes[]='App\Http\Controllers\\'.$passdata['pri_acna'].'Controller'.'@'.$passdata['pri_funna'].',';
		$auth_routes[]='App\Http\Controllers\\'.$passdatas['pri_acna'].'Controller'.'@'.$passdatas['pri_funna'].',';
        // 如果当前访问路径存在于当前账号角色权限中就放行
        if(in_array($current_path,$auth_routes))
        {
            return $next($request);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'此账号无权访问']);
        }
    }
}
