<?php

namespace App\Http\Controllers\Warning;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Coperationa;

class WarningListController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 标签列表
    public function index(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();

        $now_time = date('Y-m-d H:i:s');
        // 安装质保期预警
        if ($request['type'] == 2) {
            $find_list = DB::table('warranty as a')
                            // ->leftJoin('2019_code as b','b.code','=','a.code')
                            // ->leftJoin('goods as c','c.goo_id','=','b.goods_id')
                            ->leftJoin('channels as d','d.chan_id','=','a.warr_chan_id')
                            ->where('warr_cid',$find_adm['adm_cid'])
                            ->where(function($query) use($find_adm) {
                                if (!empty($find_adm['adm_chan_id'])) {
                                    $query->where('a.warr_chan_id','=',$find_adm['adm_chan_id']);
                                }
                            })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['warr_addtime'])) {
                                    $query->where('a.warr_addtime', 'like' , '%'.$search_data['warr_addtime'].'%' );
                                }
                            })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['warr_expire_time'])) {
                                    $query->where('a.warr_expire_time', 'like' , '%'.$search_data['warr_expire_time'].'%' );
                                }
                            })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['warr_number'])) {
                                    $query->where('a.warr_number', 'like' , '%'.$search_data['warr_number'].'%' );
                                }
                            })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['code'])) {
                                    $query->where('a.code', 'like' , '%'.$search_data['code'].'%' );
                                }
                            })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['chan_enterprise_name'])) {
                                    $query->where('d.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                                }
                            })
                            // ->where(function($query) use($search_data) {
                            //     if (!empty($search_data['goo_name'])) {
                            //         $query->where('c.goo_name', 'like' , '%'.$search_data['goo_name'].'%' );
                            //     }
                            // })
                            // ->where(function($query) use($search_data) {
                            //     if (!empty($search_data['goo_number'])) {
                            //         $query->where('c.goo_number', 'like' , '%'.$search_data['goo_number'].'%' );
                            //     }
                            // })
                            ->where(function($query) use($search_data) {
                                if (!empty($search_data['state'])) {
                                    if ($search_data['state'] == 1) {
                                        $query->where('a.warr_expire_time', '<=' , date('Y-m-d H:i:s') );
                                    }
                                    if ($search_data['state'] == 2) {
                                        $query->where('a.warr_expire_time', '>=' , date('Y-m-d H:i:s') );
                                    }
                                }
                            })
                            // ->select('a.code','a.warr_number','a.warr_addtime','a.warr_expire_time','a.warranty_day','c.goo_name','c.goo_number','d.chan_enterprise_name')
                            ->select('a.code','a.warr_number','a.warr_addtime','a.warr_expire_time','a.warranty_day','d.chan_enterprise_name')
                            ->orderBy('a.warr_id','desc')
                            ->paginate($this->show_count);
            $list_items = $find_list->items();
            foreach ($list_items as $key => $value) {
                $list_items[$key]['state'] = $now_time > $value['warr_expire_time'] ? 1 :2;
                $list_items[$key]['goods'] = DB::table('formwork_code as b')
                    ->leftjoin('goods as c','c.goo_id','=','b.gco_gid')
                    ->where('gco_start','<=',$value['code'])
                    ->where('gco_end','>=',$value['code'])
                    ->where('gco_gid','!=',0)
                    ->where('c.goo_name','like','%'.$request['goo_name'].'%')
                    ->first(['gco_gid','goo_name','goo_number']);
                if ($list_items[$key]['goods'] == null){
                    $list_items[$key]['goods'] = DB::table('group as b')
                        ->leftjoin('goods as c','c.goo_id','=','b.gro_gid')
                        ->where('code_start','<=',$value['code'])
                        ->where('code_end','>=',$value['code'])
                        ->where('c.goo_name','like','%'.$request['goo_name'].'%')
                        ->first(['gro_gid','goo_name','goo_number']);
                }
            }
        }else{
            // 生产保质期预警
            $find_list = DB::table('goods_flow as a')
                        ->leftJoin('channels as b','b.chan_id','=','a.goof_chan_id')
                        ->leftJoin('goods_flow_info as c','c.goof_id','=','a.goof_id')
                        ->where('goof_cid',$find_adm['adm_cid'])
                        ->where(function($query) use($find_adm) {
                            if (!empty($find_adm['adm_chan_id'])) {
                                $query->where('a.goof_chan_id','=',$find_adm['adm_chan_id']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['gofi_production_date'])) {
                                $query->where('c.gofi_production_date', 'like' , '%'.$search_data['gofi_production_date'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['gofi_expired_date'])) {
                                $query->where('c.gofi_expired_date', 'like' , '%'.$search_data['gofi_expired_date'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['goo_name'])) {
                                $query->where('a.goo_name', 'like' , '%'.$search_data['goo_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['goo_number'])) {
                                $query->where('a.goo_number', 'like' , '%'.$search_data['goo_number'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['goo_number'])) {
                                $query->where('a.goo_number', 'like' , '%'.$search_data['goo_number'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['state'])) {
                                // 状态1已过期2未过期
                                if ($search_data['state'] == 1) {
                                    $query->where('c.gofi_expired_date', '<=' , date('Y-m-d H:i:s') );
                                }
                                if ($search_data['state'] == 2) {
                                    $query->where('c.gofi_expired_date', '>=' , date('Y-m-d H:i:s') );
                                }
                            }
                        })
                        ->where('gofi_production_date', '!=', '0000-00-00 00:00:00')
                        ->select('b.chan_enterprise_name','a.goo_name','a.goo_number','c.gofi_validity_period','c.gofi_production_date','c.gofi_expired_date','c.gofi_sum')
                        ->orderBy('c.gofi_id','desc')
                        ->paginate($this->show_count);
            $list_items = $find_list->items();
            foreach ($list_items as $key => $value) {
                $list_items[$key]['state'] = $now_time > $value['gofi_expired_date'] ? 1 :2;//状态1已过期2未过期
            }
        }
        $return_data['current_page'] = $find_list->currentPage();  //当前页面页码
        $return_data['last_page'] = $find_list->lastPage();        //表示最后一页的页码
        $return_data['total'] = $find_list->total();               //总数据个数
        $return_data['current_number'] = $this->show_count;       //一页显示多少个
        $return_data['data'] = $list_items;                //返回数据
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$return_data]);
    }
}
