<?php

namespace App\Http\Controllers\Warehouse;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Coperationa;

// 出入库记录
class OutEnterRecordController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 出入库记录列表
    public function index(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();

        $find_list = DB::table('transport as a')
            ->leftjoin('channels as b','b.chan_id','=','a.channel_id_to')
            ->where('company_id',$find_adm['adm_cid'])
            ->where(function($query) use($find_adm) {
                if (!empty($find_adm['adm_chan_id'])) {
                    $query->where('channel_id_from', $find_adm['adm_chan_id'])
                      ->orWhere('channel_id_to', $find_adm['adm_chan_id']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['admin_name'])) {
                    $query->where('admin_name', 'like' , '%'.$search_data['admin_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['channel_name_from'])) {
                    $query->where('channel_name_from', 'like' , '%'.$search_data['channel_name_from'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['channel_name_to'])) {
                    $query->where('channel_name_to', 'like' , '%'.$search_data['channel_name_to'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['start_time'])) {
                    $query->where('add_time', '>=' , $search_data['start_time']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['end_time'])) {
                    $query->where('add_time', '<=' , $search_data['end_time']);
                }
            })
            ->select('id','sn','channel_name_from','channel_name_to','state_from','state_to','add_time','total_num','admin_name','channel_id_to','remark','chan_enterprise_name','chan_name','chan_phone','chan_address','type')
            ->orderBy('id','desc')
            ->paginate($this->show_count);

        $return_data['current_page'] = $find_list->currentPage();  //当前页面页码
        $return_data['last_page'] = $find_list->lastPage();        //表示最后一页的页码
        $return_data['total'] = $find_list->total();               //总数据个数
        $return_data['current_number'] = $this->show_count;       //一页显示多少个
        $return_data['data'] = $find_list->items();                //返回数据
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$return_data]);
    }
    //详情
    public function info(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'参数错误']);
        }
        $data = DB::table('transport')
            ->where(['id'=>$request['id'],'company_id'=>$find_adm['adm_cid']])
            ->first(['id','type']);
        if(empty($data)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'没有该出入库记录']);
        }
        $id = $data['id'];
        $type = $data['type'];
        if($type==0){
            //出库
            $state=3;
        }else{
            //入库
            $state=2;
        }
        if($state == 2){
            $res=$this->getOrderInto($id,$find_adm,2);
        }elseif($state==3){
            $res=$this->getOrderout($id,$find_adm,2);
        }
        if($res['code']==200){
            if($state==2){
                return ['code'=>200,'msg'=>'success','data'=>['type'=>1,'order'=>$res['data']]];
            }else{
                return ['code'=>200,'msg'=>'success','data'=>['type'=>2,'order'=>$res['data']]];
            }
        }else{
            return $res;
        }
    }
    //入库信息
    public function getOrderInto($id,$find_adm,$state=1)
    {
        $res = DB::table('transport')
            ->leftjoin('wl','wl.order_id','=','transport.id')
            ->where(['company_id'=>$find_adm['adm_cid'],'id'=>$id])
            ->first();
        if(!$res){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'您没有该入库单']);
        }
        foreach ($res as $key => $val) {
            $res['war_type']=3;
        }
        $wl=null;
        //对物流信息进行更改
        if(!empty($res['wl_type'])){
            $wl['wl_type']=$res['wl_type'];
            $wl['wl_department']=$res['wl_department'];
            if($wl['wl_type']==1){
                $arr=explode(',',$res['wl_courier']);
                $data=[];
                foreach ($arr as $key => $value){
                    $data[]['value']=$value;
                }
                $wl['wl_courier']=$data;
                $wl['wl_user']='';
                $wl['wl_tel']='';
                $wl['wl_license']='';
                $wl['wl_content']="运输方:".$res['wl_department']."; 快递单号:".$res['wl_courier'];
            }elseif($wl['wl_type']==3 || $wl['wl_type']==2){
                $wl['wl_user']=$res['wl_user'];
                $wl['wl_tel']=$res['wl_tel'];
                $arr=explode(',',$res['wl_license']);
                $data=[];
                foreach ($arr as $key => $value){
                    $data[]['value']=$value;
                }
                $wl['wl_license']=$res['wl_license'];
                $wl['wl_courier']=[];
                $wl['wl_content']="运输方:".$res['wl_department']."; 负责人:".$res['wl_user'].'; 联系电话:'.$res['wl_tel']."; 车牌号:".$res['wl_license'];
            }
        }else{
            $res['wl_type']=1;
            $wl['wl_department']="";
            $wl['wl_courier']=[];
            $wl['wl_user']='';
            $wl['wl_tel']='';
            $wl['wl_license']='';
            $wl['wl_content']="";
        }
        //对渠道信息进行更改
        $channel = DB::table('channels')->where('chan_id',$res['channel_id_to'])->first(['chan_enterprise_name','chan_name','chan_phone','chan_address']);
        //获取商品信息；
        $goods=$this->getGoodsWare($id,2,$state);
        $data=[
            'goods'=>$goods,   //  商品信息
            'channel'=>$channel,
            'wl'=>$wl
        ];
        return ['code'=>200,'msg'=>'success','data'=>$data];
    }
    //出库信息
    public function getOrderout($id,$find_adm,$state=1){
        $res = DB::table('transport')
            ->where(['company_id'=>$find_adm['adm_cid'],'id'=>$id])
            ->leftjoin('wl','wl.order_id','=','transport.id')
            ->first();
        //对渠道信息进行更改
        $channel = DB::table('channels')->where('chan_id',$res['channel_id_to'])->first(['chan_enterprise_name','chan_name','chan_phone','chan_address']);
        $wl=null;
        //对物流信息进行更改
        if(!empty($res['wl_type'])){
            $wl['wl_type']=$res['wl_type'];
            $wl['wl_department']=$res['wl_department'];
            if($wl['wl_type']==1){
                $arr=explode(',',$res['wl_courier']);
                $data=[];
                foreach ($arr as $key => $value){
                    $data[]['value']=$value;
                }
                $wl['wl_courier']=$data;
                $wl['wl_user']='';
                $wl['wl_tel']='';
                $wl['wl_license']='';
                $wl['wl_content']="运输方:".$res['wl_department']."; 快递单号:".$res['wl_courier'];
            }elseif($wl['wl_type']==3 || $wl['wl_type']==2){
                $wl['wl_user']=$res['wl_user'];
                $wl['wl_tel']=$res['wl_tel'];
                $arr=explode(',',$res['wl_license']);
                $data=[];
                foreach ($arr as $key => $value){
                    $data[]['value']=$value;
                }
                $wl['wl_license']=$res['wl_license'];
                $wl['wl_courier']=[];
                $wl['wl_content']="运输方:".$res['wl_department']."; 负责人:".$res['wl_user'].'; 联系电话:'.$res['wl_tel']."; 车牌号:".$res['wl_license'];
            }
        }else{
            $res['wl_type']=1;
            $wl['wl_department']="";
            $wl['wl_courier']=[];
            $wl['wl_user']='';
            $wl['wl_tel']='';
            $wl['wl_license']='';
            $wl['wl_content']="";
        }
        //获取商品信息；
        $goods=$this->getGoodsWare($id,1,$state);
        $data=[
            'goods'=>$goods,   //  商品信息
            'wl'=>$wl,          //物流信息
            'channel'=>$channel
        ];
        unset($res);
        return ['code'=>200,'msg'=>'success','data'=>$data];
    }
    //商品信息
    public function getGoodsWare($id,$order_state,$type=1){
        if($order_state == 1){
            //出库单
            $CK = DB::table('transport')->where('id',$id)->first();
            $goods_type = 1;
        }else{
            //出库单
            $RK = DB::table('transport')->where('id',$id)->first();
            $goods_type = 2;
        }
        $order_goods = DB::table('transport_info')
            ->where(['transport_id'=>$id])
            ->get();
        $order_goods = json_decode(json_encode($order_goods),true);
        $order=array_column($order_goods,'number','goods_id');
        $order_goods_id=array_column($order_goods,'goods_id');
        $ware_goods = DB::table('transport_info')->where(['transport_id'=>$id])->get(['goods_id']);
        $ware_goods_id=array_column($ware_goods,'goods_id');
        // 合并
        $merge_id=array_unique(array_merge($ware_goods_id,$order_goods_id));
        $data=Db::table('transport_info')->where(['transport_id'=>$id])->whereIn('goo_id',$merge_id)->join('goods','goods.goo_id','=','transport_info.goods_id')->get(['goods.goo_id as goods_id','goods.goo_name as goods_name','goods_code','det_real_quantity','det_real_quantitys']);
        $data=json_decode(json_encode($data),true);
        foreach ($data as $key => $value){
            $data[$key]['num'] = empty($data[$value['goods_id']]) ? 1 : $data[$value['goods_id']]['num']++;
        }
        $last_names = array_column($data,'num');
        array_multisort($last_names,SORT_DESC,$data);
        return $data;
    }
    //查看
    public function view(Request $request)
    {
        //获取操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if(empty($request['id']) || !is_numeric($request['id'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $data['goods'] = DB::table('transport as t')
            ->leftjoin('transport_info as ti','ti.trans