<?php

namespace App\Http\Controllers\Warehouse;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Coperationa;

// 出入库记录
class OutEnterRecordController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 出入库记录列表
    public function index(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $search_data = $request->all();

        $find_list = DB::table('transport as a')
            ->leftjoin('channels as b','b.chan_id','=','a.channel_id_to')
            ->where('company_id',$find_adm['adm_cid'])
            ->where(function($query) use($find_adm) {
                if (!empty($find_adm['adm_chan_id'])) {
                    $query->where('channel_id_from', $find_adm['adm_chan_id'])
                      ->orWhere('channel_id_to', $find_adm['adm_chan_id']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['sn'])) {
                    $query->where('sn', 'like' , '%'.$search_data['sn'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['admin_name'])) {
                    $query->where('admin_name', 'like' , '%'.$search_data['admin_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['channel_name_from'])) {
                    $query->where('channel_name_from', 'like' , '%'.$search_data['channel_name_from'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['channel_name_to'])) {
                    $query->where('channel_name_to', 'like' , '%'.$search_data['channel_name_to'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['start_time'])) {
                    $query->where('add_time', '>=' , $search_data['start_time']);
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['end_time'])) {
                    $query->where('add_time', '<=' , $search_data['end_time'].' 23:59:59');
                }
            })
            ->select('id','sn','channel_name_from','channel_name_to','state_from','state_to','add_time','total_num','admin_name','channel_id_to','remark','chan_enterprise_name','chan_name','chan_phone','chan_address','type')
            ->orderBy('id','desc')
            ->paginate($this->show_count);

        $return_data['current_page'] = $find_list->currentPage();  //当前页面页码
        $return_data['last_page'] = $find_list->lastPage();        //表示最后一页的页码
        $return_data['total'] = $find_list->total();               //总数据个数
        $return_data['current_number'] = $this->show_count;       //一页显示多少个
        $return_data['data'] = $find_list->items();                //返回数据
        $return_data['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$return_data]);
    }
    //详情
    public function info(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['id']) || !is_numeric($request['id'])) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'参数错误']);
        }
        $find_list = DB::table('transport_info')
            ->where('transport_id',$request['id'])
            ->select('goods_id', 'goods_name', 'goods_code','det_real_quantity','det_real_quantitys')
            ->get();
        $goods_data = array();
        foreach ($find_list as $key => $value) {
            if (empty($goods_data[$value['goods_id']])) {
                $goods_data[$value['goods_id']]['num'] = $value['det_real_quantity'];
                $goods_data[$value['goods_id']]['nums'] = $value['det_real_quantitys'];
                $goods_data[$value['goods_id']]['goods_name'] = $value['goods_name'];
                $goods_data[$value['goods_id']]['goods_code'] = $value['goods_code'];
            } else {
                $goods_data[$value['goods_id']]['num']++;
                $goods_data[$value['goods_id']]['nums']++;
            }
        }
        return response()->json(['code'=> 200,'msg'=>'success','data'=>$goods_data]);
    }
    
    //查看
    public function view(Request $request)
    {
        //获取操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        if(empty($request['id']) || !is_numeric($request['id'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $data['goods'] = DB::table('transport as t')
            ->leftjoin('transport_info as ti','ti.transport_id','=','t.id')
            ->where('company_id',$find_adm['adm_cid'])
            ->where('t.id',$request['id'])
            ->get(['goods_name','det_real_quantity','det_real_actual','det_real_quantitys','det_real_actuals','remark']);
        $a = 0;
        $b = 0;
        $c = 0;
        $d = 0;
        foreach($data['goods'] as $key=>$value){
            $a += $value['det_real_quantity'];//要求出库数量
            $b += $value['det_real_actual'];//要求实际出库数量
            $c += $value['det_real_quantitys'];//要求入库数量
            $d += $value['det_real_actuals'];//要求实际入库数量
        }
        $data['ask'] = $c;//要求入库数量
        $data['asks'] = $d;//实际入库数量
        $data['det_real_actual'] = $a;//要求出库数量
        $data['det_real_actuals'] = $b;//实际出库数量
        return response()->json(['code'=>200,'data'=>'获取消息列表','data_info'=>$data]);
    }
    //导出
    public function export(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        $data = DB::table('transport')
            ->where(function($query) use($find_adm) {
                if (!empty($find_adm['adm_chan_id'])) {
                    $query->where('channel_id_from', $find_adm['adm_chan_id'])
                      ->orWhere('channel_id_to', $find_adm['adm_chan_id']);
                }
            })
            ->where(function($query) use($input){
                if (!empty($input['sn'])) {
                    $query->where('sn','like','%'.$input['sn'].'%');
                }
            })
            ->where(function($query) use($input) {
                if (!empty($input['start_time'])) {
                    $query->where('add_time', '>=' , $input['start_time']);
                }
            })
            ->where(function($query) use($input) {
                if (!empty($input['end_time'])) {
                    $query->where('add_time', '<=' , $input['end_time']);
                }
            })
            ->where(function($query) use($input) {
                if (!empty($input['admin_name'] )) {
                    $query->where('admin_name', 'like','%'.$input['admin_name'].'%');
                }
            })
            ->where(['company_id'=>$find_adm['adm_cid']])
            ->orderBy('id','desc')
            ->get();
        if($data){
            foreach ($data as $key => $value) {
                $data[$key]['channel'] = DB::table('channels')->where('chan_id',$value['channel_id_to'])->first(['chan_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
            }
        }
        $file_name = '10000-'.$find_adm['adm_id'];
        try{
            if(!empty($data)){
                \Excel::create($file_name, function($excel) use ($data) {
                    // 销售额统计
                    $excel->sheet('销售额', function($sheet) use ($data)
                    {
                        $sheet->cell('A1', function($cell) {$cell->setValue('操作时间');});
                        $sheet->cell('B1', function($cell) {$cell->setValue('系统单号');});
                        $sheet->cell('C1', function($cell) {$cell->setValue('类型');});
                        $sheet->cell('D1', function($cell) {$cell->setValue('数量');});
                        $sheet->cell('E1', function($cell) {$cell->setValue('收货方信息');});
                        $sheet->cell('F1', function($cell) {$cell->setValue('发货方信息');});
                        $sheet->cell('G1', function($cell) {$cell->setValue('备注'); });
                        $sheet->cell('H1', function($cell) {$cell->setValue('操作人');});
                        $sheet->cell('I1', function($cell) {$cell->setValue('状态'); });

                        foreach ($data as $key => $value) {
                            $i= $key+2;
                            $type = ($value['type'] == 0) ? '出库' : '入库';
                            $state_to = $value['state_to']==0 ? '未入库' : '已入库';
                            if ($value['type'] == 0) {
                                $state_to = $value['state_from']==0 ? '未发货' : '已发货';
                            }
                            $sheet->cell('A'.$i, $value['add_time']);     //操作时间
                            $sheet->cell('B'.$i, $value['sn']);    //系统单号
                            $sheet->cell('C'.$i, $type);  //类型
                            $sheet->cell('D'.$i, $value['total_num']);  //数量
                            $sheet->cell('E'.$i, $value['channel']['chan_enterprise_name'].','.$value['channel']['chan_name'].','.$value['channel']['chan_phone']);  //收货方
                            $sheet->cell('F'.$i, $value['channel']['chan_enterprise_name'].','.$value['channel']['chan_name'].','.$value['channel']['chan_phone']); //发货方
                            $sheet->cell('G'.$i, $value['remark']);           //备注
                            $sheet->cell('H'.$i, $value['admin_name']);     		//操作人
                            $sheet->cell('I'.$i, $state_to);  //状态
                        }
                    });

                })->save('xls',storage_path('excel/Statement'));
                return response()->json(['code'=> 200,'msg'=>'success','data'=>"storage/excel/Statement/".$file_name.".xls"]);
            }else{
                return response()->json(['code'=> 500,'msg'=>'error']);
            }
        }catch(Exception $e){
            return $e->getMessage();
        }
    }
}
