<?php

namespace App\Http\Controllers\Verify\Warranty;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 表单设置验证器
class VerifyWarrantyTableController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'info_name.required' => '参数错误',
            'info_name.array' => '参数错误',
            'info_content.required' => '参数错误',
            'info_content.array' => '参数错误',
            'info_show.required' => '参数错误',
            'info_show.array' => '参数错误',
            'info_type.required' => '参数错误',
            'info_type.array' => '参数错误',
            'info_required.required' => '参数错误',
            'info_required.array' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'info_name' => 'required|array',
            'info_content' => 'required|array',
            'info_show' => 'required|array',
            'info_type' => 'required|array',
            'info_required' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
