<?php

namespace App\Http\Controllers\Verify\Warranty;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 质保列表验证器
class VerifyWarrantyListController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 详情
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'warr_id.required' => '参数错误',
            'warr_id.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'warr_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 通过验证器
    public function passValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'warr_id.required' => '参数错误',
            'warr_id.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'warr_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 驳回验证器
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'warr_id.required' => '参数错误',
            'warr_id.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'warr_id' => 'required|numeric',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
