<?php

namespace App\Http\Controllers\Verify\Source;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyTagController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'lab_name.required' => '请输入:标签名称',
            'lab_name.max' => '标签名称长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'lab_name' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'lab_id.required' => '参数错误',
            'lab_id.integer' => '参数错误',
            'lab_name.required' => '请输入:标签名称',
            'lab_name.max' => '标签名称长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'lab_id' => 'required|integer',
            'lab_name' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'lab_id.required' => '参数错误',
            'lab_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'lab_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
