<?php

namespace App\Http\Controllers\Verify\Source;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyFormworkController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 添加验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fom_label.required' => '请选择标签',
            'fom_label.numeric' => '参数类型错误',
            'fom_temid.required' => '请选择模板',
            'fom_temid.numeric' => '参数类型错误',
            'fom_number.required' => '参数错误',
            'fom_number.numeric' => '参数类型错误',
            'fom_title.required' => '请输入:信息名称',
            'formkey.required' => '参数错误',
            'formkey.array' => '参数类型错误',
            'formshow.required' => '参数错误',
            'formshow.array' => '参数类型错误',
            'formtype.required' => '参数错误',
            'formtype.array' => '参数类型错误',
            'formvalue.required' => '参数错误',
            'formvalue.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fom_label' => 'required|numeric',
            'fom_temid' => 'required|numeric',
            'fom_number' => 'required|numeric',
            'fom_title' => 'required',
            'formkey' => 'required|array',
            'formshow' => 'required|array',
            'formtype' => 'required|array',
            'formvalue' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fom_id.required' => '参数错误',
            'fom_id.numeric' => '参数类型错误',
            'fom_label.required' => '请选择标签',
            'fom_label.numeric' => '参数类型错误',
            'fom_temid.required' => '请选择模板',
            'fom_temid.numeric' => '参数类型错误',
            'fom_number.required' => '参数错误',
            'fom_number.numeric' => '参数类型错误',
            'fom_title.required' => '请输入:信息名称',
            'formkey.required' => '参数错误',
            'formkey.array' => '参数类型错误',
            'formshow.required' => '参数错误',
            'formshow.array' => '参数类型错误',
            'formtype.required' => '参数错误',
            'formtype.array' => '参数类型错误',
            'formvalue.required' => '参数错误',
            'formvalue.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fom_id' => 'required|numeric',
            'fom_label' => 'required|numeric',
            'fom_temid' => 'required|numeric',
            'fom_number' => 'required|numeric',
            'fom_title' => 'required',
            'formkey' => 'required|array',
            'formshow' => 'required|array',
            'formtype' => 'required|array',
            'formvalue' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fom_id.required' => '参数错误',
            'fom_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fom_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
