<?php

namespace App\Http\Controllers\Verify\Channels;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

// 技师验证器
class VerifyTechnicianController extends Controller
{

    // 技师列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.numeric' => '数据类型不正确',
            'tech_audit_state.required' => '参数错误',
            'tech_audit_state.numeric' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|numeric',
            'tech_audit_state' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_chan_id.required' => '参数错误',
            'tech_chan_id.numeric' => '参数错误',
            'tech_name.required' => '参数错误',
            'tech_name.max' => '技师姓名长度超过最大限制',
            'tech_phone.required' => '请输入手机号',
            'tech_phone.regex' => '手机号格式不正确',
            'tech_identity_card.required' => '参数错误',
            'tech_address.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_chan_id' => 'required|numeric',
            'tech_name' => 'required|max:50',
            'tech_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'tech_identity_card' => 'sometimes',
            'tech_address' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_id.required' => '参数错误',
            'tech_id.numeric' => '参数错误',
            'tech_chan_id.required' => '参数错误',
            'tech_chan_id.numeric' => '参数错误',
            'tech_name.required' => '请输入:技师姓名',
            'tech_name.max' => '技师姓名长度超过最大限制',
            'tech_phone.required' => '请输入:联系电话',
            'tech_phone.regex' => '手机号格式不正确',
            'tech_identity_card.required' => '参数错误',
            'tech_address.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_id' => 'required|numeric',
            'tech_chan_id' => 'required|numeric',
            'tech_name' => 'required|max:50',
            'tech_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
            'tech_identity_card' => 'sometimes',
            'tech_address' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_id.required' => '参数错误',
            'tech_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_id' => 'required|array'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师积分操作验证器
    public function integralValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_id.required' => '参数错误',
            'tech_id.numeric' => '参数错误',
            // 'integral_number.required' => '请输入:积分值',
            // 'integral_number.integer' => '请输入整数',
            // 'content.required' => '请输入操作内容',
            // 'content.max' => '长度超过最大限制'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_id' => 'required|numeric',
            // 'integral_number' => 'required|integer',
            // 'content' => 'required|max:255'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师启用验证器
    public function passValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_id.required' => '参数错误',
            'tech_id.numeric' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_id' => 'required|numeric'
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }

    // 技师驳回验证器
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'tech_id.required' => '参数错误',
            'tech_id.numeric' => '参数错误',
            'tech_remark.required' => '请输入备注',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'tech_id' => 'required|numeric',
            'tech_remark' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            return $validator->errors();
        }
    }
}
