<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use \Exception;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\StatisicModel;
use Excel;
class StatisicController extends Controller
{
    /**
     统计，数据大屏
     */
    public function overaplaning(Request $request)
    {
        // $token="3268bd102caab726145a49e74c2f6b64acaa78fd";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $type=$request->input('type',1);
        if($type==3){
            //请求设备分布页码
            $page=(int)$request->input('equ_page',1);
            $obj=new StatisicModel();
            $res=$obj->Equ_Data($user,$page);
            return response()->json($res);
        }
        if($type==4){
            //请求基地分布数据
            $page=(int)$request->input('reg_page',1);
            $obj=new StatisicModel();
            $res=$obj->base_operate($user,$page);
            return response()->json($res);
        }
        $page['equ_page']=$request->input('equ_page',1);
        $page['reg_page']=$request->input('reg_page',1);
        $obj=new StatisicModel();
        $res=$obj->Big_Data_Count($user,$type,$page);
        return response()->json($res);
    }

    //获取 商品分类查询量统计；
    public function classtati(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $name=$request->input('name',null);
        if(empty($name)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'分类名称不能为空']);
        }
        $year=date('Y');
        //根据分类id查询 分类下商品的查询量;
        $class_data=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2])->selectRaw("sum(stal_total) as value,goo_name as name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->join('goo_classifi','goo_classifi','=','cla_id')->where(['cla_name'=>$name])->groupBy('stal_goo_id')->get();
        return response()->json(['code'=>200,'msg'=>'success','name'=>$name,'data'=>$class_data]);
    }

    //获取商品查询量的日期
    public function goodstati(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $name=$request->input('name',null);
        if(empty($name)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'商品名称不能为空']);
        }
        $year=date('Y');
        //根据商品名称获取，商品的查询量;
        $goods_data=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2])->selectRaw("stal_total as value,stal_month as name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->where(['goo_name'=>$name])->get();
        $goods_data=$this->handle_month($goods_data);
        return response()->json(['code'=>200,'msg'=>'success','name'=>$name,'data'=>$goods_data]);
    }

    //获取城市查询量的日期
    public function citystati(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $name=$request->input('name',null);
        if(empty($name)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'城市名称不能为空']);
        }
        $year=date('Y');
        //根据城市名称获取，获取城市的查询量;
        $city_data=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>1])->selectRaw("stal_total as value,stal_month as name")->where(['stal_city'=>$name])->get();
        $city_data=$this->handle_month($city_data);
        return response()->json(['code'=>200,'msg'=>'success','name'=>$name,'data'=>$city_data]);
    }

    //获取手机查询量的日期
    public function phonestati(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $name=$request->input('name',null);
        if(empty($name)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'手机名称不能为空']);
        }
        $year=date('Y');
        //根据城市名称获取，获取城市的查询量;
        $phone_data=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>3])->selectRaw("stal_total as value,stal_month as name")->where(['stal_city'=>$name])->get();
        $phone_data=$this->handle_month($phone_data);
        return response()->json(['code'=>200,'msg'=>'success','name'=>$name,'data'=>$phone_data]);
    }



    public function handle_month($data){
        $last_names = array_column($data,'name');
        array_multisort($last_names,SORT_ASC,$data);
        $data=array_column($data,null,'name');
        $arr=[];
        for ($i=1; $i <=12 ; $i++) { 
            if(empty($data[$i])){
                $data[$i]=['name'=>$i,'value'=>0];
            }
            $arr[]=$data[$i];
        }
        // sort($data);
        return $arr;
    }



    //天气接口
    public function guzzlehttp(Request $request){
        ini_set('max_execution_time',180);
        $pathName=storage_path().'/log';
        if (!file_exists($pathName)) {
            mkdir($pathName,0775,true);
            chmod($pathName,0775);
        }
        $now_time=date('Y-m-d H:i:s');
         // $last_time=Db::table('weather')->orderBy('wea_id','desc')->select('add_time')->first();
        // if(!empty($last_time)){
        //     $time=strtotime($last_time['add_time'],true);
        //     $new_time=time();
        //     $diff_time=$new_time-$time;
        //     if($diff_time<2*60*60){
        //         $diff_time=2*60*60-$diff_time;
        //         $hour=floor($diff_time/3600);
        //         $minute=floor(($diff_time%3600)/60);
        //         $second=$diff_time%60;
        //         $str=$now_time.':每2小时查询一次。距离下次运行还有'.$hour.':'.$minute.':'.$second."\t";
        //         file_put_contents($pathName.'/weather.txt',$str,FILE_APPEND);
        //         echo '每2小时查询一次';
        //         die;
        //     }
        // }

        //获取所有区域的所处城市
        $data=Db::table('massif_region')
        ->where(['reg_parent_id'=>0])->where('reg_state','!=',3)
        ->join('farmland','farmland.far_id','=','massif_region.far_id')
        ->select('far_city','reg_id')->get();

        if(empty($data)){
            $str=$now_time.':ok.没有任何区域需要查询天气'."\t";
            file_put_contents($pathName.'/weather.txt',$str,FILE_APPEND);
            echo '没有需要查询的天气';
            die;
        }
        $city_data=array_unique(array_column($data,'far_city'));
        $obj=new CommenModel();
        $arr=[];
        foreach ($city_data as $key => $val){
            if(empty($val) || $val=='未知'){
                continue;
            }
           $arr[$key]['city']=$val;

           $city=$val;
           $end=mb_substr($city,-1);
           if($end=='市'){
                $city=rtrim($city,'市');
           }
           if($end=='区'){
                $city=rtrim($city,'区');
           }
           $temp=$obj->curl('https://www.tianqiapi.com/api/',['city'=>$city,'version'=>'v6'],false,true);
           $arr[$key]['data']=json_decode($temp,true);
        }
        // dd($arr);
        if(empty($arr)){
            $str=$now_time.':天气请求接口失败'."\t";
            file_put_contents($pathName.'/weather.txt',$str,FILE_APPEND);
            echo '请求失败';
            die;
        }
        $city_data=array_column($arr,'data','city');
        // dd($city_data);
        $weather=[];
        $group_num=date('YmdHi');
        foreach ($data as $key => $val) {
            $weather[$key]['region_id']=$val['reg_id'];// 区域id
            $weather[$key]['city']=$val['far_city'];   //城市
            if($val['far_city'] == '未知'){
                $weather[$key]['date']=0;         //天气接口更新时间
                $weather[$key]['temp']=0;         //温度
                $weather[$key]['wd']=0;           //风向
                $weather[$key]['wdforce']=0;      //风力等级
                $weather[$key]['wdspd']=0;        //风速
                $weather[$key]['weather']='qing'; //天气状况
                $weather[$key]['weatherimg']=0;   //天气图片  天气对应图图标
                $weather[$key]['humidity']=0;     //湿度
                $weather[$key]['temp']=0;         //降雨量
                $weather[$key]['temp']=0;         //24小时降雨量
                $weather[$key]['air']=0;          // 空气质量
                $weather[$key]['pm25']=0;         //pM2.5
            }else{

                $weather[$key]['date']=$city_data[$val['far_city']]['date'].' '.$city_data[$val['far_city']]['update_time'];//  天气接口更新时间
                $weather[$key]['temp']=$city_data[$val['far_city']]['tem'];  //温度
                $weather[$key]['wd']=$city_data[$val['far_city']]['win'];    //风向
                $weather[$key]['wdforce']=$city_data[$val['far_city']]['win_speed'];   //风力等级
                $weather[$key]['wdspd']=$city_data[$val['far_city']]['win_meter'];   //风速
                $weather[$key]['weather']=$city_data[$val['far_city']]['wea'];   //天气状况
                $weather[$key]['weatherimg']=$city_data[$val['far_city']]['wea_img'];   //天气图片  天气对应图图标
                $weather[$key]['humidity']=$city_data[$val['far_city']]['humidity'];   //湿度
                $weather[$key]['prcp']=0;   //降雨量
                $weather[$key]['prcp24h']=0;   //24小时降雨量
                $weather[$key]['air']=$city_data[$val['far_city']]['air_level'];   // 空气质量
                $weather[$key]['pm25']=$city_data[$val['far_city']]['air_pm25'];   //pM2.5
            }
            $weather[$key]['add_time']=$now_time;   //添加时间
            $weather[$key]['group_num']=$group_num;  //分组编号
        }
        $data=[];
        if(count($weather)>1000){
            $data=array_chunk($weather,1000);
        }else{
            $data[]=$weather;
        }
        unset($weather);
        DB::beginTransaction();
        foreach ($data as $key => $val) {
            $res=Db::table('weather')->insert($val);
            if(!$res){
                Db::rollback();
                $str=$now_time.':添加失败'."\t";
                file_put_contents($pathName.'/weather.txt',$str,FILE_APPEND);
                die;
            }
        }
        Db::commit();
        $str=$now_time.':添加成功'."\t";
        file_put_contents($pathName.'/weather.txt',$str,FILE_APPEND);
        echo 'ok';die;
    }
}