<?php

namespace App\Http\Controllers\Prevention;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use \Exception;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Prevention\PreWarningModel;
use App\Http\Models\Coperationa;
class PreWarningController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    /**
     //防窜报表
     */
    public function formpre(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $where['time_start'] =$request->input('time_start',null);
        $where['time_end']   =$request->input('time_end',null);
        $where['code_number']=$request->input('code_number',null);
        $where['region_name']=$request->input('region_name',null);
        $where['page']       =(int)$request->input('page',1);
        $where['pagesize']    =(int)$request->input('page_size',1);
        if($where['pagesize']>100 || $where['pagesize'] < 1){
            $where['pagesize']=10;
        }
        $obj=new PreWarningModel();
        $res=$obj->Form_Prevention($where,$user,1);
        $res['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json($res);

    }

    /**
     导出防窜报表
     */
    public function exportform(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $where['time_start'] =$request->input('time_start',null);
        $where['time_end']   =$request->input('time_end',null);
        $where['code_number']=$request->input('code_number',null);
        $where['region_name']=$request->input('region_name',null);
        $where['id']         =$request->input('id',null);
        if(empty($where['id'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择要导出的防窜报表']);
        }
        $obj=new PreWarningModel();
        $res=$obj->Form_Prevention($where,$user,2);
        return response()->json($res);
    }

    /**
     防窜预警列表
     */
    public function earlylist(Request $request)
    {
         $input = $request->all();
         $user = Coperationa::getUserInfo($request->input('api_token'));
         $sql = 'NOT EXISTS (SELECT * FROM `trace_region_detailed` as `tra_d` WHERE `tra_re`.province = `tra_d`.pid AND `tra_re`.city = `tra_d`.chi_id AND `tra_re`.`region_id` = `tra_d`.`region_id`)';
         $data = DB::table('region_early as re')
                ->join('region as r','re.region_id','=','r.id')
                ->where(function($query) use($input) {
                    if (!empty($input['state'])) {
                        $query->where('re.state',$input['state']);
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['trace_code'])) {
                        $query->where('re.trace_code','like','%'.$input['trace_code'].'%');
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['region_number'])) {
                        $query->where('r.region_id','like','%'.$input['region_number'].'%');
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['batch_number'])) {
                        $query->where('re.batch_number','like','%'.$input['batch_number'].'%');
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['group_name'] )) {
                        $query->where('r.group_name', 'like' , '%'.$input['group_name'].'%' );
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['region_name'] )) {
                        $query->where('re.province', 'like' , '%'.$input['region_name'].'%');
                    }
                })
                ->where(function($query) use($input) {
                    if (!empty($input['city'] )) {
                        $query->where('re.city', 'like' , '%'.$input['city'].'%');
                    }
                })
                ->where(function($query) use($input) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($input['time_start']) && !empty($input['time_end'])){
                        $query->whereBetween('re.add_time',[$input['time_start'],$input['time_end'].' 23:59:59']);
                    }
                    else{
                        // 如果选择开始时间
                        if (!empty($input['time_start'])){
                            $query->where('re.add_time','>',$input['time_start']);
                        }else{
                        // 如果选择结束时间
                            if (!empty($input['time_end'] )) {
                                $query->where('re.add_time','<',$input['time_end'.' 23:59:59']);
                            }
                        }
                    }
                })
        ->where('ent_cid',$user['adm_cid'])
        ->orderBy('id','desc')
        ->select('re.id','re.add_time','re.trace_code','re.batch_number','re.code_number','r.region_id','r.group_name','re.province','re.city','re.state','re.remarks')
        ->paginate($this->show_count);

        $data_info['current_page'] = $data->currentPage();  //当前页面页码
        $data_info['last_page'] = $data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;   //一页显示多少个
        $data_info['data'] = $data->items();                //返回数据
        $data_info['button_data'] = wherebutton($request['api_token'],$request['pri_id']);

        if(!$data_info)
        {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'防窜预警列表获取失败']);
        }
        return response()->json(['code'=> 200,'msg'=>'success','data'=>'防窜预警列表获取成功','data_info'=>$data_info]);
    }

    /**
     处理预警
     */
    public function handlearly(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id',null);
        if(empty($id)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择要处理的防伪预警信息']); 
        }
        $remarks=$request->input('remarks','');
        $obj=new PreWarningModel();
        $res=$obj->Handl_Early($user,$id,$remarks,1);
        return response()->json($res);
    }

    /**
    编辑预警
     */
    public function editearly(Request $request)
    {
        // $token="d34f105ddbb0fbe052ad69f430c57e15a6d19e60";
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $id=$request->input('id');
        if(empty($id)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'id不能为空']); 
        }
        $remarks=$request->input('remarks','');
        $obj=new PreWarningModel();
        $res=$obj->Handl_Early($user,$id,$remarks,2);
        return response()->json($res);
    }
}
