<?php

namespace App\Http\Controllers\Pda;

use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Verify\VerifyCodeController;
use App\Http\Models\Code;
use App\Http\Models\RelationCodeModel;
use Session;
use DB;
use AuthenticatesUsers;

class PackageController extends Controller
{
    // 组合
    public function compose(Request $request) {
        $input = $request->only('codes', 'relation_code');
        $codes = trim($input['codes']);
        $relation_code = VerifyCodeController::validator(trim($input['relation_code']));
        if(empty($codes) || empty($relation_code)) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => []]);
        }

        //验证待组合的产品码或关联码
        $error_codes = [];
        $codes = explode(',', trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '错误的码', 'data' => $error_codes]);
        }

        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];

        //todo 添加mysql事务
        //关联码对象
        $RelationBig = RelationCodeModel::where('code', $relation_code)->first();
        foreach($codes as $key=>$code) {
            if (strpos($code,'G') === 0) {
                //step.1.修改关联码表//直属上级&上级id串
                $RelationSmall = RelationCodeModel::where('code', $code)->first();
                if($RelationSmall->up_code > 0) {
                    return response()->json([
                        'code' => 500,
                        'msg' => $code.'已经组合到了'.$RelationSmall->up_code.',请先拆分',
                        'data' => []
                    ]);
                }
                $RelationSmall->up_code = $RelationBig->id;
                $RelationSmall->chain_code = ','.$RelationBig->id.',';
                $RelationSmall->save();
                //step.2.修改该箱里的关联码的chain_code,追加上关联码id
                $sql = "UPDATE trace_relation_code 
                        SET chain_code=CONCAT(chain_code,$RelationBig->id,',') 
                        where chain_code regexp ',{$RelationSmall->id},$'";
                DB::update($sql);

                //step.3.修改相关的产品码,把relation_chain追加上关联码id
                $sql = "UPDATE trace_2019_code 
                        SET relation_chain = CONCAT(relation_chain,{$RelationBig->id},',') 
                        WHERE relation_chain regexp ',{$RelationSmall->id},$'";
                DB::update($sql);

            }else {
                //产品码
                $CodeObj = Code::firstOrCreate(["code"=>$code]);

                //如果该产品已经被装入其它箱子，则不能做组合
                if($CodeObj->relation_code > 0) {
                    return response()->json([
                        'code' => 500,
                        'msg' => $code.'已经组合到了'.$CodeObj->relation_code.',请先拆分',
                        'data' => []
                    ]);
                }
                //查询该产品码对应的商品
                //todo 修改查询方式
                $code_len = strlen($code);
                $group_info = DB::table('group')
                                ->where('gro_cid',$company_id)
                                ->where('nums','=',$code_len)
                                ->where('code_start','<=',$code)
                                ->where('code_end','>=',$code)
                                ->orderBy('gro_id', 'desc')
                                ->first();
                if(is_array($group_info) and $group_info['gro_gid']) {
                    $group_id = $group_info['gro_id'];
                    $goods_id = $group_info['gro_gid'];
                    $goods_name = $group_info['gro_good_name'];
                }else{
                    $group_id = 0;
                    $goods_id = 0;
                    $goods_name = '';
                }
                $CodeObj->relation_code = $RelationBig->id;
                $CodeObj->group_id = $group_id;
                $CodeObj->company_id = $company_id;
                $CodeObj->goods_id = $goods_id;
                $CodeObj->goods_name = $goods_name;
                $CodeObj->relation_chain = ','.$RelationBig->id.',';
                $CodeObj->add_time = date('Y-m-d H:i:s');
                $CodeObj->save();
            }
        }
        //新增操作日志
        //生成relation_log表记录
        $total_num = $this->insertRelationLog($request,1,$RelationBig->code,$RelationBig->id,$codes);
        DB::table('operate_log')->insert([
            'admin_id'=>$request['_admin_id'],
            'admin_name'=>$request['_admin_name'],
            'company_id'=>$company_id,
            'channel_id'=>$channel_id,
            'obj_table'=>'relation_log',
            'obj_id'=>$RelationBig->id,
            'name'=>'组合',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => []]);
    }

    public function insertRelationLog($find_adm, $type, $relation_code, $relation_id, $codes) {
        $codes = implode("','",$codes);
        $addtime = date('Y-m-d H:i:s');
        $company_id = $find_adm['_company_id'];
        $channel_id = $find_adm['_channel_id'];
        $sql = "SELECT goods_id,MIN(goods_code) as goods_code,MIN(code) as code,MIN(goods_name) as goods_name,count(*) as num 
                from trace_2019_code 
                WHERE company_id={$company_id} AND relation_chain regexp ',{$relation_id},$' AND code IN ('{$codes}') 
                GROUP BY goods_id";
        $goods_list = DB::select($sql);
        $total_num = 0;
        $i = 0;
        $insert_array = [];
        DB::beginTransaction();
        try {
            foreach ($goods_list as $value) {
                array_push($insert_array, [
                        'company_id' => $company_id,
                        'channel_id' => $channel_id,
                        'type' => $type,
                        'relation_id' => $relation_id,
                        'relation_code' => $relation_code,
                        'goods_id' => $value['goods_id']?$value['goods_id']:0,
                        'goods_name' => $value['goods_name']?$value['goods_name']:'',
                        'goods_code' => $value['goods_code']?$value['goods_code']:'',
                        'code' => $value['code'],
                        'num' => $value['num'],
                        'add_time' => $addtime]
                );
                $total_num += $value['num'];
                $i += 1;
                if ($i == 100) {
                    $ret = DB::table('relation_log')->insert($insert_array);
                    if (!$ret) {
                        throw new ExceptionNew("insert failed");
                    }
                    $i = 0;
                    $insert_array = [];
                }
            }
            if (count($insert_array) > 0) {
                $ret = DB::table('relation_log')->insert($insert_array);
                if (!$ret) {
                    throw new ExceptionNew("insert failed");
                }
            }
        }catch (Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();
        return $total_num;
    }

    public function scan(Request $request) {
        $input = $request->only('code','api_token');
        $code = trim($input['code']);
        if(empty($code)) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        $code = VerifyCodeController::validator($code);
        if(!$code) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        $company_id = $request['_company_id'];
        if (strpos($code,'G') === 0) {
            $RelationObj = RelationCodeModel::where('code', $code)->first();
            //查询该箱中的产品数量
            $sql = "SELECT COUNT(*) as num 
                    FROM trace_2019_code 
                    WHERE company_id=$company_id AND relation_chain regexp ',{$RelationObj->id},'";
            $num = DB::select($sql);
            if(is_array($num) AND count($num) > 0) {
                $res_data = array(
                    'name' => $code,
                    'code' => $code,
                    'num' => $num[0]['num']
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            }else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        }else {
            //todo 修改查询方式
            $code_len = strlen($code);
            $sql = "SELECT b.goo_name as name,a.gro_id,a.gro_gid,b.goo_number
                    from trace_group a LEFT JOIN trace_goods b on a.gro_gid=b.goo_id 
                    WHERE a.gro_cid=$company_id and LENGTH(a.code_start)=$code_len and a.code_start<='$code' and a.code_end>='$code'";
            $name = DB::select($sql);
            if(is_array($name) AND count($name) > 0) {
                //生成trace_2019_code
                $exist_code = Code::where('code', $code)->get();
                if(!$exist_code OR count($exist_code) < 1) {
                    DB::table('2019_code')->insert(
                        [
                            'company_id' => $company_id,
                            'group_id' => $name[0]['gro_id'],
                            'goods_id'=>$name[0]['gro_gid'],
                            'goods_name'=>$name[0]['name'],
                            'goods_code'=>$name[0]['goo_number'],
                            'code'=>$code,
                            'relation_code'=>0,
                            'relation_chain'=>'',
                            'add_time'=>date('Y-m-d H:i:s')
                        ]
                    );
                }
                $res_data = array(
                    'name' => $name[0]['name'],
                    'code' => $code,
                    'num' => 1
                );
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => $res_data]);
            }else {
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
            }
        }
    }

    public function scanlist(Request $request) {
        $input = $request->only('relation_code');
        $relation_code = VerifyCodeController::validator(trim($input['relation_code']));
        if(empty($relation_code) OR strpos($relation_code, 'G') !== 0) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => []]);
        }
        $RelationObj = RelationCodeModel::where('code', $relation_code)->first();

        //step.1.找出直接商品
        $sql = "SELECT MIN(goods_name) as name, MIN(code) as code, count(*) as num 
                from trace_2019_code
                WHERE relation_code={$RelationObj->id}
                GROUP BY goods_id";
        $goods_list = DB::select($sql);

        //step.2.找出直接箱码
        $sql = "SELECT MIN(b.goods_name) as name, a.code,count(1) as num
                from trace_relation_code a
                left join trace_2019_code b on b.relation_chain regexp concat(',',a.id,',')
                where a.up_code = {$RelationObj->id} 
                GROUP BY a.code";
        $relation_list = DB::select($sql);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => array_merge($goods_list, $relation_list)]);
    }

    //拆分
    public function divide(Request $request)
    {
        $input = $request->only('codes', 'relation_code');
        $codes = trim($input['codes']);
        $relation_code = trim($input['relation_code']);
        $relation_code = VerifyCodeController::validator($relation_code);
        if (empty($codes) AND !$relation_code) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => []]);
        }

        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];
        //todo 事务
        if ($codes) {
            //零拆
            $error_codes = [];
            $codes = explode(',', trim($codes, ','));
            foreach ($codes as $key => $code) {
                $code_tmp = VerifyCodeController::validator($code);
                if (!$code_tmp) {
                    unset($codes[$key]);
                    $error_codes[] = $code;
                }else {
                    $codes[$key] = $code_tmp;
                }
            }
            if (count($error_codes) > 0) {
                return response()->json(['code' => 500, 'msg' => '错误的码', 'data' => $error_codes]);
            }
            //查询是否是同一个上级关联码
            $sql = "SELECT distinct(relation_code) as up_rcode
                    FROM  trace_2019_code 
                    WHERE company_id=$company_id AND code in ('" . implode("','", $codes) . "')";
            $up_code1 = DB::select($sql);
            $sql = "SELECT distinct(up_code) as up_rcode
                    FROM  trace_relation_code 
                    WHERE company_id=$company_id AND code in ('" . implode("','", $codes) . "')";
            $up_code2 = DB::select($sql);
            if (count($up_code1) > 1 OR count($up_code2) > 1) {
                return response()->json(['code' => 500, 'msg' => '只能拆分同一关联码下的产品', 'data' => []]);
            }
            if (count($up_code1) == 1 AND count($up_code2) == 1) {
                if ($up_code1[0]['up_rcode'] != $up_code2[0]['up_rcode']) {
                    return response()->json(['code' => 500, 'msg' => '只能拆分同一关联码下的产品', 'data' => []]);
                }
            }
            if (count($up_code1) == 1) {
                $up_code_id = $up_code1[0]['up_rcode'];//上级关联码id
            } else {
                $up_code_id = $up_code2[0]['up_rcode'];//上级关联码id
            }

            //关联码对象
            $RelationObj = RelationCodeModel::where('id', $up_code_id)->first();
            if (!$RelationObj) {
                return response()->json(['code' => 500, 'msg' => '上级关联码未找到', 'data' => []]);
            }
            if ($RelationObj->up_code > 0) {
                return response()->json(['code' => 500, 'msg' => '不能越级拆分', 'data' => []]);
            }

            //生成relation_log表记录
            $total_num = $this->insertRelationLog($request,2,$RelationObj->code,$RelationObj->id, $codes);

            //拆产品码
            if (count($up_code1) == 1) {
                $sql = "UPDATE trace_2019_code 
                        SET relation_code=0, relation_chain='' 
                        WHERE relation_code={$up_code_id} AND code in ('" . implode("','", $codes) . "')";
                DB::update($sql);
            }
            //拆关联码
            if (count($up_code2) == 1) {
                $sql = "UPDATE trace_relation_code 
                        SET chain_code=REPLACE(chain_code,',{$up_code_id},', ',')
                        WHERE chain_code regexp ',{$up_code_id},$' AND code in ('" . implode("','", $codes) . "')";
                DB::update($sql);
                $sql = "UPDATE trace_relation_code 
                        SET up_code=0, chain_code=''
                        WHERE up_code = {$up_code_id} AND code in ('" . implode("','", $codes) . "')";
                DB::update($sql);
            }
//            return response()->json(['code' => 200, 'msg' => 'success', 'data' => []]);

        }elseif ($relation_code) {
            //整拆
            //关联码对象
            $RelationObj = RelationCodeModel::where('code', $relation_code)->first();
            if (!$RelationObj OR $RelationObj->up_code > 0) {
                return response()->json(['code' => 500, 'msg' => '该关联码还有组合关系，不能整拆', 'data' => []]);
            }

            //生成relation_log表记录
            $total_num = $this->insertRelationLog($request,2,$RelationObj->code,$RelationObj->id, $codes);

            $sql = "UPDATE trace_relation_code 
                    SET chain_code=REPLACE(chain_code,',{$RelationObj->id},',','), up_code=0  
                    WHERE up_code={$RelationObj->id}";
            DB::update($sql);
            $sql = "UPDATE trace_2019_code 
                    SET relation_code=0, relation_chain=''  
                    WHERE relation_code={$RelationObj->id}";
            DB::update($sql);
            $sql = "UPDATE trace_2019_code 
                    SET relation_chain=REPLACE(relation_chain,',{$RelationObj->id},',',')  
                    WHERE relation_chain regexp ',{$RelationObj->id},$'";
            DB::update($sql);
//            return response()->json(['code' => 200, 'msg' => 'success', 'data' => []]);
        }
        //新增操作日志
        DB::table('operate_log')->insert([
            'admin_id'=>$request['_admin_id'],
            'admin_name'=>$request['_admin_name'],
            'company_id'=>$company_id,
            'channel_id'=>$channel_id,
            'obj_table'=>'relation_log',
            'obj_id'=>$RelationObj->id,
            'name'=>'拆分',
            'add_time'=>date('Y-m-d H:i:s'),
            'total_num'=>$total_num]);
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => []]);
    }

}

