<?php

namespace App\Http\Controllers\Pda;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\LoginController;
use App\Http\Models\Admin;
use App\Http\Models\Register;
use Illuminate\Support\Facades\Crypt;
use Session;
use DB;
use AuthenticatesUsers;

class LoginPdaController extends LoginController
{
    public function __construct() {
        DB::connection()->enableQueryLog(); // 开启查询日志

    }

    public function login(Request $request)
    {
        $input = $request->only('username', 'password');
        if(empty($input['username']) || empty($input['password'])){
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
        }

        $username = trim($input['username']);
        $password = trim($input['password']);

        if(empty($username)) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'用户名为空']);
        }

        if(empty($password)) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码为空']);
        }

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$password)){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }
        // 查询是否有此用户
        $user = DB::table('admin')
            ->leftJoin('company', 'admin.adm_cid', '=', 'company.com_id')
            ->where('admin.adm_acc', $username)
            ->where('admin.adm_acc', $username)
            ->orderBy('adm_id','desc')
            ->first(['adm_mobile','adm_pas','adm_id','adm_flow','adm_cid','adm_stase','adm_pre','adm_name','adm_account_type']);

        if (!$user) {
            return response()->json(["code"=>500,'msg'=>'无此用户','data'=>'无此用户']);
        }
        // 获取账号所属公司
        $com_stase = DB::table('company')->where('com_id','=',$user['adm_cid'])
            ->select('com_stase')
            ->first();
        if($com_stase['com_stase'] != 1)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号所属公司已停用']);
        }

        $password = md5(md5(trim($password.'admin')));
        if($password !== $user['adm_pas'])
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'密码错误']);
        }
        // 判断该账号是否停用
        if($user['adm_stase'] != 1)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号已停用']);
        }
        // 判断该账号权限
        if (!in_array($user['adm_account_type'],array(1,2)) || $user['adm_account_type'] === 1) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号无权限登录']);
        }
        // 判断该账号所属角色已是否停用
        $rol_sta = DB::table('role')->where('rol_id','=',$user['adm_pre'])
            ->select('rol_sta')
            ->first();
        if($rol_sta['rol_sta'] == '2') {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该账号所属角色已停用,请联系总管理员']);
        }
        // 生成token

        $api_token = $user['adm_id'].','.sha1($user['adm_mobile'].$user['adm_pas'].date('Ymd'));
        $api_token = Crypt::encrypt($api_token);
        return response()->json(["code"=>200,'msg'=>'success','data'=>$api_token]);
    }

    // 个人中心修改密码
    public function editpwd(Request $request)
    {
        $admin_id = intval($request['_admin_id']);
        if(!$admin_id) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $input = $request->only('old_pwd','new_password','renew_password');

        if(trim($input['new_password']) !== trim($input['renew_password'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'两次密码输入不一致']);
        }
        if(!$input['new_password']) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新密码不能为空']);
        }
        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$input['new_password'])) {
//            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }
        $adm_pas = DB::table('admin as a')
            ->where('a.adm_id','=',$admin_id)
            ->select('a.adm_pas')
            ->first();
        $old_pwd = md5(md5(trim($input['old_pwd']).'admin'));
        if($old_pwd !== $adm_pas['adm_pas']) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'原密码错误']);
        }else{
            $new_password = md5(md5(trim($input['new_password']).'admin'));
            $res = DB::table('admin as a')
                ->where('a.adm_id','=',$admin_id)
                ->update(['a.adm_pas'=>$new_password]);
            if($res) {
                return response()->json(["code"=>200,'msg'=>'success','data'=>'密码修改成功']);
            }else{
                return response()->json(["code"=>500,'msg'=>'error','data'=>'密码修改失败']);
            }
        }
    }

    // 个人中心接口
    public function personal(Request $request)
    {
        $admin_id = intval($request['_admin_id']);
        if(!$admin_id) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $admin = DB::table('admin as a')
            ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'a.adm_cid')
            ->where('a.adm_id','=',$admin_id)
            ->select('a.adm_acc','a.adm_name','a.adm_mobile','a.adm_leave','adm_endtime','adm_pre','c.com_name','c.com_logo','ci.info_address','ci.info_telephone','ci.info_license')
            ->first();
        if($admin) {
            return response()->json(["code"=>200,'msg'=>'success','data'=>$admin]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'个人信息获取失败']);
        }
    }
}

