<?php

namespace App\Http\Controllers\Pda;

use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Controllers\Controller;
use Session;
use DB;
use AuthenticatesUsers;

class LogController extends Controller
{
    public function logList(Request $request) {
        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];

        $last_id = intval($request->input('last_id'));
        $logTable = DB::table('operate_log');
        if($last_id > 0) {
            $logTable->where('id', '<', $last_id);
        }
        $log_list = $logTable->where('company_id', $company_id)
            ->where('channel_id', $channel_id)
            ->orderBy('id','desc')
            ->select('id','admin_name','name','add_time','total_num')
            ->take(20)
            ->get();

        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $log_list]);
    }

    public function logDetail(Request $request) {
        $company_id = $request['_company_id'];
        $channel_id = $request['_channel_id'];

        $log_id = intval($request->input('log_id'));
        $log_row = DB::table('operate_log')->where('id',$log_id)->select('add_time','name','total_num','obj_table','obj_id')->first();
        $channel_name = '';
        if($channel_id > 0) {
            $channel_row = DB::table('channels')
                ->where('chan_cid',$company_id)
                ->where('chan_id', $channel_id)
                ->select('chan_enterprise_name')
                ->first();
            if($channel_row) {
                $channel_name = $channel_row['chan_enterprise_name'];
            }
        }
        $log_row['channel_name'] = $channel_name;
        if(!$log_row) {
            return response()->json(['code' => 500, 'msg' => '数据未找到', 'data' => []]);
        }
        if(!$log_row['obj_table'] OR !$log_row['obj_id']) {
            return response()->json(['code' => 500, 'msg' => '该数据不完整', 'data' => []]);
        }
        if($log_row['obj_table'] == 'relation_log') {
            if($log_row['name'] == '组合') {
                $type = 1;
            }elseif($log_row['name'] == '拆分') {
                $type = 2;
            }
            //查询最新一条的时间
            $sql = "SELECT add_time 
                    FROM trace_relation_log 
                    WHERE company_id={$company_id} AND channel_id={$channel_id} AND type={$type} AND relation_id={$log_row['obj_id']}
                    ORDER BY add_time DESC 
                    LIMIT 1";

            $max_addtime = DB::select($sql);
            if($max_addtime) {
                $max_addtime = $max_addtime[0]['add_time'];
            }

            $sql = "SELECT goods_name,goods_code,num 
                    FROM trace_relation_log 
                    WHERE company_id=$company_id AND channel_id={$channel_id} AND type={$type} AND relation_id={$log_row['obj_id']} AND add_time='{$max_addtime}'
                    LIMIT 500";
            $log_detail = DB::select($sql);
        }elseif($log_row['obj_table'] == 'transport') {
            //出入库日志
            $sql = "SELECT goods_name,goods_code,count(id) as num, transport_id
                    FROM trace_transport_info
                    WHERE transport_id={$log_row['obj_id']}
                    GROUP BY goods_id
                    LIMIT 500";
            $log_detail = DB::select($sql);
            //查询出库目标渠道
            if($log_detail) {
                $sql = "select channel_name_to from trace_transport where id={$log_detail[0]['transport_id']}";
                $channel_name_to = DB::select($sql);
                if($channel_name_to) {
                    $log_row['channel_name'] = $channel_name_to[0]['channel_name_to'];
                }
            }
        }
        $log_row['detail'] = $log_detail;
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $log_row]);
    }

}

