<?php
namespace App\Http\Controllers\Order;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Db;
use App\Http\Models\WareModel;
use App\Http\Models\CommenModel;
use Illuminate\Support\Facades\Crypt;
class PiecemealController extends Controller{

	//模糊查询  商品名，商品条形码    获取获取商品
	public function getname(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		$goods_name=$request->input('goods_name',null);
		if(empty($goods_name) && $goods_name!=0){
			$arr=['code'=>500,'msg'=>'失败','data'=>'商品名称不能为空'];
			return json_encode($arr,JSON_UNESCAPED_UNICODE);
		}
		$data=Db::table('goods')
		->where(['goo_sta'=>1,'del_type'=>1])
		->where(function($query) use ($goods_name){
			$query->where('goo_number','like','%'.$goods_name.'%')->orwhere('goo_name','like','%'.$goods_name.'%');
		})->selectRaw("concat(goo_name,'/',goo_number) as value,goo_id as goods_id,goo_name as goods_name,0 as goods_number,0 as goods_money")
		->limit(5)
		->get();
		return json_encode(['code'=>200,'msg'=>'成功','data'=>$data],JSON_UNESCAPED_UNICODE);
	}

	//首页概括
	public function homestatis(Request $request){
		// $token='813251ba43ea0a7306e23f0eb867dabd75b13a84';
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}

		//统计商品分类数量，统计商品数量,统计溯源信息
		$goods['goods_number']=Db::table('goods')->where(['goo_sta'=>1,'goo_cid'=>$user['adm_cid'],'del_type'=>1])->count();
		$goods['class_number']=Db::table('goo_classifi')->where(['cla_stase'=>1,'cla_cid'=>$user['adm_cid']])->count();
		$goods['formwork_number']=Db::table('formwork')->where(['fom_stase'=>1,'fom_cid'=>$user['adm_cid']])->count();

		//统计订单个数  统计待出库个数  统计待入库个数
		$order_s['new_order']=Db::table('order_form')->where(['order_state'=>1,'company_id'=>$user['adm_cid']])->count();
		$order_s['apply_order']=Db::table('order_form')->where('order_state','<',5)->where(['company_id'=>$user['adm_cid']])->count();
		$order_s['out_order']=Db::table('out_order')->where(['war_out_state'=>1,'del_state'=>1,'war_out_cid'=>$user['adm_cid']])->count();
		$order_s['info_order']=Db::table('receipt_order')->where(['rec_state'=>1,'del_state'=>1,'rec_cid'=>$user['adm_cid']])->count();

		$aa=Db::table('repertory')->selectRaw('count(*) as count,rep_type')->groupBy('rep_type')->where(['rep_state'=>1,'rep_cid'=>$user['adm_cid']])->get();

		$data=array_column($aa,'count','rep_type');

		//统计云仓个数
		$ware['ware_sum']=array_sum($data); //云仓
		$ware['ware_product']=empty($data[1])?0:$data[1]; //成品
		$ware['ware_artially']=empty($data[2])?0:$data[2]; //半成品
		$ware['ware_material']=empty($data[3])?0:$data[3]; //原料

		$time=date("Ym");
    	$count_sum=Db::table('group')->where(['gro_cid'=>$user['adm_cid']])->whereRaw($time."=date_format(gro_time,'%Y%m')")->sum('gro_num');

    	$goods_data=Db::table('group')->where(['gro_cid'=>$user['adm_cid']])->where('goo_cid',$user['adm_cid'])->whereRaw($time."=date_format(gro_time,'%Y%m')")->orderBy('number','desc')->groupBy('gro_gid')->join('goods','gro_gid','=','goo_id')->selectRaw('sum(gro_num) as number,trace_goods.goo_name as goods_name')->get();
    	if(empty($goods_data)){
    		$goods_orderby=[];
			$piechart_state=0;
    	}else{
    		$goods_num=array_sum(array_column($goods_data,'number'));
    		$diff_num=$count_sum-$goods_num;

    		if(count($goods_data)>9){
    			$goods_b=array_splice($goods_data,9);
    			$goods_or['goods_name']='其他';
				$goods_or['number']=array_sum(array_column($goods_b,'number'))+$diff_num;
				$goods_orderby=array_slice($goods_data,0,9);
				$goods_orderby[]=$goods_or;
    		}elseif ($diff_num>0){
    			// return $goods;
    			$goods_or['goods_name']='其他';
				$goods_or['number']=$diff_num;
				$goods_data[]=$goods_or;
				$goods_orderby=$goods_data;
    		}else{
    			$goods_orderby=$goods_data;
    		}
    		// return $goods_orderby;
    		foreach ($goods_orderby as $key => $val) {
				$goods_orderby[$key]['proportion']=number_format($val['number']/$count_sum*100,2);
			}
			$piechart_state=1;
    	}

		
		//统计今年的查询量,发码量,订单量
		$year=date("Y");
		//统计今年的订单量
		$order_count=Db::table('statistic_send')->where(['sta_cid'=>$user['adm_cid'],'sta_type'=>2,'sta_year'=>$year])->orderBy('month','asc')->select('sta_month as month','sta_total as number')->get();
		$order=array_column($order_count,'number','month');
		//统计今年的发码量
		$send_count=Db::table('statistic_send')->where(['sta_cid'=>$user['adm_cid'],'sta_type'=>1,'sta_year'=>$year])->orderBy('month','asc')->select('sta_month as month','sta_total as number')->get();
		$send=array_column($send_count,'number','month');
		//统计今年的查询量
		$select_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2,'stal_cid'=>$user['adm_cid']])->selectRaw("sum(stal_total) as number,stal_month as month")->orderBy('month','asc')->groupBy('month')->get();
		$select=array_column($select_count,'number','month');

		$year_count=[];
		$month=date('m');

		for($i=1;$i<=12;$i++){
			if($i<=$month){
				$year_count[$i-1]['month']  =(int)$i;
				$year_count[$i-1]['order_count']  =(int)(empty($order[$i])?0:$order[$i]);
				$year_count[$i-1]['send_count']   =(int)(empty($send[$i])?0:$send[$i]);
				$year_count[$i-1]['select_count'] =(int)(empty($select[$i])?0:$select[$i]);
				$year_count[$i-1]['is_show'] =1;
			}else{
				$year_count[$i-1]['month']  =$i;
				$year_count[$i-1]['order_count']  =0;
				$year_count[$i-1]['send_count']   =0;
				$year_count[$i-1]['select_count'] =0;
				$year_count[$i-1]['is_show'] =2;
			}
			
		}

		//统计今年城市查询量
		$day = date("d");
		// $city_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>1])->selectRaw("sum(stal_city_total) as number,stal_city as city")->orderBy('stal_city_total','desc')->groupBy('stal_city')->limit(6)->get();

		$city_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>1,'stal_cid'=>$user['adm_cid']])->where("stal_city",'!=','未知')->selectRaw("sum(stal_total) as number,stal_city as city")->orderBy('stal_total','desc')->groupBy('stal_city')->limit(10)->get();
		// 统计今日查询量
		$city_counts=Db::table('statistic_look')->where(['stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$user['adm_cid']])->where("stal_city",'!=','未知')->selectRaw("sum(stal_total) as number,stal_city as city")->orderBy('stal_total','desc')->groupBy('stal_city')->limit(10)->get();
		
		//统计今年城市查询量
		// $goods_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2])->selectRaw("sum(stal_goo_total) as number,goo_name as goods_name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('stal_goo_total','desc')->groupBy('stal_goo_id')->limit(6)->get();

		$goods_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2,'stal_cid'=>$user['adm_cid']])->selectRaw("sum(stal_total) as number,goo_name as goods_name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('stal_total','desc')->groupBy('stal_goo_id')->limit(10)->get();
		// 统计今日商品查询量
		$goods_count=Db::table('statistic_look')->where(['stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$user['adm_cid']])->selectRaw("sum(stal_total) as number,goo_name as goods_name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('stal_total','desc')->groupBy('stal_goo_id')->limit(10)->get();

		$city_count_state=1;
		if(empty($city_count)){
			$city_count_state=0;
		}

		$goods_count_state=1;
		if(empty($goods_count)){
			$goods_count_state=0;
		}

		//地块统计的统计的是耕地的数据  
		//统计耕地数量  代培养指有培养时间而且
		$massif_count=Db::table('cultivation')->where(['cul_type'=>1,'cul_cid'=>$user['adm_cid'],'cul_state'=>1])->count();
		
		$massif_breed=Db::table('cultivation')->where(['cul_type'=>1,'cul_cid'=>$user['adm_cid'],'cul_state'=>1])->whereRaw("date_add(cultiva_time,interval cultiva_year year)>date_format(now(),'%Y-%m-%d %H:%i:%s') and date_add(date_add(cultiva_time,interval cultiva_year year),interval -3 month) < date_format(now(),'%Y-%m-%d %H:%i:%s')")->count();
		$massif=['massif_count'=>$massif_count,'breed_massif'=>$massif_breed];
		

		$code=['code'=>200,'msg'=>'成功','data'=>
			['goods'=>$goods,
			'order'=>$order_s,
			'ware'=>$ware,
			'piechart_state'=>$piechart_state,
			'piechart'=>$goods_orderby,
			'year_count'=>$year_count,
			'month_count'=>count($year_count),
			'city_count_state'=>$city_count_state,
			'city_count'=>$city_count,
			'goods_count_state'=>$goods_count_state,
			'goods_count'=>$goods_count
			,'massif'=>$massif
			]
		];
		return json_encode($code,JSON_UNESCAPED_UNICODE);
	}

	// 消息中心
	public function messageCenter(Request $request)
	{
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		if (!in_array($request->input('type'),array(1,2))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
		if ($request['type'] == '1') {
			$messages = DB::table('notice')->orderBy('notice_created_at','DESC')->get();
		}elseif ($request['type'] == '2') {
			$messages = DB::table('message')->where(['msg_adm_id' => $user['adm_cid']])->orderBy('msg_is_read','ASC')->orderBy('msg_created_at','DESC')->get();
		}
		// $messages = DB::table('message')->where(['msg_adm_id' => $user['adm_cid']])->orderBy('msg_is_read','ASC')->orderBy('msg_created_at','DESC')->get();
		return response()->json(['code'=>200,'msg'=>'success','messages'=>$messages]);
	}
	public function show(Request $request)
	{
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		if (!in_array($request->input('type'),array(1,2))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
		if ($request['type'] == '1') {
			$res = DB::table('notice')->where(['notice_id'=>$request['id']])->first();
			$info['title'] = "【系统公告】 ".$res['notice_title'];
            $info['content'] = $res['notice_content'];
            $info['created_at'] = $res['notice_created_at'];
		}elseif($request['type'] == '2'){
            $res = DB::table('message')->where(['msg_id' => $request['id']])->first();
            $info['title'] = "【系统消息】 ".$res['msg_title'];
            $info['content'] = $res['msg_content'];
            $info['created_at'] = $res['msg_created_at'];
            $info['is_read'] = $res['msg_is_read'];
            DB::table('message')->where(['msg_id' => $request['id']])->update(['msg_is_read' => 2]);
        }
        return response()->json(['code'=>200,'msg'=>'success','info'=>$info]);
	}
}