<?php
namespace App\Http\Controllers\Order;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Db;
use App\Http\Models\Order\OrderModel;
use App\Http\Models\CommenModel;
use \Exception;
use Excel;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Crypt;
class OrderController extends Controller
{

	//订单列表
	public function orderlist(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		if(empty((int)$request->input("pri_id",0)))return json_encode(['code'=>500,'msg'=>'失败','data'=>'缺少按钮id'],JSON_UNESCAPED_UNICODE);
		
		//订单类型
		$data['state']           =(int)$request->input('state',null);
		if(!empty($data['state'])){
			$state=[1,2,3];
			if(in_array($data['state'],$state)) $data['state']=1;
		}
		//系统编号
		$data['system_number']   =$request->input('system_number',null);
		//平台  和 平台单号
		$data['plat_id']         =(int)$request->input('plat_id',null);
		$data['plat_number']     =$request->input('plat_number',null);
		//商品名称
		$data['goods_name']      =$request->input('goods_name',null);
		//客户名称，客户电话
		$data['user_name']       =$request->input('user_name',null);
		$data['user_tel']        =$request->input('user_tel',null);
		//物流信息  备注
		$data['wl']              =$request->input('wl',null);
		$data['remarks']         =$request->input('remarks',null);

		//页码数量
		$data['page']            =(int)$request->input('page',1);
		$data['page_size']       =(int)$request->input('page_size',5);
		$data   =  CommenModel::checkData_dc($data,2);

		$export=2;
		//创建时间
		$data['create_start']    =$request->input("create_start",null);
		$data['create_end']      =$request->input('create_end',null);
		//完成时间
		$data['complete_start']  =$request->input('complete_start',null);
		$data['complete_end']    =$request->input('complete_end',null);
		$obj=new OrderModel();

		$res=$obj->orderListMax($data,$user,$export);
		$res['button']=wherebutton($request->input("api_token"),(int)$request->input("pri_id",0));
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//导出订单 excel
	public function orderexport(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		// $token='90f42b18a86f00519390d2cef200173322bf29e6';
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		//订单类型
		$data['state']           =(int)$request->input('state',null);
		if(!empty($data['state'])){
			$state=[1,2,3];
			if(in_array($data['state'],$state)) $data['state']=1;
		}
		//系统编号
		$data['system_number']   =$request->input('system_number',null);
		//平台  和 平台单号
		$data['plat_id']         =(int)$request->input('plat_id',null);
		$data['plat_number']     =$request->input('plat_number',null);
		//商品名称
		$data['goods_name']      =$request->input('goods_name',null);
		//客户名称，客户电话
		$data['user_name']       =$request->input('user_name',null);
		$data['user_tel']        =$request->input('user_tel',null);
		//物流信息  备注
		$data['wl']              =$request->input('wl',null);
		$data['remarks']         =$request->input('remarks',null);
		$data   =  CommenModel::checkData_dc($data,2);
		$export=1;
		$data['create_start']    =$request->input("create_start",null);
		$data['create_end']      =$request->input('create_end',null);
		$data['complete_start']  =$request->input('complete_start',null);
		$data['complete_end']    =$request->input('complete_end',null);
		$obj=new OrderModel();
		return json_encode($obj->orderListMax($data,$user,$export));
	}
	
	//请求添加订单页面   只是获取所有的平台列表 和一个订单号
	public function addorderpage(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		$order_number='OR'.$user['adm_cid'].'0'.$user['admin_id'].date('YmdHis').rand(1000,9999);
		//获取所有平台
		$plot=Db::table('platform')->where(['plat_cid'=>$user['adm_cid'],'plat_state'=>1])->select('plat_id','plat_name')->get();
		$data=Db::table('goods')
		->where(['goo_sta'=>1,'del_type'=>1])
		->where(['goo_cid'=>$user['adm_cid']])
		->selectRaw("concat(goo_name,'/',goo_number) as value,goo_id as goods_id,goo_name as goods_name,0 as goods_number,0 as goods_money")
		->limit(5)
		->get();
		return json_encode(['code'=>200,'msg'=>'成功','data'=>['system_number'=>$order_number,'goods'=>$data,'plat'=>$plot]],JSON_UNESCAPED_UNICODE);
	}

	//添加订单
	public function addorder(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$type=1;
			//订单信息
			$order['customer_account']   =$request->input('user_account',null);
			$order['plat_number']        =$request->input('plat_number',null);
			$order['plat_id']            =(int)$request->input('plat_id',null);
			//单号
			$order['system_number']=$request->input('system_number');
			$this->check_order_number($order['system_number'],$user['adm_cid'],$user['admin_id']);
			$order['create_user']  =$user['admin_id'];
			$order['company_id']   =$user['adm_cid'];
			$order['order_state']  =1;

			//客服
			$order['customer_user']=$request->input('customer_user',null);
			//客户信息表
			$user_data['oru_user_name']  =$order['user_name']=$request->input('user_name',null);
			$order=CommenModel::checkData_dc($order,2);
			//客户信息
			$user_data['oru_user_tel']   =$order['user_tel']=$request->input('user_tel',null);

			//地区
			$user_data['oru_province']    =$request->input('province',null);
			$user_data['oru_city']        =$request->input('city',null);
			$user_data['oru_county']      =$request->input('county',null);
			$user_data['oru_address']     =$request->input('address',null);
			$user_data=CommenModel::checkData_dc($user_data,2);

			//获取商品信息
			$arr_goods   =$request->input('goods',null);
			$goods=[];
			if(empty($arr_goods)){throw new Exception("商品不能为空");}
			foreach ($arr_goods as $key => $val){
				$goods['goods_id'][]=$val['goods_id'];
				$goods['goods_number'][]=$val['goods_number'];
				$goods['goods_money'][]=$val['goods_money'];
			}
			//校验订单信息
			$this->check_order_gods($order,$goods,$user_data);

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		$obj=new OrderModel();
		$res=$obj->addOrderDb($order,$user_data,$goods,$user,$type);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//校验订单和 商品信息
	public function check_order_gods($order,$goods,$user_data){

		$res=CommenModel::checkData_dc($goods);
		if(!$res || !is_array($goods['goods_id']) || !is_array($goods['goods_number']) || !is_array($goods['goods_money'])){throw new Exception("商品信息格式");}
		//缺少 平台id  和客户账号；
		// if(empty($order['plat_id']) || empty($order['customer_account']) || empty($order['plat_number'])){throw new Exception("信息不全");}
			

		if(empty($user_data['oru_province']) || empty($user_data['oru_city']) || empty($user_data['oru_address'])){throw new Exception("地址不全,请填写全部路径");}

		//判断商品信息
		if(empty($goods['goods_id']) || !is_array($goods['goods_id']) || !is_array($goods['goods_number']) || count($goods['goods_id']) != count($goods['goods_number'])){throw new Exception("缺少商品信息");}

		//判断商品信息
		if(empty($goods['goods_money']) || !is_array($goods['goods_id']) || !is_array($goods['goods_money']) || count($goods['goods_id']) != count($goods['goods_money'])){throw new Exception("缺少商品信息");}

		if(count($goods['goods_money'])<1){throw new Exception("商品信息不能为空");}
	}

	//编辑订单
	public function editorder(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$type=2;
			//订单信息
			$order['customer_account']   =$request->input('user_account',null);
			$order['plat_number']        =$request->input('plat_number',null);
			$order['plat_id']            =(int)$request->input('plat_ids',null);
			$order['order_id']=(int)$request->input('order_id',null);
			if(empty($order['order_id'])){throw new Exception("订单id不能为空");}
			//客服
			$order['customer_user']=$request->input('customer_user',null);
			//客户信息表
			$user_data['oru_user_name']  =$order['user_name']=$request->input('user_name',null);
			$order=CommenModel::checkData_dc($order,2);
			//客户信息
			$user_data['oru_user_tel']   =$order['user_tel']=$request->input('user_tel',null);
			//地区
			$user_data['oru_province']    =$request->input('province',null);
			$user_data['oru_city']        =$request->input('city',null);
			$user_data['oru_county']      =$request->input('county',null);
			$user_data['oru_address']     =$request->input('address',null);
			$user_data=CommenModel::checkData_dc($user_data,2);

			//获取商品信息
			$arr_goods   =$request->input('goods',null);
			$goods=[];
			if(empty($arr_goods)){ throw new Exception("商品不能为空");}
			foreach ($arr_goods as $key => $val){
				$goods['goods_id'][]=$val['goods_id'];
				$goods['goods_number'][]=$val['goods_number'];
				$goods['goods_money'][]=$val['goods_money'];
			}
			
			//校验订单信息
			$this->check_order_gods($order,$goods,$user_data);
		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		$obj=new OrderModel();
		$res=$obj->addOrderDb($order,$user_data,$goods,$user,$type);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//锁定，删除，修改，完成
	public function lockingdel(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$order_id=$request->input('order_id',null);
			$res=CommenModel::checkData_dc($order_id);
			if(!$res || empty($order_id)){throw new Exception("订单id格式错误");}
        }catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		//1 锁定   2 解锁  3 删除   4 完成
		$state=1;
		$obj=new OrderModel();
		$res=$obj->editOrderState($order_id,$state,$user);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}
	//解锁
	public function orderunlock(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$order_id=$request->input('order_id',null);
			$res=CommenModel::checkData_dc($order_id);
			if(!$res || empty($order_id)){throw new Exception("订单id格式错误");}

        }catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		//1 锁定   2 解锁  3 删除   4 完成
		$state=2;
		$obj=new OrderModel();
		$res=$obj->editOrderState($order_id,$state,$user);
		// dd($res);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}
	//删除
	public function orderdel(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$order_id=$request->input('order_id',null);
			$res=CommenModel::checkData_dc($order_id);
			if(!$res || empty($order_id)){throw new Exception("订单id格式错误");}

        }catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		//3 删除
		$state=3;
		$obj=new OrderModel();
		$res=$obj->editOrderState($order_id,$state,$user);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}
	//完成
	public function ordercomplete(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$order_id=$request->input('order_id',null);
			$res=CommenModel::checkData_dc($order_id);
			if(!$res || empty($order_id)){throw new Exception("订单id格式错误");}

        }catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		//1 锁定   2 解锁  3 删除   4 完成
		$state=4;
		$obj=new OrderModel();
		$res=$obj->editOrderState($order_id,$state,$user);
		// dd($res);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//导入 订单excel 
	public function importorder(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}

		$file=$request->file('file');
		if(empty($file)){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件不能为空'],JSON_UNESCAPED_UNICODE);
		}
		if($file->isValid()){
               	$obj=new OrderModel();
               	$res=$obj->UploadsFileImport($file,$user);
            	return json_encode($res,JSON_UNESCAPED_UNICODE);
        }else{
        	return json_encode(['code'=>500,'msg'=>'失败','data'=>'上传文件失败'],JSON_UNESCAPED_UNICODE);
        }
	}

	//签收
	public function signfor(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
			$data['order_id']=(int)$request->input('order_id',null);
			if(empty($data['order_id'])){throw new Exception("订单id不能为空");}
			$data['receipt_time']=$request->input('create_img',date('Y-m-d H:i:s'));
			$file=$request->input('order_img');
			if(empty($file)){throw new Exception("图片不能为空");}

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
        $obj=new OrderModel();
        $res=$obj->Order_SignFor($file,$data,$user);

        return json_encode($res,JSON_UNESCAPED_UNICODE);

	}


	//订单备注列表
	public function remarkslist(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$order_id=(int)$request->input('order_id',null);
			if(empty($order_id)){throw new Exception("订单id不能为空");}

			$res=Db::table('order_form')->where('order_state','!=',11)->where(['ord_id'=>$order_id,'company_id'=>$user['adm_cid']])->first();
			if(empty($res)){throw new Exception("没有该订单");}

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }

		$remarks=Db::table('order_remarks')->where(['order_id'=>$order_id])->join('admin','admin.adm_id','=','order_remarks.rma_user_id')->select('admin.adm_name','order_remarks.create_time','remarks')->get();
		$data=['order_id'=>$order_id,'remarks'=>$remarks];
		return json_encode(['code'=>200,'msg'=>'成功','data'=>$remarks],JSON_UNESCAPED_UNICODE);
	}

	//添加订单备注
	public function addremarks(Request $request){

		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$order_id=(int)$request->input('order_id',null);
			$content =(string)$request->input('content',null);
			if(empty($order_id)){throw new Exception("订单id不能为空");}
			if(empty($content)) {throw new Exception("请填写备注");}

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		$obj=new OrderModel();
		$res=$obj->RemarksAdd($order_id,$content,$user);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	/**
	 *  获取派单数据    那个仓库里有这个商品;
	 * 派单   分配订单到各个仓库;
	 * @param Request $request [description]
	 */
	public function distriorder(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$order_id=$request->input('order_id',null);
			if(empty($order_id)){ throw new Exception("订单id不能为空");}
			$res1=CommenModel::checkData_dc($order_id);
			if(!$res1){throw new Exception("订单信息不正确");}

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }

		$obj=new OrderModel();
		$res=$obj->Distri_Order($user,$order_id);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//派单 到各个仓库
	public function distriware(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}

			$data['order_id']=$order_id=$request->input('order_id',null);
			$data['goods_id']=$request->input('goods_id',null);
			$data['ware_id']=$request->input('ware_id',null);

			if(empty($order_id)){throw new Exception("订单数据不能为空");}
			//判断是否为成品仓
			$rep_type=Db::table('repertory')->whereIn('rep_id',$data['ware_id'])->select('rep_type')->get();

			foreach($rep_type as $k=>$v)
			{
				if($v['rep_type'] !==1)
				{
					throw new Exception("只有成品仓才能派单");
				}
			}
			if(!is_array($data['ware_id']) || !is_array($data['goods_id'])){throw new Exception("提交信息格式错误");}

			if(empty($data['goods_id']) || empty($data['ware_id'])){throw new Exception("商品或仓库信息不能为空");}

			if(!is_array($order_id)){
				$str=$order_id;
				unset($order_id);
				$order_id[]=$str;
			}

			if(count($data['ware_id']) != count($data['goods_id'])){throw new Exception("必须每个商品都分到对应的仓库");}

			if(count($data['ware_id'])!= count($order_id)){throw new Exception("每个商品都要对应一个订单");}

			$res=CommenModel::checkData_dc($data);
			$res1=CommenModel::checkData_dc($order_id);
			if(!$res && !$res1){throw new Exception("商品或仓库信息不正确");}

		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }
		$obj=new OrderModel();
		$res=$obj->Distri_Ware($user,$order_id,$data);
		// dd($res);
		return json_encode($res,JSON_UNESCAPED_UNICODE);
	}

	//获取订单详情，然后修改
	public function ordereidt(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		try{
			if(!$user){throw new Exception("token错误");}
		}catch (Exception $e){
            return json_encode(["code"=>500,'msg'=>'失败','data'=>$e->getMessage()],JSON_UNESCAPED_UNICODE);
        }

		$order_id=(int)$request->input('order_id',null);

		$obj=new OrderModel();
		$res=$obj->OrderDetails($user,$order_id);
		return json_encode($res,JSON_UNESCAPED_UNICODE);

	}

	//校验订单
	public function check_order_number($order,$cid=1,$admin_id=1){
		$order=CommenModel::checkData_dc($order,2);
		if(empty($order)){throw new Exception("单号不能为空");}

		if(strlen($order)<20){throw new Exception("单号错误");}
		$str='OR'.$cid.'0'.$admin_id;
		//比较编号前几位
		$len=strlen($str);
		$getstr=substr($order,0,$len);
		//判断前几位是格式一致
		if($getstr!=$str){throw new Exception("单号格式错误");}

		//判断后几位是否是整形
		if(!is_numeric(substr($order,$len))){throw new Exception("单号错误");}

		//判断 订单是否过期
		$time=substr($order,$len,-4);
		$now_time=time();
		$t_time=strtotime($time);
		if($t_time>$now_time){throw new Exception("订单单号被修改");}

		if(($now_time-$t_time) > 3000){throw new Exception("单号过期");}
	}

	public function remark_list(Request $request){
		$token=Crypt::decrypt($request->input("api_token"));
		$user=CommenModel::getUserToken($token);
		if(!$user){
			return json_encode(['code'=>500,'msg'=>'失败','data'=>'token错误'],JSON_UNESCAPED_UNICODE);
		}
		$order=(int)$request->input('order_id',null);
		$type=(int)$request->input('type',1);
		// type 1获取 备注   2 获取订单信息
		if($type==1){
			$data=Db::table('order_remarks')->where(['order_id'=>$order])->join('admin','admin.adm_id','=','order_remarks.rma_user_id')->select('admin.adm_name','order_remarks.create_time','remarks')->orderBy('rma_id','desc')->get();
		}elseif($type==2){
			$data=DB::table('order_log')->where(['order_id'=>$order])->join('admin','admin.adm_id','=','order_log.admin_user')->select('admin.adm_name as admin_user','order_log.create_time','details')->orderBy('orc_id','desc')->get();
		}elseif($type==3){
			//返回商品信息；
			$goods=Db::table('order_goods as ware')->where(['order_wid'=>$order])->join('goods','ware.warg_goodsid','=','goods.goo_id')->select('goods.goo_name as goods_name','goods.goo_picurl as goods_img','ware.goods_number as goods_number','goods_money as goods_money')->get();
			$num=0;
			foreach ($goods as $key => $value) {
				$goods[$key]['goods_img']=ltrim(explode(',',$value['goods_img'])[0],'/');
				$num+=$value['goods_number']*$value['goods_money'];
			}
			return json_encode(['code'=>200,'msg'=>'success','data'=>$goods,'money'=>$num]);
		}
		return json_encode(['code'=>200,'msg'=>'success','data'=>$data]);
	}
}
