<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use \Exception;
use App\Http\Models\CommenModel;
use App\Http\Controllers\CommonController;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Goods\Navigation;
use App\Http\Controllers\Controller;
use App\Http\Models\Coperationa;
class NoticeController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    //公告列表
    public function index(Request $request)
    {
        // 验证数据
        if (empty($request['pri_id']) || !is_numeric($request['pri_id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $notice_info = $request->all();
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch(\Exception $e){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $userinfo = DB::table('notice')
                    // ->selectRaw('notice_id,notice_title,notice_content,notice_actor,notice_created_at,notice_level')
                    ->orderBy('notice_id','desc')
                    ->paginate($this->show_count);
        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;   //一页显示多少个
        $data_info['userinfo'] = $userinfo->items();                //返回数据
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info)
        {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'公告管理列表获取成功','data_info'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'公告管理列表获取失败']);
        }
    }
    // 添加
    public function addNotice(Request $request)
    {
        // 获取当前操作账号
        $notice_actor = Coperationa::getUserInfo($request->input('api_token'));
        if (empty($request['notice_title']) || empty($request['notice_content'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $res =  DB::table('notice')->insert([
                                'notice_title'      => $request['notice_title'],    //标题
                                'notice_content'    => $request['notice_content'],  //消息内容
                                'notice_actor'      => $notice_actor['adm_name'],   //创建者
                                'notice_created_at' => date('Y-m-d H:i:s'),         //用户名
                                'notice_level'      => $request['notice_level']     //重要程度
                                ]);
        if($res)
        {
            Coperationa::add($notice_actor['adm_id'],$request->getClientIp(),'新增公告','新增','新增'.$request['notice_title']);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }
    // 编辑
    public function editNotice(Request $request)
    {
        // 根据token获取用户信息
        $notice_actor = Coperationa::getUserInfo($request->input('api_token'));
        // 验证数据
        if (!$request->exists('notice_id') || !is_numeric($request->input('notice_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $res = DB::table('notice')
                ->where('notice_id',$request['notice_id'])
                ->update([
                    'notice_title'      => $request['notice_title'],    //标题
                    'notice_content'    => $request['notice_content'],  //消息内容
                    'notice_actor'      => $notice_actor['adm_name'],   //创建者
                    'notice_level'      => $request['notice_level']     //重要程度
                    ]);
        if($res)
        {
            Coperationa::add($notice_actor['adm_id'],$request->getClientIp(),'编辑公告','编辑','编辑'.$request['notice_title']);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }
    // 删除
    public function delNotice(Request $request)
    {
        // 验证数据
        if (!$request->exists('notice_id') || !is_numeric($request->input('notice_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $notice_actor = Coperationa::getUserInfo($request->input('api_token'));
        $res = DB::table('notice')
                ->where('notice_id',$request['notice_id'])
                ->delete();
        if($res)
        {
            Coperationa::add($notice_actor['adm_id'],$request->getClientIp(),'删除公告','删除','删除'.$request['notice_title']);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }
}