<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use \Exception;
use App\Http\Models\CommenModel;
use App\Http\Controllers\CommonController;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Goods\Navigation;
use App\Http\Controllers\Controller;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Source\VerifyFormworkController;

class NavigationController extends Controller
{
    //导航列表
    public function index(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $data['time_start']=$request->input('time_start',null);
        $data['time_end']  =$request->input('time_end',null);
        $data['nav_name']  =$request->input('nav_name',null);
        $data['nav_state']  =$request->input('nav_state',null);
        $data['nav_style']  =$request->input('nav_style',null);
        $data['page']      =(int)$request->input('page',1);
        $data['pagesize']    =(int)$request->input('page_size',10);
        if($data['pagesize']>100 || $data['pagesize'] < 1){
            $data['pagesize']=10;
        }
        $obj=new Navigation();
        $res=$obj->Naviga_list($data,$user);
        $res['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json($res);
    }

    // 获取标签,模板,信息
    public function formwork_info(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $forminfo = $request->all();
        DB::connection()->enableQueryLog();#开启执行日志
        if ($request['lab_type'] == '1'){
            // 获取消费者表单设置信息
            $datas['warrantys_table'] = DB::table('warrantys_table')
                ->where('watas_cid',1)
                ->first(['watas_id','watas_stase','watas_content']);
            $data['watas_content'] = json_decode($datas['warrantys_table']['watas_content'],true);
            $data['watas_stase'] = $datas['warrantys_table']['watas_stase'];
            $data['watas_id'] = $datas['warrantys_table']['watas_id'];
            // 获取技师表单设置信息
            $datas['warranty_table'] = DB::table('warranty_table')
                ->where('wata_cid',1)
                ->first(['wata_id','wata_stase','wata_content']);
            $data['wata_content'] = json_decode($datas['warranty_table']['wata_content'],true);
            $data['wata_stase'] = $datas['warranty_table']['wata_stase'];
            $data['wata_id'] = $datas['warranty_table']['wata_id'];
            // 获取环境信息
            $data['env_list'] = DB::table('environment')
                ->where(['env_cid'=>1,'env_state'=>1])
                ->get(['env_id','env_name','env_number']);
            //获取真伪信息
            $initial=Db::table('note')
                ->where(['not_cid'=>0])
                ->first(['note_content as content','note_number as number']);
            $enterprise=Db::table('note')
                ->where(['not_cid'=>$find_adm['adm_cid']])
                ->first(['note_content as content','note_number as number']);
            $initial['content']=stripslashes($initial['content']);
            if(empty($enterprise)){
                $enterprise=$initial;
            }
            $enterprise['content']=stripslashes($enterprise['content']);
            $show_data=$enterprise;
            $old_data=$initial;
            $show_data['content']=$this->replace_str($show_data['content']);
            $old_data['content'] =$this->replace_str($old_data['content']);
            $data['antiset']=['old_data'=>$initial,'new_data'=>$enterprise,'show_data'=>$show_data,'old_show'=>$old_data];
            // 我的标签
            $data['label'] = DB::table('form_label')
                ->where(['lab_cid'=>1,'lab_stase'=>1,'lab_type'=>1])
                ->get(['lab_id','lab_name']);
            $data['template'] = DB::table('formwork_template')
                ->where(['tem_cid'=>1,'tem_state'=>1,'tem_type'=>1])
                ->get(['tem_id','tem_name','tem_content']);
            $data['formwork'] = DB::table('formwork as f')
                ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                ->where(['fom_cid'=>1,'fom_stase'=>1,'fom_type'=>1])
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fom_title'] )) {
                        $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                    }
                })
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['lab_name'] )) {
                        $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                    }
                })
                ->orderBy('lab_id','desc')
                ->select('lab_id','lab_name','fom_id','fom_title','fom_content','fom_label','tem_id','tem_name')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        }else{
            // 获取消费者表单设置信息
            $datas['warrantys_table'] = DB::table('warrantys_table')
                ->where('watas_cid',$find_adm['adm_cid'])
                ->first(['watas_id','watas_stase','watas_content']);
            $data['watas_content'] = json_decode($datas['warrantys_table']['watas_content'],true);
            $data['watas_stase'] = $datas['warrantys_table']['watas_stase'];
            $data['watas_id'] = $datas['warrantys_table']['watas_id'];
            // 获取技师表单设置信息
            $datas['warranty_table'] = DB::table('warranty_table')
                ->where('wata_cid',$find_adm['adm_cid'])
                ->first(['wata_id','wata_stase','wata_content']);
            $data['wata_content'] = json_decode($datas['warranty_table']['wata_content'],true);
            $data['wata_stase'] = $datas['warranty_table']['wata_stase'];
            $data['wata_id'] = $datas['warranty_table']['wata_id'];
            // 获取环境信息
            $data['env_list'] = DB::table('environment')
                ->where(['env_cid'=>$find_adm['adm_cid'],'env_state'=>1])
                ->get(['env_id','env_name','env_number']);
            //获取真伪信息
            $initial=Db::table('note')
                ->where(['not_cid'=>0])
                ->first(['note_content as content','note_number as number']);
            $enterprise=Db::table('note')
                ->where(['not_cid'=>$find_adm['adm_cid']])
                ->first(['note_content as content','note_number as number']);
            $initial['content']=stripslashes($initial['content']);
            if(empty($enterprise)){
                $enterprise=$initial;
            }
            $enterprise['content']=stripslashes($enterprise['content']);
            $show_data=$enterprise;
            $old_data=$initial;
            $show_data['content']=$this->replace_str($show_data['content']);
            $old_data['content'] =$this->replace_str($old_data['content']);
            $data['antiset']=['old_data'=>$initial,'new_data'=>$enterprise,'show_data'=>$show_data,'old_show'=>$old_data];
            // 我的标签
            $data['label'] = DB::table('form_label')
                ->where(['lab_cid'=>$find_adm['adm_cid'],'lab_stase'=>1])
                ->orWhere('lab_cid',0)
                ->get(['lab_id','lab_name']);
            $data['formwork'] = DB::table('formwork as f')
                ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
                ->where(['fom_stase'=>1,'fom_cid'=>$find_adm['adm_cid']])
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fom_title'] )) {
                        $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                    }
                })
                ->orderBy('lab_id','desc')
                ->select('lab_id','lab_name','fom_id','fom_title','fom_content','fom_label','fom_temid','tem_id','tem_name')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>'信息获取成功','data'=>$data]);
        }
    }
    public function replace_str($data){
        $data=str_replace('{goods}',"满天星窗帘",$data);
        $data=str_replace('{code}',"500011810015498",$data);
        $data=str_replace('{num}','1',$data);
        $data=str_replace('{nums}','1',$data);
        $data=str_replace('{time}',"2019-07-22 12:00:00",$data);
        $data=str_replace('{pros}',"天津 武清区",$data);
        return $data;
    }
    //添加导航
    public function addnaviga(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_type=(int)$request->input('nav_type',1);
        if($nav_type==1){
            $data=Db::table('navigation')->where(['nav_id'=>1])->select('nav_name','nav_icon')->first();
            $data['nav_icon']=json_decode($data['nav_icon'],true);
            if ($user['admin_id'] == '1'){
                $data['nav_cid'] = DB::table('admin')->where('adm_cid',$user['adm_cid'])->value('adm_cid');
            }
            if ($user['adm_module'] == '1'){
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                }
            }else if ($user['adm_module'] == '3'){
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 4){
                        unset($data['nav_icon'][$key]);
                    }
                }
            }else if ($user['adm_module'] == '4'){
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 5){
                        unset($data['nav_icon'][$key]);
                    }
                }
            }else if ($user['adm_module'] == '5'){
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                    if ($value['icon_ids'] == 5 || $value['icon_ids'] == 4){
                        unset($data['nav_icon'][$key]);
                    }
                }
            }else{
                foreach ($data['nav_icon'] as $key => $value) {
                    $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
                }
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        $navdata['nav_name']  =$request->input('nav_name',null);
        $navdata['nav_style'] =(int)$request->input('nav_style');
        if(empty($navdata['nav_name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'导航参数错误']);
        }
        $navdata['nav_addtime']=date('Y-m-d H:i:s');
        $navdata['nav_user']   =$user['admin_id'];
        $navdata['nav_cid']    =$user['adm_cid'];
        $navdata['nav_genre']  =$request['nav_genre'];
        $navdata['nav_column_setup'] = $request->input('nav_column_setup');

        $data['name']        =$request->input('name');
        $data['icon_type']   =$request->input('icon_type');
        $data['content']     =$request->input('content');
        $data['icon_ids']    =$request->input('icon_ids');
        $data['pic']         =$request->input('pic');
        $data['show']        =$request->input('show');
        $data['system_icon'] =$request->input('system_icon');
        $data['icon_order'] =$request->input('icon_order');

        $data['wata_type'] = $request->input('wata_type');
        $data['watas_type'] = $request->input('watas_type');
        $data['watas_id'] = $request->input('watas_id');
        $data['wata_id'] = $request->input('wata_id');

        $data['wata_stase'] = $request->input('wata_stase');
        $data['watas_stase'] = $request->input('watas_stase');
        $data['infos_name'] = $request->input('infos_name');
        $data['infos_show'] = $request->input('infos_show');
        $data['infos_required'] = $request->input('infos_required');
        $data['infos_content'] = $request->input('infos_content');
        $data['infos_type'] = $request->input('infos_type');
        $data['info_name'] = $request->input('info_name');
        $data['info_show'] = $request->input('info_show');
        $data['info_required'] = $request->input('info_required');
        $data['info_content'] = $request->input('info_content');
        $data['info_type'] = $request->input('info_type');

        if(count($data['name']) < 1 || count($data['name']) != count($data['icon_ids']) || count($data['name']) != count($data['content']) || count($data['name']) != count($data['icon_type']) || count($data['name']) != count($data['name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数格式错误']);
        }
        if(count($data['name']) > 10){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'图标最多10个']);
        }
        $obj=new Navigation();
        $res=$obj->add_Navigation($navdata,$data,$user,1);
        return response()->json($res);
    }

    //编辑导航
    public function editnaviga(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_type=(int)$request->input('nav_type',1);
        $id  =(int)$request->input('nav_id');
        if($nav_type==1){
            $data=Db::table('navigation')->where(['nav_id'=>$id,'nav_del'=>1,'nav_cid'=>$user['adm_cid']])->first(['nav_id','nav_name','nav_style','nav_icon','nav_column_setup','nav_genre']);
            if(!$data){return response()->json(['code'=>500,'msg'=>'error','data'=>'没有这个导航']);}
            $data['nav_icon']=json_decode($data['nav_icon'],true);
            if ($user['admin_id'] == '1'){
                $data['nav_cid'] = DB::table('navigation')->where('nav_cid',$user['adm_cid'])->value('nav_cid');
            }
            foreach ($data['nav_icon'] as $key => $value) {
                $data['nav_icon'][$key]['show'] = $value['show'] == 1 ? false : true;
            }
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        $navdata['nav_id']    =(int)$request->input('nav_id');
        $navdata['nav_name']  =$request->input('nav_name',null);
        $navdata['nav_style'] =(int)$request->input('nav_style');
        $navdata['nav_genre']  =$request['nav_genre'];
        if(empty($navdata['nav_name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'导航参数错误']);
        }
        $navdata['nav_column_setup'] = $request->input('nav_column_setup');
        $navdata['nav_updatime']=date('Y-m-d H:i:s');
        $data['name']        =$request->input('name');
        $data['icon_type']   =$request->input('icon_type');
        $data['content']     =$request->input('content');
        $data['icon_ids']    =$request->input('icon_ids');
        $data['pic']         =$request->input('pic');
        $data['show']        =$request->input('show');
        $data['system_icon'] =$request->input('system_icon');
        $data['icon_order'] =$request->input('icon_order');

        $data['wata_stase'] = $request->input('wata_stase');
        $data['watas_stase'] = $request->input('watas_stase');

        if(count($data['name']) < 1 || count($data['name']) != count($data['icon_ids']) || count($data['name']) != count($data['content']) || count($data['name']) != count($data['icon_type'])|| count($data['name']) != count($data['name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数格式错误']);
        }
        if(count($data['name']) > 10){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'图标最多10个']);
        }
        $obj=new Navigation();
        $res=$obj->add_Navigation($navdata,$data,$user,2);
        return response()->json($res);
    }

    //删除导航
    public function delnaviga(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_id=$request->input('nav_id',null);
        $obj=new Navigation();
        $res=$obj->Navi_update($nav_id,$user,3);
        return response()->json($res);
    }

    //停用
    public function stopnav(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_id=$request->input('nav_id',null);
        $obj=new Navigation();
        $res=$obj->Navi_update($nav_id,$user,2);
        return response()->json($res);
    }

    //启用
    public function startnav(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_id=$request->input('nav_id',null);
        $obj=new Navigation();
        $res=$obj->Navi_update($nav_id,$user,1);
        return response()->json($res);
    }

    //复制
    public function copynav(Request $request){
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $nav_type=(int)$request->input('nav_type',1);
        if($nav_type==1){
            $data=Db::table('navigation')->where(['nav_id'=>1])->first(['nav_name','nav_icon']);
            $data['nav_icon']=json_decode($data['nav_icon'],true);
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        
        $navdata['nav_name']  =$request->input('nav_name',null);

        $navdata['nav_style'] =(int)$request->input('nav_style');
        if(empty($navdata['nav_name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'导航参数错误']);
        }
        $navdata['nav_addtime']=date('Y-m-d H:i:s');
        $navdata['nav_user']   =$user['admin_id'];
        $navdata['nav_cid']    =$user['adm_cid'];
        $navdata['nav_genre']  =$request['nav_genre'];
        $navdata['nav_column_setup'] = $request->input('nav_column_setup');

        $data['name']        =$request->input('name');
        $data['icon_type']   =$request->input('icon_type');
        $data['content']     =$request->input('content');
        $data['icon_ids']    =$request->input('icon_ids');
        $data['pic']         =$request->input('pic');
        $data['show']        =$request->input('show');
        $data['system_icon'] =$request->input('system_icon');
        $data['icon_order'] =$request->input('icon_order');

        $data['wata_type'] = $request->input('wata_type');
        $data['watas_type'] = $request->input('watas_type');
        $data['watas_id'] = $request->input('watas_id');
        $data['wata_id'] = $request->input('wata_id');

        $data['wata_stase'] = $request->input('wata_stase');
        $data['watas_stase'] = $request->input('watas_stase');
        $data['infos_name'] = $request->input('infos_name');
        $data['infos_show'] = $request->input('infos_show');
        $data['infos_required'] = $request->input('infos_required');
        $data['infos_content'] = $request->input('infos_content');
        $data['infos_type'] = $request->input('infos_type');
        $data['info_name'] = $request->input('info_name');
        $data['info_show'] = $request->input('info_show');
        $data['info_required'] = $request->input('info_required');
        $data['info_content'] = $request->input('info_content');
        $data['info_type'] = $request->input('info_type');
        $data['watas_stase'] = $request->input('watas_stase');

        if(count($data['name']) < 1 || count($data['name']) != count($data['icon_ids']) || count($data['name']) != count($data['content']) || count($data['name']) != count($data['icon_type']) || count($data['name']) != count($data['name'])){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数格式错误']);
        }
        if(count($data['name']) > 10){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'图标最多10个']);
        }

        $obj=new Navigation();
        $res=$obj->add_Navigation($navdata,$data,$user,1);
        return response()->json($res);
    }

    // 上传图片
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".time()."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        if(!empty($image))
        {
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/nav";
            if (!is_dir($path)){             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'图片上传成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }
    
    // 删除图片
    public function delimageform(Request $request)
    {
        $image =  $request['images'];
        if(!is_array($image)){
            $temp=$image;
            unset($image);
            $image[]=$temp;
        }
        foreach ($image as $key => $val) {
            if(file_exists(public_path().'/'.$val) && !empty($val)){
                // 修改原圖片权限
                chmod(public_path().'/'.$val,0777);
                // 删除原圖片
                unlink(public_path().'/'.$val); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除图片成功']);
    }

    // 添加溯源信息
    public function addformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        //判断标签名称是否存在
        $lab_name = DB::table('form_label')
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_name',trim($request['lab_name']))
            ->select('lab_id')
            ->first();
        if ($lab_name['lab_id']) {
            $fom_label = $lab_name['lab_id'];
        } else {
            $lab_add_data['lab_name'] = $request['lab_name'];
            $lab_add_data['lab_stase'] = 1;
            $lab_add_data['lab_time'] = date('Y-m-d H:i:s');
            $lab_add_data['lab_cid'] = $find_adm['adm_cid'];
            $lab_add_data['lab_type'] = 3;
            $fom_label = DB::table('form_label')->insertGetId($lab_add_data);
        }
        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_title',trim($request['fom_title']))
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->select('fom_title')
            ->first();
        if ($fom_title) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'信息名称已存在']);
        }
        //新增溯源信息
        $day = date('Ymd');
        $arr = [];
        foreach ($request['formkey'] as $key => $value) {
            $arr[$key]['key'] = $value;
            $arr[$key]['type'] = $request['formtype'][$key];
            $arr[$key]['show'] = $request['formshow'][$key];
            $url = $request['formvalue'][$key];
            if (($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];    //获取后缀
                    $file_name = $arr[$key]['type'] == 2 ? 'images' : 'videos';
                    $new_name = 'uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                    //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path),0777,true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path); //移动
                    $url = $new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[] = $url;
                }
            }
            $arr[$key]['value'] = $url;
            $arr[$key]['content'] = $request['contents'][$key]; //图文内容
        }
        $fom_picurl = '';
        if (!empty($request['fom_picurl'])) {
            //上传图片
            $uploadImg = new CommonController();
            foreach ($request['fom_picurl'] as $key => $value) {
                $uploadPath = $uploadImg->uploadBase64Img($value);
                if ($uploadPath) {
                    $fom_picurl .= $uploadPath.',';
                } else {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }
        $tem_add_data['tem_name'] = $request['fom_title'];
        $tem_add_data['tem_content'] = json_encode($arr);
        $tem_add_data['tem_state'] = 1;
        $tem_add_data['tem_cid'] = $find_adm['adm_cid'];
        $tem_add_data['tem_addtime'] = date('Y-m-d H:i:s');
        $tem_add_data['tem_type'] = 3;
        if (!empty($fom_picurl)){
            $tem_add_data['tem_img'] = 1;
        }else{
            $tem_add_data['tem_img'] = 2;
        }
        $tem_add_data['tem_type_swaitch'] = $request['tem_type_swaitch'];
        $fom_temid = DB::table('formwork_template')->insertGetId($tem_add_data);
        $fom_add_data['fom_title'] = $request['fom_title'];
        $fom_add_data['fom_label'] = $fom_label;
        $fom_add_data['fom_content'] = json_encode($arr);
        $fom_add_data['fom_cid'] = $find_adm['adm_cid'];
        $fom_add_data['fom_stase'] = 1;
        $fom_add_data['fom_temid'] = $fom_temid;
        $fom_add_data['fom_number'] = $request['fom_number'];
        $fom_add_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fom_add_data['fom_picurl'] = $fom_picurl;
        DB::beginTransaction(); //开启事务
        //判断是否有这个模板
        $template = DB::table('formwork_template')
            ->where('tem_id',$fom_temid)
            ->where('tem_cid',$find_adm['adm_cid'])
            ->where('tem_state',1)
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name')
            ->first();
        if (empty($template)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
        } else {
            $tem_res = DB::table('formwork_template')
                ->where('tem_id',$fom_temid)
                ->increment('tem_total');
            if (!$tem_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
            }
        }
        //判断是否有这个标签
        $label = DB::table('form_label')
            ->where('lab_id',$fom_label)
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_stase',1)
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->first();
        if (empty($label)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
        } else {
            $lab_res = DB::table('form_label')
                ->where('lab_id',$fom_label)
                ->increment('lab_total');
            if (!$lab_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
            }
        }
        $fom_res =  DB::table('formwork')->insertGetId($fom_add_data);
        if ($fom_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','新增','新增'.$request['fom_title'].'成功');
            $return_data['fom_id'] =  $fom_res;
            $return_data['lab_id'] =  $fom_label;
            $return_data['tem_id'] =  $fom_temid;
            $fom_picurl = DB::table('formwork')
                ->where('fom_id',$fom_res)
                ->value('fom_picurl');
            $return_data['fom_picurl'] =  explode(',',$fom_picurl);
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加溯源信息成功','return_data'=>$return_data]);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加溯源信息失败']);
        }
    }

    // 保存溯源
    public function handleformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_title',trim($request['fom_title']))
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->select('fom_title')
            ->first();
        if ($fom_title) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请修改信息名称']);
        }
        //新增溯源信息
        $day = date('Ymd');
        $arr = [];
        foreach ($request['formkey'] as $key => $value) {
            $arr[$key]['key'] = $value;
            $arr[$key]['type'] = $request['formtype'][$key];
            $arr[$key]['show'] = $request['formshow'][$key];
            $url = $request['formvalue'][$key];
            if (($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];    //获取后缀
                    $file_name = $arr[$key]['type'] == 2 ? 'images' : 'videos';
                    $new_name = 'uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                    //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path),0777,true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path); //移动
                    $url = $new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[] = $url;
                }
            }
            $arr[$key]['value'] = $url;
            $arr[$key]['content'] = $request['contents'][$key]; //图文内容
        }
        $fom_picurl = '';
        if (!empty($request['fom_picurl'])) {
            //上传图片
            $uploadImg = new CommonController();
            foreach ($request['fom_picurl'] as $key => $value) {
                if (stristr($value,'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $fom_picurl .= $uploadPath.',';
                    } else {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                } else {
                    //获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    //新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                    // 返回路径
                    $filePath = "storage". $pathName;
                    $fom_picurl .= $filePath.',';
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }
        if ($request['fos_type'] == 1){
            $lab = DB::table('form_label')
                ->where('lab_id',$request['fom_label'])
                ->first();
            if (!empty($lab)) {
                if ($lab['lab_name'] != $lab['lab_name']) {
                    $str = (int)substr($lab['lab_name'],strrpos($lab['lab_name'],'+')+1);
                    $name = $lab['lab_name'] . "+" . (++$str);
                }else{
                    $name = $lab['lab_name'] . "+1";
                }
            }
            unset($lab['lab_id']);
            unset($lab['lab_total']);
            unset($lab['lab_type']);
            $lab['lab_name'] = $name;
            $lab['lab_time'] = date('Y-m-d H:i:s');
            $lab['lab_type'] = 3;
            $lab['lab_cid'] = $find_adm['adm_cid'];
            $lab_id = DB::table('form_label')->insertGetId($lab);
            $tem = DB::table('formwork_template')
                ->where('tem_id',$request['fom_temid'])
                ->first();
            if (!empty($tem)) {
                if ($tem['tem_name'] != $tem['tem_name']) {
                    $str = (int)substr($tem['tem_name'],strrpos($tem['tem_name'],'+')+1);
                    $name = $tem['tem_name'] . "+" . (++$str);
                }else{
                    $name = $tem['tem_name'] . "+1";
                }
            }
            unset($tem['tem_id']);
            unset($tem['tem_total']);
            unset($tem['tem_type']);
            $tem['tem_name'] = $name;
            $tem['tem_addtime'] = date('Y-m-d H:i:s');
            $tem['tem_type'] = 3;
            $tem['tem_cid'] = $find_adm['adm_cid'];
            $tem_id = DB::table('formwork_template')->insertGetId($tem);
        }else {
            $tem_id = $request['fom_temid'];
            $lab_id = $request['fom_label'];
        }
        $fom_add_data['fom_title'] = $request['fom_title'];
        $fom_add_data['fom_label'] = $lab_id;
        $fom_add_data['fom_content'] = json_encode($arr);
        $fom_add_data['fom_cid'] = $find_adm['adm_cid'];
        $fom_add_data['fom_stase'] = 1;
        $fom_add_data['fom_temid'] = $tem_id;
        $fom_add_data['fom_number'] = $request['fom_number'];
        $fom_add_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fom_add_data['fom_picurl'] = $fom_picurl;
        DB::beginTransaction(); //开启事务
        //判断是否有这个模板
        $template = DB::table('formwork_template')
            ->where('tem_id',$tem_id)
            ->where('tem_cid',$find_adm['adm_cid'])
            ->where('tem_state',1)
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name')
            ->first();
        if (empty($template)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
        } else {
            $tem_res = DB::table('formwork_template')
                ->where('tem_id',$tem_id)
                ->increment('tem_total');
            if (!$tem_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
            }
        }
        //判断是否有这个标签
        $label = DB::table('form_label')
            ->where('lab_id',$lab_id)
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_stase',1)
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->first();
        if (empty($label)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
        } else {
            $lab_res = DB::table('form_label')
                ->where('lab_id',$lab_id)
                ->increment('lab_total');
            if (!$lab_res) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
            }
        }
        $fom_res =  DB::table('formwork')->insertGetId($fom_add_data);
        if ($fom_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','新增','新增'.$request['fom_title'].'成功');
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑溯源信息成功','fom_id'=>$fom_res]);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑溯源信息失败']);
        }
    }
}