<?php
namespace App\Http\Controllers\MobileWeb\Homepage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\MobileWeb\Verify\VerifyHomepageController;

// 主页
class HomepageController extends Controller
{
    // protected $company_id = 1;//默认公司id

    // 发送验证码
    public function sendVerifyCode(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->phoneValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查看技师手机号相关信息
        $find_tech = DB::table('technician as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
            ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
            ->where('a.tech_phone', $request['phone'])
            ->where('a.tech_audit_state', '<>' ,3)
            ->select('tech_id', 'tech_state', 'tech_chan_id', 'com_stase', 'chan_state')
            ->first();              
        // 判断是否是技师手机号
        if (empty($find_tech)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是技师手机号']);
        }
        // 判断技师账号是否停用
        if ($find_tech['tech_state'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师已停用']);
        }
        if ($find_tech['tech_chan_id'] > 0 ) {
            if ($find_tech['chan_state'] != 1) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师所属渠道商已停用']);
            }
        }
        if ($find_tech['com_stase'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师所属品牌商已停用']);
        }

        $code = mt_rand(100000, 999999);//生成六位验证码
        $message = "您的登录验证码为{$code}，有效时间十分钟。";//短信信息
        $now_time = date('Y-m-d H:i:s');
        $phc_data['phc_phone'] = $request['phone'];
        $phc_data['phc_code'] = $code;
        $phc_data['phc_type'] = 1;
        $phc_data['phc_creacttime'] = $now_time;
        $phc_data['phc_expirationtime'] = date('Y-m-d H:i:s', strtotime($now_time) + 600);//过期时间

        // 查看是否发送验证码
        $find_phone_code = DB::table('phone_code')->where('phc_phone', $request['phone'])
                    ->select('phc_id', 'phc_code', 'phc_type', 'phc_expirationtime')->first();
        if ($find_phone_code) {
            if ($find_phone_code['phc_type'] == 1 && $find_phone_code['phc_expirationtime'] > date('Y-m-d H:i:s')) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'短信验证码已发送，十分钟内到期。']);
            } else {
                $send_res = sendSmsCode($request['phone'], $message);
                $phc_data['phc_send_code'] = $send_res;//短信发送返回值
                $phc_res = DB::table('phone_code')->where('phc_id', $find_phone_code['phc_id'])->update($phc_data);
            }
        } else {
            $send_res = sendSmsCode($request['phone'], $message);
            $phc_data['phc_send_code'] = $send_res;//短信发送返回值
            $phc_res = DB::table('phone_code')->insert($phc_data);
        }

        if ($phc_res) {
            Coperationa::addTechnician($find_tech['tech_id'], $request->getClientIp(), '技师登录', '发送验证码', '发送验证码：'.$code.'成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'验证码发送成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码发送失败']);
        }
    }

    // 登录
    public function login(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->loginValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 判断验证码是否正确
        $find_phone_code = DB::table('phone_code')
            ->where('phc_phone', $request['phone'])
            ->where('phc_code', $request['code'])
            ->select('phc_id', 'phc_type', 'phc_expirationtime')
            ->first();
        if (empty($find_phone_code)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'验证码错误']);
        }
        if ($find_phone_code['phc_type'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已使用，请重新获取验证码']);
        }
        if ($find_phone_code['phc_expirationtime'] < date('Y-m-d H:i:s')) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前验证码已过期失效，请重新获取验证码']);
        }
        // 更改验证码状态
        DB::table('phone_code')->where('phc_id', $find_phone_code['phc_id'])->update(['phc_type'=>2]);

        // 查询操作技师的信息
        $find_tech = DB::table('technician as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
            ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
            ->where('a.tech_phone', $request['phone'])
            ->where('a.tech_audit_state', '<>' ,3)
            ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name')
            ->first();
        if (empty($find_tech)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'非系统账号，请先注册账号']);
        }
        // 查询操作技师是否通过审核
        $find_techs = DB::table('technician as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
            ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
            ->where('a.tech_phone', $request['phone'])
            ->where('a.tech_audit_state', '<>' ,1)
            ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name')
            ->first();
        if (empty($find_techs)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前账号未审核']);
        }
        // 返回数据
        $data['api_token'] = webCreateToken($find_tech['tech_id']);
        $data['userid'] = $find_tech['tech_id'];
        $data['user_name'] = $find_tech['tech_name'];
        $data['integral'] = $find_tech['tech_integral'];
        $data['phone'] = $find_tech['tech_phone'];
        $data['enterprise_name'] = $find_tech['tech_chan_id'] == 0 ? $find_tech['com_name'] : $find_tech['chan_enterprise_name'];
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
    }

    // 退出
    public function quit(Request $request)
    {
        $tech_data['tech_openid'] = '';
        $tech_data['tech_updatetime'] = date('Y-m-d H:i:s');
        // 清空当前技师的openid
        $openid = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->update($tech_data);
        if ($openid) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'退出成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'退出失败']);
        }
    }

    // 获取渠道商信息
    public function getChannels(Request $request)
    {
        $find_data = DB::table('channels')
            // ->where('chan_cid', $this->company_id)
            ->where('chan_cid', $request['tech_cid'])
            ->select('chan_id', 'chan_enterprise_name')
            ->get();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_data]);
    }

    // 注册
    public function register(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->registerValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        
        // 判断技师是否已注册
        /*$identity_card = DB::table('technician')
            ->where('tech_identity_card', $request['tech_identity_card'])
            ->where('tech_audit_state', '<>' ,3)
            ->select('tech_id')->first(); 
        if (!empty($identity_card)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师已注册']);
        }*/
        
        $phone = DB::table('technician')
            ->where('tech_phone', $request['tech_phone'])
            ->where('tech_audit_state', '<>' ,3)
            ->select('tech_id')->first();
        if (!empty($phone)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'手机号已存在']);
        }

        $data = $request->all();
        // $data['tech_cid'] = $this->company_id;//公司id
        $data['tech_cid'] = '748';//$request['tech_cid'];//公司id
		$find_data = DB::table('channels')
            ->where('chan_cid', '748')
			->where('chan_enterprise_name', $request['tech_employer_address'])
            ->select('chan_id', 'chan_enterprise_name')
            ->first();
		if($find_data){
		$data['tech_chan_id'] = $find_data['chan_id'];//渠道id
		}
		
        $res = DB::table('technician')->insert($data);
        if ($res) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'注册成功，请等待审核通过']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'注册失败，请重新注册']);
        }
    }

    // 积分记录
    public function integralRecord(Request $request)
    {
        // 查询接口，需要验证 api_token，中间件中已经验证过，这里不需要再次验证
        // 兑换记录
        $integral_record = DB::table('technician as a')
            ->leftJoin('integral_record as b', function($join){
                $join->on('a.tech_cid', '=', 'b.inte_cid')
                    ->on('a.tech_chan_id', '=', 'b.inte_chan_id')
                    ->on('a.tech_id', '=', 'b.inte_userid');
            })
            ->where('a.tech_id', $request['userid'])
            ->where('b.inte_type',2)
            ->select('b.inte_content', 'b.inte_addtime', 'b.inte_state', 'b.inte_integral_number', 'b.inte_audit_state')
            ->orderBy('b.inte_id', 'desc')
            ->get();
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$integral_record]);
    }

    // 积分兑换 - 兑换公告
    public function integralExchange(Request $request)
    {
        // 查询接口，需要验证 api_token，中间件中已经验证过，这里不需要再次验证
        // 兑换公告
        $exchange_notice = DB::table('technician as a')
            ->leftJoin('exchange_notice as b', 'b.exno_cid', '=', 'a.tech_cid')
            ->where('a.tech_id', $request['userid'])
            ->select('b.exno_content')
            ->first();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$exchange_notice['exno_content']]);
    }

    // 积分兑换 - 兑换物品
    public function forItems(Request $request)
    {
        // 兑换物品
        $foritem = DB::table('technician as a')
            ->leftJoin('for_items as b', 'b.fori_cid', '=', 'a.tech_cid')
            ->where('tech_id', $request['userid'])
            ->where('fori_state',2)
            ->select('fori_id', 'fori_item_name', 'fori_number', 'fori_remain_integral', 'fori_integral_number')
            ->orderBy('fori_id', 'desc')
            ->get();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$foritem]);
    }

    // 积分兑换
    public function reduceIntegral(Request $request)
    {
    	// 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->reduceIntegralValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 查询操作技师的信息
        $tech_data = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->select('tech_name', 'tech_cid','tech_id', 'tech_chan_id', 'tech_phone', 'tech_integral')
            ->first();
		 // 查询操作技师待审核积分
        $inte_data = DB::table('integral_record')
            ->where('inte_userid', $tech_data['tech_id'])
			->where('inte_audit_state', '1')
			->where('inte_state', '2')
            ->select('inte_id', 'inte_integral_number')
            ->first();
		if ($inte_data) {
            return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'已有待审核红包']);
        }
        // 剩余积分
        $forr = DB::table('for_items')
            ->where(['fori_id'=>$request['fori_id']])
            ->select('fori_id', 'fori_item_name', 'fori_integral_number', 'fori_number', 'fori_remain_integral')
            ->first();
        if (!$forr['fori_id']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前物品已下架']);
        }
        $remain_integral = $tech_data['tech_integral'] - $forr['fori_integral_number'];
        if ($remain_integral<0) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'消耗积分值超过剩余积分值']);
        }

        if ($forr['fori_remain_integral'] <= 0) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前物品已兑换完']);
        }

        DB::beginTransaction();
        // 技师积分减少
        // $update_data['tech_integral'] = $remain_integral;
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->update($update_data);
        //物品数量减少
        $update_dates['fori_remain_integral'] = $forr['fori_remain_integral'] - 1;
        $fori_res = DB::table('for_items')
            ->where(['fori_id'=>$request['fori_id']])
            ->update($update_dates);
        // 添加积分操作记录
       	$inte_data['inte_cid'] = $tech_data['tech_cid'];                                //公司id
        $inte_data['inte_chan_id'] = $tech_data['tech_chan_id'];                        //渠道id
        $inte_data['inte_userid'] = $request['userid'];                                 //用户id
        $inte_data['inte_user_phone'] = $tech_data['tech_phone'];                       //联系电话
        $inte_data['inte_user_name'] = $tech_data['tech_name'];                         //姓名
        $inte_data['inte_state'] = 2;	                                                //操作类型1增加积分2消耗积分
        $inte_data['inte_integral_number'] = '-'.$forr['fori_integral_number'];         //消耗积分数量
        $inte_data['inte_content'] = '技师兑换['.$forr['fori_item_name'].']减少积分';   //兑换内容
        $inte_data['inte_type'] = 2;
        $inte_data['inte_remain_integral'] = $tech_data['tech_integral'];                          //剩余积分
        $inte_data['inte_operation_id'] = $request['userid'];                           //操作人id
        $inte_data['inte_operation_name'] = $tech_data['tech_name'];                    //操作人姓名
        $inte_data['inte_audit_state'] = 1;                                             //审核状态1待审核2已通过3已驳回
        $inte_data['inte_fori_id'] = $forr['fori_id'];                                  //物品id
        $inte_res = DB::table('integral_record')->insertGetId($inte_data);

        // 添加兑换记录
        $aure_data['aure_cid'] = $tech_data['tech_cid'];	//公司id
        $aure_data['aure_chan_id'] = $tech_data['tech_chan_id'];	//渠道id
        $aure_data['aure_userid'] = $request['userid'];	//用户id
        $aure_data['aure_user_phone'] = $tech_data['tech_phone'];	//联系电话
        $aure_data['aure_user_name'] = $tech_data['tech_name'];	//姓名
        $aure_data['aure_integral_number'] = '-'.$forr['fori_integral_number'];	//消耗积分数量
        $aure_data['aure_content'] = '技师兑换['.$forr['fori_item_name'].']减少积分';	//兑换内容
        $aure_data['aure_type'] = 2;	//1渠道积分2技师积分
        $aure_data['aure_remain_auregral'] = $tech_data['tech_integral'];	//剩余积分
        $aure_data['aure_operation_name'] = $tech_data['tech_name'];	//操作人姓名
        $aure_data['aure_operation_id'] = $request['userid'];	//操作人id
        $aure_data['aure_audit_state'] = 1;	//审核状态1待审核2通过3已驳回
        $aure_data['aure_fori_id'] = $forr['fori_id'];	//物品id
        $aure_data['aure_inte_id'] = $inte_res;  //积分操作id
        $aure_res = DB::table('audit_record')->insert($aure_data);

        if ($tech_res && $inte_res && $fori_res && $aure_res) {
            DB::commit();
            Coperationa::addTechnician($request['userid'], $request->getClientIp(), '积分兑换', '积分兑换', $tech_data['tech_phone'].'账号消耗'.$request['integral_number'].'积分成功');
            return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'积分兑换成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500, 'msg'=>'error', 'data'=>'积分兑换失败']);
        }
    }

    // 获取积分值
    public function getIntegral(Request $request)
    {
        $find_tech = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->select('tech_integral')
            ->first();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$find_tech]);
    }

    // 扫一扫，扫码获取产品码信息
    public function scanCode(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->scanCodeValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        $code_len = strlen($request['code']);

        // 判断二维码的位数
        if (!in_array($code_len,config('common.code_length'))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'非本系统码1']);
        }

        // 查询码所属公司id
        $info_code_id = substr($request['code'],0,5);
        $find_company_info = DB::table('company_info')
            ->where('info_code_id', $info_code_id)
            ->select('info_cid')
            ->first();
        // 查询技师所属公司id
        $find_tech_cid = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->select('tech_cid')
            ->first();
        // 判断技师所属公司与二维码所属公司是否相同
        if ($find_company_info['info_cid'] != $find_tech_cid['tech_cid']) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是同一公司产品码']);
        }

        if ($code_len == 33) {
            // 根据条形码，查询商品id
            $code_data = splitCode($request['code']);
            $gco_gid = DB::table('goods')
                ->where('goo_number', $code_data['bar_code'])
                ->orderBy('goo_id', 'desc')
                ->select('goo_id')
                ->first();
            if (empty($gco_gid)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未查到商品信息']);
            }
        } else {
            $gco_gid = '';
        }
        

        // 查询产品码的商品信息
        $sql = 'SELECT
                    `trace_a`.`gco_group`,
                    `trace_b`.`goo_id`,
                    `trace_b`.`goo_name`,
                    `trace_b`.`goo_number`,
                    `trace_b`.`warranty_day`
                FROM
                    `trace_formwork_code` AS `trace_a`
                LEFT JOIN `trace_goods` AS `trace_b` ON `trace_b`.`goo_id` = `trace_a`.`gco_gid`
                WHERE
                    `trace_a`.`nums` = '.$code_len.'
                AND `trace_a`.`gco_start` <= \''.$request['code'].'\'
                AND `trace_a`.`gco_end` >= \''.$request['code'].'\'
                AND `trace_a`.`gco_gid` != 0
                ORDER BY
                    `trace_a`.`gco_id` DESC
                LIMIT 1';
        $code_goods = DB::select($sql);
        if (empty($code_goods)) {
            // 查询商品信息
            $code_goods = DB::table('group as a')
                ->leftjoin('goods as b', 'b.goo_id', '=', 'a.gro_gid')
                ->where('nums', $code_len)
                ->where('code_start', '<=', $request['code'])
                ->where('code_end', '>=', $request['code'])
                ->select('a.gro_number as gco_group', 'b.goo_id', 'b.goo_name', 'b.goo_number', 'b.warranty_day')
                ->orderBy('gro_id', 'desc')
                ->limit(1)
                ->get();
            if (empty($code_goods)) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'当前码未录入系统']);
            }
        }
        $code_goods = $code_goods[0];

        // 查询生产日期
        $group_data = DB::table('group')
                        ->where('gro_number', $code_goods['gco_group'])
                        ->select('production_date')->first();
        // 查询质保单数据
        $warranty_data = DB::table('warranty')
            ->where('code', $request['code'])
            ->select('warr_content as content', 'warr_expire_time', 'warranty_day', 'warr_tech_name')
            ->first();
        if (empty($warranty_data)) {
            // 没有提交质保单，查询质保单模板
            $warranty_data = DB::table('technician as a')
                ->leftJoin('warranty_table as b', 'b.wata_cid', '=', 'a.tech_cid')
                ->where('tech_id', $request['userid'])
                ->select('wata_content as content')->first();            
            // $expire_time = date('Y-m-d',strtotime($group_data['production_date'].' + '.$code_goods['warranty_day'].' day'));
            if ($group_data['production_date'] != '0000-00-00') {
                $expire_time = date('Y-m-d',strtotime($group_data['production_date'].' + '.$code_goods['warranty_day'].' day'));
            } else {
                $expire_time = '0000-00-00';
            }
            $return_data['warranty_day'] = $code_goods['warranty_day'];
            $return_data['technician'] = '未绑定';
            $return_data['serviced'] = 0;
        } else {
            // 已提交质保单
            $expire_time = $warranty_data['warr_expire_time'];
            $return_data['warranty_day'] = $warranty_data['warranty_day'];
            $return_data['technician'] = $warranty_data['warr_tech_name'];
            $return_data['serviced'] = 1;
        }

        if (empty($warranty_data['content'])) {
            $return_data['wata_type'] = 2;
        } else {
            $return_data['wata_type'] = 1;
        }

        // 返回数据
        $return_data['goo_name'] = $code_goods['goo_name'];
        $return_data['goo_number'] = $code_goods['goo_number'];
        if ($group_data['production_date'] != '0000-00-00') {
            $return_data['production_date'] = date('Y-m-d', strtotime($group_data['production_date']));
        } else {
            $return_data['production_date'] = $group_data['production_date'];
        }
        if ($expire_time != '0000-00-00') {
            $return_data['expire_time'] = date('Y-m-d', strtotime($expire_time));
        } else {
            $return_data['expire_time'] = '0000-00-00';
        }
        // $return_data['expire_time'] = date('Y-m-d', strtotime($expire_time));
        $return_data['gid'] = $code_goods['goo_id'];
        $return_data['wata_content'] = json_decode($warranty_data['content']);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 扫一扫，提交质保信息
    public function subWarrantyInfo(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->subWarrantyInfoValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误33', 'error_message'=>$error_message]);
        }
        $code_len = strlen($request['code']);
        // 判断二维码的位数
        if (!in_array($code_len, config('common.code_length'))) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'非本系统码']);
        }
        /**
         * 处理表单数据
         *  表单json数据字段说明
            {
                "key":"商品编号",//信息名称
                "value":"6922266440090",//信息内容
                "show":1,//1显示2隐藏
                "type":"1",//类型1普通文本2安装时间3联系电话4上传图片
                "required":"1",//是否必填1必填2选填
            }
         */
        $now_time = date('Y-m-d H:i:s');
        if ($request['type'] == 1) {
            foreach ($request['info_name'] as $key => $value) {
                if (empty($value) || !in_array($request['info_show'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2,3,4]) ) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'信息项存在空项']);
                }

                $table_content[$key]['type'] = $request['info_type'][$key];
                // 判断是否显示
                if ($request['info_show'][$key] == 1) {
                    // 判断是否必填
                    if ($request['info_required'][$key] == 1) {
                        // 必填项，内容不能为空
                        if (empty($request['info_content'][$key])) {
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入信息']);
                        }
                    }
                    if ($value == '客户电话') {
                        if(!preg_match("/^1[345678]{1}\d{9}$/", $request['info_content'][$key])){
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入正确手机号']);
                        }
                        $add_data['warr_phone'] = $request['info_content'][$key];
                    }
                }

                // 判断上传类型
                if ($request['info_type'][$key] == 4) {
                    // 上传图片
                    // $uploadPath = uploadBase64Img($request['info_content'][$key]);
                    // if (!$uploadPath) {
                    //     return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'图片上传失败']);
                    // }
                    // $table_content[$key]['value'] = $uploadPath;
                    $table_content[$key]['value'] = $request['info_content'][$key];
                } else {
                    $table_content[$key]['value'] = $request['info_content'][$key];
                }
                $table_content[$key]['key'] = $value;
                $table_content[$key]['show'] = $request['info_show'][$key];
                $table_content[$key]['required'] = $request['info_required'][$key];
            }
            $table_content = json_encode($table_content);
        } else {
            $table_content = '';
        }

        // 获取技师、质保单相关信息
        $find_data = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->select('tech_cid', 'tech_chan_id', 'tech_phone', 'tech_name', 'tech_state', 'tech_policy_number', 'tech_integral', 'tech_mount_number')
            ->first();
        if ($find_data['tech_state'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师已停用']);
        }
        // 商品积分值
        $goods_integral = DB::table('goods')
            ->where('goo_id', $request['gid'])
            ->select('goo_name', 'technician_integral', 'warranty_day')
            ->first();

        DB::beginTransaction();
        // 提交质保表单数据
        $add_data['warr_tech_id'] = $request['userid'];
        $add_data['warr_tech_name'] = $find_data['tech_name'];
        $add_data['warr_number'] = date('YmdHis').rand(100000,999999);
        $add_data['warr_content'] = $table_content;
        $add_data['warr_cid'] = $find_data['tech_cid'];
        $add_data['warr_chan_id'] = $find_data['tech_chan_id'];
        $add_data['code'] = $request['code'];
        $add_data['warr_addtime'] = $now_time;
        $add_data['warr_expire_time'] = date('Y-m-d H:i:s',strtotime($now_time.' + '.$goods_integral['warranty_day'].' day'));
        $add_data['warranty_day'] = $goods_integral['warranty_day'];
        $warranty_res = DB::table('warranty')->insertGetId($add_data);

        // 更改技师积分值、质保单数量
        // $tech_integral = $goods_integral['technician_integral'] + $find_data['tech_integral'];
        $tech_save['tech_policy_number'] = $find_data['tech_policy_number'] + 1;    //质保单数量
        $tech_save['tech_mount_number'] = $find_data['tech_mount_number'] + 1;    //技师安装数量
        // $tech_save['tech_integral'] = $tech_integral;
        $tech_save['tech_updatetime'] = $now_time;
        $tech_res = DB::table('technician')->where('tech_id', $request['userid'])->update($tech_save);

        // 添加积分记录
        $inte_data['inte_cid'] = $find_data['tech_cid'];
        $inte_data['inte_chan_id'] = $find_data['tech_chan_id'];
        $inte_data['inte_chan_id'] = $find_data['tech_chan_id'];
        $inte_data['inte_userid'] = $request['userid'];
        $inte_data['inte_user_phone'] = $find_data['tech_phone'];
        $inte_data['inte_user_name'] = $find_data['tech_name'];
        $inte_data['inte_state'] = 1;
        $inte_data['inte_integral_number'] = $goods_integral['technician_integral'];
        $inte_data['inte_content'] = '技师提交['.$goods_integral['goo_name'].']获取积分';
        $inte_data['inte_type'] = 2;
        $inte_data['inte_remain_integral'] = $find_data['tech_integral'];
        $inte_data['inte_operation_id'] = $request['userid'];
        $inte_data['inte_operation_name'] = $find_data['tech_name'];
        $inte_data['inte_audit_state'] = 1;//审核状态1待审核2已通过3已驳回
        $inte_data['warr_id'] = $warranty_res;//质保单id
        $inte_res = DB::table('integral_record')->insert($inte_data);

        if ($warranty_res && $tech_res && $inte_res) {
            DB::commit();
            Coperationa::addTechnician($request['userid'], $request->getClientIp(), '扫一扫', '提交质保单', '质保单号:'.$add_data['warr_number'].'，提交成功');
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'提交成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'提交失败']);
        }
    }

    // 上传图片
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".time()."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        if(!empty($image))
        {
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/web";
            if (!is_dir($path)){             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'图片上传成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }

    // 获取技师列表
    public function techIndex(Request $request)
    {
        $tech_cid = DB::table('technician')
            ->where('tech_id', $request['userid'])
            ->value('tech_cid');
        $userinfo = DB::table('technician as a')
            ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
            ->where('a.tech_cid', $tech_cid)
            ->where('a.tech_audit_state',2)
            ->select('a.tech_id', 'b.chan_enterprise_name as parent_enterprise_name', 'a.tech_name', 'a.tech_phone', 'a.tech_state', 'a.tech_policy_number', 'a.tech_integral', 'a.tech_addtime', 'a.tech_audit_state', 'a.tech_mount_number')
            ->orderBy('a.tech_mount_number', 'desc')
            ->get();
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$userinfo]);
    }

    // 获取jssdk配置信息
    public function getJSSDK(Request $request)
    {
        // 获取 access_token
       // $url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wx86e66784dc1b808a&secret=030880995267737ff58d2e7915b3aa76';
	   $url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=wxfe958115feceeb23&secret=f6771118aa431ef5ce64684d9a11f946';
        $access_token = $this->curl($url);
        if (empty($access_token['access_token'])) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'获取access_token失败']);
        }

        // 获取 jsapi_ticket
        $jsapi_url = 'https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token='.$access_token['access_token'].'&type=jsapi';
        $jsapi_ticket = $this->curl($jsapi_url, '', 'get');
        if ($jsapi_ticket['errmsg'] != 'ok') {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'获取access_token失败']);
        }

        // 生成签名
        $noncestr =md5(rand(10000000,99999999).'fdafjl');
        $timestamp = time();
        // $string1 = 'jsapi_ticket='.$jsapi_ticket['ticket'].'&noncestr='.$noncestr.'&timestamp='.$timestamp.'&url=http://suyuan41.bluearp.com/wxdist/index.html';
        $string1 = 'jsapi_ticket='.$jsapi_ticket['ticket'].'&noncestr='.$noncestr.'&timestamp='.$timestamp.'&url=https://suyuan.bluearp.com/tdwxdist/index.html';
        $signature = sha1($string1);

        $return_data['appId'] = 'wxfe958115feceeb23';
        $return_data['timestamp'] = $timestamp;
        $return_data['nonceStr'] = $noncestr;
        $return_data['signature'] = $signature;
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$return_data]);
    }

    // 获取code
    public function getCustomerInfo(Request $request)
    {
        // 获取基本信息,网页授权
        $appid = "wxfe958115feceeb23";
        $tech_phone = $request['phone'];    //技师手机号码
        $code = $request['code'];    //验证码
        // 判断验证码是否正确
        $find_phone_code = DB::table('phone_code')
            ->where('phc_phone', $tech_phone)
            ->where('phc_code', $code)
            ->select('phc_id', 'phc_type', 'phc_expirationtime')
            ->first();
        if (empty($find_phone_code)) {
            Header("Location:https://suyuan.bluearp.com/tdwxdist/index.html");
        }

        $callback = 'https://suyuan41.bluearp.com/public/web/getCustomerInfos';   //回调地址
        $res = 'https://open.weixin.qq.com/connect/oauth2/authorize?appid='.$appid.'&redirect_uri='.urlencode( $callback ).'&response_type=code&scope=snsapi_userinfo&state='.$tech_phone.'#wechat_redirect';
        header( "Location:".$res );
    }

    // 获取信息
    public function getCustomerInfos(Request $request)
    {
        $appid = "wxfe958115feceeb23";
        $secret = "f6771118aa431ef5ce64684d9a11f946";

        $code = $_GET['code'];  //获取code
        $phone = $_GET['state'];  //获取手机号

        // 取得openid
        $url = 'https://api.weixin.qq.com/sns/oauth2/access_token?appid='.$appid.'&secret='.$secret.'&code='.$code.'&grant_type=authorization_code';
        $data = $this->curl($url);  //获取openid值

        /**
        * 判断是否有手机号
        * 
        * 手机号不为空,跳转首页
        * 
        * 手机号为空,openid查询到手机号,跳转首页,否则跳转登录页
        *
        * 否则,跳转到登录页
        * 
        * */
        if (empty($phone)) {
            $tech_phones = DB::table('technician')
                ->where('tech_openid', $data['openid'])
                ->select('tech_phone')
                ->first();
            if ($tech_phones) {
				Header("Location:https://suyuan.bluearp.com/tdwxdist/index.html#/home?phone=".$tech_phones['tech_phone']);
            } else {
                Header("Location:https://suyuan.bluearp.com/tdwxdist/index.html?types=1");
            }
        } else {
            // 清空openid值
            $tech_openid = "";
            $tech_openid = DB::table("technician")
                ->where('tech_openid', $data['openid'])
                ->update(['tech_openid'=>$tech_openid]);
            // 获取验证码,在技师表保存openid
            $tech_data = DB::table('technician')
                ->where('tech_phone', $phone)
                ->update(['tech_openid'=>$data['openid']]);
            Header("Location:https://suyuan.bluearp.com/tdwxdist/index.html#/home?phone=".$phone);
        }
    }

    // 获取token值
    public function getTokens(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyHomepageController;
        $error_message = $verify_data->loginValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查询操作技师的信息
		if($request['phone']=='okwMF1ScFAvh3EgLjWaOsDN-rziw'){
    		$find_tech = DB::table('technician as a')
                ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
                ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
                ->where('a.tech_openid', $request['phone'])
                ->where('a.tech_audit_state', '<>' ,3)
                ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name')->first();
		}else{
    		$find_tech = DB::table('technician as a')
                ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
                ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
                ->where('a.tech_phone', $request['phone'])
                ->where('a.tech_audit_state', '<>' ,3)
                ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name')->first();
		}
        
        if (empty($find_tech)) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非系统账号，请先注册账号']);
        }
        // 查询操作技师是否通过审核
		if($request['phone']=='okwMF1ScFAvh3EgLjWaOsDN-rziw'){
    		$find_techs = DB::table('technician as a')
                ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
                ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
                ->where('a.tech_openid', $request['phone'])
                ->where('a.tech_audit_state', '<>' ,1)
                ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name', 'tech_openid')
                ->first();
		}else{
    		$find_techs = DB::table('technician as a')
                ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
                ->leftJoin('company as c', 'c.com_id', '=', 'a.tech_cid')
                ->where('a.tech_phone', $request['phone'])
                ->where('a.tech_audit_state', '<>' ,1)
                ->select('tech_id', 'tech_chan_id', 'tech_name', 'tech_integral', 'tech_phone', 'chan_enterprise_name', 'com_name', 'tech_openid')
                ->first();
		}
        
        if (empty($find_techs)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前账号未审核']);
        }
        
        // 返回数据
        $data['api_token'] = webCreateToken($find_tech['tech_id']);
        $data['userid'] = $find_tech['tech_id'];
        $data['user_name'] = $find_tech['tech_name'];
        $data['integral'] = $find_tech['tech_integral'];
        $data['phone'] = $find_tech['tech_phone'];
        $data['enterprise_name'] = $find_tech['tech_chan_id'] == 0 ? $find_tech['com_name'] : $find_tech['chan_enterprise_name'];
		return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$data]);
        
    }

    /**
    * function：链接访问curl方法
    * 
    * */
    public function curl($url, $data = NULL, $type = 'post', $header = NULL, $timeout = '10'){
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        // curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        if ($type == 'post') {
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        $output = curl_exec($curl);
        curl_close($curl);
        return json_decode($output, true);
    }
}
