<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\VerifyCodeController;
/**
 * 终端页面接口
 */
class LookController extends Controller
{
    public function GetInfo(Request $request)
    {
        if (!isset($request['funnumber']) || empty($request['funnumber'])) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
        }
        $actionName = array(
            'GetInfo', 'getGoodsInfo', 'Goodsdata', 'getSourceInfo','getTraceabilityInfo','getEnvironmentInfo','preventforge','warranty','warrantys','subwarranty',
            'getWarehouse',
        );
        if (in_array($request['funnumber'], $actionName)) {
            return $this->$request['funnumber']($request,2);
        } else {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请求方法不存在']);
        }
    }
    // 获取商品信息接口
    public function getGoodsInfo(Request $request)
    {
        $code = $request->input('code',null);
        $time = (int)$request->input('time',0);
        $address['province'] = $request->input('province','未知');
        $address['city'] = $request->input('city','未知');
        $address = $this->check_address($address);
        $code_id = substr($code,0,5);   //产品码
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'非本系统所属的二维码']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null) {
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $table_name = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($table_name['code'] == 500) {
                return response()->json($table_name);
            }
            // 获取二维码数据
            $table = $table_name['data'];
            $vtiger = DB::connection('mysql_two');
            $code_data = $vtiger->table($table."_code")->where(['gco_number'=>$code])->first(['gco_codeid as table','gco_number','gco_temstr as gco_trace','gco_group','gco_gid','gco_coderegid as region_id','gco_cid']);
            if (empty($code_data['gco_gid'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该二维码未绑定商品']);
            }
            // 获取二维码量
            $num=Db::table('group')->where(['gro_number'=>$code_data['gco_group']])->value('gro_num');
            // 因为每次前端前进后退都请求此接口 _info表会不停的添加数据
            if($time == 1){
               $res_data = $this->logicHandle($code_data,$address,$num,$code);
            }
            //获取商品数据
            $goods_data=DB::table('goods')->where('goo_id',$code_data['gco_gid'])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_navid','goo_cid','goo_id','goo_nutrient_content']);
            if($goods_data['goo_picurl']!=''){
                $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            }else{
                $goods_data['goo_picurl']=[];
            }
            //获取导航数据
            $nav_data=Db::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_icon');
            $nav_data=json_decode($nav_data,true);
            foreach ($nav_data as $key => $val) {
                //2 展示  1 隐藏
                if($val['show']===1 || $val['show']=== false){
                    unset($nav_data[$key]);
                }
            }
            // 获取栏目设置
            $nav_column_setup = DB::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_column_setup');
            // 获取是否开启验证
            $gro_data = DB::table('group')->where('gro_number',$code_data['gco_group'])->pluck('gro_validation');
            if ($gro_data === 0) {
                foreach ($nav_data as $key => $val) {
                    //2 展示  1 隐藏
                    if (isset($val['type'])) {
                        //2 展示  1 隐藏
                        if($val['type']==='3'){
                            unset($nav_data[$key]);
                        }
                    }else{
                        //2 展示  1 隐藏
                        if($val['icon_type']==='3'){
                            unset($nav_data[$key]);
                        }
                    }
                }
            }
            // 获取发布状态
            $gro_release = DB::table('group')->where('gro_number',$code_data['gco_group'])->value('gro_release');
            // 查询真伪是否开启,开启的是计次防伪还是真伪序列
            $gro_validation = DB::table('group')->where('gro_number',$code_data['gco_group'])->value('gro_validation');
            //获取公司logo
            $logo=Db::table('company')->where(['com_id'=>$goods_data['goo_cid']])->first(['com_logo','com_name']);
            //判断是否是原有数据
            if($nav_column_setup != '0'){
                $arraystr=$this->for_navigation($request,$nav_data,$code_data,$code);
                $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'nav_column_setup'=>$nav_column_setup,'arraystr'=>$arraystr,'gro_validation'=>$gro_validation]];
                return response()->json($res);
            }
            $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'nav_column_setup'=>$nav_column_setup,'gro_validation'=>$gro_validation]];
            return response()->json($res);
        }
        // 验证产品码是否正确
        $code = VerifyCodeController::validator(trim($code));
        if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'非本系统所属的二维码']);
        }
        // 获取二维码数据
        $code_data = DB::table('formwork_code')
            ->where('gco_start', '<=', $code)
            ->where('gco_end', '>=' ,$code)
            ->where('gco_gid','!=',0)->limit(1)
            ->get(['gco_number','gco_temstr as gco_trace','gco_group','gco_start','gco_end','gco_gid','gco_coderegid as region_id','gco_cid','gco_info','gco_icon']);
        if (!$code_data) {
            $code_data = DB::table('group')->where('code_start','<=',$code)->where('code_end','>=',$code)->first(['gro_id','gro_gid','gro_number','code_start','code_end']);
            if (empty($code_data['gro_gid'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该二维码未绑定商品']);
            }
            // 获取商品数据
            $goods_data = DB::table('goods')->where(['goo_id'=>$code_data['gro_gid']])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_navid','goo_cid','goo_id','goo_nutrient_content']);
            if (!empty($goods_data['goo_picurl'])) {
                $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            }else{
                $goods_data['goo_picurl']=[];
            }
            //获取导航数据
            $nav_data=Db::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_icon');
            $nav_data=json_decode($nav_data,true);
            // 获取栏目设置
            $nav_column_setup = DB::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_column_setup');
            $nav_id = DB::table('navigation')->where('nav_id',$goods_data['goo_navid'])->select('nav_id')->first();
            // 获取发布状态
            $gro_release = DB::table('group')->where('gro_number',$code_data['gro_number'])->value('gro_release');
            // 查询真伪是否开启,开启的是计次防伪还是真伪序列
            $gro_validation = DB::table('group')->where('gro_number',$code_data['gro_number'])->value('gro_validation');
            // 查询防伪预警是否关闭
            $total_status = DB::table('info_total')->where('total_code',$code)->value('total_status');
            // 查询技师表单设置是否开启
            $wata_stase = DB::table('warranty_table as w')
            ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
            ->where('info_code_id',$code_id)
            ->value('wata_stase');
            // 判断消费者质保单列表是否开启
            $watas_stase = DB::table('warrantys_table as ws')
            ->leftjoin('company_info as ci','ci.info_cid','=','ws.watas_cid')
            ->where('info_code_id',$code_id)
            ->value('watas_stase');
            //获取公司logo
            $logo=Db::table('company')->where(['com_id'=>$goods_data['goo_cid']])->first(['com_logo','com_name']);
            // _info
            $cin_codeid = DB::table('base_info')
                ->where('cin_codeid',$code)
                ->value('cin_codeid');
            if (empty($cin_codeid)) {
                $info_data=['cin_gooid'=>$code_data['gro_gid'],'cin_codeid'=>$code,'cin_provin'=>$address['province'],'cin_city'=>$address['city'],'cin_ip'=>$_SERVER['REMOTE_ADDR'],'cin_time'=>date('Y-m-d H:i:s')];
                Db::table("base_info")->insert($info_data);
            }
            //获取导航绑定的溯源数据
            $source_data=json_decode($code_data[0]['gco_icon'],true);
            //判断是否是原有数据
            if($nav_column_setup != '0'){
                $arraystr=$this->for_navigation($request,$nav_data,$code_data,$code);
                $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'gro_validation'=>$gro_validation,'total_status'=>$total_status,'wata_stase'=>$wata_stase,'watas_stase'=>$watas_stase,'nav_column_setup'=>$nav_column_setup,'arraystr'=>$arraystr,'nav_id'=>$nav_id,'source_data'=>$source_data]];
                return response()->json($res);
            }
            $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'gro_validation'=>$gro_validation,'total_status'=>$total_status,'wata_stase'=>$wata_stase,'watas_stase'=>$watas_stase,'nav_column_setup'=>$nav_column_setup,'nav_id'=>$nav_id,'source_data'=>$source_data]];
            return response()->json($res);
        }else{
            $num = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->orderBy('gro_id','desc')->value('gro_num');
            // 因为每次前端前进后退都请求此接口 _info表会不停的添加数据
            if($time == 1){
               $res_data = $this->logicHandle($code_data,$address,$num,$code);
            }
            $goods_data = DB::table('goods')->where('goo_id',$code_data[0]['gco_gid'])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_navid','goo_cid','goo_id','goo_nutrient_content']);
            if (!empty($goods_data['goo_picurl'])) {
                $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            }else{
                $goods_data['goo_picurl']=[];
            }
            //获取导航数据
            $nav_data=Db::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_icon');
            $nav_data=json_decode($nav_data,true);
            $nav_id = DB::table('navigation')->where('nav_id',$goods_data['goo_navid'])->select('nav_id')->first();
            // 获取栏目设置
            $nav_column_setup = DB::table('navigation')->where('nav_id',$goods_data['goo_navid'])->pluck('nav_column_setup');
            // 查询真伪是否开启,开启的是计次防伪还是真伪序列
            $gro_validation = DB::table('group')->where('gro_number',$code_data[0]['gco_group'])->value('gro_validation');
            // 查询技师表单设置是否开启
            $wata_stase = DB::table('warranty_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                ->where('info_code_id',$code_id)
                ->value('wata_stase');
            // 判断消费者质保单列表是否开启
            $watas_stase = DB::table('warrantys_table as ws')
                ->leftjoin('company_info as ci','ci.info_cid','=','ws.watas_cid')
                ->where('info_code_id',$code_id)
                ->value('watas_stase');
            // 获取发布状态
            $gro_release = DB::table('group')->where('gro_number',$code_data[0]['gco_group'])->value('gro_release');
            $total_status = DB::table('info_total')->where('total_code',$code)->value('total_status');
            //获取公司logo
            $logo=Db::table('company')->where(['com_id'=>$goods_data['goo_cid']])->first(['com_logo','com_name']);
            //获取导航绑定的溯源数据
            $source_data=json_decode($code_data[0]['gco_icon'],true);
            if($nav_column_setup != '0'){
                $arraystr=$this->for_navigation($request,$nav_data,$code_data,$code);
                $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'gro_validation'=>$gro_validation,'total_status'=>$total_status,'wata_stase'=>$wata_stase,'watas_stase'=>$watas_stase,'nav_column_setup'=>$nav_column_setup,'arraystr'=>$arraystr,'nav_id'=>$nav_id,'source_data'=>$source_data]];
                return response()->json($res);
            }
            $res=['code'=>200,'msg'=>'success','data'=>['goods_name'=>$goods_data['goo_name'],'logo'=>$logo['com_logo'],'company_name'=>$logo['com_name'],'image'=>$goods_data['goo_picurl'],'navigation'=>$nav_data,'gro_release'=>$gro_release,'gro_validation'=>$gro_validation,'total_status'=>$total_status,'wata_stase'=>$wata_stase,'watas_stase'=>$watas_stase,'nav_column_setup'=>$nav_column_setup,'gco_temstr'=>$code_data[0]['gco_trace'],'gco_info'=>$code_data[0]['gco_info'],'nav_id'=>$nav_id,'source_data'=>$source_data]];
            return response()->json($res);
        }
    }
    public function for_navigation(Request $request,$nav_data,$code_data,$code)
    {
        if ($nav_data == NULL){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'']);
        }
        //$arraystr['navigation'] = $nav_data;
        foreach ($nav_data as $key => $val) {
            $content = is_array($val['content']);
            if($content == true){
                $fom_lab = array_unique($val['content']['fom_lab']);
                foreach($fom_lab as $kk=>$vv){
                    if($vv == '5'){
                        //溯源信息
                        $arraystr['source'][]=json_decode($this->getSourceInfo($request,1),true);
                        $arraystr['source'] = $arraystr['source'][0];
                    }elseif($vv == '4'){
                        //环境信息
                        $arraystr['env'][]=json_decode($this->getEnvironmentInfo($request,1),true);
                        $arraystr['env'] = $arraystr['env'][0];
                    }elseif($vv == '3'){
                        //质保
                        $code_id = substr($code,0,5);   //产品码
                        // 查询技师表单设置是否开启
                        $wata_stase = DB::table('warranty_table as w')
                            ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                            ->where('info_code_id',$code_id)
                            ->value('wata_stase');
                        // 判断消费者质保单列表是否开启
                        $watas_stase = DB::table('warrantys_table as ws')
                            ->leftjoin('company_info as ci','ci.info_cid','=','ws.watas_cid')
                            ->where('info_code_id',$code_id)
                            ->value('watas_stase');
                        if($wata_stase == '2' && $watas_stase == '2'){
                            $arraystr['guarantee'][]=json_decode($this->warranty($request,1),true);
                            $arraystr['guarantee'] = $arraystr['guarantee'][0];
                        }
                    }elseif($vv == '2'){
                        //真伪
                        // 查询真伪是否开启,开启的是计次防伪还是真伪序列
                        /*if (isset($code_data[0]['gco_group'])){
                            $gro_validation = DB::table('group')->where('gro_number',$code_data[0]['gco_group'])->value('gro_validation');
                            if($gro_validation == '1'){
                                $arraystr['preventforge'][]=json_decode($this->preventforge($request,1),true);
                                $arraystr['preventforge'] = $arraystr['preventforge'][0];
                            }
                        }else{
                            $gro_validation = DB::table('group')->where('gro_number',$code_data['gro_number'])->value('gro_validation');
                            if($gro_validation == '1'){
                                $arraystr['preventforge'][]=json_decode($this->preventforge($request,1),true);
                                $arraystr['preventforge'] = $arraystr['preventforge'][0];
                            }
                        }*/
                    }elseif($vv == '1'){
                        //商品信息
                        $arraystr['goods'][]=json_decode($this->Goodsdata($request,1),true);
                        $arraystr['goods'] = $arraystr['goods'][0];
                    }else{
                        $arraystr['multi-homed'][] = $val['content'];
                    }
                }
            }else{
                $arraystr['single_link'][] = $val['content'];
            }
        }
        if (isset($arraystr)){
            return $arraystr;
        }
    }
    // 判断一下省市县
    public function check_address($address){
        $address['province']=str_replace(" ","",$address['province']);
        $address['city']    =str_replace(" ","",$address['city']);
        if(empty($address['province']) || $address['province']=='provin'){
            $address['province']='未知';
        }
        if(empty($address['city']) || $address['city']=='city'){
            $address['city']='未知';
        }
        return $address;
    }
    // 获取商品数据接口
    public function Goodsdata(Request $request,$type){
        $code =$request->input('code',null);
        if(empty($code)){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'非本系统所属的二维码']);
        }
        if(!is_numeric($code) || strpos($code,'.')){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'非本系统所属的二维码']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null){
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $table_name = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($table_name['code'] == 500) {
                return response()->json($table_name);
            }
            //获取二维码数据
            $table=$table_name['data'];
            $vtiger = DB::connection('mysql_two');
            $code_data=$vtiger->table($table."_code")->where(['gco_number'=>$code])->first(['gco_codeid as table','gco_number','gco_temstr as gco_trace','gco_group','gco_gid','gco_coderegid as region_id']);

            if(empty($code_data['gco_gid'])){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该二维码未绑定商品']);
            }

            //获取商品数据
            $goods_data=Db::table('goods')->join('goo_classifi','goo_classifi','=','cla_id')->where(['goo_id'=>$code_data['gco_gid']])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_cid','cla_name','goo_nutrient_content']);
            $goo_pro=json_decode($goods_data['goo_pro'], true);
            foreach($goo_pro as $k=>$v){
                $goo_pro[$k]['value']=str_replace("&","",$goo_pro[$k]['value']);
            }
            $goods_data['goo_pro']=$goo_pro;
            $goo_nutrient_content = json_decode($goods_data['goo_nutrient_content'],true);
            if ($goo_nutrient_content != '') {
                foreach ($goo_nutrient_content as $key => $value) {
                    $goo_pro[$key]['value'] = str_replace("&","",$goo_nutrient_content[$key]['value']);
                }
            }
            $goods_data['goo_nutrient_content'] = $goo_nutrient_content;
            $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            if($type == "1"){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$goods_data;
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$goods_data]);
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }

        // 获取二维码数据
        $code_data = DB::table('formwork_code')->where('gco_start', '<=', $code)->where('gco_end', '>=' ,$code)->where('gco_gid','!=',0)->orderBy('gco_id','desc')->first(['gco_number','gco_temstr as gco_trace','gco_group','gco_start','gco_end','gco_gid','gco_coderegid as region_id','gco_cid']);
        if (!$code_data) {
            $code_data = DB::table('group')->where('code_start','<=',$code)->where('code_end','>=',$code)->first(['gro_id','gro_gid','gro_number','code_start','code_end']);
            if (empty($code_data['gro_gid'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该二维码未绑定商品']);
            }
            //获取商品数据
            $goods_data=Db::table('goods')->join('goo_classifi','goo_classifi','=','cla_id')->where(['goo_id'=>$code_data['gro_gid']])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_cid','cla_name','goo_nutrient_content']);
            $goo_pro=json_decode($goods_data['goo_pro'], true);
            foreach($goo_pro as $k=>$v){
                $goo_pro[$k]['value']=str_replace("&","",$goo_pro[$k]['value']);
            }
            $goods_data['goo_pro']=$goo_pro;
            $goo_nutrient_content = json_decode($goods_data['goo_nutrient_content'],true);
            if ($goo_nutrient_content != '') {
                foreach ($goo_nutrient_content as $key => $value) {
                    $goo_pro[$key]['value'] = str_replace("&","",$goo_nutrient_content[$key]['value']);
                }
            }
            $goods_data['goo_nutrient_content'] = $goo_nutrient_content;
            $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            if($type == "1"){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$goods_data;
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$goods_data]);
            }
        }else{
            //获取商品数据
            $goods_data=Db::table('goods')->join('goo_classifi','goo_classifi','=','cla_id')->where(['goo_id'=>$code_data['gco_gid']])->first(['goo_name','goo_number','goo_picurl','goo_pro','goo_cid','cla_name','goo_nutrient_content']);
            $goo_pro=json_decode($goods_data['goo_pro'], true);
            foreach($goo_pro as $k=>$v){
                $goo_pro[$k]['value']=str_replace("&","",$goo_pro[$k]['value']);
            }
            $goods_data['goo_pro']=$goo_pro;
            $goo_nutrient_content = json_decode($goods_data['goo_nutrient_content'],true);
            if ($goo_nutrient_content != '') {
                foreach ($goo_nutrient_content as $key => $value) {
                    $goo_pro[$key]['value'] = str_replace("&","",$goo_nutrient_content[$key]['value']);
                }
            }
            $goods_data['goo_nutrient_content'] = $goo_nutrient_content;
            $goods_data['goo_picurl']=explode(',',$goods_data['goo_picurl']);
            if($type=="1"){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$goods_data;
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$goods_data]);
            }
        }
    }
    // 获取溯源信息
    public function getSourceInfo(Request $request,$type)
    {
        $code = $request->input('code',null);
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null) {
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $table_name = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($table_name['code'] == 500) {
                return response()->json($table_name);
            }
            // 获取二维码数据
            $table = $table_name['data'];
            $vtiger = DB::connection('mysql_two');
            $result = $vtiger->table($table."_code")->where('gco_number',$code)->first(['gco_id','gco_gid','gco_temstr','gco_group','gco_op_id']);
            $group_id = DB::table('2019_code')
                ->where('code',$code)
                ->first(['group_id','transport_chain']);
            $group = DB::table('group')
                ->where('gro_id',$group_id['group_id'])
                ->first(['gro_number']);
            if ($result) {
                //获取批次信息
                $temstr = DB::table("group")->where("gro_number",$result['gco_group'])->first(['gro_release']);
                if ($temstr['gro_release'] == '1') {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码未发布']);
                }
                unset($temstr);
                //获取字段类型
                $gco_op_id = trim($result['gco_op_id'],',');
                $opresu = DB::table('base_op')->whereIn("id",array($gco_op_id))->get();
                foreach ($opresu as $k => $v) {
                    $temarr = explode(",",trim($v['form_id'],","));
                    foreach ($temarr as $kk => $vv) {
                        $temarray[$vv]['time'] = $v['op_date'];
                        $temarray[$vv]['admin'] = $v['op_man'];
                    }
                }
                $arrd =  preg_replace('#,{2,}#',',', $result['gco_temstr']);
                $arr1 = explode(",",trim($arrd,","));
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                $chan = DB::table('transport')->whereIn('channel_id_to',$transport_chain)->first(['channel_name_to','add_time','admin_name','company_id']);
                $list = DB::table('formwork as f')
                            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                            ->whereIn('fom_id',$arr1)
                            ->where('fom_stase','!=',3)
                            ->get(['fom_id','fom_title as title','fom_content as content','lab_name','lab_picurl','fom_picurl','fom_label']);
                $i = 0;
                foreach ($list as $k => $v) {
                    $array[$i]['fom_id'] = $v['fom_id'];
                    $array[$i]['title'] = $v['title'];
                    $array[$i]['lab_name'] = $v['lab_name'];
                    $array[$i]['lab_picurl'] = $v['lab_picurl'];
                    $array[$i]['fom_picurl']=explode(',',$v['fom_picurl']);
                    $soures = json_decode($v['content'], true);
                    foreach ($soures as $kk => $vv) {
                        if ($vv['type'] == "4") {          
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['time'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['time'];
                                    }
                                }
                            }
                        }elseif ($vv['type'] == "3") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['admin'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['admin'];
                                    }
                                }
                            }
                        } elseif ($vv['type'] == "1") {
                            $soures[$kk]['value'] =  $code;
                        } elseif ($vv['type'] == "7") {
                            $soures[$kk]['value'] = str_replace("\n", "<br/>", $vv['value']);
                        }
                    }
                    $array[$i]['content'] = $soures;
                    $i++;
                }
                unset($list);
                if (isset($array)) {
                    if($type == '1'){
                        $arr=array();
                        $arr['code']="200";
                        $arr['msg']="success";
                        $arr['data']=$array;
                        // $arr['chan']=$chan;
                        return json_encode($arr);
                    }else{
                        return response()->json(['code'=>200,'msg'=>'success','data'=>$array]);
                    }
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'未找到产品码']);
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 获取二维码数据
        $result = DB::table('formwork_code')
            ->where('gco_start','<=',$code)
            ->where('gco_end','>=',$code)
            ->orderBy('gco_id','desc')
            ->get(['gco_id','gco_gid','gco_temstr','gco_group','gco_start','gco_end','gco_op_id','gco_info']);
        $group_id = DB::table('2019_code')
            ->where('code',$code)
            ->first(['group_id','transport_chain']);
        $group = DB::table('group')
            ->where('gro_id',$group_id['group_id'])
            ->first(['gro_number']);
        if ($result) {
            $i="0";
            $j = "0";
            foreach ($result as $key => $value) {
                //获取批次信息
                $temstr = DB::table("group")->where("gro_number",$value['gco_group'])->first(['gro_release']);
                if ($temstr['gro_release'] == '1') {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码未发布']);
                }
                unset($temstr);
                $arr1=explode(",",trim($value['gco_temstr'],","));
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                //$chan = DB::table('channels')->whereIn("chan_id",$transport_chain)->get(['chan_id','chan_parent_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
                // $chan = DB::table('transport')->whereIn('channel_id_to',$transport_chain)->orderBy('id','desc')->first(['channel_name_to','add_time','admin_name','company_id']);
                //获取字段类型
                $gco_op_id = trim($value['gco_op_id'],',');
                $opresu = DB::table('base_op')->whereIn("id",array($gco_op_id))->get();
                foreach ($opresu as $k => $v) {
                    $temarr = explode(",",trim($v['form_id'],","));
                    foreach ($temarr as $kk => $vv) {
                        $temarray[$vv]['time'] = $v['op_date'];
                        $temarray[$vv]['admin'] = $v['op_man'];
                    }
                }
                DB::connection()->enableQueryLog();#开启执行日志
                //溯源信息// 多个溯源组合到一起
                $list = DB::table('formwork as f')
                            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                            ->whereIn('fom_id',$arr1)
                            ->where('fom_stase','!=',3)
                            ->get(['fom_id','fom_title as title','fom_content as content','lab_name','lab_picurl','fom_picurl','fom_label']);
                foreach ($list as $k => $v) {
                    $array[$i]['fom_id'] = $v['fom_id'];
                    $array[$i]['title'] = $v['title'];
                    $array[$i]['lab_name'] = $v['lab_name'];
                    $array[$i]['lab_picurl'] = $v['lab_picurl'];
                    $array[$i]['fom_label'] = $v['fom_label'];
                    $array[$i]['fom_picurl']=explode(',',$v['fom_picurl']);
                    $soures = json_decode($v['content'], true);
                    foreach ($soures as $kk => $vv) {
                        if ($vv['type'] == "4") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['time'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['time'];
                                    }
                                }
                            }
                        }elseif ($vv['type'] == "3") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['admin'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['admin'];
                                    }
                                }
                            }
                        } elseif ($vv['type'] == "1") {
                            $soures[$kk]['value'] =  $code;
                        } elseif ($vv['type'] == "7") {
                            $soures[$kk]['value'] = str_replace("\n", "<br/>", $vv['value']);
                        }
                    }
                    $array[$i]['content'] = $soures;
                    $i++;
                }
                
                $lists = DB::table('form_label as fl')
                    ->leftjoin('formwork as f','fl.lab_id','=','f.fom_label')
                    ->whereIn('fom_id',$arr1)
                    ->where('lab_stase','!=',2)
                    ->groupBy('lab_id')
                    ->get(['lab_id','lab_name','lab_picurl']);
                foreach ($lists as $key => $value) {
                    $arrays[$j]['lab_id'] = $value['lab_id'];
                    $arrays[$j]['lab_name'] = $value['lab_name'];
                    $arrays[$j]['lab_picurl'] = $value['lab_picurl'];
                    $j++;
                }
                unset($list);
                unset($lists);
            }
            if (isset($array)) {
                if($type == '1'){
                    $arr=array();
                    $arr['code']="200";
                    $arr['msg']="success";
                    $arr['data']=$array;
                    $arr['arrays']=$arrays;
                    // $arr['chan']=$chan;
                    return json_encode($arr);
                }else{
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$array,'arrays'=>$arrays]);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
            }
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
        }
    }
    // 获取溯源信息
    public function getTraceabilityInfo(Request $request,$type)
    {
        $code = $request->input('code',null);
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }
        if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null) {
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $table_name = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($table_name['code'] == 500) {
                return response()->json($table_name);
            }
            // 获取二维码数据
            $table = $table_name['data'];
            $vtiger = DB::connection('mysql_two');
            $result = $vtiger->table($table."_code")->where('gco_number',$code)->first(['gco_id','gco_gid','gco_temstr','gco_group','gco_op_id']);
            $group_id = DB::table('2019_code')
                ->where('code',$code)
                ->first(['group_id','transport_chain']);
            $group = DB::table('group')
                ->where('gro_id',$group_id['group_id'])
                ->first(['gro_number']);
            if ($result) {
                //获取批次信息
                $temstr = DB::table("group")->where("gro_number",$result['gco_group'])->first(['gro_release']);
                if ($temstr['gro_release'] == '1') {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码未发布']);
                }
                unset($temstr);
                //获取字段类型
                $gco_op_id = trim($result['gco_op_id'],',');
                $opresu = DB::table('base_op')->whereIn("id",array($gco_op_id))->get();
                foreach ($opresu as $k => $v) {
                    $temarr = explode(",",trim($v['form_id'],","));
                    foreach ($temarr as $kk => $vv) {
                        $temarray[$vv]['time'] = $v['op_date'];
                        $temarray[$vv]['admin'] = $v['op_man'];
                    }
                }
                $arrd =  preg_replace('#,{2,}#',',', $result['gco_temstr']);
                $arr1 = explode(",",trim($arrd,","));
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                // $chan = DB::table('transport')->whereIn('channel_id_to',$transport_chain)->first(['channel_name_to','add_time','admin_name','company_id']);
                $list = DB::table('formwork as f')
                    ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                    ->whereIn('fom_id',$arr1)
                    ->where('fom_stase','!=',3)
                    ->get(['fom_id','fom_title as title','fom_content as content','lab_name','lab_picurl','fom_picurl','fom_label']);
                $i = 0;
                foreach ($list as $k => $v) {
                    $array[$i]['fom_id'] = $v['fom_id'];
                    $array[$i]['title'] = $v['title'];
                    $array[$i]['lab_name'] = $v['lab_name'];
                    $array[$i]['lab_picurl'] = $v['lab_picurl'];
                    $array[$i]['fom_picurl']=explode(',',$v['fom_picurl']);
                    $soures = json_decode($v['content'], true);
                    foreach ($soures as $kk => $vv) {
                        if ($vv['type'] == "4") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['time'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['time'];
                                    }
                                }
                            }
                        }elseif ($vv['type'] == "3") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['admin'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['admin'];
                                    }
                                }
                            }
                        } elseif ($vv['type'] == "1") {
                            $soures[$kk]['value'] =  $code;
                        } elseif ($vv['type'] == "7") {
                            $soures[$kk]['value'] = str_replace("\n", "<br/>", $vv['value']);
                        }
                    }
                    $array[$i]['content'] = $soures;
                    $i++;
                }
                unset($list);
                if (isset($array)) {
                    if($type == '1'){
                        $arr=array();
                        $arr['code']="200";
                        $arr['msg']="success";
                        $arr['data']=$array;
                        // $arr['chan']=$chan;
                        return json_encode($arr);
                    }else{
                        return response()->json(['code'=>200,'msg'=>'success','data'=>$array]);
                    }
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'未找到产品码']);
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 获取二维码数据
        $result = DB::table('formwork_code')
            ->where('gco_start','<=',$code)
            ->where('gco_end','>=',$code)
            ->orderBy('gco_id','desc')
            ->get(['gco_id','gco_gid','gco_group','gco_start','gco_end','gco_op_id','gco_temstr','gco_info','gco_icon']);
        $group_id = DB::table('2019_code')
            ->where('code',$code)
            ->first(['group_id','transport_chain']);
        $group = DB::table('group')
            ->where('gro_id',$group_id['group_id'])
            ->first(['gro_number']);
        if ($result) {
            $i="0";
            $j = "0";
            foreach ($result as $key => $value) {
                //获取批次信息
                $temstr = DB::table("group")->where("gro_number",$value['gco_group'])->first(['gro_release']);
                if ($temstr['gro_release'] == '1') {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码未发布']);
                }
                unset($temstr);
                // 1、一键发码绑定溯源信息,gco_json有数据
                // 2、创建溯源码,信息维护绑定溯源信息,gco_json没有数据
                if ($value['gco_icon'] == '' && $value['gco_temstr'] == $value['gco_info']) {
                    $arr2=explode(",",trim($value['gco_info'],","));
                }
                if($value['gco_temstr'] == $value['gco_info']) {
                    $arr2="";
                }else{
                    $arr2=explode(",",trim($value['gco_info'],","));
                }
                // $arr2=explode(",",trim($value['gco_info'],","));
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                //$chan = DB::table('channels')->whereIn("chan_id",$transport_chain)->get(['chan_id','chan_parent_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
                // $chan = DB::table('transport')->whereIn('channel_id_to',$transport_chain)->orderBy('id','desc')->first(['channel_name_to','add_time','admin_name','company_id']);
                //获取字段类型
                $gco_op_id = trim($value['gco_op_id'],',');
                $opresu = DB::table('base_op')->whereIn("id",array($gco_op_id))->get();
                foreach ($opresu as $k => $v) {
                    $temarr = explode(",",trim($v['form_id'],","));
                    foreach ($temarr as $kk => $vv) {
                        $temarray[$vv]['time'] = $v['op_date'];
                        $temarray[$vv]['admin'] = $v['op_man'];
                    }
                }
                DB::connection()->enableQueryLog();#开启执行日志
                //溯源信息// 多个溯源组合到一起
                $list = DB::table('formwork as f')
                    ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
                    ->WhereIn('fom_id',$arr2)
                    ->where('fom_stase','!=',3)
                    ->get(['fom_id','fom_title as title','fom_content as content','lab_name','lab_picurl','fom_picurl','fom_label']);
                foreach ($list as $k => $v) {
                    $array[$i]['fom_id'] = $v['fom_id'];
                    $array[$i]['title'] = $v['title'];
                    $array[$i]['lab_name'] = $v['lab_name'];
                    $array[$i]['lab_picurl'] = $v['lab_picurl'];
                    $array[$i]['fom_label'] = $v['fom_label'];
                    $array[$i]['fom_picurl']=explode(',',$v['fom_picurl']);
                    $soures = json_decode($v['content'], true);
                    foreach ($soures as $kk => $vv) {
                        if ($vv['type'] == "4") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['time'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['time'];
                                    }
                                }
                            }
                        }elseif ($vv['type'] == "3") {
                            if (isset($temarray[$v['fom_id']])) {
                                $soures[$kk]['value'] = $temarray[$v['fom_id']]['admin'];
                            }else{
                                foreach($v as $kkk=>$vvv){
                                    if($kkk==$v["fom_id"]){
                                        $soures[$kk]['value'] = $vvv['admin'];
                                    }
                                }
                            }
                        } elseif ($vv['type'] == "1") {
                            $soures[$kk]['value'] =  $code;
                        } elseif ($vv['type'] == "7") {
                            $soures[$kk]['value'] = str_replace("\n", "<br/>", $vv['value']);
                        }
                    }
                    $array[$i]['content'] = $soures;
                    $i++;
                }

                $lists = DB::table('form_label as fl')
                    ->leftjoin('formwork as f','fl.lab_id','=','f.fom_label')
                    ->WhereIn('fom_id',$arr2)
                    ->where('lab_stase','!=',2)
                    ->groupBy('lab_id')
                    ->get(['lab_id','lab_name','lab_picurl']);
                foreach ($lists as $key => $value) {
                    $arrays[$j]['lab_id'] = $value['lab_id'];
                    $arrays[$j]['lab_name'] = $value['lab_name'];
                    $arrays[$j]['lab_picurl'] = $value['lab_picurl'];
                    $j++;
                }
                unset($list);
                unset($lists);
            }
            if (isset($array)) {
                if($type == '1'){
                    $arr=array();
                    $arr['code']="200";
                    $arr['msg']="success";
                    $arr['data']=$array;
                    $arr['arrays']=$arrays;
                    // $arr['chan']=$chan;
                    return json_encode($arr);
                }else{
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$array,'arrays'=>$arrays]);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
            }
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
        }
    }
    //出入库渠道商信息
    public function getWarehouse(Request $request,$type)
    {
        $code = $request->input('code',null);
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }
        if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null) {
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $table_name = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($table_name['code'] == 500) {
                return response()->json($table_name);
            }
            // 获取二维码数据
            $table = $table_name['data'];
            $vtiger = DB::connection('mysql_two');
            $result = $vtiger->table($table."_code")->where('gco_number',$code)->first(['gco_id','gco_gid','gco_temstr','gco_group','gco_op_id']);
            $group_id = DB::table('2019_code')
                ->where('code',$code)
                ->first(['group_id','transport_chain']);
            $group = DB::table('group')
                ->where('gro_id',$group_id['group_id'])
                ->first(['gro_number']);
            if ($result) {
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                /*$chan = DB::table('transport as a')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->first(['channel_name_to','add_time','admin_name','company_id','com_name','type']);
                $chans = DB::table('transport as a')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->orderBy('a.id','desc')
                    ->first(['channel_name_to','add_time','admin_name','company_id','com_name','type','channel_id_to']);*/
                $chan = DB::table('transport as a')
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->leftjoin('transport_info as c','c.transport_id','=','a.id')
                    ->leftjoin('2019_code as d','d.code','=','c.code')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->where('c.code',$code)
                    ->where('type',0)
                    ->orderBy('a.add_time','desc')
                    ->first(['channel_name_to','a.add_time','admin_name','a.company_id','com_name','type','channel_id_to','a.id']);
                $chans = DB::table('transport as a')
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->leftjoin('transport_info as c','c.transport_id','=','a.id')
                    ->leftjoin('2019_code as d','d.code','=','c.code')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->where('c.code',$code)
                    ->where('type',1)
                    ->orderBy('a.add_time','desc')
                    ->first(['channel_name_to','a.add_time','admin_name','a.company_id','com_name','type','channel_id_to','a.id']);
                if (isset($chan)) {
                    if($type == '1'){
                        $arr=array();
                        $arr['code']="200";
                        $arr['msg']="success";
                        $arr['data']=$chan;
                        $arr['chans']=$chans;
                        return json_encode($arr);
                    }else{
                        return response()->json(['code'=>200,'msg'=>'success','data'=>$chan,'chans'=>$chans]);
                    }
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息']);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'未找到产品码']);
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 获取二维码数据
        $result = DB::table('formwork_code')
            ->where('gco_start','<=',$code)
            ->where('gco_end','>=',$code)
            ->orderBy('gco_id','desc')
            ->get(['gco_id','gco_gid','gco_group','gco_start','gco_end','gco_op_id','gco_temstr']);
        $group_id = DB::table('2019_code')
            ->where('code',$code)
            ->first(['group_id','transport_chain']);
        $group = DB::table('group')
            ->where('gro_id',$group_id['group_id'])
            ->first(['gro_number']);
        if ($result) {
            $i="0";
            $j = "0";
            foreach ($result as $key => $value) {
                //获取批次信息
                $temstr = DB::table("group")->where("gro_number",$value['gco_group'])->first(['gro_release']);
                if ($temstr['gro_release'] == '1') {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码未发布']);
                }
                unset($temstr);
                $arr2=explode(",",trim($value['gco_temstr'],","));
                //获取渠道商
                $arrd =  preg_replace('#,{2,}#',',', $group_id['transport_chain']);
                $transport_chain = explode(",",trim($arrd,","));
                //$chan = DB::table('channels')->whereIn("chan_id",$transport_chain)->get(['chan_id','chan_parent_id','chan_enterprise_name','chan_name','chan_phone','chan_address']);
                $chan = DB::table('transport as a')
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->leftjoin('transport_info as c','c.transport_id','=','a.id')
                    ->leftjoin('2019_code as d','d.code','=','c.code')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->where('c.code',$code)
                    ->where('type',0)
                    ->orderBy('a.add_time','desc')
                    ->first(['channel_name_to','a.add_time','admin_name','a.company_id','com_name','type','channel_id_to','a.id']);
                $chans = DB::table('transport as a')
                    ->leftjoin('company as b','b.com_id','=','a.company_id')
                    ->leftjoin('transport_info as c','c.transport_id','=','a.id')
                    ->leftjoin('2019_code as d','d.code','=','c.code')
                    ->whereIn('channel_id_to',$transport_chain)
                    ->where('c.code',$code)
                    ->where('type',1)
                    ->orderBy('a.add_time','desc')
                    ->first(['channel_name_to','a.add_time','admin_name','a.company_id','com_name','type','channel_id_to','a.id']);
            }
            if (isset($chan) || isset($chans)) {
                if($type == '1'){
                    $arr=array();
                    $arr['code']="200";
                    $arr['msg']="success";
                    $arr['data']=$chan;
                    $arr['chans']=$chans;
                    return json_encode($arr);
                }else{
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$chan,'chans'=>$chans]);
                }
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息1']);
            }
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未绑定溯源信息2']);
        }
    }
    // 获取环境信息接口
    public function getEnvironmentInfo(Request $request,$type)
    {
        $code = $request->input('code',null);
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null) {
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $tableData = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ( 500 == $tableData['code']) {
                return response()->json($tableData);
            }
            $vtiger = DB::connection('mysql_two');
            $result = $vtiger->table($tableData['data']."_code")->where('gco_number', $code)
                ->first(['gco_envid','gco_group']);
            if ($result) {
                // 环境信息
                $find_data = DB::table('environment')->where('env_id', $result['gco_envid'])
                    ->first(['env_id','env_name','env_number','env_equipment_number','env_start_time','env_end_time']);
                $device_time = [];//配置时间
                $ASCIIValue = '';
                if ($find_data['env_equipment_number']) {
                    $type = 1;//设备自动获取数据
                    $device_data = $find_data['env_equipment_number'];
                    $device_time['env_start_time'] = $find_data['env_start_time'] == '0000-00-00 00:00:00' ? '' : $find_data['env_start_time'];
                    $device_time['env_end_time'] = $find_data['env_end_time'] == '0000-00-00 00:00:00' ? '' : $find_data['env_end_time'];

                    // 查询最新一条数据的风向
                    $wind_explain = DB::table('device_wind_direction2')->where('DEVID',$device_data)
                        ->where(function($query) use($device_time) {
                            if (!empty($device_time['env_end_time'] )) {
                                $query->where('device_time', '<' ,$device_time['env_end_time'] );
                            }
                        })
                        ->orderBy('id','desc')
                        ->first(['initial_data']);
                    if ($wind_explain) {
                        $initial_data = json_decode($wind_explain['initial_data'],true);
                        $ASCIIValue = $initial_data['ASCIIValue'];//风向，文字说明
                    }
                } else {
                    $type = 2;//手动添加数据
                    $device_data = $find_data['env_id'];
                }
                $list['device_temperature'] = $this->findDeviceData('device_temperature',$device_data,$type,$device_time);//温度
                $list['device_soil_temperature1'] = $this->findDeviceData('device_soil_temperature1',$device_data,$type,$device_time);//土壤温度1
                $list['device_moisture'] = $this->findDeviceData('device_moisture',$device_data,$type,$device_time);//湿度
                $list['device_soil_moisture1'] = $this->findDeviceData('device_soil_moisture1',$device_data,$type,$device_time);//土壤湿度1
                $list['device_co2'] = $this->findDeviceData('device_co2',$device_data,$type,$device_time);//二氧化碳
                $list['device_soil_ph'] = $this->findDeviceData('device_soil_ph',$device_data,$type,$device_time);//土壤pH
                $list['device_soil_salinity'] = $this->findDeviceData('device_soil_salinity',$device_data,$type,$device_time);//土壤盐分
                $list['device_wind_direction1'] = $this->findDeviceData('device_wind_direction1',$device_data,$type,$device_time);//风向1
                $list['ASCIIValue'] = $ASCIIValue;//风向，文字说明
                $list['device_wind_speed'] = $this->findDeviceData('device_wind_speed',$device_data,$type,$device_time);//风速
                $list['device_illumination'] = $this->findDeviceData('device_illumination',$device_data,$type,$device_time);//光照度
                $list['device_rainfall1'] = $this->findDeviceData('device_rainfall1',$device_data,$type,$device_time);//雨量1
                if($type == '1'){
                    $arr = array();
                    $arr['code'] = 200;
                    $arr['msg'] = 'success';
                    $arr['data'] = $list;
                    return json_encode($arr);
                }else{
                    return ['code'=>200,'msg'=>'success','data'=>$list];
                }
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 获取商品信息
        $result = $this->getCodeData(2,$request->input('code'));
        if($type == '1'){
            $arr=array();
            $arr = $result;
            return json_encode($arr);
        }else{
            return response()->json($result);
        }
    }
    //防窜   _info  查询量  城市  商品 。。。。。
    public function logicHandle($code_data,$address,$num,$code){
        //更改 访问端 网络  操作系统 软件  查询量
        $year=date('Y');
        $month=date('m');
        $day=date('d');
        //公司id
        $com_id=(int)substr($code,1,4);
        //需要更改 访问端 网络  操作系统 软件  城市 商品  商品分类 区域防窜 _info 查询量
        //防窜判断
        if (isset($code_data[0]['region_id'])){
            if($code_data[0]['region_id']){
                $city=$address['city'];
                $end=mb_substr($city,-1);
                if($end=='区' || $end=='市'){
                    $city=mb_substr($city,0,-1);
                }
                $region_data=Db::table('region_detailed')->where(['reg_id'=>$code_data[0]['region_id']])->where(function($query)use($city){
                    $query->where('chi_id','like',$city.'%')->orWhere('pid','like',$city.'%');
                })->get(['chi_id']);

                if(empty($region_data)){
                    $region_data=[
                        'trace_code'=>$code,
                        'province'=>$address['province'],
                        'city'=>$address['city'],
                        'ip'=>$_SERVER['REMOTE_ADDR'],
                        'com_id'=>$com_id,
                        'region_id'=>$code_data[0]['region_id'],
                        'batch_number'=>$code_data[0]['gco_group'],
                        'code_number'=>$num,
                        'add_time'=>date('Y-m-d H:i:s'),
                        'good_id'=>$code_data[0]['gco_gid'],
                        'type'=>2
                    ];
                    Db::table('region_early')->insert($region_data);
                }else{
                    $region_data=[
                        'trace_code'=>$code,
                        'province'=>$address['province'],
                        'city'=>$address['city'],
                        'ip'=>$_SERVER['REMOTE_ADDR'],
                        'com_id'=>$com_id,
                        'region_id'=>$code_data[0]['region_id'],
                        'batch_number'=>$code_data[0]['gco_group'],
                        'code_number'=>$num,
                        'add_time'=>date('Y-m-d H:i:s'),
                        'good_id'=>$code_data[0]['gco_gid'],
                        'type'=>1
                    ];
                    Db::table('region_early')->insert($region_data);
                }
            }else{
                $region_data=[
                    'trace_code'=>$code,
                    'province'=>$address['province'],
                    'city'=>$address['city'],
                    'ip'=>$_SERVER['REMOTE_ADDR'],
                    'com_id'=>$com_id,
                    'region_id'=>0,
                    'batch_number'=>$code_data[0]['gco_group'],
                    'code_number'=>$num,
                    'add_time'=>date('Y-m-d H:i:s'),
                    'good_id'=>$code_data[0]['gco_gid'],
                    'type'=>3
                ];
                Db::table('region_early')->insert($region_data);
            }
            //获取运营商
            $ip_address=$this->get_operator();
            //手机型号
            $phone     =$this->check_phone($_SERVER['HTTP_USER_AGENT']);
            //操作系统
            $system    =$this->get_system($_SERVER['HTTP_USER_AGENT']);
            //软件
            $software  =$this->get_software($_SERVER['HTTP_USER_AGENT']);

            $overall=[$ip_address,$system,$software];

            foreach ($overall as $key => $value){
                $arr=Db::table('overall_plan')->where(['ovp_time'=>$year,'ovp_type'=>$value['type'],'ovp_name'=>$value['data'],'ovp_cid'=>$com_id])->first(['ovp_id']);
                if($arr){
                    $res=Db::table('overall_plan')->where(['ovp_id'=>$arr['ovp_id']])->increment('ovp_num');
                }else{
                    $str=['ovp_cid'=>$com_id,'ovp_type'=>$value['type'],'ovp_time'=>$year,'ovp_name'=>$value['data'],'ovp_num'=>1];
                    Db::table('overall_plan')->insert($str);
                }
            }
            $cin_codeid = DB::table("base_info")
                ->where('cin_codeid',$code)
                ->value('cin_codeid');
            if (empty($cin_codeid)) {
                // _info
                $info_data=['cin_gooid'=>$code_data[0]['gco_gid'],'cin_codeid'=>$code,'cin_provin'=>$address['province'],'cin_city'=>$address['city'],'cin_ip'=>$_SERVER['REMOTE_ADDR'],'cin_time'=>date('Y-m-d H:i:s')];
                Db::table("base_info")->insert($info_data);
            }
            //更改城市查询量
            $city=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$com_id,'stal_provin'=>$address['province'],'stal_city'=>$address['city']])->first(['stal_id']);
            if($city){
                Db::table('statistic_look')->where('stal_id',$city['stal_id'])->increment('stal_total');
            }else{
                $city_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$com_id,'stal_provin'=>$address['province'],'stal_city'=>$address['city'],'stal_total'=>1];
                Db::table('statistic_look')->insert($city_data);
            }
            //更改商品查询量
            $goods=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$com_id,'stal_goo_id'=>$code_data[0]['gco_gid']])->first(['stal_id']);
            if($goods){
                Db::table('statistic_look')->where('stal_id',$goods['stal_id'])->increment('stal_total');
            }else{
                $goods_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$com_id,'stal_goo_id'=>$code_data[0]['gco_gid'],'stal_total'=>1];
                Db::table('statistic_look')->insert($goods_data);
            }
            //更改手机型号查询
            $phone_res=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>3,'stal_cid'=>$com_id,'stal_city'=>$phone['data']])->first(['stal_id']);
            if($phone_res){
                Db::table('statistic_look')->where('stal_id',$phone_res['stal_id'])->increment('stal_total');
            }else{
                $phone_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>3,'stal_cid'=>$com_id,'stal_city'=>$phone['data'],'stal_total'=>1];
                Db::table('statistic_look')->insert($phone_data);
            }
            return true;
        }else{
            if($code_data['region_id']){
                $city=$address['city'];
                $end=mb_substr($city,-1);
                if($end=='区' || $end=='市'){
                    $city=mb_substr($city,0,-1);
                }
                $region_data=Db::table('region_detailed')->where(['reg_id'=>$code_data['region_id']])->where(function($query)use($city){
                    $query->where('chi_id','like',$city.'%')->orWhere('pid','like',$city.'%');
                })->get(['chi_id']);

                if(empty($region_data)){
                    $region_data=[
                        'trace_code'=>$code,
                        'province'=>$address['province'],
                        'city'=>$address['city'],
                        'ip'=>$_SERVER['REMOTE_ADDR'],
                        'com_id'=>$com_id,
                        'region_id'=>$code_data['region_id'],
                        'batch_number'=>$code_data['gco_group'],
                        'code_number'=>$num,
                        'add_time'=>date('Y-m-d H:i:s'),
                        'good_id'=>$code_data['gco_gid'],
                        'type'=>2
                    ];
                    Db::table('region_early')->insert($region_data);
                }else{
                    $region_data=[
                        'trace_code'=>$code,
                        'province'=>$address['province'],
                        'city'=>$address['city'],
                        'ip'=>$_SERVER['REMOTE_ADDR'],
                        'com_id'=>$com_id,
                        'region_id'=>$code_data['region_id'],
                        'batch_number'=>$code_data['gco_group'],
                        'code_number'=>$num,
                        'add_time'=>date('Y-m-d H:i:s'),
                        'good_id'=>$code_data['gco_gid'],
                        'type'=>1
                    ];
                    Db::table('region_early')->insert($region_data);
                }
            }else{
                $region_data=[
                    'trace_code'=>$code,
                    'province'=>$address['province'],
                    'city'=>$address['city'],
                    'ip'=>$_SERVER['REMOTE_ADDR'],
                    'com_id'=>$com_id,
                    'region_id'=>0,
                    'batch_number'=>$code_data['gco_group'],
                    'code_number'=>$num,
                    'add_time'=>date('Y-m-d H:i:s'),
                    'good_id'=>$code_data['gco_gid'],
                    'type'=>3
                ];
                Db::table('region_early')->insert($region_data);
            }
            //获取运营商
            $ip_address=$this->get_operator();
            //手机型号
            $phone     =$this->check_phone($_SERVER['HTTP_USER_AGENT']);
            //操作系统
            $system    =$this->get_system($_SERVER['HTTP_USER_AGENT']);
            //软件
            $software  =$this->get_software($_SERVER['HTTP_USER_AGENT']);

            $overall=[$ip_address,$system,$software];

            foreach ($overall as $key => $value){
                $arr=Db::table('overall_plan')->where(['ovp_time'=>$year,'ovp_type'=>$value['type'],'ovp_name'=>$value['data'],'ovp_cid'=>$com_id])->first(['ovp_id']);
                if($arr){
                    $res=Db::table('overall_plan')->where(['ovp_id'=>$arr['ovp_id']])->increment('ovp_num');
                }else{
                    $str=['ovp_cid'=>$com_id,'ovp_type'=>$value['type'],'ovp_time'=>$year,'ovp_name'=>$value['data'],'ovp_num'=>1];
                    Db::table('overall_plan')->insert($str);
                }
            }
            $cin_codeid = DB::table("base_info")
                ->where('cin_codeid',$code)
                ->value('cin_codeid');
            if (empty($cin_codeid)) {
                // _info
                $info_data=['cin_gooid'=>$code_data['gco_gid'],'cin_codeid'=>$code,'cin_provin'=>$address['province'],'cin_city'=>$address['city'],'cin_ip'=>$_SERVER['REMOTE_ADDR'],'cin_time'=>date('Y-m-d H:i:s')];
                Db::table("base_info")->insert($info_data);
            }
            //更改城市查询量
            $city=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$com_id,'stal_provin'=>$address['province'],'stal_city'=>$address['city']])->first(['stal_id']);
            if($city){
                Db::table('statistic_look')->where('stal_id',$city['stal_id'])->increment('stal_total');
            }else{
                $city_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$com_id,'stal_provin'=>$address['province'],'stal_city'=>$address['city'],'stal_total'=>1];
                Db::table('statistic_look')->insert($city_data);
            }
            //更改商品查询量
            $goods=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$com_id,'stal_goo_id'=>$code_data['gco_gid']])->first(['stal_id']);
            if($goods){
                Db::table('statistic_look')->where('stal_id',$goods['stal_id'])->increment('stal_total');
            }else{
                $goods_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$com_id,'stal_goo_id'=>$code_data['gco_gid'],'stal_total'=>1];
                Db::table('statistic_look')->insert($goods_data);
            }
            //更改手机型号查询
            $phone_res=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>3,'stal_cid'=>$com_id,'stal_city'=>$phone['data']])->first(['stal_id']);
            if($phone_res){
                Db::table('statistic_look')->where('stal_id',$phone_res['stal_id'])->increment('stal_total');
            }else{
                $phone_data=['stal_year'=>$year,'stal_month'=>$month,'stal_day'=>$day,'stal_type'=>3,'stal_cid'=>$com_id,'stal_city'=>$phone['data'],'stal_total'=>1];
                Db::table('statistic_look')->insert($phone_data);
            }
            return true;
        }
    }
    // 质保单查询
    public function warranty(Request $request,$types)
    {
        $type = $request->input('type');   //类型
        $code = $request->input('code',null);   //产品码
        $code_id = substr($code,0,5);   //产品码
        if ($type == 1) {
            $com_id = DB::table('warranty_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                ->where('info_code_id',$code_id)
                ->first(['wata_cid']);
            if (empty($com_id)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未设置质保单']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 判断技师质保单列表是否开启
        $wata_stase = DB::table('warranty_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                ->where('info_code_id',$code_id)
                ->value('wata_stase');
        // 判断消费者质保单列表是否开启
        $watas_stase = DB::table('warrantys_table as ws')
                ->leftjoin('company_info as ci','ci.info_cid','=','ws.watas_cid')
                ->where('info_code_id',$code_id)
                ->first(['watas_stase','watas_cid']);
        if ($wata_stase == '1' && $watas_stase['watas_stase'] == '1') {
            // 消费者跟技师表单都开启
            $phone = $request->input('warr_phone',null);     //手机号
            if (empty($phone)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'手机号错误']);
            }
            // 判断是否有这个码号
            $code = DB::table('warranty')->where('code',$codes)->where('warr_phone',$phone)->value('code');
            if ($code == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该手机号尚未绑定']);
            }
            
            $province= $request->input('province','未知');
            $city=     $request->input('city','未知');
            $address=$this->check_address(['province'=>$province,'city'=>$city]);
            $province=$address['province'];
            $city   =$address['city'];
            $datas = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->first(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            if ($datas == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'暂无数据']);
            }
            $data = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('warr_phone',$phone)
                    ->where('code',$codes)
                    ->get(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            foreach ($data as $key => $value) {
                $data[$key]['chan_phone']=$value['chan_phone'];
                $data[$key]['chan_phone']=substr_replace($data[$key]['chan_phone'],'****',3,4);;
                $data[$key]['warr_content']=json_decode($value['warr_content'],true);
                foreach ($data[$key]['warr_content'] as $k => $v) {
                    if ($v['type'] == '3') {
                        $data[0]['warr_phone'] = ($v['value']);
                        $data[0]['warr_phone'] = substr_replace($data[0]['warr_phone'],'****',3,4);
                        $data[0]['warr_content'][0]['value'] = ($v['value']);
                        $data[0]['warr_content'][0]['value'] = substr_replace($data[0]['warr_content'][0]['value'],'****',3,4);
                    }
                }
            }
            if($types == '1'){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$data[0];
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$data[0]]);
            }
        }elseif($wata_stase == '2' && $watas_stase['watas_stase'] == '1'){
            // 消费者表单开启,技师的表单关闭
            $province= $request->input('province','未知');
            $city=     $request->input('city','未知');
            $address=$this->check_address(['province'=>$province,'city'=>$city]);
            $province=$address['province'];
            $city   =$address['city'];
            $datas = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->first(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            if ($datas == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'暂无数据']);
            }
            $data = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->get(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            foreach ($data as $key => $value) {
                $data[$key]['chan_phone']=$value['chan_phone'];
                $data[$key]['chan_phone']=substr_replace($data[$key]['chan_phone'],'****',3,4);;
                $data[$key]['warr_content']=json_decode($value['warr_content'],true);
                foreach ($data[$key]['warr_content'] as $k => $v) {
                    if ($v['type'] == '3') {
                        $data[0]['warr_phone'] = ($v['value']);
                        $data[0]['warr_phone'] = substr_replace($data[0]['warr_phone'],'****',3,4);
                        $data[0]['warr_content'][0]['value'] = ($v['value']);
                        $data[0]['warr_content'][0]['value'] = substr_replace($data[0]['warr_content'][0]['value'],'****',3,4);
                    }
                }
            }
            if($types == '1'){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$data[0];
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$data[0]]);
            }
        }elseif($wata_stase == '1' && $watas_stase['watas_stase'] == '2'){
            // 消费者表单关闭,技师表单开启
            $phone = $request->input('warr_phone',null);     //手机号
            if (empty($phone)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'手机号错误']);
            }
            // 判断是否有这个码号
            $code = DB::table('warranty')->where('code',$codes)->where('warr_phone',$phone)->value('code');
            if ($code == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该手机号尚未绑定']);
            }
            
            $province= $request->input('province','未知');
            $city=     $request->input('city','未知');
            $address=$this->check_address(['province'=>$province,'city'=>$city]);
            $province=$address['province'];
            $city   =$address['city'];
            $datas = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->first(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            if ($datas == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'暂无数据']);
            }
            $data = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('warr_phone',$phone)
                    ->where('code',$codes)
                    ->get(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            foreach ($data as $key => $value) {
                $data[$key]['chan_phone']=$value['chan_phone'];
                $data[$key]['chan_phone']=substr_replace($data[$key]['chan_phone'],'****',3,4);;
                $data[$key]['warr_content']=json_decode($value['warr_content'],true);
                foreach ($data[$key]['warr_content'] as $k => $v) {
                    if ($v['type'] == '3') {
                        $data[0]['warr_phone'] = ($v['value']);
                        $data[0]['warr_phone'] = substr_replace($data[0]['warr_phone'],'****',3,4);
                        $data[0]['warr_content'][0]['value'] = ($v['value']);
                        $data[0]['warr_content'][0]['value'] = substr_replace($data[0]['warr_content'][0]['value'],'****',3,4);
                    }
                }
            }
            if($types == '1'){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$data[0];
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$data[0]]);
            }
        }else if($wata_stase == '2' && $watas_stase['watas_stase'] == '2'){
            // 消费者和技师的表单都关闭
            $province= $request->input('province','未知');
            $city=     $request->input('city','未知');
            $address=$this->check_address(['province'=>$province,'city'=>$city]);
            $province=$address['province'];
            $city   =$address['city'];
            $datas = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->first(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            if ($datas == null) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'暂无数据']);
            }
            $data = DB::table('warranty as a')
                    ->leftJoin('channels as b', 'b.chan_id', '=', 'a.warr_chan_id')
                    ->where('code',$codes)
                    ->get(['a.warr_id','b.chan_enterprise_name as parent_enterprise_name','a.warr_tech_id','a.warr_tech_name','a.warr_number','a.warr_content','a.warr_addtime','a.warr_phone','a.warr_expire_time','a.warranty_day','b.chan_phone']);
            foreach ($data as $key => $value) {
                $data[$key]['chan_phone']=$value['chan_phone'];
                $data[$key]['chan_phone']=substr_replace($data[$key]['chan_phone'],'****',3,4);;
                $data[$key]['warr_content']=json_decode($value['warr_content'],true);
                foreach ($data[$key]['warr_content'] as $k => $v) {
                    if ($v['type'] == '3') {
                        $data[0]['warr_phone'] = ($v['value']);
                        $data[0]['warr_phone'] = substr_replace($data[0]['warr_phone'],'****',3,4);
                        $data[0]['warr_content'][0]['value'] = ($v['value']);
                        $data[0]['warr_content'][0]['value'] = substr_replace($data[0]['warr_content'][0]['value'],'****',3,4);
                    }
                }
            }
            if($types == '1'){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$data[0];
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$data[0]]);
            }
        }
    }
    // 获取质保单信息
    public function warrantys(Request $request)
    {
        $code = $request->input('code',null);   //产品码
        $code_id = substr($code,0,5);   //产品码
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 查询质保单数据
        $warrantys_data = DB::table('warrantys')
                        ->where('code',$code)
                        ->first(['warrs_content as content']);
        if (empty($warrantys_data)) {
            // 没有提交质保单，查询质保单模板
            $warrantys_data = DB::table('warrantys_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.watas_cid')
                ->where('info_code_id',$code_id)
                ->first(['watas_content as content']);
            $return_data['serviced'] = 0;
        }else{
            // 已提交质保单
            $return_data['serviced'] = 1;
        }

        if (empty($warrantys_data['content'])) {
            $return_data['wata_type'] = 2;
        }else{
            $return_data['wata_type'] = 1;
        }
        // 返回数据
        $return_data['wata_content'] = json_decode($warrantys_data['content']);
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$return_data]);
    }
    // 提交质保单信息
    public function subwarranty(Request $request)
    {
        $type = $request->input('type');   //类型
        $code = $request->input('code',null);   //产品码
        $code_id = substr($code,0,5);   //产品码
        if ($type == 1) {
            $com_id = DB::table('warranty_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                ->where('info_code_id',$code_id)
                ->first(['wata_cid']);
            if (empty($com_id)) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'该商品尚未设置质保单']);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
            }
        }
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        // 判断技师质保单列表是否开启
        $wata_stase = DB::table('warranty_table as w')
                ->leftjoin('company_info as ci','ci.info_cid','=','w.wata_cid')
                ->where('info_code_id',$code_id)
                ->value('wata_stase');
        // 判断消费者质保单列表是否开启
        $watas_stase = DB::table('warrantys_table as ws')
                ->leftjoin('company_info as ci','ci.info_cid','=','ws.watas_cid')
                ->where('info_code_id',$code_id)
                ->first(['watas_stase','watas_cid']);
        // 查询是否有质保单,技师提交的数据
        $warranty_data = DB::table('warranty')
            ->where('code',$code)
            ->first();
        if (empty($warranty_data)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'技师尚未填写质保单']);
        }
        if ($wata_stase == '1' && $watas_stase['watas_stase'] == '1') {
            // 消费者和技师表单都开启
            $code_len = strlen($request['code']);
            // 判断二维码的位数
            if (!in_array($code_len, config('common.code_length'))) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码']);
            }
            /**
             * 处理表单数据
             *  表单json数据字段说明
                {
                    "key":"商品编号",//信息名称
                    "value":"6922266440090",//信息内容
                    "show":1,//1显示2隐藏
                    "type":"1",//类型1普通文本2安装时间3联系电话4上传图片
                    "required":"1",//是否必填1必填2选填
                }
             */
            $now_time = date('Y-m-d H:i:s');
            if (empty($request['types'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if ($request['types'] == 1) {
                foreach ($request['info_name'] as $key => $value) {
                    if (empty($value) || !in_array($request['info_show'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2,3,4]) ) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
                    }
                    if ($value == '联系电话') {
                        if(!preg_match("/^1[345678]{1}\d{9}$/", $request['info_content'][$key])){
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入正确手机号']);
                        }
                        $add_data['warrs_phone'] = $request['info_content'][$key];
                    }

                    $table_content[$key]['type'] = $request['info_type'][$key];
                    // 判断是否显示
                    if ($request['info_show'][$key] == 1) {
                        // 判断是否必填
                        if ($request['info_required'][$key] == 1) {
                            // 必填项，内容不能为空
                            if (empty($request['info_content'][$key])) {
                                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入信息']);
                            }
                        }
                    }

                    // 判断上传类型
                    if ($request['info_type'][$key] == 4) {
                        // 上传图片
                        $uploadPath = uploadBase64Img($request['info_content'][$key]);
                        if (!$uploadPath) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                        }
                        $table_content[$key]['value'] = $uploadPath;
                    }else{
                        $table_content[$key]['value'] = $request['info_content'][$key];
                    }
                    $table_content[$key]['key'] = $value;
                    $table_content[$key]['show'] = $request['info_show'][$key];
                    $table_content[$key]['required'] = $request['info_required'][$key];
                }
                $table_content = json_encode($table_content);
            }else{
                $table_content = '';
            }
            DB::beginTransaction();
            // 提交质保表单数据
            $add_data['warrs_number'] = date('YmdHis').rand(100000,999999);
            $add_data['warrs_content'] = $table_content;
            $add_data['warrs_cid'] = $watas_stase['watas_cid'];
            $add_data['code'] = $request['code'];
            $add_data['warrs_addtime'] = $now_time;
            $warrantys_res = DB::table('warrantys')->insertGetId($add_data);
            $warrantys_record = DB::table('warrantys_table')->where('watas_cid',$watas_stase['watas_cid'])->update(['watas_stase'=>2]);
            if ($warrantys_res && $warrantys_record) {
                DB::commit();
                return response()->json(['code'=>200,'msg'=>'success','data'=>'提交成功']);
            }else{
                DB::rollBack();
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'提交失败']);
            }
        }elseif($wata_stase == '2' && $watas_stase['watas_stase'] == '1'){
            // 消费者表单开启,技师的表单关闭
            $code_len = strlen($request['code']);
            // 判断二维码的位数
            if (!in_array($code_len, config('common.code_length'))) {
                return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'非本系统码']);
            }
            /**
             * 处理表单数据
             *  表单json数据字段说明
                {
                    "key":"商品编号",//信息名称
                    "value":"6922266440090",//信息内容
                    "show":1,//1显示2隐藏
                    "type":"1",//类型1普通文本2安装时间3联系电话4上传图片
                    "required":"1",//是否必填1必填2选填
                }
             */
            $now_time = date('Y-m-d H:i:s');
            if (empty($request['types'])) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if ($request['types'] == 1) {
                foreach ($request['info_name'] as $key => $value) {
                    if (empty($value) || !in_array($request['info_show'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2]) || !in_array($request['info_required'][$key], [1,2,3,4]) ) {
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
                    }
                    if ($value == '联系电话') {
                        if(!preg_match("/^1[345678]{1}\d{9}$/", $request['info_content'][$key])){
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入正确手机号']);
                        }
                        $add_data['warrs_phone'] = $request['info_content'][$key];
                    }

                    $table_content[$key]['type'] = $request['info_type'][$key];
                    // 判断是否显示
                    if ($request['info_show'][$key] == 1) {
                        // 判断是否必填
                        if ($request['info_required'][$key] == 1) {
                            // 必填项，内容不能为空
                            if (empty($request['info_content'][$key])) {
                                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入信息']);
                            }
                        }
                    }

                    // 判断上传类型
                    if ($request['info_type'][$key] == 4) {
                        // 上传图片
                        $uploadPath = uploadBase64Img($request['info_content'][$key]);
                        if (!$uploadPath) {
                            return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                        }
                        $table_content[$key]['value'] = $uploadPath;
                    }else{
                        $table_content[$key]['value'] = $request['info_content'][$key];
                    }
                    $table_content[$key]['key'] = $value;
                    $table_content[$key]['show'] = $request['info_show'][$key];
                    $table_content[$key]['required'] = $request['info_required'][$key];
                }
                $table_content = json_encode($table_content);
            }else{
                $table_content = '';
            }
            DB::beginTransaction();
            // 提交质保表单数据
            $add_data['warrs_number'] = date('YmdHis').rand(100000,999999);
            $add_data['warrs_content'] = $table_content;
            $add_data['warrs_cid'] = $watas_stase['watas_cid'];
            $add_data['code'] = $request['code'];
            $add_data['warrs_addtime'] = $now_time;
            $warrantys_res = DB::table('warrantys')->insertGetId($add_data);
            $warrantys_record = DB::table('warrantys_table')->where('watas_cid',$watas_stase['watas_cid'])->update(['watas_stase'=>2]);
            if ($warrantys_res && $warrantys_record) {
                DB::commit();
                return response()->json(['code'=>200,'msg'=>'success','data'=>'提交成功']);
            }else{
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'提交失败']);
            }
        }
    }
    //防伪查询
    public function preventforge(Request $request,$types)
    {
        $code = $request->input('code',null);   //产品码
        $type = $request->input('gro_validation',1);
        if (empty($code)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码不能为空']);
        }if (!is_numeric($code) || strpos($code,'.')) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码错误']);
        }
        $codeStart = DB::table('group')->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->first(['code_start','code_end']);
        if ($codeStart['code_start'] == null || $codeStart['code_end'] == null){
            $province= $request->input('province','未知');
            $city=     $request->input('city','未知');
            $address=$this->check_address(['province'=>$province,'city'=>$city]);
            $province=$address['province'];
            $city   =$address['city'];
            $security = $request->input('security',null);   //序列号
            if(empty($security) || strlen($security) < 8 ){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'产品序列号错误']);
            }
            // 获取二维码标识、年月
            $dealData = $this->dealCode($request->input('code'));
            // 获取二维码表名
            $gro_number = $this->getTable($dealData['codeid'],$dealData['tab_yemo']);
            if ($gro_number['code'] == 500) {
                return response()->json($gro_number);
            }
            $vtiger = DB::connection('mysql_two');
            $is_com=$vtiger->table($gro_number['data']."_code")->where(['gco_number'=>$code])->first(['gco_cid','gco_group']);
            //获取 该公司的设置的防伪样式
            $note_style=Db::table('note')->whereIn('not_cid',[0,$is_com['gco_cid']])->get(['note_id','note_content']);
            $note_style=end($note_style);
            //获取随即数
            $validation=Db::table('validation')->where(['val_codenumber'=>$is_com['gco_group']])->first(['val_leaver','val_sta','val_end','val_rand']);
            if(empty($validation)){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'未绑定防伪码']);
            }
            //判断随即数
            $rand_str=$security[2].$security[3].$security[5].$security[6];
            if($rand_str!=$validation['val_rand']){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'真伪序列号错误']);
            }

            //判断真伪值
            $vali_st=$security[0].$security[1].$security[4].substr($security,7);
            $data=Db::table('validation_data')->where(['vald_leaver'=>$validation['val_leaver']-4,'vald_rand'=>$vali_st])->whereBetween('vald_number',[$validation['val_sta'],$validation['val_end']])->first();
            if(empty($data)){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'序列号错误']);
            }
            //获取二维码的数据   获取商品名称和id
            $goods_data = DB::table('group')
                ->leftJoin('goods','goods.goo_id','=','group.gro_gid')
                ->where('gro_number',$is_com['gco_group'])
                ->select('gro_gid','goo_name')
                ->first();
            // $goods_data=$vtiger->table($gro_number['data']."_code")->where(['gco_number'=>$code])->join('goods2','goo_id','=','gco_gid')->first(['gco_gid','goo_name']);
            //查询扫码次数和时间
            $code_data=Db::table('info_total')->where(['total_code'=>$code])->first(['total_id','create_at','total_provin','total_city','total_num','total_nums','total_validation']);
            if($code_data){
                //增加次数
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_num',1,['total_good_id'=>$goods_data['gro_gid']]);
                $code_data['total_num']++;
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_nums',1,['total_good_id'=>$goods_data['gro_gid']]);
                $code_data['total_nums']++;
            }else{
                //添加一条防伪记录
                $code_data=[
                'total_num'=>1,
                'total_cid'=>$is_com['gco_cid'],
                'total_code'=>$code,
                'total_state'=>1,
                'total_good_id'=>$goods_data['gro_gid'],
                'total_provin'=>$province,
                'total_city'=>$city,
                'create_at'=>date("Y-m-d H:i:s"),
                'total_nums' => 1,
                'total_validation' => $security
                ];
                Db::table('info_total')->insert($code_data);
            }
            //{goods} {code}{num}{time}{pros}
            //替换数据
            $note_style['note_content']=str_replace('{goods}',$goods_data['goo_name'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{code}',$code,$note_style['note_content']);
            $note_style['note_content']=str_replace('{num}',$code_data['total_num'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{time}',$code_data['create_at'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{pros}',$code_data['total_provin']." ".$code_data['total_city'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{nums}',$code_data['total_nums'],$note_style['note_content']);
            unset($code_data['total_nums']);
            if($types == '1'){
                $arr=array();
                $arr['code']="200";
                $arr['msg']="success";
                $arr['data']=$note_style;
                return json_encode($arr);
            }else{
                return response()->json(['code'=>200,'msg'=>'success','data'=>$note_style]);
            }
        }
        // 验证产品码是否正确
        $codes = trim($code);
        $error_codes = [];
        $codes = explode(',',trim($codes,','));
        foreach($codes as $key=>$code) {
            $code_tmp = VerifyCodeController::validator($code);
            if(!$code_tmp) {
                unset($codes[$key]);
                $error_codes[] = $code;
            }else {
                $codes[$key] = $code_tmp;
            }
        }
        if(count($error_codes) > 0) {
            return response()->json(['code' => 500, 'msg' => '非本系统所属码', 'data' => $error_codes]);
        }
        $province= $request->input('province','未知');
        $city=     $request->input('city','未知');
        $address=$this->check_address(['province'=>$province,'city'=>$city]);
        $province=$address['province'];
        $city   =$address['city'];
        if ($type == 1) {
            $coms = DB::table('formwork_code')->where('gco_start', '<=', $code)->where('gco_end', '>=' ,$code)->where('gco_gid','!=',0)->limit(1)->get(['gco_cid','gco_group']);
            if (!$coms) {
                $comss = DB::table('group')->where('code_start','<=',$code)->where('code_end','>=',$code)->first(['gro_cid','gro_number','gro_valleaver','gro_validation']);
                // 获取该公司的防伪样式
                $note_style=Db::table('note')->whereIn('not_cid',[0,$comss['gro_cid']])->orderBy('note_id','desc')->get(['note_id','note_content']);
                $note_style=end($note_style);
                $goods_data = DB::table('group')
                    ->join('goods','goo_id','=','gro_gid')
                    ->where('code_start','<=',$code)
                    ->where('code_end','>=',$code)
                    ->first();
                //查询扫码次数和时间
                $code_data=Db::table('info_total')->where(['total_code'=>$code])->first(['total_id','create_at','total_provin','total_city','total_num','total_nums','total_validation']);
                if ($code_data) {
                    //增加次数
                    // Db::table('info_total')->where(['total_code'=>$code])->increment('total_nums',1,['total_good_id'=>$goods_data['gro_gid']]);
                    // Db::table('info_total')->where(['total_code'=>$code])->increment('total_num',1,['total_good_id'=>$goods_data['gro_gid']]);
                    // $code_data['total_nums']++;
                    // $code_data['total_num']++;
                }else{
                    // 增加一条防伪记录
                    $code_data=[
                    'total_num'=>1,
                    'total_cid'=>$comss['gro_cid'],
                    'total_code'=>$code,
                    'total_state'=>1,
                    'total_good_id'=>$goods_data['gro_gid'],
                    'total_provin'=>$province,
                    'total_city'=>$city,
                    'create_at'=>date("Y-m-d H:i:s"),
                    'total_nums' => 1,
                    'total_num' => 1,
                    ];
                    Db::table('info_total')->insert($code_data);
                }
                //替换数据
                $note_style['note_content']=str_replace('{goods}',$goods_data['goo_name'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{code}',$code,$note_style['note_content']);
                $note_style['note_content']=str_replace('{num}',$code_data['total_num'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{nums}',$code_data['total_nums'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{time}',$code_data['create_at'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{pros}',$code_data['total_provin']." ".$code_data['total_city'],$note_style['note_content']);
                if($types){
                    $arr=array();
                    $arr['code']="200";
                    $arr['msg']="success";
                    $arr['data']=$note_style;
                    return json_encode($arr);
                }else{
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$note_style]);
                }
            }else{
                // 获取该公司的防伪样式
                $note_style=Db::table('note')->whereIn('not_cid',[0,$coms[0]['gco_cid']])->get(['note_id','note_content']);
                $note_style=end($note_style);
                //获取二维码的数据   获取商品名称和id
                $goods_data=Db::table("formwork_code")->where('gco_start', '<=', $code)->where('gco_end', '>=' ,$code)->join('goods','goo_id','=','gco_gid')->first(['gco_gid','goo_name']);
                //查询扫码次数和时间
                $code_data=Db::table('info_total')->where(['total_code'=>$code])->first(['total_id','create_at','total_provin','total_city','total_num','total_nums','total_validation']);
                if($code_data){
                    //增加次数
                    // Db::table('info_total')->where(['total_code'=>$code])->increment('total_nums',1,['total_good_id'=>$goods_data['gco_gid']]);
                    // Db::table('info_total')->where(['total_code'=>$code])->increment('total_num',1,['total_good_id'=>$goods_data['gco_gid']]);
                    // $code_data['total_nums']++;
                    // $code_data['total_num']++;
                }else{
                    //添加一条防伪记录
                    $code_data=[
                    'total_num'=>1,
                    'total_cid'=>$coms[0]['gco_cid'],
                    'total_code'=>$code,
                    'total_state'=>1,
                    'total_good_id'=>$goods_data['gco_gid'],
                    'total_provin'=>$province,
                    'total_city'=>$city,
                    'create_at'=>date("Y-m-d H:i:s"),
                    'total_nums' => 1,
                    'total_num' => 1,
                    ];
                    Db::table('info_total')->insert($code_data);
                }
                //替换数据
                $note_style['note_content']=str_replace('{goods}',$goods_data['goo_name'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{code}',$code,$note_style['note_content']);
                $note_style['note_content']=str_replace('{num}',$code_data['total_num'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{nums}',$code_data['total_nums'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{time}',$code_data['create_at'],$note_style['note_content']);
                $note_style['note_content']=str_replace('{pros}',$code_data['total_provin']." ".$code_data['total_city'],$note_style['note_content']);
                if($types == '1'){
                    $arr=array();
                    $arr['code']="200";
                    $arr['msg']="success";
                    $arr['data']=$note_style;
                    return json_encode($arr);
                }else{
                    return response()->json(['code'=>200,'msg'=>'success','data'=>$note_style]);
                }
            }
        }
        $security = $request->input('security',null);   //序列号
        if(empty($security) || strlen($security) < 8 ){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'产品序列号错误']);
        }
        $is_com = DB::table('formwork_code')->where('gco_start', '<=', $code)->where('gco_end', '>=' ,$code)->where('gco_gid','!=',0)->get(['gco_cid','gco_group']);
        if (!$is_com) {
            $is_coms = DB::table('group')->where('code_start','<=',$code)->where('code_end','>=',$code)->first(['gro_cid','gro_number','gro_valleaver','gro_validation']);
            // 获取该公司的防伪样式
            $note_style=Db::table('note')->whereIn('not_cid',[0,$is_coms['gro_cid']])->get(['note_id','note_content']);
            $note_style=end($note_style);
            //获取随即数
            $validation=Db::table('validation')->where(['val_codenumber'=>$is_coms['gro_number']])->first(['val_leaver','val_sta','val_end','val_rand']);
            //判断随即数
            $rand_str=$security[2].$security[3].$security[5].$security[6];
            
            if($rand_str!=$validation['val_rand']){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'真伪序列号错误']);
            }

            //判断真伪值
            $vali_st=$security[0].$security[1].$security[4].substr($security,7);
            $data=Db::table('validation_data')->where(['vald_leaver'=>$validation['val_leaver']-4,'vald_rand'=>$vali_st])->whereBetween('vald_number',[$validation['val_sta'],$validation['val_end']])->first();
            if(empty($data)){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'序列号错误']);
            }
            //获取二维码的数据   获取商品名称和id
            $goods_data=Db::table("group")->where('code_start', '<=', $code)->where('code_end', '>=' ,$code)->join('goods','goo_id','=','gro_gid')->first(['gro_gid','goo_name']);
            //查询扫码次数和时间
            $code_data=Db::table('info_total')->where(['total_code'=>$code])->first(['total_id','create_at','total_provin','total_city','total_num','total_nums','total_validation']);
            if($code_data){
                //增加次数
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_num',1,['total_good_id'=>$goods_data['gro_gid']]);
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_nums',1,['total_good_id'=>$goods_data['gro_gid']]);
                $code_data['total_num']++;
                $code_data['total_nums']++;
            }else{
                // 判断是否有序列号
                $total_validation = DB::table('info_total')->where(['total_validation'=>$security])->value('total_validation');
                $total_code = DB::table('info_total')->where(['total_code'=>$code])->value('total_code');
                if ($total_validation == null && $total_code == null) {
                    //添加一条防伪记录
                    $code_data=[
                    'total_num'=>1,
                    'total_cid'=>$is_coms['gro_cid'],
                    'total_code'=>$code,
                    'total_state'=>1,
                    'total_good_id'=>$goods_data['gro_gid'],
                    'total_provin'=>$province,
                    'total_city'=>$city,
                    'create_at'=>date("Y-m-d H:i:s"),
                    'total_nums' => 1,
                    'total_validation' => $security
                    ];
                    DB::connection()->enableQueryLog();#开启执行日志
                    Db::table('info_total')->insert($code_data);
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'序列号错误']);
                }
            }
            //替换数据
            $note_style['note_content']=str_replace('{goods}',$goods_data['goo_name'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{code}',$code,$note_style['note_content']);
            $note_style['note_content']=str_replace('{num}',$code_data['total_num'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{nums}',$code_data['total_nums'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{time}',$code_data['create_at'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{pros}',$code_data['total_provin']." ".$code_data['total_city'],$note_style['note_content']);
            return response()->json(['code'=>200,'msg'=>'success','data'=>$note_style]);
        }else{
            // 获取该公司的防伪样式
            $note_style=Db::table('note')->whereIn('not_cid',[0,$is_com[0]['gco_cid']])->get(['note_id','note_content']);
            $note_style=end($note_style);
            //获取随即数
            $validation=Db::table('validation')->where(['val_codenumber'=>$is_com[0]['gco_group']])->first(['val_leaver','val_sta','val_end','val_rand']);
            //判断随即数
            $rand_str=$security[2].$security[3].$security[5].$security[6];
            
            if($rand_str!=$validation['val_rand']){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'真伪序列号错误']);
            }

            //判断真伪值
            $vali_st=$security[0].$security[1].$security[4].substr($security,7);
            $data=Db::table('validation_data')->where(['vald_leaver'=>$validation['val_leaver']-4,'vald_rand'=>$vali_st])->whereBetween('vald_number',[$validation['val_sta'],$validation['val_end']])->first();

            if(empty($data)){
                return response()->json(['code'=>500,'msg'=>'error','data'=>'序列号错误']);
            }
            //获取二维码的数据   获取商品名称和id
            $goods_data=Db::table("formwork_code")->where('gco_start', '<=', $code)->where('gco_end', '>=' ,$code)->join('goods','goo_id','=','gco_gid')->first(['gco_gid','goo_name']);
            //查询扫码次数和时间
            $code_data=Db::table('info_total')->where(['total_code'=>$code])->first(['total_id','create_at','total_provin','total_city','total_num','total_nums','total_validation']);
            if($code_data){
                //增加次数
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_num',1,['total_good_id'=>$goods_data['gco_gid']]);
                Db::table('info_total')->where(['total_code'=>$code])->increment('total_nums',1,['total_good_id'=>$goods_data['gco_gid']]);
                $code_data['total_num']++;
                $code_data['total_nums']++;
            }else{
                // 判断是否有序列号
                $total_validation = DB::table('info_total')->where(['total_validation'=>$security])->value('total_validation');
                $total_code = DB::table('info_total')->where(['total_code'=>$code])->value('total_code');
                if ($total_validation == null && $total_code == null) {
                    //添加一条防伪记录
                    $code_data=[
                    'total_num'=>1,
                    'total_cid'=>$is_com[0]['gco_cid'],
                    'total_code'=>$code,
                    'total_state'=>1,
                    'total_good_id'=>$goods_data['gco_gid'],
                    'total_provin'=>$province,
                    'total_city'=>$city,
                    'create_at'=>date("Y-m-d H:i:s"),
                    'total_nums' => 1,
                    'total_validation' => $security
                    ];
                    Db::table('info_total')->insert($code_data);
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'序列号错误']);
                }
            }
            //替换数据
            $note_style['note_content']=str_replace('{goods}',$goods_data['goo_name'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{code}',$code,$note_style['note_content']);
            $note_style['note_content']=str_replace('{num}',$code_data['total_num'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{nums}',$code_data['total_nums'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{time}',$code_data['create_at'],$note_style['note_content']);
            $note_style['note_content']=str_replace('{pros}',$code_data['total_provin']." ".$code_data['total_city'],$note_style['note_content']);
            return response()->json(['code'=>200,'msg'=>'success','data'=>$note_style]);
        }
    }
    /**
     * [dealCode 获取二维码标识、年月]
     * @param  [type] $code [二维码号]
     * @return [type]       [返回二维码标识、年月]
     */
    private function dealCode($code)
    {
        $codeid = substr($code, 0, 5); //二维码标识
        $tab_yemo = substr($code, 5, 4); //年月
        return ['codeid'=>$codeid,'tab_yemo'=>$tab_yemo];
    }

    /**
     * [getTable 获取二维码表名]
     * @param  [type] $codeid   [二维码标识]
     * @param  [type] $tab_yemo [年月]
     * @return [type]           [description]
     */
    private function getTable($codeid, $tab_yemo)
    {
        // 查找码表是否存在
        $vtiger = DB::connection('mysql_two');
        $result = $vtiger->table('table_link')->where('tab_codeid', $codeid)
                ->where('tab_yemo', $tab_yemo)
                ->first(['tab_tablenam']);
        if ($result) {
            return ['code'=>200,'msg'=>'success','data'=>$result['tab_tablenam']];
        }else{
            return ['code'=>500,'msg'=>'error','data'=>'非本系统所属码'];
        }
    }

    //获取表名数据
    public function get_code_table($code){
        $end=substr($code,-1);
        $gro_number=Db::table("code".$end)->where(['code'=>$code])->pluck('batch_number');
        if(empty($gro_number)){
            return ['code'=>500,'msg'=>'error','data'=>'没有该二维码'];
        }
        $data=Db::table('group')->where(['gro_number'=>$gro_number])->first(['gro_codeid','gro_del','gro_cid','gro_num']);
        return ['code'=>200,'msg'=>'success','table_name'=>$data['gro_codeid'],'gro_number'=>$gro_number,'com_id'=>$data['gro_cid'],'num'=>$data['gro_num']];
    }
    /**
     * [getCodeData 获取产品码数据]
     * @param  [type] $type  [类型：1商品信息2环境信息3溯源信息]
     * @param  [type] $table [二维码表名]
     * @param  [type] $code  [二维码号]
     * @return [type]        [description]
     */
    private function getCodeData($type,$code)
    {
        // 获取产品码信息
        if (1 == $type) {
            $fields = 'gco_gid';//商品信息
        }else if(2 == $type){
            $fields = 'gco_envid';//环境信息
        }else if(3 == $type){
            $fields = 'gco_temstr';//溯源信息
        }
        $result = DB::table('formwork_code')
            ->where('gco_start','<=', $code)
            ->where('gco_end','>=',$code)
            ->get([$fields,'gco_group']);
        if ($result) {
            //获取批次信息
            $find_group = DB::table('group')->where('gro_number', $result[0]['gco_group'])
                ->first(['gro_release']);
            //判断产品码是否发布
            if (1 == $find_group['gro_release']) {
                return ['code'=>500,'msg'=>'error','data'=>'产品码尚未发布'];
            }
            if (1 == $type) {
                //商品信息
                $find_data = DB::table('goods')->where('goo_id', $result[0]['gco_gid'])
                    ->first(['goo_name','goo_picurl','goo_pro']);
                if (!empty($find_data['goo_picurl'])) {
                    $find_data['goo_picurl'] = explode(',', $find_data['goo_picurl']);
                }
                return ['code'=>200,'msg'=>'success','data'=>$find_data];
            }else if(2 == $type){
                // 环境信息
                $i = 0;
                foreach ($result as $key => $value) {
                    $find_data = DB::table('environment')->where('env_id', $value['gco_envid'])
                        ->get(['env_id','env_name','env_number','env_equipment_number','env_start_time','env_end_time','env_equipment']);
                    $device_time = [];//配置时间
                    $ASCIIValue = '';
                    foreach ($find_data as $k => $v) {
                        $i = 0;
                        if ($v['env_equipment_number']) {
                            $type = 1;//设备自动获取数据
                            $device_data = $v['env_equipment_number'];
                            $device_time['env_start_time'] = $v['env_start_time'] == '0000-00-00 00:00:00' ? '' : $v['env_start_time'];
                            $device_time['env_end_time'] = $v['env_end_time'] == '0000-00-00 00:00:00' ? '' : $v['env_end_time'];

                            // 查询最新一条数据的风向
                            $wind_explain = DB::table('device_wind_direction2')->where('DEVID',$device_data)
                                ->where(function($query) use($device_time) {
                                    if (!empty($device_time['env_end_time'] )) {
                                        $query->where('device_time', '<' ,$device_time['env_end_time'] );
                                    }
                                })
                                ->orderBy('id','desc')
                                ->first(['initial_data']);
                            if ($wind_explain) {
                                $initial_data = json_decode($wind_explain['initial_data'],true);
                                $ASCIIValue = $initial_data['ASCIIValue'];//风向，文字说明
                            }
                        } else {
                            $type = 2;//手动添加数据
                            if (isset($v['env_id'])) {
                                $device_data[$i] = $v['env_id'];
                            }else{
                                foreach ($v as $kkk => $vvv) {
                                    if ($kkk==$v['env_id']) {
                                        $device_data[$i] = $vvv['env_id'];
                                    }
                                }
                            }
                        }
                        $list[$i]['device_temperature'] = $this->findDeviceData('device_temperature',$device_data,$type,$device_time);//温度
                        $list[$i]['device_soil_temperature1'] = $this->findDeviceData('device_soil_temperature1',$device_data,$type,$device_time);//土壤温度1
                        $list[$i]['device_moisture'] = $this->findDeviceData('device_moisture',$device_data,$type,$device_time);//湿度
                        $list[$i]['device_soil_moisture1'] = $this->findDeviceData('device_soil_moisture1',$device_data,$type,$device_time);//土壤湿度1
                        $list[$i]['device_co2'] = $this->findDeviceData('device_co2',$device_data,$type,$device_time);//二氧化碳
                        $list[$i]['device_soil_ph'] = $this->findDeviceData('device_soil_ph',$device_data,$type,$device_time);//土壤pH
                        $list[$i]['device_soil_salinity'] = $this->findDeviceData('device_soil_salinity',$device_data,$type,$device_time);//土壤盐分
                        $list[$i]['device_wind_direction1'] = $this->findDeviceData('device_wind_direction1',$device_data,$type,$device_time);//风向1
                        $list[$i]['ASCIIValue'] = $ASCIIValue;//风向，文字说明
                        $list[$i]['device_wind_speed'] = $this->findDeviceData('device_wind_speed',$device_data,$type,$device_time);//风速
                        $list[$i]['device_illumination'] = $this->findDeviceData('device_illumination',$device_data,$type,$device_time);//光照度
                        $list[$i]['device_rainfall1'] = $this->findDeviceData('device_rainfall1',$device_data,$type,$device_time);//雨量1
                        $i++;
                        return ['code'=>200,'msg'=>'success','data'=>$list];
                    }
                }
            }else if(3 == $type){
                $gco_temstr = explode(',',$result[0]['gco_temstr']);
                $gco_temstr = array_filter($gco_temstr);//去除空值
                $temstr_id = array_unique($gco_temstr);//去重
                // 溯源信息
                $find_data = DB::table('formwork')->whereIn('fom_id', $temstr_id)
                    ->get(['fom_title','fom_content','fom_label']);
                return ['code'=>200,'msg'=>'success','data'=>$find_data];
            }
        } else {
            return ['code'=>500,'msg'=>'error','data'=>'未找到产品码'];
        }
    }

    // 查找环境的设备数据
    private function findDeviceData($table,$device_data,$type,$device_time)
    {
        if ($type == 1) {
            $fields = 'DEVID';
        }else {
            $fields = 'env_id';
        }
        $result = DB::table($table)->where($fields,$device_data)
                ->where(function($query) use($device_time) {
                    if (!empty($device_time['env_start_time'] )) {
                        $query->where('device_time', '>' ,$device_time['env_start_time'] );
                    }
                })
                ->where(function($query) use($device_time) {
                    if (!empty($device_time['env_end_time'] )) {
                        $query->where('device_time', '<' ,$device_time['env_end_time'] );
                    }
                })
                ->orderBy('id','desc')
                ->offset(0)->limit(20)
                ->get(['maximum','device_time']);
        if($result){
        
        }else{
            $result=array();
        }
        return $result;
    }

    //获取手机型号
    public function check_phone($user_agent){
        if (stripos($user_agent, "iPhone")!==false) {
            $brand = 'iPhone';
        } else if (stripos($user_agent, "SAMSUNG")!==false || stripos($user_agent, "Galaxy")!==false || strpos($user_agent, "GT-")!==false || strpos($user_agent, "SCH-")!==false || strpos($user_agent, "SM-")!==false) {
            $brand = '三星';
        } else if (stripos($user_agent, "Huawei")!==false || stripos($user_agent, "Honor")!==false || stripos($user_agent, "H60-")!==false || stripos($user_agent, "H30-")!==false) {
            $brand = '华为';
        } else if (stripos($user_agent, "Lenovo")!==false) {
            $brand = '联想';
        } else if (strpos($user_agent, "MI-ONE")!==false || strpos($user_agent, "MI 1S")!==false || strpos($user_agent, "MI 2")!==false || strpos($user_agent, "MI 3")!==false || strpos($user_agent, "MI 4")!==false || strpos($user_agent, "MI-4")!==false) {
            $brand = '小米';
        } else if (strpos($user_agent, "HM NOTE")!==false || strpos($user_agent, "HM201")!==false) {
            $brand = '红米';
        } else if (stripos($user_agent, "Coolpad")!==false || strpos($user_agent, "8190Q")!==false || strpos($user_agent, "5910")!==false) {
            $brand = '酷派';
        } else if (stripos($user_agent, "ZTE")!==false || stripos($user_agent, "X9180")!==false || stripos($user_agent, "N9180")!==false || stripos($user_agent, "U9180")!==false) {
            $brand = '中兴';
        } else if (stripos($user_agent, "OPPO")!==false || strpos($user_agent, "X9007")!==false || strpos($user_agent, "X907")!==false || strpos($user_agent, "X909")!==false || strpos($user_agent, "R831S")!==false || strpos($user_agent, "R827T")!==false || strpos($user_agent, "R821T")!==false || strpos($user_agent, "R811")!==false || strpos($user_agent, "R2017")!==false) {
            $brand = 'OPPO';
        } else if (strpos($user_agent, "HTC")!==false || stripos($user_agent, "Desire")!==false) {
            $brand = 'HTC';
        } else if (stripos($user_agent, "vivo")!==false) {
            $brand = 'vivo';
        } else if (stripos($user_agent, "K-Touch")!==false) {
            $brand = '天语';
        } else if (stripos($user_agent, "Nubia")!==false || stripos($user_agent, "NX50")!==false || stripos($user_agent, "NX40")!==false || stripos($user_agent, "NX")!==false) {
            $brand = '努比亚';
        } else if (strpos($user_agent, "M045")!==false || strpos($user_agent, "M032")!==false || strpos($user_agent, "M355")!==false) {
            $brand = '魅族';
        } else if (stripos($user_agent, "DOOV")!==false) {
            $brand = '朵唯';
        } else if (stripos($user_agent, "GFIVE")!==false) {
            $brand = '基伍';
        } else if (stripos($user_agent, "Gionee")!==false || strpos($user_agent, "GN")!==false) {
            $brand = '金立';
        } else if (stripos($user_agent, "HS-U")!==false || stripos($user_agent, "HS-E")!==false) {
            $brand = '海信';
        } else if (stripos($user_agent, "Nokia")!==false) {
            $brand = '诺基亚';
        } else {
            $brand = '其他';
        }
        return ['type'=>1,'data'=>$brand];
    }

    //获取操作系统
    public function get_system($user_agent){
        if(stripos($user_agent,'Android')){
            $brand='Android';
        }elseif(stripos($user_agent,'iPhone')){
            $brand='IOS';
        }elseif(stripos($user_agent,'iPhone')){
            $brand='Android';
        }elseif(stripos($user_agent,'Windows ')){
            $brand='Windows ';
        }else{
            $brand='其他';
        }
        return ['type'=>4,'data'=>$brand];
    }

    //获取软件
    public function get_software($user_agent){
        if(stripos($user_agent,'Firefox')){
            $brand='火狐';
        }elseif(stripos($user_agent,'MSIE')){
            $brand='IE';
        }elseif(stripos($user_agent,'UCBrowser')){
            $brand='UC浏览器';
        }elseif(stripos($user_agent,'QQ')){
            $brand='QQ';
        }elseif(stripos($user_agent,'MicroMessenger')){
            $brand='微信';
        }elseif(stripos($user_agent,'Chrome')){
            $brand='谷歌';
        }else{
            $brand='其他';
        }
        return ['type'=>2,'data'=>$brand];
    }

    // 根据ip查到运营商
    public function get_operator(){
        if ($_SERVER["REMOTE_ADDR"]=="")
        {
            $user_ip=$_SERVER["HTTP_X_FORWARDED_FOR"];
        }else{
            $user_ip=$_SERVER["REMOTE_ADDR"];
        }
        $url="https://api.ttt.sh/ip/qqwry/".$user_ip."?type=add";
        $ip_addr = file_get_contents($url);
        $ip_addr=json_decode($ip_addr,TRUE);
        if(strpos($ip_addr['address'],"电信") !== false){
            $ip_address = "电信"; 
        }else if(strpos($ip_addr['address'],"移动")){
            $ip_address = "移动";
        }else if(strpos($ip_addr['address'],"联通")){
            $ip_address = "联通";
        }else{
            $ip_address = "其他";
        }
        return ['type'=>3,'data'=>$ip_address];
    }
}