<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Session;
use App\Http\Models\Coperationa;
class LabelController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    // 标签列表
    public function index(Request $request)
    {
        $label_info = $request->all();
        // 解密token
        $api_token = Crypt::decrypt($request['api_token']);
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $userinfo = DB::table('channels_label')
                        ->where(function($query) use($label_info) {
                            if (!empty($label_info['label_name'] )) {
                                $query->where('label_name', 'like' , '%'.$label_info['label_name'].'%' );
                            }
                        })
                        ->where(function($query) use($label_info) {
                            if (!empty($label_info['label_state'] )) {
                                $query->where('label_state','=',$label_info['label_state']);
                            }
                        })
                        ->where('label_cid',$find_adm['adm_cid'])
                        ->where('label_state','!=',3)
                        ->select('label_id','label_name','label_state','label_time','label_total')
                        ->orderBy('label_id','desc')
                        ->paginate($this->show_count);

                        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
                        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
                        $data_info['total'] = $userinfo->total();               //总数据个数
                        $data_info['current_number'] = $this->show_count;       //一页显示多少个
                        $data_info['data'] = $userinfo->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info)
        {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'渠道标签获取成功','data_info'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'渠道标签获取失败']);
        }
    }
    // 添加渠道标签
    public function addlabel(Request $request)
    {
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        $input = $request->only('label_name','label_state');

        if(empty($input['label_name']) || empty($input['label_state']))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 判断渠道标签名称是否重复
        $label_name = DB::table('channels_label')->where('label_name',$input['label_name'])->first();
        if($label_name)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'渠道标签名称已存在']);
        }

        $res =  DB::table('channels_label')->insert([
                                'label_name'   =>$input['label_name'],          //标签名称
                                'label_state'  =>$input['label_state'],         //标签状态
                                'label_cid'    =>$adm_info['adm_cid'],          //标签状态
                                'label_time'   =>date('Y-m-d H:i:s',time())     //添加时间
                                ]);
        if(!$res)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加渠道标签失败']);
        }

        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','添加','添加'.$input['label_name']);
        return response()->json(["code"=>200,'msg'=>'success','data'=>'添加渠道标签成功']);
    }
    // 编辑渠道标签
    public function editlabel(Request $request)
    {
        $input = $request->only('label_name','label_state','label_id');

        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        $res = DB::table('channels_label')->where('label_id','=',$input['label_id'])
                                 ->update(['label_name'=>$input['label_name'],'label_state'=>$input['label_state'],'label_edittime'=>date('Y-m-d H:i:s',time())]);
        if(!$res)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','编辑','编辑'.$input['label_name']);
        return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑渠道标签成功']);
    }

    // 启用标签
    public function startlabel(Request $request)
    {
        $label_id = $request['label_id'];

        if(empty($label_id))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 状态1
        $label_stase = 1;
        // 操作名称
        $label_name = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name')->get();

        foreach($label_name as $k=>$v)
        {
            $name[] = $v['label_name'];
        }
        $name = implode($name,',');

        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->update(['label_state'=>$label_stase,'label_edittime'=>date('Y-m-d H:i:s',time())]);
        if(!$res)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'启用渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','启用','启用('.$name.')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'启用渠道标签成功']);
    }
    // 停用标签
    public function shoplabel(Request $request)
    {
       $label_id = $request['label_id'];

        if(empty($label_id))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 操作名称
        $label_name = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name')->get();
        foreach($label_name as $k=>$v)
        {
            $name[] = $v['label_name'];
        }
        $name = implode($name,',');
        // 状态
        $label_stase = 2;

        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->update(['label_state'=>$label_stase,'label_edittime'=>date('Y-m-d H:i:s',time())]);
        if(!$res)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','停用','停用('.$name.')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'停用渠道标签成功']);
    }
    // 删除标签
    public function dellabel(Request $request)
    {
       $label_id = $request['label_id'];

        if(empty($label_id))
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 操作名称
        $label_name = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name')->get();
        foreach($label_name as $k=>$v)
        {
            $name[] = $v['label_name'];
        }
        $name = implode($name,',');
        // 状态
        $label_stase = 3;

        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->update(['label_state'=>$label_stase,'label_edittime'=>date('Y-m-d H:i:s',time())]);
        if(!$res)
        {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'删除渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','删除','删除('.$name.')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除渠道标签成功']);
    }
}
