<?php
namespace App\Http\Controllers\Integral;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Integral\VerifyIntegralRecordController;

// 积分记录
class IntegralRecordController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 积分列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyIntegralRecordController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $userinfo = DB::table('integral_record as a')
                        ->leftJoin('channels as b', 'b.chan_id', '=', 'a.inte_chan_id')
                        ->where('a.inte_cid', $find_adm['adm_cid'])
                        ->where(function($query) use($find_adm) {
                            if ($find_adm['adm_chan_id'] > 0) {
                                $query->where('a.inte_chan_id', $find_adm['adm_chan_id']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            // 隶属渠道商
                            if (!empty($search_data['chan_enterprise_name'])) {
                                $query->where('b.chan_enterprise_name', 'like' , '%'.$search_data['chan_enterprise_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['inte_userid'])) {
                                $query->where('a.inte_userid', 'like' , '%'.$search_data['inte_userid'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['inte_user_name'])) {
                                $query->where('a.inte_user_name', 'like' , '%'.$search_data['inte_user_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['inte_user_phone'])) {
                                $query->where('a.inte_user_phone', 'like' , '%'.$search_data['inte_user_phone'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['inte_content'])) {
                                $query->where('a.inte_content', 'like' , '%'.$search_data['inte_content'].'%' );
                            }
                        })
                        ->select('a.inte_userid', 'b.chan_enterprise_name as parent_enterprise_name', 'a.inte_user_name', 'a.inte_user_phone', 'a.inte_state', 'a.inte_integral_number', 'a.inte_content', 'a.inte_type', 'a.inte_remain_integral', 'a.inte_operation_name', 'a.inte_operation_id', 'a.inte_addtime', 'a.inte_audit_state', 'a.warr_id')
                        ->orderBy('a.inte_id', 'desc')
                        ->paginate($this->show_count);
        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'], $request['pri_id']);

        if ($data_info) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'button'=>$button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
