<?php

namespace App\Http\Controllers\Integral;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\Verify\Integral\VerifyForItemController;

// 兑换物品
class ForItemController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 兑换物品信息
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $data_info = DB::table('for_items')
            ->where('fori_cid',$find_adm['adm_cid'])
            ->where('fori_chan_id',$find_adm['adm_chan_id'])
            ->where(function($query) use($search_data) {
                if (!empty($search_data['fori_item_name'])) {
                    $query->where('fori_item_name', 'like' , '%'.$search_data['fori_item_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['fori_state'] )) {
                    $query->where('fori_state', '=' ,$search_data['fori_state'] );
                }
            })
            ->select('fori_id','fori_item_name','fori_integral_number','fori_picurl','fori_number','fori_state','fori_remain_integral','fori_operation_name','fori_addtime')
            ->orderBy('fori_id','desc')
            ->paginate($this->show_count);
        // 获取当前列表下的按钮
        $listData['current_page'] = $data_info->currentPage();
        $listData['total'] = $data_info->total();
        $listData['data'] = $data_info->items();
        $listData['last_page'] = $data_info->lastPage();
        $listData['current_number'] = $this->show_count;
        $listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        $listData['code'] = 200;
        return response()->json($listData);
    }
    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        // 判断是否有该物品
        $item_name = DB::table('for_items')
            ->where(['fori_cid'=>$find_adm['adm_cid'],'fori_item_name'=>$request['fori_item_name']])
            ->value('fori_item_name');
        if ($item_name) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'物品名称已存在']);
        }
        $fori_picurl = '';
        if (!empty($request->input('fori_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            $uploadPath = $uploadImg->uploadBase64Img($request['fori_picurl']);
            if ($uploadPath){
                $fori_picurl .= $uploadPath;
            }else{
                return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
            }
            $fori_picurl = trim($fori_picurl,',');
        }
        $res = DB::table('for_items')->insert([
            'fori_item_name' => $request['fori_item_name'],
            'fori_number' => $request['fori_number'],
            'fori_integral_number' => $request['fori_integral_number'],
            'fori_remain_integral' => $request['fori_number'],
            'fori_picurl' => $fori_picurl,
            'fori_cid' => $find_adm['adm_cid'],
            'fori_operation_name' => $find_adm['adm_name'],
            'fori_operation_id' => $find_adm['adm_id'],
            'fori_chan_id' => $find_adm['adm_chan_id'],
            'fori_state'    =>2
            ]);
        if ($res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'兑换物品','添加','添加('.$request['fori_item_name'].')物品成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }
    // 编辑保存
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $fori_picurl = '';
        if (!empty($request->input('fori_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            if (stristr($request['fori_picurl'],'data:image')){
                $uploadPath = $uploadImg->uploadBase64Img($request['fori_picurl']);
                if ($uploadPath){
                    $fori_picurl .= $uploadPath;
                }else{
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                }
            }else{
                // 获取原图片路径
                $path = explode(config('app.url'),$request['fori_picurl']);
                $path_url = trim($path[1],'/');
                $path_type = explode('.',$path_url);
                // 新图片路径文件名
                $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                // 复制图片
                $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                // 返回路径
                $filePath = "storage". $pathName;
                $fori_picurl .= $filePath.',';
            }
            $fori_picurl = trim($fori_picurl,',');
        }
        $res = DB::table('for_items')
                ->where('fori_id',$request['fori_id'])
                ->update([
                    'fori_item_name' => $request['fori_item_name'],
                    'fori_number' => $request['fori_number'],
                    'fori_integral_number' => $request['fori_integral_number'],
                    'fori_remain_integral' => $request['fori_number'],
                    'fori_picurl' => $fori_picurl,
                    'fori_updatetime' => date('Y-m-d H:i:s'),
                    ]);
                       
        if($res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'兑换物品','编辑','编辑('.$request['fori_item_name'].')物品成功');
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'保存成功']);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'保存失败']);
        }
    }
    // 上架
    public function putaway(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->putawayValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 查询物品名称
        $for_data = DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->get(['fori_item_name']);
        foreach ($for_data as $key => $value) {
            $name[] = $value['fori_item_name'];
        }

        $update_data['fori_state'] = 2;//状态:1未上架2上架3下架
        $update_data['fori_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'兑换物品','上架','上架('.implode(',', $name).')物品成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'上架成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'上架失败']);
        }
    }

    // 下架
    public function soldout(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->putawayValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 查询物品名称
        $for_data = DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->get(['fori_item_name']);
        foreach ($for_data as $key => $value) {
            $name[] = $value['fori_item_name'];
        }
        
        $update_data['fori_state'] = 3;//状态:1未上架2上架3下架
        $update_data['fori_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'兑换物品','下架','下架('.implode(',', $name).')物品成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'下架成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'下架失败']);
        }
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyForItemController;
        $error_message = $verify_data->putawayValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 查询物品名称
        $for_data = DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->get(['fori_item_name']);
        foreach ($for_data as $key => $value) {
            $name[] = $value['fori_item_name'];
        }
        
        $tech_res =  DB::table('for_items')->whereIn('fori_id',$request['fori_id'])->delete();
        if($tech_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'兑换物品','删除','删除('.implode(',', $name).')物品成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }
}

