<?php
namespace App\Http\Controllers\Integral;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Integral\VerifyAutiRecordController;

// 兑换物品审核列表
class AutiRecordController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 兑换物品审核列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAutiRecordController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $userinfo = DB::table('audit_record as a')
                        ->leftJoin('channels as b', 'b.chan_id', '=', 'a.aure_chan_id')
                        ->where('a.aure_cid', $find_adm['adm_cid'])
                        ->where(function ($query) use ($find_adm) {
                            if ($find_adm['adm_chan_id'] > 0) {
                                $query->where('a.aure_chan_id', $find_adm['adm_chan_id']);
                            }
                        })
                        ->where(function ($query) use ($search_data) {
                            // 隶属渠道商
                            if (!empty($search_data['chan_enterprise_name'])) {
                                $query->where('b.chan_enterprise_name', 'like', '%'.$search_data['chan_enterprise_name'].'%');
                            }
                        })
                        ->where(function ($query) use ($search_data) {
                            if (!empty($search_data['aure_userid'])) {
                                $query->where('a.aure_userid', 'like', '%'.$search_data['aure_userid'].'%');
                            }
                        })
                        ->where(function ($query) use ($search_data) {
                            if (!empty($search_data['aure_user_name'])) {
                                $query->where('a.aure_user_name', 'like', '%'.$search_data['aure_user_name'].'%');
                            }
                        })
                        ->where(function ($query) use ($search_data) {
                            if (!empty($search_data['aure_user_phone'])) {
                                $query->where('a.aure_user_phone', 'like', '%'.$search_data['aure_user_phone'].'%');
                            }
                        })
                        ->where(function ($query) use ($search_data) {
                            if (!empty($search_data['aure_content'])) {
                                $query->where('a.aure_content', 'like', '%'.$search_data['aure_content'].'%');
                            }
                        })
                        ->select('a.aure_id', 'a.aure_userid', 'b.chan_enterprise_name as parent_enterprise_name', 'a.aure_user_name', 'a.aure_user_phone', 'a.aure_integral_number', 'a.aure_content', 'a.aure_type', 'a.aure_remain_auregral', 'a.aure_operation_name', 'a.aure_operation_id', 'a.aure_addtime', 'a.aure_audit_state')
                        ->orderBy('a.aure_id', 'desc')
                        ->paginate($this->show_count);
        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'], $request['pri_id']);

        if ($data_info) {
            return response()->json(['code'=>200 ,'msg'=>'success', 'data'=>$data_info, 'button'=>$button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 通过
    public function pass(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAutiRecordController;
        $error_message = $verify_data->passValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request['api_token']);

        // 查询数据
        $find_data = DB::table('audit_record')
            ->where('aure_id', $request['aure_id'])
            ->select('aure_id', 'aure_userid', 'aure_user_name', 'aure_integral_number', 'aure_audit_state', 'aure_type', 'aure_fori_id', 'aure_remain_auregral', 'aure_chan_id')
            ->first();
        if ($find_data['aure_audit_state'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该记录不是待审核状态']);
        }

        // 获取当前技师的openid值
        // 根据技师id 查询公司id，状态启用，质保数量>0
        $tech_id = DB::table('technician')
            ->where('tech_id', $find_data['aure_userid'])
            ->select('tech_openid', 'tech_cid', 'tech_state', 'tech_policy_number')
            ->first();

        $update_data['aure_audit_state'] = 2;   //状态1待审核2通过3驳回
        $update_data['aure_openid'] = $tech_id['tech_openid'];   //微信用户申请兑换红包的openid值
        $update_data['aure_updatetime'] = date('Y-m-d H:i:s');

        $update_datas['inte_audit_state'] = 2;   //状态1待审核2通过3驳回
        $update_datas['inte_remain_integral'] = $find_data['aure_remain_auregral'] + $find_data['aure_integral_number'];   //剩余积分
        $update_datas['inte_updatetime'] = date('Y-m-d H:i:s');

        DB::beginTransaction();

        $aure_res = DB::table('audit_record')
            ->where('aure_id', $request['aure_id'])
            ->update($update_data);

        $inre_res = DB::table('integral_record as a')
            ->leftjoin('audit_record as b', 'b.aure_inte_id', '=', 'a.inte_id')
            ->where('aure_id', $request['aure_id'])
            ->update($update_datas);

        if ($find_data['aure_type'] == 1) {
            // 更改渠道积分值
            $chan_res = DB::table('channels')
                ->where('chan_id', $find_data['aure_chan_id'])
                ->increment('chan_integral', $find_data['aure_integral_number']);
            if (!$chan_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'更改渠道积分值失败']);
            }
        } else {
            // 更改技师积分值
            $tech_res = DB::table('technician')
                ->where('tech_id', $find_data['aure_userid'])
                ->increment('tech_integral', $find_data['aure_integral_number']);
            if (!$tech_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'更改技师积分值失败']);
            }
            // 发送现金红包
            // if ($tech_id['tech_cid'] == '486' and $tech_id['tech_state'] == '1' and $tech_id['tech_policy_number'] > '0') {
            if ($tech_id['tech_cid'] == '25' and $tech_id['tech_state'] == '1' and $tech_id['tech_policy_number'] > '0') {
                //生成一个长度10，的阿拉伯数字随机字符串
                $rnd_num = array('0','1','2','3','4','5','6','7','8','9');
                $rndstr = "";
                while (strlen($rndstr)<10) {
                    $rndstr .= $rnd_num[array_rand($rnd_num)];
                }
                $mch_id       = '1541441401'; //微信支付分配的商户号
                $mch_billno   = $mch_id.date('YmdHis').rand(1000, 9999);//订单ID（商户订单号）
                $wxappid      = 'wx86e66784dc1b808a';//公众账号appid
                $send_name      = '雪佛龙官方商城'; //商户名称
                $re_openid      = $tech_id['tech_openid'];    //用户openid
                $total_amount = '100'; // 付款金额，单位分
                $total_num      = '1';   //红包发放总人数
                $wishing      = '感谢您参与';   //红包祝福语
                $act_name      = '兑换红包';   //活动名称
                $remark          = 'remarkcontent';      //备注
                $nonce_str      =  md5(rand()); //随机字符串，不长于32位
                $paysecret      = 'chevron2019Hengxi0624weixin17380';    //32位
                $redpack_info = array(
                    'mch_billno' => $mch_billno,
                    'mch_id' => $mch_id,
                    'wxappid' => $wxappid,
                    'send_name' => $send_name,
                    're_openid' => $re_openid,
                    'total_amount' => $total_amount,
                    'total_num' => $total_num,
                    'wishing' => $wishing,
                    'act_name' => $act_name,
                    'remark' => $remark,
                    'nonce_str'=> $nonce_str
                );
                
                $res = $this->sendRedpack($redpack_info);//发送现金红包
            }
        }

        if ($aure_res && $inre_res) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '兑换记录', '通过', '('.$find_data['aure_user_name'].')扣减积分成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'通过成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'通过失败']);
        }
    }

    // 驳回
    public function reject(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyAutiRecordController;
        $error_message = $verify_data->rejectValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request['api_token']);

        // 查询数据
        $find_data = DB::table('audit_record')
            ->where('aure_id', $request['aure_id'])
            ->select('aure_id', 'aure_cid', 'aure_chan_id', 'aure_userid', 'aure_user_name', 'aure_user_phone', 'aure_integral_number', 'aure_audit_state', 'aure_type', 'aure_fori_id', 'aure_remain_auregral')
            ->first();
        if ($find_data['aure_audit_state'] != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'该记录不是待审核状态']);
        }

        $forrs = DB::table('for_items')
            ->where('fori_id', $find_data['aure_fori_id'])
            ->select('fori_item_name', 'fori_remain_integral')
            ->first();
        
        // 兑换物品
        $update_data['aure_audit_state'] = 3;   //状态1待审核2通过3驳回
        $update_data['aure_remark'] = $request['aure_remark'];   //驳回备注
        // $update_data['aure_content'] = $request['aure_remark'];   //驳回备注
        $update_data['aure_integral_number'] = 0;   //驳回备注
        $update_data['aure_updatetime'] = date('Y-m-d H:i:s');

        // 添加积分操作记录
        $update_inte_datas['inte_audit_state'] = 3;   //状态1待审核2通过3驳回
        if ($find_data['aure_type'] == 1) {
            $chan_integral = DB::table('channels')
                ->where('chan_id', $find_data['aure_chan_id'])
                ->value('chan_integral');
            $update_inte_datas['inte_remain_integral'] = $chan_integral; //剩余积分
        } else {
            $tech_integral = DB::table('technician')
                ->where('tech_id', $find_data['aure_userid'])
                ->value('tech_integral');
            $update_inte_datas['inte_remain_integral'] = $tech_integral; //剩余积分
        }
        $update_inte_datas['inte_content'] = $request['aure_remark'];   //兑换内容/详情
        $update_inte_datas['inte_integral_number'] = 0;   //消耗积分
        $update_inte_datas['inte_updatetime'] = date('Y-m-d H:i:s');

        //物品数量增加
        $update_dates['fori_remain_integral'] = $forrs['fori_remain_integral'] + 1;
        $update_dates['fori_updatetime'] = date('Y-m-d H:i:s');

        DB::beginTransaction();

        // 添加积分记录
        $inre_res = DB::table('integral_record as a')
            ->leftjoin('audit_record as b', 'b.aure_inte_id', '=', 'a.inte_id')
            ->where('aure_id', $request['aure_id'])
            ->update($update_inte_datas);

        // 兑换物品驳回
        $aure_res = DB::table('audit_record')
            ->where('aure_id', $request['aure_id'])
            ->update($update_data);

        // 物品数量增加
        $fori_number = DB::table('for_items')
            ->where('fori_id', $find_data['aure_fori_id'])
            ->update($update_dates);

        if ($aure_res && $inre_res && $fori_number) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '兑换记录', '驳回', '('.$find_data['aure_user_name'].')驳回成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'驳回成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'驳回失败']);
        }
    }

    // 现金红包
    public function sendRedpack($array)
    {
        if ('/'==DIRECTORY_SEPARATOR) {
            $client_ip=$_SERVER['SERVER_ADDR'];
        } else {
            $client_ip=@gethostbyname($_SERVER['SERVER_NAME']);
        }
        $array['client_ip'] = $client_ip;
        array_filter($array); // 清空参数为空的数组元素
        ksort($array); // 按照参数名ASCII码从小到大排序
        $stringA = "";
        foreach ($array as $key => $row) {
            $stringA .= "&" . $key . '=' . $row;
        }
        $stringA = substr($stringA, 1);
        $paysecret      = 'chevron2019Hengxi0624weixin17380';    //32位
        // 拼接API密钥：
        $stringSignTemp = $stringA."&key=".$paysecret;
        $sign = strtoupper(md5($stringSignTemp));//签名
        $textTpl = '<xml>
                        <mch_billno><![CDATA[%s]]></mch_billno>
                        <mch_id><![CDATA[%s]]></mch_id>
                        <wxappid><![CDATA[%s]]></wxappid>
                        <send_name><![CDATA[%s]]></send_name>
                        <re_openid><![CDATA[%s]]></re_openid>
                        <total_amount><![CDATA[%s]]></total_amount>
                        <total_num><![CDATA[%s]]></total_num>
                        <wishing><![CDATA[%s]]></wishing>
                        <client_ip><![CDATA[%s]]></client_ip>
                        <act_name><![CDATA[%s]]></act_name>
                        <remark><![CDATA[%s]]></remark>
                        <nonce_str><![CDATA[%s]]></nonce_str>
                        <sign><![CDATA[%s]]></sign>
                    </xml>';
        $resultStr = sprintf($textTpl, $array['mch_billno'], $array['mch_id'], $array['wxappid'], $array['send_name'], $array['re_openid'], $array['total_amount'], $array['total_num'], $array['wishing'], $array['client_ip'], $array['act_name'], $array['remark'], $array['nonce_str'], $sign);
        $url = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
        // dump($resultStr);
        // exit;
        $this->curl_post_ssl($url, $resultStr);
    }

    private function curl_post_ssl($url, $param)
    {
        $postUrl = $url;
        $curlPost = $param;
        //初始化curl
        $ch = curl_init();
        //抓取指定网页
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        //设置header
        curl_setopt($ch, CURLOPT_HEADER, 0);
        //要求结果为字符串且输出到屏幕上
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //post提交方式
        curl_setopt($ch, CURLOPT_POST, 1);
        // 增加 HTTP Header（头）里的字段
        curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
        // 终止从服务端进行验证
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        
        //这个是证书的位置
        curl_setopt($ch, CURLOPT_SSLCERT, getcwd().'/apiclient_cert.pem');
        //这个也是证书的位置
        curl_setopt($ch, CURLOPT_SSLKEY, getcwd().'/apiclient_key.pem');
        //运行curl
        $data = curl_exec($ch);
        //关闭curl
        curl_close($ch);
         
        return $data;
    }

    public function curl_post_ssl2($vars, $url, $second=30, $aHeader=array())
    {
        $ch = curl_init();
        //超时时间
        curl_setopt($ch, CURLOPT_TIMEOUT, $second);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //这里设置代理，如果有的话
        //curl_setopt($ch,CURLOPT_PROXY, '10.206.30.98');
        //curl_setopt($ch,CURLOPT_PROXYPORT, 8080);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

        //以下两种方式需选择一种

        //第一种方法，cert 与 key 分别属于两个.pem文件
        //默认格式为PEM，可以注释
        curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');
        curl_setopt($ch, CURLOPT_SSLCERT, dirname(__FILE__).'/apiclient_cert.pem');
        //默认格式为PEM，可以注释
        curl_setopt($ch, CURLOPT_SSLKEYTYPE, 'PEM');
        curl_setopt($ch, CURLOPT_SSLKEY, dirname(__FILE__).'/apiclient_key.pem');

        curl_setopt($ch, CURLOPT_CAINFO, 'PEM');
        //引入上面2个PEM即可，下面这个貌似不用
        // curl_setopt($ch, CURLOPT_CAINFO, dirname(__FILE__).'/hongbao/rootca.pem');

        //第二种方式，两个文件合成一个.pem文件
        //curl_setopt($ch,CURLOPT_SSLCERT,getcwd().'/all.pem');

        if (count($aHeader) >= 1) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeader);
        }

        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        $data = curl_exec($ch);
        if ($data) {
            curl_close($ch);
            return $data;
        } else {
            $error = curl_errno($ch);
            echo "call faild, errorCode:$error\n";
            curl_close($ch);
            return false;
        }
    }

    public function curl_post_ssl1($url, $vars, $second=30, $aHeader=array())
    {
        $ch = curl_init();
        //超时时间
        curl_setopt($ch, CURLOPT_TIMEOUT, $second);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //这里设置代理，如果有的话
        //curl_setopt($ch,CURLOPT_PROXY, '10.206.30.98');
        //curl_setopt($ch,CURLOPT_PROXYPORT, 8080);
        curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
         
        //以下两种方式需选择一种
         
        //第一种方法，cert 与 key 分别属于两个.pem文件
        //默认格式为PEM，可以注释
        curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'PEM');
        curl_setopt($ch, CURLOPT_SSLCERT, './apiclient_cert.pem');
        //默认格式为PEM，可以注释
        curl_setopt($ch, CURLOPT_SSLKEYTYPE, 'PEM');
        curl_setopt($ch, CURLOPT_SSLKEY, './apiclient_key.pem');
        curl_setopt($ch, CURLOPT_CAINFO, 'rootca.pem');
         
        //第二种方式，两个文件合成一个.pem文件
        //curl_setopt($ch,CURLOPT_SSLCERT,getcwd().'/all.pem');
      
        if (count($aHeader) >= 1) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeader);
        }
      
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        $data = curl_exec($ch);
        if ($data) {
            $rsxml = simplexml_load_string($data);
                 
            if ($rsxml->result_code=='SUCCESS') {
                echo "业务结果成功<br/>";
            }
            echo "call success";
            curl_close($ch);
            return $data;
        } else {
            $error = curl_errno($ch);
            echo "call faild, errorCode:$error\n";
            curl_close($ch);
            return false;
        }
    }

    public function curl_post_ssls($url, $vars, $second = 30, $aHeader = array())
    {
        $ch = curl_init();
        //超时时间
        curl_setopt($ch, CURLOPT_TIMEOUT, $second);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        //这里设置代理，如果有的话
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        //cert 与 key 分别属于两个.pem文件
        //请确保您的libcurl版本是否支持双向认证，版本高于7.20.1
        curl_setopt($ch, CURLOPT_SSLCERT, dirname(__FILE__) . DIRECTORY_SEPARATOR .
            'zhengshu' . DIRECTORY_SEPARATOR . 'apiclient_cert.pem');
        curl_setopt($ch, CURLOPT_SSLKEY, dirname(__FILE__) . DIRECTORY_SEPARATOR .
            'zhengshu' . DIRECTORY_SEPARATOR . 'apiclient_key.pem');
        curl_setopt($ch, CURLOPT_CAINFO, dirname(__FILE__) . DIRECTORY_SEPARATOR .
            'zhengshu' . DIRECTORY_SEPARATOR . 'rootca.pem');
        if (count($aHeader) >= 1) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeader);
        }
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        $data = curl_exec($ch);
        if ($data) {
            curl_close($ch);
            return $data;
        } else {
            $error = curl_errno($ch);
            echo "call faild, errorCode:$error\n";
            curl_close($ch);
            return false;
        }
    }
}
