<?php

namespace App\Http\Controllers\Index;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use App\Http\Models\Coperationa;
use App\Http\Models\Index\Technician;

class HomeController extends Controller
{
    // 首页
    public function index(Request $request)
    {
        // 数据验证
        
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        switch ($request['search_type']) {
            case '1':
                // 技师积分值排行
                $technician_policy_top = Technician::integralTop($find_adm['adm_cid']);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$technician_policy_top]);
                break;
            case '2':
                // 技师质保单排行
                $technician_integral_top = Technician::policyTop($find_adm['adm_cid']);
                return response()->json(['code'=>200,'msg'=>'success','data'=>$technician_integral_top]);
                break;
            case '3':
                // 城市查询量
                break;
            case '4':
                // 商品查询量
                break;
            default:
                // 技师积分值排行
                $return_data['technician_integral_top'] = Technician::integralTop($find_adm['adm_cid']);
                break;
        }

        //统计商品分类数量，统计商品数量,统计溯源信息
        $goods['goods_number']=Db::table('goods')->where(['goo_sta'=>1,'goo_cid'=>$find_adm['adm_cid'],'del_type'=>1])->count();
        $goods['class_number']=Db::table('goo_classifi')->where(['cla_stase'=>1,'cla_cid'=>$find_adm['adm_cid']])->count();
        $goods['formwork_number']=Db::table('formwork')->where(['fom_stase'=>1,'fom_cid'=>$find_adm['adm_cid']])->count();
        $return_data['goods'] = $goods;

        $time=date("Ym");
        $count_sum=Db::table('group')->where(['gro_cid'=>$find_adm['adm_cid']])->whereRaw($time."=date_format(gro_time,'%Y%m')")->sum('gro_num');

        $goods_data=Db::table('group')->where(['gro_cid'=>$find_adm['adm_cid']])->where('goo_cid',$find_adm['adm_cid'])->whereRaw($time."=date_format(gro_time,'%Y%m')")->orderBy('number','desc')->groupBy('gro_gid')->join('goods','gro_gid','=','goo_id')->selectRaw('sum(gro_num) as number,trace_goods.goo_name as goods_name')->get();
        if(empty($goods_data)){
            $goods_orderby=[];
            $piechart_state=0;
        }else{
            $goods_num=array_sum(array_column($goods_data,'number'));
            $diff_num=$count_sum-$goods_num;

            if(count($goods_data)>9){
                $goods_b=array_splice($goods_data,9);
                $goods_or['goods_name']='其他';
                $goods_or['number']=array_sum(array_column($goods_b,'number'))+$diff_num;
                $goods_orderby=array_slice($goods_data,0,9);
                $goods_orderby[]=$goods_or;
            }elseif ($diff_num>0){
                $goods_or['goods_name']='其他';
                $goods_or['number']=$diff_num;
                $goods_data[]=$goods_or;
                $goods_orderby=$goods_data;
            }else{
                $goods_orderby=$goods_data;
            }
            foreach ($goods_orderby as $key => $val) {
                $goods_orderby[$key]['proportion']=number_format($val['number']/$count_sum*100,2);
            }
            $piechart_state=1;
        }
        $return_data['piechart_state'] = $piechart_state;
        $return_data['goods_orderby'] = $goods_orderby;

        //统计今年的查询量,发码量
        $year=date("Y");
        //统计今年的发码量
        $send_count=Db::table('statistic_send')->where(['sta_cid'=>$find_adm['adm_cid'],'sta_type'=>1,'sta_year'=>$year])->orderBy('month','asc')->select('sta_month as month','sta_total as number')->get();
        $send=array_column($send_count,'number','month');
        //统计今年的查询量
        $select_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2,'stal_cid'=>$find_adm['adm_cid']])->selectRaw("sum(stal_total) as number,stal_month as month")->orderBy('month','asc')->groupBy('month')->get();
        $select=array_column($select_count,'number','month');

        $year_count=[];
        $month=date('m');

        for($i=1;$i<=12;$i++){
            if($i<=$month){
                $year_count[$i-1]['month']  =(int)$i;
                $year_count[$i-1]['send_count']   =(int)(empty($send[$i])?0:$send[$i]);
                $year_count[$i-1]['select_count'] =(int)(empty($select[$i])?0:$select[$i]);
                $year_count[$i-1]['is_show'] =1;
            }else{
                $year_count[$i-1]['month']  =$i;
                $year_count[$i-1]['send_count']   =0;
                $year_count[$i-1]['select_count'] =0;
                $year_count[$i-1]['is_show'] =2;
            }
            
        }
        $return_data['year_count'] = $year_count;
        $return_data['month_count'] = count($year_count);
        //统计今年城市查询量
        $day = date("d");
        $city_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>1,'stal_cid'=>$find_adm['adm_cid']])->where("stal_city",'!=','未知')->selectRaw("sum(stal_total) as number,stal_city as city")->orderBy('stal_total','desc')->groupBy('stal_city')->limit(10)->get();
        // 统计今日查询量
        $city_counts=Db::table('statistic_look')->where(['stal_day'=>$day,'stal_type'=>1,'stal_cid'=>$find_adm['adm_cid']])->where("stal_city",'!=','未知')->selectRaw("sum(stal_total) as number,stal_city as city")->orderBy('stal_total','desc')->groupBy('stal_city')->limit(10)->get();
        
        //统计今年商品查询量
        $goods_count=Db::table('statistic_look')->where(['stal_year'=>$year,'stal_type'=>2,'stal_cid'=>$find_adm['adm_cid']])->selectRaw("sum(stal_total) as number,goo_name as goods_name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('stal_total','desc')->groupBy('stal_goo_id')->limit(10)->get();
        // 统计今日商品查询量
        $goods_counts=Db::table('statistic_look')->where(['stal_day'=>$day,'stal_type'=>2,'stal_cid'=>$find_adm['adm_cid']])->selectRaw("sum(stal_total) as number,goo_name as goods_name")->join('goods','goods.goo_id','=','statistic_look.stal_goo_id')->orderBy('stal_total','desc')->groupBy('stal_goo_id')->limit(10)->get();

        $city_count_state=1;
        if(empty($city_count)){
            $city_count_state=0;
        }

        $city_counts_state=1;
        if(empty($city_counts)){
            $city_counts_state=0;
        }

        $goods_count_state=1;
        if(empty($goods_count)){
            $goods_count_state=0;
        }

        $goods_counts_state=1;
        if(empty($goods_counts)){
            $goods_counts_state=0;
        }
        $return_data['city_count_state'] = $city_count_state;
        $return_data['city_count'] = $city_count;
        $return_data['city_counts_state'] = $city_counts_state;
        $return_data['city_counts'] = $city_counts;
        $return_data['goods_count_state'] = $goods_count_state;
        $return_data['goods_count'] = $goods_count;
        $return_data['goods_counts_state'] = $goods_counts_state;
        $return_data['goods_counts'] = $goods_counts;
        // 渠道商积分值排行
        $return_data['channels_top'] = DB::table('channels')
                        ->where('chan_cid', $find_adm['adm_cid'])
                        ->select('chan_integral','chan_enterprise_name')
                        ->orderBy('chan_integral','desc')
                        ->limit(10)
                        ->get();

        return response()->json(['code'=>200,'msg'=>'success','data'=>$return_data]);
    }
}
