<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
/**
 * 商品模板管理
 */
class GooFormworkController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
	protected $table = 'goo_formwork';//数据表

    // 列表查询
    public function index(Request $request)
    {
    	if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		if (!empty($request->input('for_stase'))) {
			if (!in_array($request->input('for_stase'),array(1,2))) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
			}
		}

		$data = $request->all();
		$list = DB::table('goo_formwork as a')
				->where('for_cid', $find_adm['adm_cid'])
				->where(function($query) use($data) {
					if (!empty($data['for_name'] )) {
						$query->where('a.for_name', 'like' , '%'.$data['for_name'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['for_stase'] )) {
						$query->where('a.for_stase', '=' ,$data['for_stase'] );
					}
				})
				->select('for_id','for_name','for_stase')
				->orderBy('for_id','desc')
				->paginate($this->show_count);

		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['last_page'] = $list->lastPage();
		$listData['current_number'] = $this->show_count;
		$listData['code'] = 200;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
		return response()->json($listData);
    }
    // 获取模板信息
    public function getFormworkInfo(Request $request){
		// 验证数据
		if (empty($request->input('for_id')) || !is_numeric($request->input('for_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		$list = DB::table('goo_formwork')
				->where('for_cid', $find_adm['adm_cid'])
				->where('for_id', $request->input('for_id'))
				->select('for_content','for_img')
				->first();
		$listData['data'] = json_decode($list['for_content']);
		$listData['img_state'] = $list['for_img'];
		$listData['code'] = 200;
		return response()->json($listData);
    }
    // 添加模板
	public function addgf(Request $request)
	{

		// 验证数据
		if (empty($request->input('for_name'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'模板名称不能为空']);
		}
		if (!in_array($request->input('for_img'),array(1,2))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择图片上传状态']);
		}

		foreach ($request->input('info_name') as $key => $value) {
			if (empty($value) || empty($request->input('info_content')[$key]) || !in_array($request->input('info_show')[$key],array(1,2)) ) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
			}
			$goo_pro[$key]['key'] = $value;
			$goo_pro[$key]['value'] = $request->input('info_content')[$key];
			$goo_pro[$key]['show'] = $request->input('info_show')[$key];
		}


		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 添加模板
		$time = date('Y-m-d H:i:s');
		$formwork_data = [
				$find_adm['adm_cid'], 
				$request->input('for_name').'--模板', 
				json_encode($goo_pro),
				$time,
				$request->input('for_img')
			];
		$res_formwork = DB::insert('insert into trace_goo_formwork ( `for_cid`, `for_name`, `for_content`, `for_creattime`, `for_img`) values(?,?,?,?,?)',$formwork_data);
		if ($res_formwork) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品模板','新增','新增“'.$request->input('for_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
		}
	}

	// 编辑模板
	public function editgf(Request $request)
	{

		// 验证数据
		if (empty($request->input('edit_id')) || !is_numeric($request->input('edit_id')) || !in_array($request->input('type'),array(1,2)) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}

		if ($request->input('type') == 1) {
			// 获取编辑模板信息
			// 根据token获取用户信息
			$find_adm = Coperationa::getUserInfo($request->input('api_token'));

			$list = DB::table('goo_formwork')
					->where('for_cid', $find_adm['adm_cid'])
					->where('for_id', $request->input('edit_id'))
					->select('for_name','for_content','for_img')
					->first();
			$list['for_name'] = mb_substr($list['for_name'], 0,mb_strlen($list['for_name'])-4 );
			$list['for_content'] = json_decode($list['for_content']);
			$listData['data'] = $list;
			$listData['code'] = 200;
			return response()->json($listData);
		}

		if (empty($request->input('for_name'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'模板名称不能为空']);
		}
		if (!in_array($request->input('for_img'),array(1,2))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择图片上传状态']);
		}

		foreach ($request->input('info_name') as $key => $value) {
			if (empty($value) || empty($request->input('info_content')[$key]) || !in_array($request->input('info_show')[$key],array(1,2)) ) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'信息项存在空项']);
			}
			$goo_pro[$key]['key'] = $value;
			$goo_pro[$key]['value'] = $request->input('info_content')[$key];
			$goo_pro[$key]['show'] = $request->input('info_show')[$key];
		}

		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 编辑模板
		$formwork_data = [
				$find_adm['adm_cid'], 
				$request->input('for_name').'--模板', 
				json_encode($goo_pro),
				$request->input('for_img'),
				$request->input('edit_id')
			];

		$res_formwork = DB::update('UPDATE `trace_goo_formwork` SET `for_cid`=?, `for_name`=?,`for_content`=?,`for_img`=? WHERE `for_id`=?',$formwork_data);

		if ($res_formwork) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品模板','编辑','编辑“'.$request->input('for_name').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
		}
	}

	// 删除商品模板
	public function delgf(Request $request){
		// 验证数据
		if ( empty($request->input('del_id')) || !is_array($request->input('del_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断删除个数
		if (count($request->input('del_id')) > 1) {
			$find_goods = DB::table($this->table)->whereIn('for_id', $request->input('del_id'))->select('for_name')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find_goods = DB::table($this->table)->where('for_id', $request->input('del_id'))->select('for_name')->get();
		}

		if (empty($find_goods)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品模板不存在或者已删除']);
		}

		// 判断商品模板是否绑定商品
		$find_group = DB::table('goods')
			->where('del_type',1)
			->where('goo_cid',$find_adm['adm_cid'])
			->$where_type('tem_id',$request->input('del_id'))
			->select('tem_id')->first();

		if ($find_group) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前商品模板已绑定商品，无法删除']);
		}

		$res_class = DB::table($this->table)
				->where('for_cid', $find_adm['adm_cid'])
				->$where_type('for_id', $request->input('del_id'))
				->delete();
		$goo_name = '';
		foreach ($find_goods as $key => $value) {
			$goo_name .= $value['for_name'].',';
		}

		if ($res_class) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品模板','删除','删除“'.trim($goo_name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'success','data'=>'删除失败']);
		}
	}
	// 启用
    public function open_state(Request $request)
    {
    	// 验证数据
		if (empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('edit_id')) > 1) {
			$find = DB::table('goo_formwork')->whereIn('for_id', $request->input('edit_id'))->select('for_name','for_stase')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find = DB::table('goo_formwork')->where('for_id', $request->input('edit_id'))->select('for_name','for_stase')->get();
		}
		if (empty($find)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前模板不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find as $key => $value) {
			if ($value['for_stase'] != 1) {
				$istype = true;
			}
			$name .= $value['for_name'].',';
		}

		if ($istype) {
			$result = DB::table('goo_formwork')
					->where('for_cid', $find_adm['adm_cid'])
					->$where_type('for_id', $request->input('edit_id'))
					->update(['for_stase'=>1]);
        } else {
            $result = true;
        }
		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品模板','启用','启用“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
		}
    }

    // 停用
    public function stop_state(Request $request)
    {
    	// 验证数据
		if (empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('edit_id')) > 1) {
			$find = DB::table('goo_formwork')->whereIn('for_id', $request->input('edit_id'))->select('for_name','for_stase')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find = DB::table('goo_formwork')->where('for_id', $request->input('edit_id'))->select('for_name','for_stase')->get();
		}
		if (empty($find)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前模板不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find as $key => $value) {
			if ($value['for_stase'] != 2) {
				$istype = true;
			}
			$name .= $value['for_name'].',';
		}

		if ($istype) {
			$result = DB::table('goo_formwork')
					->where('for_cid', $find_adm['adm_cid'])
					->$where_type('for_id', $request->input('edit_id'))
					->update(['for_stase'=>2]);
        } else {
            $result = true;
        }
		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'商品模板','停用','停用“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
		}
    }


}