<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Crypt;
use DB;
use App\Http\Models\Coperationa;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Verify\Source\VerifyFormworkController;

class FormworkController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 溯源列表主页
    public function indexformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // if (!$request->exists('fom_cretime_range0')|| !$request->exists('fom_cretime_range1')) {
        //     return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        // }
        $forminfo = $request->all();

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $data = DB::table('formwork as f')
            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
            ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['fom_title'] )) {
                    $query->where('f.fom_title', 'like' , '%'.$forminfo['fom_title'].'%' );
                }
            })
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['fom_number'] )) {
                    $query->where('fom_number', 'like' , '%'.$forminfo['fom_number'].'%' );
                }
            })
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['lab_name'] )) {
                    $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                }
            })
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['tem_name'] )) {
                    $query->where('tem_name', 'like' , '%'.$forminfo['tem_name'].'%' );
                }
            })
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['fom_stase'] )) {
                    $query->where('f.fom_stase','=',$forminfo['fom_stase']);
                }
            })
            ->where(function($query) use($forminfo) {
                //如果选择开始时间并且选择结束时间
                if (!empty($forminfo['fom_cretime_range0'] && $forminfo['fom_cretime_range1'])){
                    $query->whereBetween('fom_cretime',[$forminfo['fom_cretime_range0'],$forminfo['fom_cretime_range1']]);
                }else{
                    // 如果选择开始时间
                    if (!empty($forminfo['fom_cretime_range0'])){
                        $query->where('fom_cretime','>=',$forminfo['fom_cretime_range0']);
                    }else{
                        // 如果选择结束时间
                        if (!empty($forminfo['fom_cretime_range1'])) {
                            $query->where('fom_cretime','<=',$forminfo['fom_cretime_range1']);
                        }
                    }
                }
            })
            ->where('f.fom_stase','!=',3)
            ->where('f.fom_cid',$find_adm['adm_cid'])
            ->orderBy('f.fom_cretime','desc')
            ->select('fom_id','fom_title','fom_number','lab_name','tem_name','fom_cretime','fom_stase','fom_type')
            ->paginate($this->show_count);
        $data_info['current_page']   = $data->currentPage();  //当前页面页码
        $data_info['last_page']      = $data->lastPage();     //表示最后一页的页码
        $data_info['total']          = $data->total();        //总数据个数
        $data_info['current_number'] = $this->show_count;     //一页显示多少个
        $data_info['data']           = $data->items();        //返回数据
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);
        if ($find_adm['adm_id'] == '1') {
            $data_info['fom_cid'] = DB::table('admin')->where('adm_cid',$find_adm['adm_cid'])->value('adm_cid');
        }
        if ($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'溯源信息列表获取成功','data_info'=>$data_info,'button'=>$button]);
        } else {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'溯源信息列表获取失败']);
        }
    }

    // 获取标签/渠道列表-----用于添加
    public function labelist(Request $request)
    {
        // 根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));

        if ($user['adm_id'] == '1') {
            $data['fom_cid'] = DB::table('admin')->where('adm_cid',$user['adm_cid'])->value('adm_cid');
        }
        if ($request['type'] == '1') {
            $forminfo = $request->all();
            // 溯源管理 -- 标签
            $data['label'] = DB::table('form_label')
                ->where('lab_cid',$user['adm_cid'])
                ->where('lab_stase',1)
                ->where('lab_type',1)
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['lab_name'] )) {
                        $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                    }
                })
                ->orWhere('lab_cid',0)
                ->select('lab_id','lab_name')
                ->get();
            // 获取溯源模板信息
            $data['template'] = DB::table('formwork_template')
                ->where('tem_cid',$user['adm_cid'])
                ->where('tem_state',1)
                ->where('tem_type',1)
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['tem_name'] )) {
                        $query->where('tem_name', 'like' , '%'.$forminfo['tem_name'].'%' );
                    }
                })
                ->orWhere('tem_cid',0)
                ->select('tem_id','tem_name','tem_content','tem_img','tem_type_swaitch')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }else{
            $forminfo = $request->all();
            // 溯源管理 -- 标签
            $data['label'] = DB::table('form_label')
                ->where('lab_cid',$user['adm_cid'])
                ->where('lab_stase',1)
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['lab_name'] )) {
                        $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                    }
                })
                ->orWhere('lab_cid',0)
                ->select('lab_id','lab_name')
                ->get();
            // 获取溯源模板信息
            $data['template'] = DB::table('formwork_template')
                ->where('tem_cid',$user['adm_cid'])
                ->where('tem_state',1)
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['tem_name'] )) {
                        $query->where('tem_name', 'like' , '%'.$forminfo['tem_name'].'%' );
                    }
                })
                ->orWhere('tem_cid',0)
                ->select('tem_id','tem_name','tem_content','tem_img','tem_type_swaitch')
                ->get();
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
    }

    // 添加溯源列表
    public function addformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_title',trim($request['fom_title']))
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->select('fom_title')
            ->first();
        if($fom_title) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'信息名称已经存在']);
        }
        // 判断当前复制列表是否为复制列表
        if(strpos($request['fom_title'],'---副本') !==false){
             return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
        }

        $day=date('Ymd');
        $arr=[];
        foreach ($request['formkey'] as $key => $val) {
            $arr[$key]['key'] =$val;
            $arr[$key]['type'] =$request['formtype'][$key];
            $arr[$key]['show'] =$request['formshow'][$key];
            $url= $request['formvalue'][$key];   //信息项内容     
            if (($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)) {
                //判断是否是临时文件;
                if (strpos($url,'temporary')) {
                    $end = explode('.',$url)[1];  //获取后缀
                    $file_name = $arr[$key]['type']==2?'images':'videos';
                    $new_name = 'uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path = public_path().'/'.$new_name;  //新的文件地址
                    $old_url = public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if (!is_dir(dirname($new_path))) {
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                } else {
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }
            $arr[$key]['value'] = $url;
            $arr[$key]['content'] = $request['contents'][$key];
        }
        DB::beginTransaction();
        // 判断有这个模板吗?
        $lab = DB::table('formwork_template')
            ->where('tem_id',(int)$request['fom_temid'])
            ->where('tem_cid',$find_adm['adm_cid'])
            ->where('tem_state',1)
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name')
            ->first();
        if (empty($lab)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源模板']);
        } else {
            $res3 = DB::table('formwork_template')->where(['tem_id'=>(int)$request['fom_temid']])->increment('tem_total');
            if (!$res3) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改模板数量失败']);
            }
        }
        // 判断是否有这个标签
        $labels = DB::table('form_label')
            ->where('lab_id',(int)$request['fom_label'])
            ->where('lab_cid',$find_adm['adm_cid'])
            ->where('lab_stase',1)
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->first();
        if (empty($labels)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择溯源标签']);
        } else {
            $record = DB::table('form_label')->where(['lab_id'=>(int)$request['fom_label']])->increment('lab_total');
            if (!$record) {
                DB::rollBack();
                return response()->json(['code'=>500,'msg'=>'error','data'=>'更改标签数量失败']);
            }
        }
        $fom_picurl = '';
        if (!empty($request->input('fom_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('fom_picurl') as $key => $value) {
                $uploadPath = $uploadImg->uploadBase64Img($value);
                if ($uploadPath) {
                    $fom_picurl .= $uploadPath.',';
                } else {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }
        $fowo_add_data['fom_title'] = $request['fom_title'];
        $fowo_add_data['fom_label'] = $request['fom_label'];
        $fowo_add_data['fom_content'] = json_encode($arr);
        $fowo_add_data['fom_cid'] = $find_adm['adm_cid'];
        $fowo_add_data['fom_stase'] = 1;
        $fowo_add_data['fom_temid'] = $request['fom_temid'];
        $fowo_add_data['fom_number'] = $request['fom_number'];
        $fowo_add_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fowo_add_data['fom_picurl'] = $fom_picurl;
        $fowo_data = DB::table('formwork')->insert($fowo_add_data);

        if($fowo_data) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','新增','新增'.$request['fom_title'].'成功');
            DB::commit();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加溯源信息成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加溯源信息失败']);
        }
    }

    // 修改
    public function editformwork(Request $request)
    {
        // 根据token获取用户信息
        $user = Coperationa::getUserInfo($request->input('api_token'));
        if (!$user) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $forminfo = $request->all();
        $data = DB::table('formwork as f')
            ->leftjoin('formwork_template as ft','ft.tem_id','=','f.fom_temid')
            ->leftjoin('form_label as fl','fl.lab_id','=','f.fom_label')
            ->where('fom_id',$request['fom_id'])
            ->select('fom_id','fom_title','fom_cretime','fom_content','fom_label','tem_id','tem_name','lab_name','fom_picurl','fom_type')
            ->first();
        if (!$data) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'信息列表获取失败']);
        }
        // 溯源管理 -- 标签
        $data['label'] = DB::table('form_label')
            ->where(['lab_cid'=>$user['adm_cid'],'lab_stase'=>1])
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['lab_name'] )) {
                    $query->where('lab_name', 'like' , '%'.$forminfo['lab_name'].'%' );
                }
            })
            ->orWhere('lab_cid',0)
            ->select('lab_id','lab_name')
            ->get();
        // 模板列表
        $data['template'] = DB::table('formwork_template')
            ->where(['tem_cid'=>$user['adm_cid'],'tem_state'=>1])
            ->where(function($query) use($forminfo) {
                if (!empty($forminfo['tem_name'] )) {
                    $query->where('tem_name', 'like' , '%'.$forminfo['tem_name'].'%' );
                }
            })
            ->orWhere('tem_cid',0)
            ->select('tem_id','tem_name','tem_content','tem_img','tem_type_swaitch')
            ->get();
        $data['fom_content'] = object_array(json_decode($data['fom_content']));
        if ($data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'溯源信息列表获取成功','data'=>$data]);
        } else {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'溯源信息列表获取失败']);
        }
    }

    // 执行修改溯源列表
    public function doeditformwork(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 判断当前复制列表是否为复制列表
        if(strpos($request['fom_title'],'---副本') !==false){
             return response()->json(["code"=>500,'msg'=>'error','data'=>'请去掉信息名称中的 " ---副本 "']);
        }
        //根据token值获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        //判断信息名称是否存在
        $fom_title = DB::table('formwork')
            ->where('fom_cid',$find_adm['adm_cid'])
            ->where('fom_stase','<>',3)
            ->where('fom_id','<>',$request['fom_id'])
            ->where('fom_title',trim($request['fom_title']))
            ->select('fom_title','fom_id','fom_temid','fom_label')
            ->first();
        if ($fom_title['fom_title']) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'信息名称已经存在']);
        }

        // 判断是否更改信息所属模板
        if ($request->input('fom_temid') != $fom_title['fom_temid']) {
            // 更改模板所属标签数量
            $res_class1 = DB::update('UPDATE `trace_formwork_template` SET `tem_total`=`tem_total`+1  WHERE `tem_id`=?',[$request->input('fom_temid')] );
            $res_class2 = DB::update('UPDATE `trace_formwork_template` SET `tem_total`=`tem_total`-1  WHERE `tem_id`=?',[$fom_title['fom_temid']] );
            if ($res_class1 && $res_class2) {
                $res_class = true;
            }else{
                $res_class = false;
            }
        }else{
            $res_class = true;
        }
        // 判断是否更改信息所属标签
        if ($request->input('fom_label') != $fom_title['fom_label']) {
            // 更改信息所属标签数量
            $res_label1 = DB::update('UPDATE `trace_form_label` SET `lab_total`=`lab_total`+1  WHERE `lab_id`=?',[$request->input('fom_label')]);
            $res_label2 = DB::update('UPDATE `trace_form_label` SET `lab_total`=`lab_total`-1  WHERE `lab_id`=?',[$fom_title['fom_label']]);
            if ($res_label1 && $res_label2) {
                $res_label = true;
            }else{
                $res_label = false;
            }
        }else{
            $res_label = true;
        }
        
        $day=date('Ymd');
        $file_data=[];
        $arr=[];
        foreach ($request['formkey'] as $key => $val) {
            $arr[$key]['key'] =$val;   //信息项标题
            $arr[$key]['type'] =$request['formtype'][$key]; //属性类型
            $arr[$key]['show'] =$request['formshow'][$key]; //显示隐藏
            $url= $request['formvalue'][$key];   //信息项内容     
            if(($arr[$key]['type']==2 || $arr[$key]['type']==9) && !empty($url)){
                //判断是否是临时文件;
                if(strpos($url,'temporary')){
                    $end=explode('.',$url)[1];  //获取后缀
                    $file_name=$arr[$key]['type']==2?'images':'videos';
                    $new_name='uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    $new_path=public_path().'/'.$new_name;  //新的文件地址
                    $old_url=public_path().'/'.$url;  //旧的文件地址
                   //给新地址 赋予 所有权限;
                    if(!is_dir(dirname($new_path))){
                        mkdir(dirname($new_path), 0777, true);
                        chmod(dirname($new_path),0777);
                    }
                    rename($old_url,$new_path);  //移动
                    $url=$new_name;
                }else{
                    //不是从临时文件夹里 传递过来,代表是之前的数据，之前的数据保存到这个数组内。
                    $file_data[]=$url;
                }
            }   
            $arr[$key]['value'] = $url;
            $arr[$key]['content']=$request['contents'][$key];
        }
        $res_info = DB::table('formwork')->where('fom_id','=',$request['fom_id'])->first();

        $resinfo = object_array(json_decode($res_info['fom_content']));
        $fom_picurl = '';
        if (!empty($request->input('fom_picurl'))) {
            // 上传图片
            $uploadImg = new CommonController;
            foreach ($request->input('fom_picurl') as $key => $value) {
                if (stristr($value, 'data:image')) {
                    $uploadPath = $uploadImg->uploadBase64Img($value);
                    if ($uploadPath) {
                        $fom_picurl .= $uploadPath.',';
                    }else{
                        return response()->json(['code'=>500,'msg'=>'error','data'=>'图片上传失败']);
                    }
                }else{
                    // 获取原图片路径
                    $path = explode(config('app.url'),$value);
                    $path_url = trim($path[1],'/');
                    $path_type = explode('.',$path_url);
                    // 新图片路径文件名
                    $streamFileRand = time() . rand(11111,99999);//产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
                    $pathName = "/image/".$streamFileRand.'.'.$path_type[1];//获取上传图片路径
                    // 复制图片
                    $new_url = copy(base_path().'/'.$path_url, storage_path().$pathName);
                    // 返回路径
                    $filePath = "storage". $pathName;
                    $fom_picurl .= $filePath.',';
                }
            }
            $fom_picurl = trim($fom_picurl,',');
        }

        $fowo_edit_data['fom_title'] = $request['fom_title'];
        $fowo_edit_data['fom_label'] = $request['fom_label'];
        $fowo_edit_data['fom_content'] = json_encode($arr);
        $fowo_edit_data['fom_cid'] = $find_adm['adm_cid'];
        $fowo_edit_data['fom_stase'] = 1;
        $fowo_edit_data['fom_temid'] = $request['fom_temid'];
        $fowo_edit_data['fom_number'] = $request['fom_number'];
        $fowo_edit_data['fom_type'] = $request['fom_type'] ? $request['fom_type'] : 3;
        $fowo_edit_data['fom_picurl'] = $fom_picurl;
        $fowo_edit_data['fom_update_time'] = date('Y-m-d H:i:s');
        $res = DB::table('formwork')
            ->where('fom_id',$request['fom_id'])
            ->update($fowo_edit_data);

        DB::table('formwork')->where('fom_id','=',$res_info['fom_fid'])->decrement('fom_count');
        if($res)
        {
            $old_file=[];
            // 删除原图片或者视频
            foreach($resinfo as $key=>$value) {
                if($value['type'] == 2 || $value['type'] == 9) {
                    $old_file[]=$value['value'];
                }
            }

            //判断是否有之前的数据； 获取修改后的文件和之前的文件的差距。
            if(!empty($old_file)){
                $diff_file=array_diff($old_file,$file_data);
                if(!empty($diff_file)){
                    //删除旧的文件
                    foreach ($diff_file as $key => $val) {
                        chmod(public_path().'/'.$val,0777);
                        unlink(public_path().'/'.$val);
                    }
                }
            }
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','修改','修改'.$request['fom_title'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'修改溯源信息成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'修改溯源信息失败']);
        }
    }

    // 图片上传
    public function imageform(Request $request)
    {
        $image =  $request['images'];
        $imageName = "IMG_".date("His",time())."_".rand(1111,9999).'.png';
        // 当前文件根路径
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

        if(!empty($image))
        {
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $path = "uploads/formwork/temporary";

            if (!is_dir($path)){             //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc= $path."/". $imageName;  //图片名字

            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'溯源图片上传成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择图片']);
        }
    }

    // 视频上传
    public function videoform(Request $request)
    {
        $file =  $request->file('video');
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        $url_path = 'uploads/formwork/temporary';
        if (!is_dir($url_path)){             //判断目录是否存在 不存在就创建
            mkdir($url_path,0777,true);
        }
        $rule = ['mp4', 'avi', 'mov','rmvb','flv','3gp'];
        // 使用 hasFile 方法判断文件在请求中是否存在
        if ($request->hasFile('video')) {
            // 使用 isValid 方法判断文件在上传过程中是否出错
            if ($file->isValid())
            {   
                //获取文件名
                $clientName = $file->getClientOriginalName();
                //获取文件路径
                $realPath = $file->getRealPath();
                // 获取文件大小(字节)
                $filesize =   $file->getClientSize();
                // 换算成M
                $filesize = $filesize/(1024*1024);
                if($filesize > 50)
                {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'最大仅支持50M的视频上传']);
                }       
                $entension = $file->getClientOriginalExtension();
                if (!in_array($entension, $rule)) {
                    return response()->json(["code"=>500,'msg'=>'error','data'=>'仅支持视频为:mp4,avi,mov,rmvb,flv,3gp']);
                }
                // 生成上传文件名
                $newName = 'Video_'.date("H:i:s") .'_'. rand(1111,9999) . "." . $entension;
                $path = $file->move($upload_files.$url_path, $newName);
                // 返回路径
                $namePath = $url_path . '/' . $newName;
                return response()->json(["code"=>200,'msg'=>'success','data'=>'溯源视频上传成功','videoSrc'=>$namePath]);
            }else{
                return response()->json(["code"=>500,'msg'=>'error','data'=>'文件上传错误']);
            }
        }else{
            return response()->json(["code"=>9000,'msg'=>'error','data'=>'文件请求不存在']);
        }
    }

    // 删除视频
    public function delvideoform(Request $request)
    {
        $video =  $request['video'];
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        foreach($video as $k=>$v)
        {
            if(is_file($video[$k])){
                // 修改原視頻权限
                chmod($upload_files.$video[$k],0777);
                // 删除原視頻
                unlink($upload_files.$video[$k]); 
            } 
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'']);
    }

    // 删除图片
    public function delimageform(Request $request)
    {
        $image =  $request['images'];
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';
        foreach($image as $k=>$v)
        {
            if(is_file($image[$k])){
                // 修改原圖片权限
                chmod($upload_files.$image[$k],0777);
                // 删除原圖片
                unlink($upload_files.$image[$k]); 
            }
        }
        return response()->json(["code"=>200,'msg'=>'success','data'=>'']);
    }

    //停用状态
    public function shopstase(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $fom_id = $request['fom_id'];
        // 查找操作名称
        $fom_title = DB::table('formwork')
            ->whereIn('fom_id',$fom_id)
            ->get(['fom_title']);
        foreach($fom_title as $k=>$v) {
            $name[] = $v['fom_title'];
        }
        $name = implode($name,',');

        $fom_stase = 2;
        $res = DB::table('formwork')
            ->whereIn('fom_id',$fom_id)
            ->update(['fom_stase'=>$fom_stase]);
        if($res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','停用','停用('.$name.')溯源列表');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'信息列表停用成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'信息列表关闭失败']);
        }
    }
    // 启用状态
    public function startstase(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $fom_id = $request['fom_id'];
        // 查找操作名称
        $fom_title = DB::table('formwork')
            ->whereIn('fom_id',$fom_id)
            ->get(['fom_title']);
        foreach($fom_title as $k=>$v) {
            $name[] = $v['fom_title'];
        }
        $name = implode($name,',');

        $fom_stase = 1;
        $res = DB::table('formwork')
            ->whereIn('fom_id',$fom_id)
            ->update(['fom_stase'=>$fom_stase]);
        if($res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','启用','启用('.$name.')溯源列表');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'信息列表开启成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'信息列表开启失败']);
        }
    }
    // 复制列表
    public function copyform(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request['api_token']);
        $fom_id = $request['fom_id'];
        $formwork = DB::table('formwork')->where('fom_id',$fom_id)->first();
        // 判断当前复制列表是否为复制列表
        if(strpos($formwork['fom_title'],'---副本') !==false){
             return response()->json(["code"=>500,'msg'=>'error','data'=>'请编辑去掉信息中的 " ---副本 "']);
        }
        if($formwork['fom_count'] >= 30) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该列表已经复制30次,请修改其他列表名称']);
        }
        $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

        $fom_content = object_array(json_decode($formwork['fom_content']));
        $day=date('Ymd');
        foreach($fom_content as $key=>$value)
        {
            if($value['type'] == 2 || $value['type'] == 9 && !empty($value['value']))
            {
                if(is_file($upload_files.$value['value']))
                {
                    $end=explode('.',$value['value'])[1];  //获取后缀
                    $file_name=$value['type']==2?'images':'videos';
                    $new_name='uploads/formwork/'.$file_name.'/'.$day.'/'.date("H:i:s") .'_'. rand(1111,9999).'.'.$end; //新的文件名称
                    //修改权限
                    chmod($upload_files.$value['value'],0777);
                    //复制原文件
                    if (!is_dir($upload_files.'uploads/formwork/'.$file_name.'/'.$day)){             //判断目录是否存在 不存在就创建
                        mkdir($upload_files.'uploads/formwork/'.$file_name.'/'.$day,0777,true);
                    }
                    $handle = fopen($upload_files.$new_name, 'w');
                    copy($upload_files.$value['value'],$upload_files.$new_name); 
                    $fom_content[$key]['value'] = $new_name;
                }   
            }
        }
        // 判断该信息是否有图片
        if(!empty($formwork['fom_picurl']))
        {
            $fom_picurl = explode(',',$formwork['fom_picurl']);

            foreach($fom_picurl as $k=>$v)
            {
                // 生成文件名
                $img_name = "storage/image/".time() . rand(11111,99999);
                // 获取文件后缀
                $suffix =  explode(".",$v);
                $suffix = end($suffix);
                // 判断当前路径是否为文件
                if(is_file($_SERVER['DOCUMENT_ROOT'].'/'.$v))
                {
                    //修改权限
                    chmod($_SERVER['DOCUMENT_ROOT'].'/'.$v,0777);
                    //复制原文件
                    copy($_SERVER['DOCUMENT_ROOT'].'/'.$v,$_SERVER['DOCUMENT_ROOT'].'/'.$img_name.'.'.$suffix); 
                }
                // 拼接图片数组
                $fom_picurl[$k] =  $img_name.'.'.$suffix;
            }
            $formwork['fom_picurl'] = implode(',',$fom_picurl);
        }
        $res = DB::table('formwork')->insert([
                                             'fom_title'   => $formwork['fom_title'].'---副本'.(++$formwork['fom_count']),
                                             'fom_label'   => $formwork['fom_label'],
                                             'fom_temid'   => $formwork['fom_temid'],
                                             'fom_content' => json_encode($fom_content),
                                             'fom_cid'     => $formwork['fom_cid'],
                                             'fom_stase'   => $formwork['fom_stase'],
                                             'fom_fid'     => $fom_id,
                                             'fom_cretime' => date("Y-m-d H:i:s"),
                                             'fom_number'  => $formwork['fom_number'],
                                             'fom_type'    => $formwork['fom_type'],
                                             'fom_picurl'  => $formwork['fom_picurl']
                                             ]);
        DB::table('formwork')->where('fom_id',$fom_id)->update(['fom_count'=>($formwork['fom_count'])]);
        // 所属模板数量更改
        $res_class = DB::update('UPDATE `trace_formwork_template` SET `tem_total`=`tem_total`+1  WHERE `tem_id`=?',[$formwork['fom_temid']]);
        // 所属标签数量更改
        $res_labels = DB::update('UPDATE `trace_form_label` SET `lab_total`=`lab_total`+1  WHERE `lab_id`=?',[$formwork['fom_label']]);
        if($res && $res_class && $res_labels) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','复制','复制溯源列表');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'复制信息列表成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'复制信息列表失败']);
        }
    }
    // 删除
    public function delform(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyFormworkController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断删除个数
        if (count($request->input('fom_id')) > 1) {
            $find_tem = DB::table('formwork')->whereIn('fom_id', $request->input('fom_id'))->select('fom_title','fom_temid','fom_label')->get();
            $where_type = 'whereIn';
        } else {
            $where_type = 'where';
            $find_tem = DB::table('formwork')->where('fom_id', $request->input('fom_id'))->select('fom_title','fom_temid','fom_label')->get();
        }

        if (empty($find_tem)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前信息不存在或者已删除']);
        }

        DB::beginTransaction();
        $res = DB::table('formwork')
                ->where('fom_cid',$find_adm['adm_cid'])
                ->$where_type('fom_id',$request->input('fom_id'))
                ->update(['fom_stase'=>'3']);
        $fom_title = '';
        foreach ($find_tem as $key => $value) {
            $fom_title .= $value['fom_title'].',';
            $fom_temid[] = $value['fom_temid'];
            $fom_label[] = $value['fom_label'];
        }
        $fom_temid = array_count_values($fom_temid);
        $fom_label = array_count_values($fom_label);
        $del_sql = '';
        $ids = '';
        if (count($fom_temid) > 1 ) {
            // 所属标签模板数量更改
            $del_sql = 'UPDATE `trace_formwork_template` SET `tem_total`=  CASE `tem_id` ';
            foreach ($fom_temid as $key => $value) {
                $del_sql = $del_sql . ' WHEN ' .$key;
                $del_sql = $del_sql . ' THEN `tem_total`-' .$value;
                $ids = $ids . $key.',';
            }
            $del_sql = $del_sql . ' END WHERE `tem_id` IN ('.trim($ids,',').')';
        } else {
            $del_sql = 'UPDATE `trace_formwork_template` SET  `tem_total`= `tem_total`-'.end($fom_temid).'  WHERE  `tem_id` ='.key($fom_temid);
        }
        if (count($fom_label) > 1) {
            // 所属信息标签数量更改
            $del_sqls = 'UPDATE `trace_form_label` SET `lab_total` = CASE `lab_id` ';
            foreach ($fom_label as $key => $value) {
                $del_sqls = $del_sqls . ' WHEN ' .$key;
                $del_sqls = $del_sqls . ' THEN `lab_total`-' .$value;
                $ids = $ids . $key . ',';
            }
            $del_sqls = $del_sqls . ' END WHERE `lab_id` IN ('.trim($ids,',').')';
        } else {
            $del_sqls = 'UPDATE `trace_form_label` SET  `lab_total`= `lab_total`-'.end($fom_label).'  WHERE  `lab_id` ='.key($fom_label);
        }
        
        $res_tem = DB::update($del_sql);
        $res_lab = DB::update($del_sqls);
        if ($res && $res_lab && $res_tem) {
            DB::commit();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'溯源管理->信息列表','删除','删除“'.trim($fom_title,',').'”成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'信息删除成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'信息删除失败2']);
        }
    }
}
