<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
use App\Http\Models\InfoModify;
/**
 * 环境管理-设备列表
 */
class EquipmentController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 设备列表
    public function index(Request $request)
    {
        // 验证数据
        if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        
        if (!empty($request->input('equ_state'))) {
            if (!in_array($request->input('equ_state'),array(1,2))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
        }
        $data = $request->all();
        $list = DB::table('equipment as a')
                ->leftJoin('massif_region as b', 'a.equ_regid', '=', 'b.reg_id')
                ->leftJoin('massif_region as c', 'a.equ_landid', '=', 'c.reg_id')
                ->where('equ_cid', $find_adm['adm_cid'])
                ->where('equ_state', '<>',3)
                ->where(function($query) use($data) {
                    if (!empty($data['equ_state'] )) {
                        $query->where('equ_state', '=' ,$data['equ_state'] );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['equ_name'] )) {
                        $query->where('equ_name', 'like' , '%'.$data['equ_name'].'%' );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['equ_number'] )) {
                        $query->where('equ_number', 'like' , '%'.$data['equ_number'].'%' );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['equ_regid_name'] )) {
                        $query->where('b.reg_name', 'like' , '%'.$data['equ_regid_name'].'%' );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['equ_landid_name'] )) {
                        $query->where('c.reg_name', 'like' , '%'.$data['equ_landid_name'].'%' );
                    }
                })
                ->select('equ_id','equ_name','equ_number','equ_state','equ_time','equ_link','b.reg_name as equ_regid_name','c.reg_name as equ_landid_name')
                ->orderBy('equ_id','desc')
                ->paginate($this->show_count);

        $listData['data'] = $list->items();
        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['current_number'] = $this->show_count;
        $listData['last_page'] = $list->lastPage();
        $listData['code'] = 200;
        $listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        return response()->json($listData);
    }

    // 添加摄像头
    public function addeq(Request $request)
    {
        // 验证数据
        if (empty($request->input('type')) || !in_array($request->input('type'),[1,2]) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 页面查询数据
        if ( 1 == $request->input('type')) {
            // 监控区域数据，查询环境数据隶属地块
            if (empty($request->input('area')) || !in_array($request->input('area'),[1,2,3]) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            // 获取监控区域、地块、耕地信息
            return response()->json($this->getMassifRegion($find_adm['adm_cid'],$request->input('area'),$request->input('region_id',0)));
        }

        // 提交数据，验证数据
        if (empty($request->input('equ_name')) || empty($request->input('equ_number'))  || empty($request->input('equ_regid')) || !is_numeric($request->input('equ_regid')) || empty($request->input('equ_domain')) || empty($request->input('equ_http')) || empty($request->input('equ_rtsp')) || empty($request->input('equ_webserve')) || empty($request->input('equ_username')) || empty($request->input('equ_password')) || empty($request->input('equ_channel')) || empty($request->input('equ_get_channel')) || empty($request->input('equ_channel_domain')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        $data = [
            $request->input('equ_name'),
            $request->input('equ_number'),
            $request->input('equ_regid'),
            $request->input('equ_landid',0),
            $request->input('equ_culid',0),
            $request->input('equ_domain'),
            $request->input('equ_http'),
            $request->input('equ_rtsp'),
            $request->input('equ_webserve'),
            $request->input('equ_username'),
            $request->input('equ_password'),
            $request->input('equ_channel'),
            $request->input('equ_get_channel'),
            $request->input('equ_channel_domain'),
            $find_adm['adm_cid'],
            $find_adm['adm_id']
        ];
        $equ_res = DB::insert('INSERT INTO `trace_equipment` (`equ_name`, `equ_number`, `equ_regid`, `equ_landid`, `equ_culid`,  `equ_domain`, `equ_http`, `equ_rtsp`, `equ_webserve`, `equ_username`, `equ_password`, `equ_channel`, `equ_get_channel`, `equ_channel_domain`, `equ_time`, `equ_cid`, `equ_aid`) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$data);
        if ($equ_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','新增','新增“'.$request->input('equ_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }


    // 编辑摄像头
    public function editeq(Request $request)
    {
        // 验证数据
        if (empty($request->input('type')) || !in_array($request->input('type'),[1,2]) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 页面查询数据
        if ( 1 == $request->input('type')) {
            // 监控区域数据，查询环境数据隶属地块
            if (empty($request->input('area')) || !in_array($request->input('area'),[1,2,3,4]) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            if ( 4 == $request->input('area')) {
                // 查询信息
                $find_env = DB::table('equipment')
                    ->where('equ_cid', $find_adm['adm_cid'])
                    ->where('equ_id', $request->input('edit_id'))
                    ->select('equ_name','equ_number','equ_regid','equ_landid','equ_culid','equ_domain','equ_http','equ_rtsp','equ_webserve','equ_username','equ_password','equ_channel','equ_get_channel','equ_channel_domain')
                    ->first();

                if ($find_env['equ_regid']) {
                    // 编辑页面，获取监控区域、地块、耕地信息
                    $find_env['reg_data'] = $this->getEditData(1,$find_env['equ_regid']);
                }
                if ($find_env['equ_landid']) {
                    $find_env['land_data'] = $this->getEditData(1,$find_env['equ_landid']);
                }
                if ($find_env['equ_culid']) {
                    $find_env['cul_data'] = $this->getEditData(2,$find_env['equ_culid']);
                }
                return response()->json(['code'=>200,'msg'=>'success','data'=>$find_env]);
            }else{
                // 获取监控区域、地块、耕地信息
                return response()->json($this->getMassifRegion($find_adm['adm_cid'],$request->input('area'),$request->input('region_id',0)));
            }
        }

        // 提交数据，验证数据
        if (empty($request->input('equ_name')) || empty($request->input('equ_number'))  || empty($request->input('equ_regid')) || !is_numeric($request->input('equ_regid')) || empty($request->input('equ_domain')) || empty($request->input('equ_http')) || empty($request->input('equ_rtsp')) || empty($request->input('equ_webserve')) || empty($request->input('equ_username')) || empty($request->input('equ_password')) || empty($request->input('equ_channel')) || empty($request->input('equ_get_channel')) || empty($request->input('equ_channel_domain')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        $data = [
            $request->input('equ_name'),
            $request->input('equ_number'),
            $request->input('equ_regid'),
            $request->input('equ_landid',0),
            $request->input('equ_culid',0),
            $request->input('equ_domain'),
            $request->input('equ_http'),
            $request->input('equ_rtsp'),
            $request->input('equ_webserve'),
            $request->input('equ_username'),
            $request->input('equ_password'),
            $request->input('equ_channel'),
            $request->input('equ_get_channel'),
            $request->input('equ_channel_domain'),
            $find_adm['adm_id'],
            $request->input('edit_id')
        ];
        // 编辑信息
        $equ_res = DB::update('UPDATE `trace_equipment` SET `equ_name`=?,`equ_number`=?,`equ_regid`=?,`equ_landid`=?,`equ_culid`=?,`equ_domain`=?,`equ_http`=?,`equ_rtsp`=?,`equ_webserve`=?,`equ_username`=?,`equ_password`=?,`equ_channel`=?,`equ_get_channel`=?,`equ_channel_domain`=?,`equ_aid`=?,  WHERE `equ_id`=?',$data);
        if ($equ_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','编辑','编辑“'.$request->input('equ_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }

    // 获取监控区域、地块、耕地信息
    private function getMassifRegion($adm_cid,$area,$region_id)
    {
       // 监控区域数据，查询环境数据隶属地块
        if (1 == $area) {
            // 查询区域信息
            $list = DB::table('massif_region')
                ->where('reg_cid', $adm_cid)
                ->where('reg_state',1)
                ->where('reg_parent_id',0)
                ->select('reg_id','reg_name')
                ->orderBy('reg_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }else if( 2 == $area){
            if (empty($region_id) || !is_numeric($region_id) ) {
                return ['code'=>500,'msg'=>'error','data'=>'请输入区域id'];
            }
            // 查询地块信息
            $list = DB::table('massif_region')
                ->where('reg_cid', $adm_cid)
                ->where('reg_state',1)
                ->where('reg_parent_id',$region_id)
                ->select('reg_id','reg_name')
                ->orderBy('reg_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }else if(3 == $area){
            if (empty($region_id) || !is_numeric($region_id) ) {
                return ['code'=>500,'msg'=>'error','data'=>'请输入地块id'];
            }
            // 查询耕地信息
            $list = DB::table('cultivation')
                ->where('cul_cid', $adm_cid)
                ->where('cul_state',1)
                ->where('cul_type',1)
                ->where('reg_id',$region_id)
                ->select('cul_id','cul_name')
                ->orderBy('cul_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }
        return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
    }
    // 编辑页面，获取监控区域、地块、耕地信息
    private function getEditData($type,$reg_id)
    {
       // 监控区域数据，查询环境数据隶属地块
        if (1 == $type) {
            // 查询区域、地块信息
            $list = DB::table('massif_region')
                ->where('reg_id', $reg_id)
                ->select('reg_id','reg_name')
                ->first();
        }else if( 2 == $type){
            // 查询耕地信息
            $list = DB::table('cultivation')
                ->where('cul_id', $reg_id)
                ->select('cul_id','cul_name')
                ->first();
        }
        return $list;
    }

    // 设备启用
    public function open_state(Request $request)
    {
        // 验证数据
        if ( empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('edit_id')) > 1) {
            $find_class = DB::table('equipment')->whereIn('equ_id', $request->input('edit_id'))->select('equ_name','equ_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('equipment')->where('equ_id', $request->input('edit_id'))->select('equ_name','equ_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前摄像头不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['equ_state'] != 1) {
                $istype = true;
            }
            $class_name .= $value['equ_name'].',';
        }

        if ($istype) {
            $result = DB::table('equipment')
                    ->where('equ_cid', $find_adm['adm_cid'])
                    ->$where_type('equ_id', $request->input('edit_id'))
                    ->update(['equ_state'=>1]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','启用','启用“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 设备停用
    public function stop_state(Request $request)
    {
        // 验证数据
        if ( empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('edit_id')) > 1) {
            $find_class = DB::table('equipment')->whereIn('equ_id', $request->input('edit_id'))->select('equ_name','equ_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('equipment')->where('equ_id', $request->input('edit_id'))->select('equ_name','equ_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前摄像头不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['equ_state'] != 2) {
                $istype = true;
            }
            $class_name .= $value['equ_name'].',';
        }

        if ($istype) {
            $result = DB::table('equipment')
                    ->where('equ_cid', $find_adm['adm_cid'])
                    ->$where_type('equ_id', $request->input('edit_id'))
                    ->update(['equ_state'=>2]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','停用','停用“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }

    // 设备删除
    public function deleq(Request $request)
    {
        // 验证数据
        if ( empty($request->input('del_id')) || !is_array($request->input('del_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('del_id')) > 1) {
            $find_class = DB::table('equipment')->whereIn('equ_id', $request->input('del_id'))->select('equ_name','equ_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('equipment')->where('equ_id', $request->input('del_id'))->select('equ_name','equ_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前摄像头不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['equ_state'] != 3) {
                $istype = true;
            }
            $class_name .= $value['equ_name'].',';
        }

        if ($istype) {
            $result = DB::table('equipment')
                    ->where('equ_cid', $find_adm['adm_cid'])
                    ->$where_type('equ_id', $request->input('del_id'))
                    ->update(['equ_state'=>3]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','删除','删除“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }
    // 设备查看
    public function look(Request $request)
    {
        // 验证数据
        if ( empty($request->input('edit_id')) || !is_numeric($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $find_data = DB::table('equipment')->where('equ_id', $request->input('edit_id'))->select('equ_name','equ_number','equ_regid','equ_link')->first();
        // 编辑页面，获取监控区域、地块、耕地信息
        $find_data['reg_data'] = $this->getEditData(1,$find_data['equ_regid']);
        // 查询是否绑定环境信息
        $find_env_data = DB::select('SELECT env_id,env_name,env_number,env_equipment_number FROM `trace_environment` WHERE `env_id`= ( SELECT envir_id FROM `trace_massif_region` WHERE `reg_id`= '.$find_data['equ_regid'].' )');
        if (empty($find_env_data)) {
            // 没有绑定环境信息
            $find_data['env_data'] = '';
            $find_data['env_device_data'] = '';
            // 环境设备数据为空值
            $list['device_temperature'] = '';
            $list['device_soil_temperature1'] = '';
            $list['device_moisture'] = '';
            $list['device_soil_moisture1'] = '';
            $list['device_co2'] = '';
            $list['device_soil_ph'] = '';
            $list['device_soil_salinity'] = '';
            $list['device_wind_direction1'] = '';
            $list['device_wind_speed'] = '';
            $list['device_illumination'] = '';
            $list['device_rainfall1'] = '';
            $find_data['env_data'] = '';
            $find_data['env_device_data'] = $list;
        }else{
            $find_env_data = $find_env_data[0];
            // 判断是否添加设备编号
            if (empty($find_env_data['env_equipment_number'])) {
                $device_data = $find_env_data['env_id'];
                $type = 2;
            }else{
                $type = 1;
                $device_data = $find_env_data['env_equipment_number'];
            }
            $list['device_temperature'] = $this->findDeviceData('device_temperature',$device_data,$type);//温度
            $list['device_soil_temperature1'] = $this->findDeviceData('device_soil_temperature1',$device_data,$type);//土壤温度1
            // $list['device_soil_temperature2'] = $this->findDeviceData('device_soil_temperature2',$device_data,$type);//土壤温度2
            // $list['device_soil_temperature3'] = $this->findDeviceData('device_soil_temperature3',$device_data,$type);//土壤温度3
            $list['device_moisture'] = $this->findDeviceData('device_moisture',$device_data,$type);//湿度
            $list['device_soil_moisture1'] = $this->findDeviceData('device_soil_moisture1',$device_data,$type);//土壤湿度1
            // $list['device_soil_moisture2'] = $this->findDeviceData('device_soil_moisture2',$device_data,$type);//土壤湿度2
            // $list['device_soil_moisture3'] = $this->findDeviceData('device_soil_moisture3',$device_data,$type);//土壤湿度3
            $list['device_co2'] = $this->findDeviceData('device_co2',$device_data,$type);//二氧化碳
            $list['device_soil_ph'] = $this->findDeviceData('device_soil_ph',$device_data,$type);//土壤pH
            $list['device_soil_salinity'] = $this->findDeviceData('device_soil_salinity',$device_data,$type);//土壤盐分
            $list['device_wind_direction1'] = $this->findDeviceData('device_wind_direction1',$device_data,$type);//风向1
            // $list['device_wind_direction2'] = $this->findDeviceData('device_wind_direction2',$device_data,$type);//风向2
            // $list['ASCIIValue'] = $ASCIIValue;//风向，文字说明
            $list['device_wind_speed'] = $this->findDeviceData('device_wind_speed',$device_data,$type);//风速
            $list['device_illumination'] = $this->findDeviceData('device_illumination',$device_data,$type);//光照度
            $list['device_rainfall1'] = $this->findDeviceData('device_rainfall1',$device_data,$type);//雨量1
            // $list['device_rainfall2'] = $this->findDeviceData('device_rainfall2',$device_data,$type);//雨量2
            $find_data['env_data'] = $find_env_data;
            // $find_data['env_device_data'] = array_filter($list);//删除数组中所有等值为 FALSE 的条目
            $find_data['env_device_data'] = $list;
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>$find_data]);
    }

    // 查找环境的设备数据
    private function findDeviceData($table,$device_data,$type)
    {
        if ($type == 1) {
            $fields = 'DEVID';
        }else {
            $fields = 'env_id';
        }
        $result = DB::table($table)->where($fields,$device_data)
                ->select('maximum','minimum','average','unit','device_time')
                ->orderBy('id','desc')
                ->first();
        if($result){
        
        }else{
            $result=array();
        }
        return $result;
    }

    // 获取摄像头设备信息
    public function getCamera()
    {
        // $ch = curl_init();
        // $url="https://open.ys7.com/api/lapp/live/video/list?accessToken=at.8thmzh9k0l8ybwa78uq32rph1cyvoxt1-2vcgk65h93-19jpuek-cdmd6s8ml";
        // // curl_setopt($ch, CURLOPT_HTTPPOST, true);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //TRUE 将curl_exec()获取的信息以字符串返回，而不是直接输出。

        // $header = ['Accept:application/json'];
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $header);


        // curl_setopt($ch, CURLOPT_HEADER, 0); //返回response头部信息
        // curl_setopt($ch, CURLINFO_HEADER_OUT, true); //TRUE 时追踪句柄的请求字符串，从 PHP 5.1.3 开始可用。这个很关键，就是允许你查看请求header

        // curl_setopt($ch, CURLOPT_URL, $url);
        // $result = curl_exec($ch);
        // $device_data = json_decode($result,true);
        $url = 'https://open.ys7.com/api/lapp/live/video/lis';
        $data = ['accessToken'=>"at.7xx56lns07fqjigf2rpnkog522ma5nhh-2o98powfqr-08jumxq-ecfdahjpw"];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        try{
            $result = curl_exec($ch);
            $device_data = json_decode($result,true);
            var_dump($device_data);die;
        } finally{
            curl_close($ch);
        }
    }

}