<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Contracts\Support\JsonableInterface;

use App\Http\Models\Coperationa;
use App\Http\Models\InfoModify;
// 环境管理 -- 设备列表
class EnvironmentController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 设备列表
    public function index(Request $request)
    {
        // 验证数据
        if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        
        if (!empty($request->input('env_state'))) {
            if (!in_array($request->input('env_state'),array(1,2))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
        }
        $data = $request->all();
        $list = DB::table('environment')
                ->leftJoin('admin', 'admin.adm_id', '=', 'environment.env_aid')
                ->where('env_cid', $find_adm['adm_cid'])
                ->where('env_state', '<>',3)
                ->where(function($query) use($data) {
                    if (!empty($data['env_state'] )) {
                        $query->where('environment.env_state', '=' ,$data['env_state'] );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['env_name'] )) {
                        $query->where('environment.env_name', 'like' , '%'.$data['env_name'].'%' );
                    }
                })
                ->where(function($query) use($data) {
                    if (!empty($data['env_number'] )) {
                        $query->where('environment.env_number', 'like' , '%'.$data['env_number'].'%' );
                    }
                })
                ->select('env_id','env_name','env_number','env_state','env_time','env_equipment','env_equipment_number','adm_name')
                ->orderBy('env_id','desc')
                ->paginate($this->show_count);

        $listData['data'] = $list->items();
        foreach ($listData['data'] as $key => &$value) {
            $value['env_equipment'] = json_decode($value['env_equipment'],true);
        }

        $listData['current_page'] = $list->currentPage();
        $listData['total'] = $list->total();
        $listData['current_number'] = $this->show_count;
        $listData['last_page'] = $list->lastPage();
        $listData['code'] = 200;
        $listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
        // 验证是否有设备数据权限，1有权限 2无权限
        $verify_data = $this->deviceVerify($find_adm['adm_id']);
        $listData['device_state'] = empty($verify_data) ? 2 : 1;
        return response()->json($listData);
    }

    // 添加
    public function adden(Request $request)
    {
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 提交数据，验证数据
        if (empty($request->input('env_name')) || empty($request->input('info_name')) || empty($request->input('info_show')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        $env_equipment = [];
        // 环境设备信息数据整理
        foreach ($request->input('info_name') as $key => $value) {
            if (empty($value) ||  !in_array($request->input('info_show')[$key],array(1,2)) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'环境设备信息错误']);
            }
            $env_equipment[$key]['key'] = $value;
            $env_equipment[$key]['show'] = $request->input('info_show')[$key];
            $env_equipment[$key]['sort'] = $this->device_sort($value);
        }
        // $env_number = date('ymd').rand(0000,9999);
        $data = [
            $request->input('env_name'),
            $request->input('env_number'),
            $find_adm['adm_id'],
            $find_adm['adm_cid'],
            json_encode($env_equipment)
        ];
        // 添加环境监控
        $env_res = DB::insert('INSERT INTO `trace_environment` (`env_name`,`env_number`,`env_aid`, `env_cid`, `env_equipment`) values(?,?,?,?,?)',$data);
        if ($env_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'环境列表','新增','添加“'.$request->input('env_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'添加成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'添加失败']);
        }
    }
    // 编辑
    public function editen(Request $request)
    {
        // 验证数据
        if (empty($request->input('type')) || !in_array($request->input('type'),[1,2]) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 页面查询数据
        if ($request->input('type') == 1) {
            # 查询信息
            $find_env = DB::table('environment')
                        ->where('env_cid', $find_adm['adm_cid'])
                        ->where('env_id', $request->input('edit_id'))
                        ->select('env_name','env_number','env_equipment')
                        ->first();
            $find_env['env_equipment'] = json_decode($find_env['env_equipment']);
            return response()->json(['code'=>200,'msg'=>'success','data'=>$find_env]);
        }
        // 提交数据,验证数据
        if (empty($request->input('env_name')) || empty($request->input('info_name')) || empty($request->input('info_show')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $env_equipment = [];
        // 设备信息数据整理
        foreach ($request->input('info_name') as $key => $value) {
            if (empty($value) ||  !in_array($request->input('info_show')[$key],array(1,2)) ) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'环境设备信息错误']);
            }
            $env_equipment[$key]['key'] = $value;
            $env_equipment[$key]['show'] = $request->input('info_show')[$key];
            $env_equipment[$key]['sort'] = $this->device_sort($value);
        }
        $data = [
            $request->input('env_name'),
            $find_adm['adm_id'],
            json_encode($env_equipment),
            $request->input('edit_id')
        ];
        // 编辑环境监控
        $env_res = DB::update('UPDATE `trace_environment` SET `env_name`=?,`env_aid`=?,`env_equipment`=?  WHERE `env_id`=?',$data);
        if ($env_res) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'设备列表','编辑','编辑“'.$request->input('env_name').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }

    // 环境设备对应的编号
    private function device_sort($name)
    {
        $sort = '';
        switch ($name) {
            case '空气温度':
                $sort = 1;
                break;
            case '土壤温度':
                $sort = 2;
                break;
            case '空气湿度':
                $sort = 5;
                break;
            case '土壤湿度':
                $sort = 6;
                break;
            case '二氧化碳':
                $sort = 9;
                break;
            case '土壤pH':
                $sort = 10;
                break;
            case '土壤盐分':
                $sort = 11;
                break;
            case '风向':
                $sort = 12;
                break;
            case '风速':
                $sort = 14;
                break;
            case '光照度':
                $sort = 15;
                break;
            case '雨量':
                $sort = 16;
                break;
            default:
                $sort = 0;
                break;
        }
        return $sort;
    }
    // 获取监控区域、地块、耕地信息
    private function getMassifRegion($adm_cid,$area,$region_id)
    {
       // 监控区域数据，查询环境数据隶属地块
        if (1 == $area) {
            // 查询区域信息
            $list = DB::table('massif_region')
                ->where('reg_cid', $adm_cid)
                ->where('reg_state',1)
                ->where('reg_parent_id',0)
                ->select('reg_id','reg_name')
                ->orderBy('reg_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }else if( 2 == $area){
            if (empty($region_id) || !is_numeric($region_id) ) {
                return ['code'=>500,'msg'=>'error','data'=>'请输入区域id'];
            }
            // 查询地块信息
            $list = DB::table('massif_region')
                ->where('reg_cid', $adm_cid)
                ->where('reg_state',1)
                ->where('reg_parent_id',$region_id)
                ->select('reg_id','reg_name')
                ->orderBy('reg_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }else if(3 == $area){
            if (empty($region_id) || !is_numeric($region_id) ) {
                return ['code'=>500,'msg'=>'error','data'=>'请输入地块id'];
            }
            // 查询耕地信息
            $list = DB::table('cultivation')
                ->where('cul_cid', $adm_cid)
                ->where('cul_state',1)
                ->where('cul_type',1)
                ->where('reg_id',$region_id)
                ->select('cul_id','cul_name')
                ->orderBy('cul_id','desc')
                ->get();
            return ['code'=>200,'msg'=>'success','data'=>$list];
        }
        return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
    }
    // 编辑页面，获取监控区域、地块、耕地信息
    private function getEditData($type,$reg_id)
    {
       // 监控区域数据，查询环境数据隶属地块
        if (1 == $type) {
            // 查询区域、地块信息
            $list = DB::table('massif_region')
                ->where('reg_id', $reg_id)
                ->select('reg_id','reg_name')
                ->first();
        }else if( 2 == $type){
            // 查询耕地信息
            $list = DB::table('cultivation')
                ->where('cul_id', $reg_id)
                ->select('cul_id','cul_name')
                ->first();
        }
        return $list;
    }

    // 环境检测启用
    public function open_state(Request $request)
    {
        // 验证数据
        if ( empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('edit_id')) > 1) {
            $find_class = DB::table('environment')->whereIn('env_id', $request->input('edit_id'))->select('env_name','env_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('environment')->where('env_id', $request->input('edit_id'))->select('env_name','env_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前环境监控不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['env_state'] != 1) {
                $istype = true;
            }
            $class_name .= $value['env_name'].',';
        }

        if ($istype) {
            $result = DB::table('environment')
                    ->where('env_cid', $find_adm['adm_cid'])
                    ->$where_type('env_id', $request->input('edit_id'))
                    ->update(['env_state'=>1]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'环境列表','启用','启用“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 环境检测停用
    public function stop_state(Request $request)
    {
        // 验证数据
        if ( empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('edit_id')) > 1) {
            $find_class = DB::table('environment')->whereIn('env_id', $request->input('edit_id'))->select('env_name','env_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('environment')->where('env_id', $request->input('edit_id'))->select('env_name','env_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前环境监控不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['env_state'] != 2) {
                $istype = true;
            }
            $class_name .= $value['env_name'].',';
        }

        if ($istype) {
            $result = DB::table('environment')
                    ->where('env_cid', $find_adm['adm_cid'])
                    ->$where_type('env_id', $request->input('edit_id'))
                    ->update(['env_state'=>2]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'环境列表','停用','停用“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }

    // 环境检测删除
    public function delen(Request $request)
    {
        // 验证数据
        if ( empty($request->input('del_id')) || !is_array($request->input('del_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        // 判断个数
        if (count($request->input('del_id')) > 1) {
            $find_class = DB::table('environment')->whereIn('env_id', $request->input('del_id'))->select('env_name','env_state')->get();
            $where_type = 'whereIn';
        }else{
            $find_class = DB::table('environment')->where('env_id', $request->input('del_id'))->select('env_name','env_state')->get();
            $where_type = 'where';
        }

        if (empty($find_class)) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'当前环境监控不存在或者已删除']);
        }
        $class_name = '';
        $istype = false;
        foreach ($find_class as $key => $value) {
            if ($value['env_state'] != 3) {
                $istype = true;
            }
            $class_name .= $value['env_name'].',';
        }

        if ($istype) {
            $result = DB::table('environment')
                    ->where('env_cid', $find_adm['adm_cid'])
                    ->$where_type('env_id', $request->input('del_id'))
                    ->update(['env_state'=>3]);
        } else {
            $result = true;
        }

        if (!empty($result)) {
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'环境列表','删除','删除“'.trim($class_name,',').'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }

    // 环境检测配置
    public function configen(Request $request)
    {
        // 验证数据
        if (empty($request->input('type')) || !in_array($request->input('type'),[1,2]) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 查询配置信息
        if (1 == $request->input('type')) {
            $env_data = DB::table('environment')->where('env_id', $request->input('edit_id'))->select('env_equipment_type','env_equipment_number','env_start_time','env_end_time')->first();
            // 查询设备配置信息
            $type_data = DB::table('equipment_type')->select('equt_name')->get();
            $data['env_data'] = $env_data;
            $data['type_data'] = $type_data;
            return response()->json(['code'=>200,'msg'=>'success','data'=>$data]);
        }
        // 验证数据
        if (empty($request->input('env_equipment_type')) || empty($request->input('env_equipment_number')) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $data = [
            $request->input('env_equipment_type'),
            $request->input('env_equipment_number'),
            $request->input('env_start_time','0000-00-00 00:00:00'),
            $request->input('env_end_time','0000-00-00 00:00:00'),
            $find_adm['adm_id'],
            $request->input('edit_id')
        ];
        // 编辑环境监控
        $env_res = DB::update('UPDATE `trace_environment` SET `env_equipment_type`=?,`env_equipment_number`=?,`env_start_time`=?,`env_end_time`=?,`env_aid`=?  WHERE `env_id`=?',$data);
        if ($env_res) {
            $find_data = DB::table('environment')->where('env_id', $request->input('edit_id'))->select('env_name')->first();
            Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'环境列表','配置','配置“'.$find_data['env_name'] .'”成功');
            return response()->json(['code'=>200,'msg'=>'success','data'=>'配置成功']);
        }else{
            return response()->json(['code'=>500,'msg'=>'error','data'=>'配置失败']);
        }
    }

    // 环境列表-设备数据处理
    private function device(Request $request)
    {
        // 验证数据
        if (empty($request->input('sign')) || !in_array($request->input('sign'),[1,2,3,4]) || !$request->exists('env_id') || !is_numeric($request->input('env_id')) ) {
            return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
        }

        // 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 验证是否有权限
        $verify_data = $this->deviceVerify($find_adm['adm_id']);
        if (empty($verify_data)) {
            return ["code"=>500,'msg'=>'error','data'=>'此账号无权访问'];
        }
        if (1 == $request->input('sign')) {
            // 判断是否添加配置时间
            $find_data = DB::table('environment')->where('env_id', $request->input('env_id'))
                ->select('env_id','env_equipment_number','env_start_time','env_end_time')
                ->first();
            $device_time = [];//配置时间
            if ($find_data['env_equipment_number']) {
                $device_time['env_start_time'] = $find_data['env_start_time'] == '0000-00-00 00:00:00' ? '' : $find_data['env_start_time'];
                $device_time['env_end_time'] = $find_data['env_end_time'] == '0000-00-00 00:00:00' ? '' : $find_data['env_end_time'];
                $request->offsetSet('env_start_time', $device_time['env_start_time']);
                $request->offsetSet('env_end_time', $device_time['env_end_time']);
            } else {
                $request->offsetSet('env_start_time', '');
                $request->offsetSet('env_end_time', '');
            }
            // 列表接口
            $search_field = empty($request->input('env_equipment_number')) ? 'env_id' : 'DEVID';
            $search_field_value = empty($request->input('env_equipment_number')) ? $request->input('env_id') : $request->input('env_equipment_number');
            $data = $request->all();
            $lists = DB::table('environment')->where('env_cid', $find_adm['adm_cid'])->where('env_state', '<>',3)->select('env_id','env_equipment')->get();
            $list = DB::table($request->input('table'))
                    ->where($search_field, $search_field_value)
                    ->where(function($query) use($data) {
                        if (!empty($data['device_time'] )) {
                            $query->where('device_time', 'like' , '%'.$data['device_time'].'%' );
                        }
                    })
                    ->where(function($query) use($data) {
                        if (!empty($data['env_start_time'] )) {
                            $query->where('device_time', '>' ,$data['env_start_time'] );
                        }
                    })
                    ->where(function($query) use($data) {
                        if (!empty($data['env_end_time'] )) {
                            $query->where('device_time', '<' ,$data['env_end_time'] );
                        }
                    })
                    ->select('id','maximum','device_time')
                    ->orderBy('id','desc')
                    ->paginate($this->show_count);
            $listData['data'] = $list->items();
            $listData['lists'] = $lists;
            $listData['current_page'] = $list->currentPage();
            $listData['total'] = $list->total();
            $listData['current_number'] = $this->show_count;
            $listData['last_page'] = $list->lastPage();
            $listData['code'] = 200;
            return $listData;
        }else if(2 == $request->input('sign')){
            // 添加数据
            // 验证数据
            if (empty($request->input('device_time')) ) {
                return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
            }
            if (2 == $request->input('sort')) {
                // 数据添加类别，有几个是添加三个数值，最大值、最小值、平均值
                if (!$request->exists('maximum') || !is_numeric($request->input('maximum'))) {
                    return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
                }
            }
            $data = [
                $request->input('maximum',''),
                $request->input('device_time'),
                $request->input('env_id'),
                2
            ];
            $dev_res = DB::insert('INSERT INTO `trace_'.$request->input('table').'` (`maximum`, `device_time`, `env_id`, `type`) values(?,?,?,?)',$data);
            if ($dev_res) {
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),$request->input('log_title'),'添加','添加成功');
                return ['code'=>200,'msg'=>'success','data'=>'添加成功'];
            }else{
                return ['code'=>500,'msg'=>'error','data'=>'添加失败'];
            }
        }else if(3 == $request->input('sign')){
            // 编辑数据
            if (empty($request->input('type')) || !in_array($request->input('type'),[1,2]) || !$request->exists('edit_id') || !is_numeric($request->input('edit_id')) ) {
                return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
            }
            if (1 == $request->input('type')) {
                $data = DB::table($request->input('table'))
                    ->where('id', $request->input('edit_id'))
                    ->select('id','maximum','device_time')
                    ->first();
                return ['code'=>200,'msg'=>'success','data'=>$data];
            }

            // 验证数据
            if (empty($request->input('device_time')) ) {
                return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
            }
            if (2 == $request->input('sort')) {
                // 数据添加类别，有几个是添加三个数值，最大值、最小值、平均值
                if (!$request->exists('maximum') || !is_numeric($request->input('maximum'))) {
                    return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
                }
            }
            // 编辑数据
            $data = [
                $request->input('maximum',''),
                $request->input('device_time'),
                $request->input('env_id'),
                2,
                $request->input('edit_id')
            ];
            $dev_res = DB::update('UPDATE `trace_'.$request->input('table').'` SET `DEVID`="",`SersorID`="",`maximum`=?,`device_time`=?,`env_id`=?,`type`=?  WHERE `id`=?',$data);
            if ($dev_res) {
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),$request->input('log_title'),'编辑','编辑成功');
                return ['code'=>200,'msg'=>'success','data'=>'编辑成功'];
            }else{
                return ['code'=>500,'msg'=>'error','data'=>'编辑失败'];
            }
        }else if(4 == $request->input('sign')){
            // 验证数据
            if ( empty($request->input('del_id')) || !is_array($request->input('del_id')) ) {
                return ['code'=>500,'msg'=>'error','data'=>'参数错误'];
            }
            // 判断个数
            if (count($request->input('del_id')) > 1) {
                $where_type = 'whereIn';
            }else{
                $where_type = 'where';
            }
            $result = DB::table($request->input('table'))
                    ->where('env_id', $request->input('env_id'))
                    ->$where_type('id', $request->input('del_id'))
                    ->delete();
            if (!empty($result)) {
                Coperationa::add($find_adm['adm_id'],$request->getClientIp(),$request->input('log_title'),'删除','删除成功');
                return ['code'=>200,'msg'=>'success','data'=>'删除成功'];
            }else{
                return ['code'=>500,'msg'=>'error','data'=>'删除失败'];
            }
        }
    }
    
    // 设备数据权限验证
    private function deviceVerify($adm_id)
    {
        // 获取权限
        $role_info = DB::table('login_temporary')
                            ->where('adm_id','=',$adm_id)
                            ->select('role_auth')
                            ->first();
        // 对象转数组
        $role_info  = json_decode($role_info['role_auth'],true);
        $istype = false;
        foreach ($role_info as $key => $value) {
            if ($value['pri_funname'] == '设备数据') {
                // 判断是否有权限
                $istype = true;
            }
        }
        return $istype;
    }

    // 设备数据，人工录入数据
    public function device_data(Request $request)
    {
        // sort 类型 1 没有最大值、最小值数据，2有最大值、最小值数据
        switch ($request->input('class')) {
            case '1':
                $request->offsetSet('table', 'device_temperature');
                $request->offsetSet('log_title', '温度');
                $request->offsetSet('sort', 2);
                break;
            case '2':
                $request->offsetSet('table', 'device_soil_temperature1');
                $request->offsetSet('log_title', '土壤温度1');
                $request->offsetSet('sort', 2);
                break;
            case '3':
                $request->offsetSet('table', 'device_soil_temperature2');
                $request->offsetSet('log_title', '土壤温度2');
                $request->offsetSet('sort', 2);
                break;
            case '4':
                $request->offsetSet('table', 'device_soil_temperature3');
                $request->offsetSet('log_title', '土壤温度3');
                $request->offsetSet('sort', 2);
                break;
            case '5':
                $request->offsetSet('table', 'device_moisture');
                $request->offsetSet('log_title', '湿度');
                $request->offsetSet('sort', 2);
                break;
            case '6':
                $request->offsetSet('table', 'device_soil_moisture1');
                $request->offsetSet('log_title', '土壤湿度1');
                $request->offsetSet('sort', 2);
                break;
            case '7':
                $request->offsetSet('table', 'device_soil_moisture2');
                $request->offsetSet('log_title', '土壤湿度2');
                $request->offsetSet('sort', 2);
                break;
            case '8':
                $request->offsetSet('table', 'device_soil_moisture3');
                $request->offsetSet('log_title', '土壤湿度3');
                $request->offsetSet('sort', 2);
                break;
            case '9':
                $request->offsetSet('table', 'device_co2');
                $request->offsetSet('log_title', '二氧化碳');
                $request->offsetSet('sort', 1);
                break;
            case '10':
                $request->offsetSet('table', 'device_soil_ph');
                $request->offsetSet('log_title', '土壤pH');
                $request->offsetSet('sort', 2);
                break;
            case '11':
                $request->offsetSet('table', 'device_soil_salinity');
                $request->offsetSet('log_title', '土壤盐分');
                $request->offsetSet('sort', 2);
                break;
            case '12':
                $request->offsetSet('table', 'device_wind_direction1');
                $request->offsetSet('log_title', '风向1');
                $request->offsetSet('sort', 2);
                break;
            case '13':
                $request->offsetSet('table', 'device_wind_direction2');
                $request->offsetSet('log_title', '风向2');
                $request->offsetSet('sort', 2);
                break;
            case '14':
                $request->offsetSet('table', 'device_wind_speed');
                $request->offsetSet('log_title', '风速');
                $request->offsetSet('sort', 1);
                break;
            case '15':
                $request->offsetSet('table', 'device_illumination');
                $request->offsetSet('log_title', '光照度');
                $request->offsetSet('sort', 1);
                break;
            case '16':
                $request->offsetSet('table', 'device_rainfall1');
                $request->offsetSet('log_title', '雨量1');
                $request->offsetSet('sort', 2);
                break;
            case '17':
                $request->offsetSet('table', 'device_rainfall2');
                $request->offsetSet('log_title', '雨量2');
                $request->offsetSet('sort', 2);
                break;
            default:
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
                break;
        }
        return response()->json($this->device($request));
    }

    // 获取环境设备数据，自动获取数据
    public function getDevice(Request $request)
    {
        $ch = curl_init();
        // 设备请求接口地址
        // $url="http://www.zkzqyun.com/AppWIOTNEW/api/Collection?name=user&pw=a&DevID=900190";
        $url="http://www.zkzqyun.com/AppWIOTNEW/api/Collection?name=jlqy&pw=a&DevID=8300105";
        // curl_setopt($ch, CURLOPT_HTTPPOST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); //TRUE 将curl_exec()获取的信息以字符串返回，而不是直接输出。

        $header = ['Accept:application/json']; 
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        curl_setopt($ch, CURLOPT_HEADER, 0); //返回response头部信息
        curl_setopt($ch, CURLINFO_HEADER_OUT, true); //TRUE 时追踪句柄的请求字符串，从 PHP 5.1.3 开始可用。这个很关键，就是允许你查看请求header

        curl_setopt($ch, CURLOPT_URL, $url);
        $result = curl_exec($ch);
        $device_data = json_decode($result,true);
        foreach ($device_data['CollectionLists'] as $key => $value) {
            $table = '';
            // 根据设备名称，选择要添加的数据表
            switch ($value['Name']) {
                case '温度':
                    $table = 'device_temperature';
                    break;
                case '土壤温度1':
                    $table = 'device_soil_temperature1';
                    break;
                case '土壤温度2':
                    $table = 'device_soil_temperature2';
                    break;
                case '土壤温度3':
                    $table = 'device_soil_temperature3';
                    break;
                case '湿度':
                    $table = 'device_moisture';
                    break;
                case '土壤湿度1':
                    $table = 'device_soil_moisture1';
                    break;
                case '土壤湿度2':
                    $table = 'device_soil_moisture2';
                    break;
                case '土壤湿度3':
                    $table = 'device_soil_moisture3';
                    break;
                case '二氧化碳':
                    $table = 'device_co2';
                    break;
                case '土壤pH':
                    $table = 'device_soil_ph';
                    break;
                case '土壤盐分':
                    $table = 'device_soil_salinity';
                    break;
                case '风向':
                    if (is_numeric($value['ASCIIValue'])) {
                        $table = 'device_wind_direction1';//风向1
                    }else{
                        $table = 'device_wind_direction2';//风向2
                    }
                    break;
                case '风速':
                    $table = 'device_wind_speed';
                    break;
                case '光照度':
                    $table = 'device_illumination';
                    break;
                case '雨量':
                    if ($value['unit'] == 'mm/h') {
                        $table = 'device_rainfall1';//雨量1 mm/h
                    }else{
                        $table = 'device_rainfall2';//雨量2 mm/天
                    }
                    break;
                default:
                    $table = '';
                    break;
            }
            if ($table) {
                // 处理从设备获取的时间数据
                $time = explode('T',$value['RecordTime']);
                if (strpos($time[1],'.') !== false) {
                    $RecordTime = $time[0].' '.substr($time[1],0,strpos($time[1],'.'));
                }else{
                    $RecordTime = $time[0].' '.$time[1];
                }
                // 判断设备数据是否添加
                // if ($this->findDeviceData($table,$value['DEVID'],$RecordTime)) {
                //     continue;
                // }
                $data = [$value['MaxValue'],$value['MinValue'],$value['ASCIIValue'],$RecordTime,$value['DEVID'],$value['SersorID'],$value['unit'],1,json_encode($value)];
                $res = $this->addDeviceData($table,$data);
                if (!$res) {
                    return response()->json(['code'=>500,'msg'=>'error','data'=>'数据获取失败']);
                }
            }
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>'数据获取成功']);
    }

    // 查找获取的设备数据是否添加
    private function findDeviceData($table,$devid,$device_time)
    {
        return DB::table($table)->where('DEVID',$devid)->where('device_time',$device_time)->select('id')->first();
    }

    // 添加环境设备数据
    private function addDeviceData($table,$data)
    {
        // return DB::insert('INSERT INTO `trace_'.$table.'` (`maximum`, `minimum`, `average`, `device_time`, `DEVID`,`SersorID`,`unit`, `type`, `initial_data`) values(?,?,?,?,?,?,?,?,?)',$data);
        return DB::insert('INSERT INTO `trace_'.$table.'` (`maximum`, `device_time`, `type`, `initial_data`) values(?,?,?,?)',$data);
    }
}