<?php
namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\Verify\VerifyCodeController;

/**
 * 发码管理
 */
class CretecodeController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
	// 最大发码数量
	protected $max_gro_num = 100000;
	// 二维码表最大存储数据
	protected $max_code_table = 6000000;

	// 发码
	public function index(Request $request)
	{
		if (!in_array($request->input('type'), array(1, 2, 3))) {
			return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
		}
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		// 查找公司信息
		$find_company_info = DB::table('company_info')->where('info_cid', $find_adm['adm_cid'])
			->select('info_code_id', 'info_result_style')->first();
		$info_code_id = $find_company_info['info_code_id']; //公司标识
		if ($request->input('type') == 1) {
			// 从商品列表点击发码，传入商品id
			if (empty($request->input('goo_id')) || !is_numeric($request->input('goo_id'))) {
				return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误1']);
			}
			$find_goods = DB::table('goods')->where('goo_id', $request->input('goo_id'))
				->select('goo_id', 'goo_name', 'goo_number')->first();
			if ($find_goods) {
				return response()->json(['code' => 200, 'msg' => 'success', 'data' => $find_goods]);
			} else {
				return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误2']);
			}
		} elseif ($request->input('type') == 2) {
			$forminfo = $request->all();
			$goo_nav = DB::table('goods')
				->where(['goo_cid' => $find_adm['adm_cid'], 'goo_id' => $request->input('gro_gid', 0), 'del_type' => 1])
				->first(['goo_id', 'goo_navid']);
			if ($goo_nav['goo_navid'] == 1) {
				$data = DB::table('navigation')
					->where('nav_id', $goo_nav['goo_navid'])
					->where('nav_del', 1)
					->where('nav_state', 1)
					->Where('nav_cid', 0)
					->first(['nav_id', 'nav_name', 'nav_icon', 'nav_style']);
			} else {
				$data = DB::table('navigation')
					->where('nav_id', $goo_nav['goo_navid'])
					->where('nav_del', 1)
					->where('nav_state', 1)
					->Where('nav_cid', $find_adm['adm_cid'])
					->first(['nav_id', 'nav_name', 'nav_icon', 'nav_style']);
			}
			$data['nav_icon'] = json_decode($data['nav_icon'], true);
			$data['formworks'] = DB::table('formwork as f')
				->leftjoin('form_label as fl', 'fl.lab_id', '=', 'f.fom_label')
				->where(['fom_cid' => $find_adm['adm_cid'], 'fom_stase' => 1])
				->orWhere(['fom_cid' => 1])
				->where(function ($query) use ($forminfo) {
					if (!empty($forminfo['fom_title'])) {
						$query->where('f.fom_title', 'like', '%' . $forminfo['fom_title'] . '%');
					}
				})
				->where(function ($query) use ($forminfo) {
					if (!empty($forminfo['lab_name'])) {
						$query->where('lab_name', 'like', '%' . $forminfo['lab_name'] . '%');
					}
				})
				->orderBy('lab_id', 'desc')
				->get(['lab_id', 'lab_name', 'fom_id', 'fom_title', 'fom_content', 'fom_label']);

			return response()->json(['code' => 200, 'msg' => 'success', 'data' => '信息获取成功', 'data' => $data]);
		} else {
			// 提交发码数据
			// 验证数据
			if (!$request->exists('gro_release') || !in_array($request->input('gro_release'), array(1, 2)) || !$request->exists('gro_num') || !is_numeric($request->input('gro_num')) || !$request->has('gro_pnumber')) {
				return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误1']);
			}

			if ($request->input('gro_num') > $this->max_gro_num) {
				return response()->json(['code' => 500, 'msg' => 'error', 'data' => '发码数量超过' . $this->max_gro_num]);
			}

			// 查找商品发码量
			$find_goods_code = DB::table('goods_code')
				->where('gco_cid', $find_adm['adm_cid'])
				->first(['gco_id', 'gco_num']);
			if ($find_goods_code) {
				$isadd = "1";
				$code = $find_goods_code['gco_num'];
			} else {
				$isadd = "0";
				$code = "0";
			}
			// 分组编号
			$gro_number = time() . str_pad($find_adm['adm_cid'], 6, '0', STR_PAD_LEFT) . str_pad(rand(0, 999), 3, '0', STR_PAD_LEFT);
			$gro_validation = $request['gro_validation'];
			if ($request['gro_validation'] == '0') {
				$gro_valleaver = '0';
			} else {
				$gro_valleaver = $request['gro_valleaver']; //真伪序列号位数
			}
			$goo_nav = DB::table('goods')
				->where(['goo_cid' => $find_adm['adm_cid'], 'goo_id' => $request->input('gro_gid', 0), 'del_type' => 1])
				->first(['goo_id', 'goo_navid']);
			if ($goo_nav['goo_navid'] == 1) {
				$navigation = DB::table('navigation')
					->where('nav_id', $goo_nav['goo_navid'])
					->where('nav_del', 1)
					->where('nav_state', 1)
					->Where('nav_cid', 0)
					->first(['nav_id', 'nav_name', 'nav_icon', 'nav_style']);
			} else {
				$navigation = DB::table('navigation')
					->where('nav_id', $goo_nav['goo_navid'])
					->where('nav_del', 1)
					->where('nav_state', 1)
					->Where('nav_cid', $find_adm['adm_cid'])
					->first(['nav_id', 'nav_name', 'nav_icon', 'nav_style']);
			}
			$info_result_style = $navigation['nav_style']; //终端展示样式
			// $info_result_style = $find_company_info['info_result_style']; //终端展示样式
			$time = date('Y-m-d H:i:s');
			// $gro_valleaver = $request['gro_valleaver'];//真伪序列号位数
			$file_name = $request['file_name'];

			$gco_temstr = implode(',', $request['gco_temstr']);
			$gco_envid = implode(',', $request['gco_envid']);
			// 查询是否绑定商品
			if ($request->input('nums') == 33) {
				if (empty($request->input('gro_gid')) || !is_numeric($request->input('gro_gid')) || empty($request->input('gro_good_name'))) {
					return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误2']);
				}
				//需补充码位数
				$ns = $request['nums'] - 25;
				// 查询商品条形码
				$goods = DB::table('goods')->where('goo_id', $request['gro_gid'])->where('goo_cid', $find_adm['adm_cid'])->value('goo_number');
				$st = strlen($goods);
				if ($st != '13' || !is_numeric($goods)) {
					return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该商品只能普通发码(20位)']);
				}
				// 查询结束编号是否存在
				$groups = DB::table('group')->where('gro_cid', $find_adm['adm_cid'])->where('nums', $request['nums'])->orderBy('gro_id', 'desc')->value('code_end');
				if ($groups) {
					$number = $info_code_id . date("ym") . $goods . str_pad(strval($groups), $ns, '0', STR_PAD_LEFT);
					$num = (int) substr($groups, 22, -3);
					if ($num) {
						$code_start = $num;
					} else {
						$code_start = 1;
					}
					$code_start = $code_start + 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					$code_end = number_format($code_ends, 0, '', '') - 1;
				} else {
					$code_start = 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					$code_end = number_format($code_ends, 0, '', '') - 1;
				}
				$code_ks = $info_code_id . date("ym") . $goods . str_pad(strval($code_start), $ns, '0', STR_PAD_LEFT);
				$code_js = $info_code_id . date("ym") . $goods . str_pad(strval($code_end), $ns, '0', STR_PAD_LEFT);

				//生成校验位
				$verify_code = VerifyCodeController::generateVerify($code_ks, 3);
				$verify_codes = VerifyCodeController::generateVerify($code_js, 3);
				if (!$verify_code) {
					return response()->json(['code' => 500, 'msg' => 'error', 'data' => '校验位生成失败']);
				} else {
					$code_ks .= $verify_code;
					$code_js .= $verify_codes;
				}
				// 查询商品有效期
				$validity_period = DB::table('goods')->where('goo_id', $request['gro_gid'])->where('goo_cid', $find_adm['adm_cid'])->value('validity_period');
				$expire_time = date('Y-m-d', strtotime($request['production_date'] . ' + ' . $validity_period . ' day'));
			} elseif ($request->input('nums') == 20) {
				//需补充码位数
				$numbernums = $request['nums'] - 12;
				// 查询结束编号是否存在
				$groups = DB::table('group')->where('gro_cid', $find_adm['adm_cid'])->where('nums', $request['nums'])->orderBy('gro_id', 'desc')->value('code_end');
				if ($groups) {
					$number = $info_code_id . date("ym") . str_pad(strval($groups), $numbernums, '0', STR_PAD_LEFT);
					$num = (int) substr($groups, 9, -3);
					if ($num) {
						$code_start = $num;
					} else {
						$code_start = 1;
					}
					$code_start = $code_start + 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					$code_end = number_format($code_ends, 0, '', '') - 1;
				} else {
					$code_start = 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					$code_end = number_format($code_ends, 0, '', '') - 1;
				}

				$code_ks = $info_code_id . date("ym") . str_pad(strval($code_start), $numbernums, '0', STR_PAD_LEFT);
				$code_js = $info_code_id . date("ym") . str_pad(strval($code_end), $numbernums, '0', STR_PAD_LEFT);
				//生成校验位
				$verify_code = VerifyCodeController::generateVerify($code_ks, 3);
				$verify_codes = VerifyCodeController::generateVerify($code_js, 3);

				if (!$verify_code) {
					return response()->json(['code' => 500, 'msg' => 'error', 'data' => '校验位生成失败']);
				} else {
					$code_ks .= $verify_code;
					$code_js .= $verify_codes;
				}
				// 查询商品有效期
				$validity_period = DB::table('goods')->where('goo_id', $request['gro_gid'])->where('goo_cid', $find_adm['adm_cid'])->value('validity_period');
				$expire_time = date('Y-m-d', strtotime($request['production_date'] . ' + ' . $validity_period . ' day'));
			} elseif ($request->input('nums') == 11) { //产品码位数11位
				// 编码规则 一位品牌标识+一位厂区标识+两位年份+一位月份+六位序列号
				//需补充码位数
				$numbernums = $request['nums'] - 5;
				$gro_brand = $request['gro_brand']; //品牌标识9统一6法拉利
				$gro_factory = $request['gro_factory']; //厂区标识老厂标示为A，新厂标示为B
				// 获取当前年份
				$year = $request['year'];
				// 获取当前月份
				$month = date('m');
				if ($month == '1') {
					$months = 'A';
				} elseif ($month == '2') {
					$months = 'B';
				} elseif ($month == '3') {
					$months = 'C';
				} elseif ($month == '4') {
					$months = 'D';
				} elseif ($month == '5') {
					$months = 'E';
				} elseif ($month == '6') {
					$months = 'F';
				} elseif ($month == '7') {
					$months = 'G';
				} elseif ($month == '8') {
					$months = 'H';
				} elseif ($month == '9') {
					$months = 'I';
				} elseif ($month == '10') {
					$months = 'J';
				} elseif ($month == '11') {
					$months = 'K';
				} elseif ($month == '12') {
					$months = 'L';
				}
				// 查询结束编号是否存在
				$groups = DB::table('group')
					->where('gro_cid', $find_adm['adm_cid'])
					->where('nums', $request['nums'])
					->where('gro_month', $month)
					->where('gro_brand', $gro_brand)
					->where('gro_factory', $gro_factory)
					->orderBy('gro_id', 'desc')
					->value('code_end');
				if ($groups) {
					$num = (int) substr($groups, 5);
					if ($num) {
						$code_start = $num;
					} else {
						$code_start = 1;
					}
					$code_start = $code_start + 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					if ($find_adm['adm_cid'] == '654') {
						if ($code_ends > '999999') {
							return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当月可生产序列号最多为999999']);
						}
					}
					$code_end = number_format($code_ends, 0, '', '') - 1;
				} else {
					$code_start = 1;
					$code_ends = (int) $code_start + (int) $request['gro_num'];
					$code_end = number_format($code_ends, 0, '', '') - 1;
				}
				$code_ks = $gro_brand . $gro_factory . $year . $months . str_pad(strval($code_start), $numbernums, '0', STR_PAD_LEFT);
				$code_js = $gro_brand . $gro_factory . $year . $months . str_pad(strval($code_end), $numbernums, '0', STR_PAD_LEFT);
				// 查询商品有效期
				$validity_period = DB::table('goods')->where('goo_id', $request['gro_gid'])->where('goo_cid', $find_adm['adm_cid'])->value('validity_period');
				$expire_time = date('Y-m-d', strtotime($request['production_date'] . ' + ' . $validity_period . ' day'));
			}

			$data = [
				$gro_validation,
				$info_result_style,
				$time,
				$gro_valleaver,
				$gro_number,
				$request->input('gro_pnumber'),
				$find_adm['adm_cid'],
				$request->input('gro_release'),
				$find_adm['adm_id'],
				$request->input('gro_gid', 0),
				$request->input('gro_num'),
				1,
				$request->input('gro_good_name', ''),
				$file_name,
				$request->input('nums'),
				$code_ks,
				$code_js,
				$request['production_date'],
				$expire_time,
				$request->input('gro_brand', 0),
				$request->input('gro_factory', 0),
				date('m')
			];
			DB::beginTransaction();
			// 添加发码信息
			$grores = DB::insert('INSERT INTO `trace_group` (`gro_validation`,`gro_style`,`gro_time`, `gro_valleaver`, `gro_number`, `gro_pnumber`, `gro_cid`, `gro_release`, `gro_aid`, `gro_gid`, `gro_num`, `gro_type`, `gro_good_name`,`file_name`,`nums`,`code_start`,`code_end`,`production_date`,`expired_date`, `gro_brand`, `gro_factory`,`gro_month`) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $data);
			$val_sta = rand(1, 100001 - $request['gro_num']);
			if (isset($request['gro_validation']) && $request['gro_validation'] == '2') {
				$validation = DB::table('validation')
					->insert([
						'val_cid' => $find_adm['adm_cid'],
						'val_nums' => $request['gro_num'],
						'val_leaver' => $gro_valleaver,
						'val_codenumber' => $gro_number,
						'val_sta' => $val_sta,
						'val_end' => $val_sta + $request['gro_num'] - 1,
						'val_rand' => $this->getRandomString('4', $find_adm['adm_cid']),
						'val_time' => $time
					]);
			}
			if ($grores) {
				// 溯源模板系统信息录入,记录操作时间、操作人
				if (!empty($gco_temstr)) {
					$gco_op_id = DB::table('base_op')->insertGetId([
						'form_id' => $gco_temstr,
						'op_date' => date('Y-m-d H:i:s'),
						'op_man'  => $find_adm['adm_name']
					]);
				} else {
					$gco_op_id = '';
				}

				if ($request['gro_gid'] == 0) {
					$grores = DB::table('formwork_code')->insert([
						'gco_group' => $gro_number,
						'gco_start' => $code_ks,
						'gco_end'   => $code_js,
						'gco_type'  => 1,
						'gco_gid'   => $request->input('gro_gid', 0),
						'gco_envid' => $gco_envid,
						'gco_temstr' => $gco_temstr,
						'gco_cid' => $find_adm['adm_cid'],
						'gco_cretime' => $time,
						'nums' => $request['nums'],
						'production_date' => $expire_time,
						'gco_op_id' => $gco_op_id
					]);
				} else {
					if (empty($request['name']) || empty($request['content'])) {
						return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误3']);
					}
					foreach ($request['name'] as $key => $val) {
						$arr[$key]['name']   = $val;
						$arr[$key]['content'] = $request['content'][$key];
					}
					$gco_icon = json_encode($arr);

					// 产品码表添加二维码信息
					$grores = DB::table('formwork_code')->insert([
						'gco_group' => $gro_number,
						'gco_start' => $code_ks,
						'gco_end'   => $code_js,
						'gco_type'  => 1,
						'gco_gid'   => $request->input('gro_gid', 0),
						'gco_envid' => $gco_envid,
						'gco_temstr' => $gco_temstr,
						'gco_cid' => $find_adm['adm_cid'],
						'gco_cretime' => $time,
						'nums' => $request['nums'],
						'production_date' => $expire_time,
						'gco_op_id' => $gco_op_id,
						'gco_icon' => $gco_icon //json数据,判定溯源信息存在哪个导航按钮下面
					]);
				}

				// 产品码表添加二维码信息
				$goods_code_res = DB::insert('INSERT INTO `trace_goods_code` (`gco_num`, `gco_cid`, `gco_year`, `gco_month`, `gco_user`, `goods_id`) values(?,?,?,?,?,?)', [$code, $find_adm['adm_cid'], date('Y'), date('m'), $find_adm['adm_id'], $request->input('gro_gid', 0)]);

				// 查询发码量统计表数量
				$now_year = date('Y'); //当前年
				$now_month = date('m'); //当前月
				$find_sta_total = DB::table('statistic_send')
					->where(['sta_cid' => $find_adm['adm_cid'], 'sta_year' => $now_year, 'sta_month' => $now_month, 'sta_type' => 1])
					->first(['sta_id', 'sta_total']);
				// 更新发码量统计表数据
				if ($find_sta_total) {
					$sta_total_res = DB::update('UPDATE `trace_statistic_send` SET `sta_total`=`sta_total`+? WHERE (`sta_id`=?) ', [$request->input('gro_num'), $find_sta_total['sta_id']]);
				} else {
					$sta_total_res = DB::insert('INSERT INTO `trace_statistic_send` (`sta_cid`, `sta_year`, `sta_month`, `sta_total`, `sta_type`) values(?,?,?,?,?)', [$find_adm['adm_cid'], $now_year, $now_month, $request->input('gro_num'), 1]);
				}

				if (!empty($request->input('gro_gid'))) {

					// 查询商品信息
					$find_goods = DB::table('goods')
						->where(['del_type' => 1, 'goo_cid' => $find_adm['adm_cid']])
						->get(['goo_id', 'goo_classifi', 'goo_code_total']);

					$company_info = DB::table('company_info')->where('info_cid', $find_adm['adm_cid'])->first(['info_usenum']);
					$compan_count = $company_info['info_usenum'] + $request->input('gro_num'); //公司总的发码量
					foreach ($find_goods as $key => $value) {
						if ($value['goo_id'] == $request->input('gro_gid')) {
							$goo_count = $value['goo_code_total'] + $request->input('gro_num');
						} else {
							$goo_count = $value['goo_code_total'];
						}
						if ($goo_count > 0) {
							// 计算商品发码量占比
							$goo_code_percent = round(($goo_count / $compan_count) * 100, 2);
							// 更新商品发码量占比
							$goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_percent`=? WHERE (`goo_id`=?) ', [$goo_code_percent, $value['goo_id']]);
							if ($goods_res === false) {
								DB::rollBack();
							}
						}
					}
					// 更新商品发码数量
					$goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_total`=`goo_code_total`+? WHERE (`goo_id`=?) ', [$request->input('gro_num'), $request->input('gro_gid')]);
					// 查询商品分类
					$find_class_id = DB::table('goods')->where('goo_id', $request->input('gro_gid'))->first(['goo_classifi']);
					// 更新商品分类发码数量
					$goo_classifi_res = DB::update('UPDATE `trace_goo_classifi` SET `cla_code_total`=`cla_code_total`+? WHERE (`cla_id`=?) ', [$request->input('gro_num'), $find_class_id['goo_classifi']]);
					// 更新公司总的发码数量
					$company_info_res = DB::update('UPDATE `trace_company_info` SET `info_usenum`=`info_usenum`+? WHERE (`info_cid`=?) ', [$request->input('gro_num'), $find_adm['adm_cid']]);
				} else {
					$goods_res = true;
					$company_info_res = true;
					$goo_classifi_res = true;
				}
				if ($grores && $goods_code_res && $sta_total_res && $goods_res && $company_info_res && $goo_classifi_res) {
					DB::commit();
					Coperationa::add($find_adm['adm_id'], $request->getClientIp(), '发码列表', '创建二维码', '创建' . $request->input('gro_num') . '个产品码');
					return response()->json(['code' => 200, 'msg' => 'success', 'data' => '发码成功']);
				} else {
					DB::rollBack();
					return response()->json(['code' => 500, 'msg' => 'error', 'data' => '发码失败2']);
				}
			} else {
				DB::rollBack();
				return response()->json(['code' => 500, 'msg' => 'error', 'data' => '发码失败3']);
			}
		}
	}

	//生成指定位数随机串
	public function getRandomString($len, $adm_cid, $chars = null)
	{
		if (is_null($chars)) {
			$chars = "abcdefghijklmnpqrstuvwxyz123456789";
		}
		mt_srand(10000000 * (float) microtime());
		for ($i = 0, $str = '', $lc = strlen($chars) - 1; $i < $len; $i++) {
			$str .= $chars[mt_rand(0, $lc)];
		}
		$res = DB::table('validation')
			->where('val_cid', $adm_cid)
			->where('val_rand', $str)
			->first();
		if ($res) {
			$this->getRandomString('4');
		} else {
			return $str;
		}
	}

	//建码选择表
	private function GetTableName($codeid, $tab_nums)
	{
		$tab_yemo = date("ym");
		// 查找码表是否存在
		$result = DB::table('table_link')->where('tab_codeid', $codeid)
			->where('tab_yemo', $tab_yemo)
			->select('id', 'tab_nums', 'tab_tablenam')
			->first();
		if ($result) {
			$save_nums = $result['tab_nums'] + $tab_nums;
			DB::update('UPDATE `trace_table_link` SET `tab_nums`=? WHERE `id`=?', [$save_nums, $result['id']]);
			return ['code' => 200, 'msg' => 'success', 'data' => $result['tab_tablenam']];
		} else {
			// 查询当前二维码标识下是否建数据表
			$tab_tablenam = DB::table('table_link')->where('tab_codeid', $codeid)
				->orderBy('id', 'desc')->select('tab_tablenam')
				->first();
			$result = DB::table('table_link')->where('tab_codeid', $codeid)
				->where('tab_tablenam', $tab_tablenam['tab_tablenam'])->select('tab_nums')
				->get();
			if ($result) {
				$nums = 0;
				foreach ($result as $k => $v) {
					$nums = $nums + $v['tab_nums'];
				}
				if ($nums < $this->max_code_table) {
					$tab_data = [
						$codeid,
						$tab_yemo,
						$tab_tablenam['tab_tablenam'],
						$tab_nums,
					];
					$tab_res = DB::insert('INSERT INTO `trace_table_link` ( `tab_codeid`, `tab_yemo`, `tab_tablenam`, `tab_nums`) VALUES (?,?,?,?)', $tab_data);
					return ['code' => 200, 'msg' => 'success', 'data' => $tab_tablenam['tab_tablenam']];
				} else {
					return $this->createTable($codeid, $tab_yemo, $tab_nums);
				}
			} else {
				return $this->createTable($codeid, $tab_yemo, $tab_nums);
			}
		}
	}

	// 创建数据表
	private function createTable($codeid, $tab_yemo, $tab_nums)
	{
		$tablename_code = $codeid . $tab_yemo . '_code';
		$tablename_info = $codeid . $tab_yemo . '_info';
		// 创建数据表
		try {
			Schema::create($tablename_code, function ($table) {
				$table->engine = 'InnoDB';
				$table->increments('gco_id');
				$table->bigInteger('gco_codeid')->comment('所属表');
				$table->string('gco_number', '50')->index('gco_number')->comment('码号');
				$table->string('gco_validation', '255')->comment('验证码');
				$table->string('gco_temstr', '255')->default(',')->comment('溯源信息');
				$table->integer('gco_cid')->comment('所属公司');
				$table->bigInteger('gco_group')->index('gco_group')->comment('分组号');
				$table->integer('gco_gid')->index('gco_gid')->comment('商品id');
				$table->integer('gco_coderegid')->default(0)->comment('防窜记录表id');
				$table->integer('gco_envid')->default(0)->comment('环境id');
				$table->string('saletable', '50')->comment('售后质保表名称');
				$table->timestamp('gco_cretime')->comment('生成时间');
				$table->integer('gco_cameraid')->comment('摄像头id');
				$table->string('gco_op_id', '200')->comment('关联trace_公司ID_op表');
				$table->comment = '产品码表';
			});
		} catch (\Exception $e) {
			// return response()->json(['code'=>500,'msg'=>'error','data'=>'产品码表创建失败']);
			return ['code' => 500, 'msg' => 'error', 'data' => '产品码表创建失败'];
		}
		try {
			Schema::create($tablename_info, function ($table) {
				$table->engine = 'InnoDB';
				$table->increments('cin_id');
				$table->integer('cin_gooid')->comment('商品id');
				$table->bigInteger('cin_codeid')->index('cin_codeid')->comment('码id');
				$table->string('cin_provin', '100')->index('cin_provin')->comment('扫码省份');
				$table->string('cin_city', '255')->index('cin_city')->comment('扫码市区');
				$table->string('cin_county', '255')->comment('扫码县城');
				$table->string('cin_addres', '255')->comment('扫码地址');
				$table->string('cin_ip', '255')->comment('扫码IP');
				$table->string('cin_openid', '255')->comment('微信标识');
				$table->string('cin_sys', '255')->comment('系统环境');
				$table->string('cin_iswx', '255')->comment('扫码入口');
				$table->timestamp('cin_time')->comment('扫码时间');
				$table->comment = '扫码信息表';
			});
		} catch (\Exception $e) {
			// return response()->json(['code'=>500,'msg'=>'error','data'=>'扫码信息表创建失败']);
			return ['code' => 500, 'msg' => 'error', 'data' => '扫码信息表创建失败'];
		}

		$tab_data = [
			$codeid,
			$tab_yemo,
			$codeid . $tab_yemo,
			$tab_nums,
		];
		$tab_res = DB::insert('INSERT INTO `trace_table_link` ( `tab_codeid`, `tab_yemo`, `tab_tablenam`, `tab_nums`) VALUES (?,?,?,?)', $tab_data);
		if (!$tab_res) {
			Schema::dropIfExists($tablename_code);
			Schema::dropIfExists($tablename_info);
			return ['code' => 500, 'msg' => 'error', 'data' => '数据表创建失败'];
		} else {
			return ['code' => 200, 'msg' => 'success', 'data' => $codeid . $tab_yemo];
		}
	}

	// 搜索商品
	public function goodscode(Request $request)
	{
		// 验证数据
		if (!$request->has('search_goods')) {
			return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$data = $request->all();

		$list = DB::table('goods')
			->where('goo_cid', $find_adm['adm_cid'])
			->where('del_type', 1)
			->where('goo_sta', 1)
			->where(function ($query) use ($data) {
				$query->where('goo_name', 'like', '%' . $data['search_goods'] . '%')
					->orWhere('goo_number', 'like', '%' . $data['search_goods'] . '%');
			})
			->select('goo_id', 'goo_name', 'goo_number')
			->orderBy('goo_id', 'desc')
			->get();
		$listData['data'] = $list;
		$listData['code'] = 200;
		return response()->json($listData);
	}

	// 返回商品
	public function goodsdata(Request $request)
	{
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$data = $request->all();

		$list = DB::table('goods')
			->where('goo_cid', $find_adm['adm_cid'])
			->where('del_type', 1)
			->where('goo_sta', 1)
			->select('goo_id', 'goo_name', 'goo_number')
			->orderBy('goo_id', 'desc')
			->offset(0)->limit(5)->get();
		$listData['data'] = $list;
		$listData['code'] = 200;
		return response()->json($listData);
	}
}
