<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Contracts\Support\JsonableInterface;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

use App\Http\Models\Coperationa;
use App\Http\Controllers\CommonController;
use App\Http\Models\CodeManageModel;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\CommenModel;
use App\Http\Controllers\Verify\VerifyCodeController;
/**
 * 发码管理
 */
class CodeManageController extends Controller
{
	// 列表每页显示数据个数
	protected $show_count = 10;
	// 位数，生成产品码位数
	protected $all_num = 20;
	// 最大发码数量
	protected $max_gro_num = 100000;
	// 二维码表最大存储数据
	protected $max_code_table = 6000000;

    // 列表查询
    public function index(Request $request)
    {
    	// 验证数据
    	if (!$request->exists('gro_pnumber') || !$request->exists('gro_release') || empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
    	}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$data = $request->all();

		$list = DB::table('group')
				->leftjoin('goods','goods.goo_id','=','group.gro_gid')
				->where('gro_cid', $find_adm['adm_cid'])
				->where(function($query) use($data) {
					if (!empty($data['gro_pnumber'] )) {
						$query->where('group.gro_pnumber', 'like' , '%'.$data['gro_pnumber'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['goo_name'] )) {
						$query->where('goo_name', 'like' , '%'.$data['goo_name'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['gro_release'] )) {
						$query->where('group.gro_release', $data['gro_release']);
					}
				})
				//->where(function($query) use($data) {
				//	//如果选择开始时间并且选择结束时间
				//	if (!empty($data['gro_time_range0'] && $data['gro_time_range1'])){
				//		$query->whereBetween('group.gro_time',[$data['gro_time_range0'],$data['gro_time_range1']]);
				//	}else{
				//		// 如果选择开始时间
				//		if (!empty($data['gro_time_range0'])){
				//			$query->where('group.gro_time','>=',$data['gro_time_range0']);
				//		}else{
				//			// 如果选择结束时间
				//			if (!empty($data['gro_time_range1'])) {
				//				$query->where('group.gro_time','<=',$data['gro_time_range1']);
				//			}
				//		}
				//	}
				//})
				->where(function($query) use($data) {
					if (!empty($data['gro_time'] )) {
						$query->where('gro_time', 'like' , '%'.$data['gro_time'].'%' );
					}
				})
				->where(function($query) use($data) {
					if (!empty($data['production_date'] )) {
						$query->where('production_date', 'like' , '%'.$data['production_date'].'%' );
					}
				})
				->selectRaw('gro_id,gro_pnumber,goo_name,goo_number,gro_num,file_name,down_num,gro_time,gro_release,gro_derid,gro_stase,nums,production_date,gro_valleaver,gro_validation,gro_number')
				->orderBy('gro_id','desc')
				->paginate($this->show_count);

		$listData['current_page'] = $list->currentPage();
		$listData['total'] = $list->total();
		$listData['data'] = $list->items();
		$listData['last_page'] = $list->lastPage();
		$listData['current_number'] = $this->show_count;
		$listData['code'] = 200;
		$listData['button_data'] = wherebutton($request['api_token'],$request['pri_id']);
		return response()->json($listData);
    }

    // 开启发布
    public function publish(Request $request)
    {
		// 验证数据
		if (empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('edit_id')) > 1) {
			$find = DB::table('group')->whereIn('gro_id', $request->input('edit_id'))->select('gro_pnumber','gro_release')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find = DB::table('group')->where('gro_id', $request->input('edit_id'))->select('gro_pnumber','gro_release')->get();
		}

		if (empty($find)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前发码批次号不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find as $key => $value) {
			if ($value['gro_release'] != 2) {
				$istype = true;
			}
			$name .= $value['gro_pnumber'].',';
		}
		if ($istype) {
			$result = DB::table('group')
					->where('gro_cid', $find_adm['adm_cid'])
					->$where_type('gro_id', $request->input('edit_id'))
					->update(['gro_release'=>2]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'发码列表','发布','开启发布“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'开启发布成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'开启发布失败']);
		}
    }

    // 关闭发布
    public function padlock(Request $request)
    {
		// 验证数据
		if (empty($request->input('edit_id')) || !is_array($request->input('edit_id')) ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
		}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));

		// 判断个数
		if (count($request->input('edit_id')) > 1) {
			$find = DB::table('group')->whereIn('gro_id', $request->input('edit_id'))->select('gro_pnumber','gro_release')->get();
			$where_type = 'whereIn';
		}else{
			$where_type = 'where';
			$find = DB::table('group')->where('gro_id', $request->input('edit_id'))->select('gro_pnumber','gro_release')->get();
		}

		if (empty($find)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前发码批次号不存在或者已删除']);
		}
		$name = '';
		$istype = false;
		foreach ($find as $key => $value) {
			if ($value['gro_release'] != 1) {
				$istype = true;
			}
			$name .= $value['gro_pnumber'].',';
		}
		if ($istype) {
			$result = DB::table('group')
					->where('gro_cid', $find_adm['adm_cid'])
					->$where_type('gro_id', $request->input('edit_id'))
					->update(['gro_release'=>1]);
        } else {
            $result = true;
        }

		if (!empty($result)) {
			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'发码列表','发布','关闭发布“'.trim($name,',').'”成功');
			return response()->json(['code'=>200,'msg'=>'success','data'=>'关闭发布成功']);
		}else{
			return response()->json(['code'=>500,'msg'=>'error','data'=>'关闭发布失败']);
		}
    }

    // 搜索商品
    public function goodscode(Request $request)
    {
    	// 验证数据
    	if (!$request->has('search_goods') ) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
    	}
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$data = $request->all();

		$list = DB::table('goods')
				->where('goo_cid', $find_adm['adm_cid'])
				->where('del_type', 1)
				->where('goo_sta', 1)
				->where(function($query) use($data){
			        $query->where('goo_name', 'like' , '%'.$data['search_goods'].'%')
			              ->orWhere('goo_number', 'like' , '%'.$data['search_goods'].'%');
			    })
				->select('goo_id','goo_name','goo_number')
				->orderBy('goo_id','desc')
				->get();
		$listData['data'] = $list;
		$listData['code'] = 200;
		return response()->json($listData);
    }
	// 返回商品
    public function goodsdata(Request $request)
    {
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$data = $request->all();

		$list = DB::table('goods')
				->where('goo_cid', $find_adm['adm_cid'])
				->where('del_type', 1)
				->where('goo_sta', 1)
				->select('goo_id','goo_name','goo_number')
				->orderBy('goo_id','desc')
				->offset(0)->limit(5)->get();
		$listData['data'] = $list;
		$listData['code'] = 200;
		return response()->json($listData);
    }

    // 编辑
    public function editgco(Request $request)
    {
    	if (!in_array($request->input('type'),array(1,2,3))) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
    	}
    	// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		if ($request['type'] == '1') {
			$result = DB::table('group')
						->where('gro_cid',$find_adm['adm_cid'])
						->where('gro_number',$request['edit_id'])
						->first();
			if ($result['gro_gid'] > '0') {
				$arr = DB::table('goods')
						->where('goo_cid',$find_adm['adm_cid'])
						->where('goo_id',$result['gro_gid'])
						->first();
			}else{
				$arr['goo_id']="";
				$arr['goo_name']="";
				$arr['goo_number']="";
			}
			return response()->json(['code'=>200,'msg'=>'success','data'=>$arr]);
		}elseif ($request['type'] == '2') {
			$arr = DB::table('goods')
					->where('goo_cid',$find_adm['adm_cid'])
					->where('goo_name','like','%'.$request['goo_name'].'%')
					->where('goo_number','like','%'.$request['goo_number'].'%')
					->where('del_type', 1)
					->where('goo_sta', 1)
					->select('goo_id','goo_name','goo_number')
					->get();
			if (!$arr) {
				$arr='1';
			}
			return response()->json(['code'=>200,'msg'=>'success','data'=>$arr]);
		}elseif ($request['type'] == '3') {
			DB::beginTransaction();
			$result = Db::table('group')
					->where('gro_cid',$find_adm['adm_cid'])
					->where('gro_id',$request['gro_id'])
					->first();

			$arr['gro_gid'] = $request['goo_id'];
			$request['gro_number'] = $result['gro_number'];
	    	$res = DB::table('group')
	    				->where('gro_cid',$find_adm['adm_cid'])
	    				->where('gro_number',$request['gro_number'])
	    				->update([
	    					'gro_gid' => $arr['gro_gid']
	    					]);
	    	if ($result['gro_gid'] != $request['goo_id']) {
    			// 查询商品信息
				$find_goods = DB::table('goods')
					->where(['del_type' => 1, 'goo_cid' => $find_adm['adm_cid']])
					->get(['goo_id', 'goo_classifi', 'goo_code_total']);

				$company_info = DB::table('company_info')->where('info_cid', $find_adm['adm_cid'])->first(['info_usenum']);
				$compan_count = $company_info['info_usenum']; //公司总的发码量
				foreach ($find_goods as $key => $value) {
					if ($value['goo_id'] == $request['goo_id']) {
						$goo_count = $value['goo_code_total'] + $result['gro_num'];
					} elseif($value['goo_id'] == $result['gro_gid']) {
						$goo_count = $value['goo_code_total'] - $result['gro_num'];
					} else {
						$goo_count = $value['goo_code_total'];
					}
					if ($goo_count > 0) {
						// 计算商品发码量占比
						$goo_code_percent = round(($goo_count / $compan_count) * 100, 2);
						// 更新商品发码量占比
						$goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_percent`=? WHERE (`goo_id`=?) ', [$goo_code_percent, $value['goo_id']]);
						if ($goods_res === false) {
							DB::rollBack();
						}
					}
				}
				// 更新商品发码数量
				$goods_res = DB::update('UPDATE `trace_goods` SET `goo_code_total`=`goo_code_total`+? WHERE (`goo_id`=?) ', [$request->input('gro_num'), $request->input('gro_gid')]);
	    	}
	    	if ($res !== false) {
	    		$tableName = DB::table('group')
	    						->where('gro_number',$request['gro_number'])
	    						->select('gro_codeid')
	    						->first();
	    		$ar['gco_gid']=$request['goo_id'];
	    		$ress = DB::table("formwork_code")
	    				->where('gco_cid',$find_adm['adm_cid'])
	    				->where('gco_group',$request['gro_number'])
	    				->update([
	    					'gco_gid' => $ar['gco_gid']
	    					]);
	    	
	    		if ($ress !== false) {
	    			DB::commit();
	    			Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'发码列表','编辑','编辑'.trim($result['gro_pnumber'],',').'”成功');
					return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑成功']);
	    		}else{
	    			DB::rollBack();
	    			return response()->json(['code'=>200,'msg'=>'success','data'=>'编辑失败']);
	    		}
	    	}else{
	    		return response()->json(['code'=>200,'msg'=>'success','data'=>'']);
	    	}
		}	
    }

	public function derivation(Request $request)
    {
        $token=Crypt::decrypt($request->input("api_token"));
        $user=CommenModel::getUserToken($token);
        if(!$user){
            return response()->json(['code'=>500,'msg'=>'error','data'=>'token错误']);
        }
        $gro_id=(int)$request->input('gro_id',null);
        $type=(int)$request->input('type',1);
        if(empty($gro_id)){
            return response()->json(['code'=>500,'msg'=>'失败','data'=>'缺少id']); 
        }
        $obj=new CodeManageModel();
        $res=$obj->Down_Code($gro_id,$user,$type);
        return response()->json($res);
    }

    //伪定时任务
    public function downdata(Request $request){
        $crontab_list = DB::table('derivation')
                ->where('der_sta', 1)
                ->select('der_id','der_table','der_content')
                ->get();
        
        if(empty($crontab_list)){
            return response()->json(['code'=>200,'msg'=>'success','data'=>'没有任何要导出的excel数据']);
        }
        foreach ($crontab_list as $key => $down_excel) {
            //二维码数据
            $code_data=Db::table($down_excel['der_table']."_code")->where(['gco_group'=>$down_excel['der_content']])->select('gco_id','gco_number')->orderBy('gco_id','asc')->get();

            //真伪码数据
            $validation=Db::table('validation')->where('val_codenumber',$down_excel['der_content'])->select('val_leaver','val_sta','val_end','val_rand')->first();

            $validation_code=DB::table('validation_data')
                            ->where('vald_leaver', $validation['val_leaver']-4)
                            ->whereBetween('vald_number', [$validation['val_sta'],$validation['val_end']])
                            ->select('vald_rand')->get();
            $validata=array_column($validation_code,'vald_rand');
            unset($validation_code);

            $url=$this->code_url;
            $group_name=$down_excel['der_content'];
            Excel::create($group_name, function($excel) use ($code_data,$validata,$validation,$group_name,$url){
                $excel->sheet('sheet1', function($sheet) use ($code_data,$validata,$validation,$group_name,$url)
                {
                    $sheet->setWidth(array('A'=>40,'B'=>30,'C'=>20,'D'=>16))->setFontSize(12);
                    $sheet->cell('A1','二维码地址');
                    $sheet->cell('B1','二维码号');
                    $sheet->cell('C1','发码批次');
                    $sheet->cell('D1','真伪序列号');
                    foreach ($code_data as $key => $value){
                        $i= $key+2;
                        $serial=$validation['val_rand'][0].$validata[$key][0].$validation['val_rand'][1].$validata[$key][1].$validation['val_rand'][2].$validata[$key][2].$validation['val_rand'][3].substr($validata[$key],3);
                        $sheet->cell('A'.$i,$url."?".$value['gco_number']);
                        $sheet->cell('B'.$i,$value['gco_number']."&");
                        $sheet->cell('C'.$i,$group_name."&");
                        $sheet->cell('D'.$i, $serial);
                    }
                });
            })->save('xls',storage_path('crontab'));
            //写入成功
            DB::table('derivation')->where('der_content',$down_excel['der_content'])->update(['der_sta'=>2]);
            Db::table('group')->where('gro_number',$down_excel['der_content'])->update(['gro_derid'=>3,'gro_update_time'=>date('Y-m-d H:i:s')]);
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>'执行定时任务结束']);
    }

    // 打印
    public function prints(Request $request)
    {
    	// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		if (!in_array($request->input('type'),array(1,2,3)) || !$request['gro_id']) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
    	}
    	if ($request['type'] == '1') {
    		$res = DB::table('group')->where('gro_id',$request['gro_id'])->select('gro_number','gro_num','print_num')->first();
    		$res['alreadyused'] = $res['gro_num'] - $res['print_num'];
    		return response()->json(['code'=>200,'msg'=>'success','data'=>$res]);
    	}elseif ($request['type'] == '2') {
    		$record = DB::table('group')->where('gro_id',$request['gro_id'])->select('gro_id','gro_gid','gro_number','code_start','nums','gro_num','gro_codeid','print_num')->first();
    		if ($record['gro_gid'] == '0') {
    			return response()->json(['code'=>500,'msg'=>'error','data'=>'请在创建溯源码时绑定商品']);
    		}
			if ($record['code_start'] == '') {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'请重新发码打印']);
			}
			if ($record['nums'] == 33) {
				$start = substr($record['code_start'],22,-3);
				$yemo = trim(substr($record['code_start'], '0','22'));
			}else if ($record['nums'] == 20) {
				$start = substr($record['code_start'],9,-3);
				$yemo = trim(substr($record['code_start'], '0','9'));
			}
			$goolist = DB::table('goods')->where('goo_id',$record['gro_gid'])->select('goo_id','goo_pro')->first();
			$strss=json_decode($goolist['goo_pro'],true);
			foreach($strss as $ks=>$vs){
				$strss[$ks]['len']=mb_strlen($vs['key'],"utf-8");
				
			}
			$arraylist[0]["goo_pro"]=$strss;
			if (empty($request['this_print_num']) || !is_numeric($request['this_print_num'])) {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入要打印的数量']);
			}
			$i="0";
			while($i<$request['this_print_num']){
				$x=$start+$record['print_num']+$i;
				//需补充码位数
				$numbernums = 8 - strlen($x);
				$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
				$codes = "$starts$x";
				//生成校验位
				$verify_code = VerifyCodeController::generateVerify($codes, 3);
				if(!$verify_code) {
					return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
				}else {
					$codes .= $verify_code;
				}
				$array[$i]["code"]=$codes;
				$array[$i]["goo_pro"]=$strss;
				
				$i=$i+1;
			}
			$print_num = DB::table('group')->where('gro_id',$request['gro_id'])->value('print_num');
			$print_num = $print_num + $request['this_print_num'];
			$result = DB::table('group')->where('gro_id',$request['gro_id'])->update(['print_num'=>$print_num,'gro_stase'=>2]);
			return response()->json(['code'=>200,'msg'=>'success','data'=>$array]);
    	}
	}
	// 扫一扫
	public function scan(Request $request){
		// 根据token获取用户信息
		$find_adm = Coperationa::getUserInfo($request->input('api_token'));
		$code_start = DB::table('group')
			->where(['gro_cid'=>$find_adm['adm_cid'],'gro_id'=>$request['gro_id']])
			->value('code_start');
		if ($code_start) {
			return response()->json(['code'=>200,'msg'=>'success','qrcode'=>config('app.url')."/sy.php?".$code_start."&"]);
		}else{
			$vtiger = DB::connection('mysql_two');
			$gro_codeid = DB::table('group')
   						->where(['gro_cid'=>$find_adm['adm_cid'],'gro_id'=>$request['gro_id']])
   						->first(['gro_codeid','gro_number']);
   			$gco_number = $vtiger->table($gro_codeid['gro_codeid']."_code")
   						->where(['gco_cid'=>$find_adm['adm_cid'],'gco_group'=>$gro_codeid['gro_number']])
   						->value('gco_number');
   			if ($gco_number) {
   				return response()->json(['code'=>200,'msg'=>'success','qrcode'=>config('app.url')."/sy.php?".$gco_number."&"]);
   			}
		}
		return response()->json(['code'=>500,'msg'=>'error','data'=>'操作失败']);
	}

	// 单个码链接
    public function singleCodeLink(Request $request)
    {
		if (empty($request['private_key'])) {
			return response()->json(['code'=>500, 'msg'=>'请输入秘钥！', 'data'=>'请输入秘钥！']);
		}
		if (empty($request['goo_number'])) {
			return response()->json(['code'=>500, 'msg'=>'请输入条形码号！', 'data'=>'请输入条形码号！']);
		}
		$key = 'S5U087Y62650U8A4172CN51857912YU44';
		$keys = md5($key);
		if (md5($request['private_key']) != $keys) {
			return response()->json(['code'=>500, 'msg'=>'秘钥输入有误', 'data'=>'秘钥输入有误']);
		}
		$request['this_print_num'] = 1; //打印次数1

		// $cid = 7; //公司id
		$cid = 378; //公司id

		// 根据条形码号查询对应的商品id
		$find_goo_id = DB::table('goods')
			->where('goo_cid', $cid)
			->where('goo_number', $request['goo_number'])
			->where('del_type', 1)
			->value('goo_id');
		if (empty($find_goo_id)) {
			return response()->json(['code'=>500, 'msg'=>'当前条形码号没有对应商品，请核对！', 'data'=>'当前条形码号没有对应商品，请核对！']);
		}
		$record = DB::table('group')
			->where('gro_cid', $cid)
			->where('gro_codeid', 0)
			->where('gro_gid', $find_goo_id)
			->where('code_start', '!=', '')
			->whereRaw('gro_num != print_num')
			->select('gro_id','gro_gid','gro_number','code_start','nums','gro_num','gro_codeid','print_num')
			->get();
		if (empty($record)) {
			return response()->json(['code'=>500,'msg'=>'error','data'=>'当前公司没有码号！']);
		}
		foreach ($record as $key => $value) {
			if ($value['gro_num'] != $value['print_num']) {
				if ($value['nums'] == 33) {
					$start = substr($value['code_start'],22,-3);
					$yemo = trim(substr($value['code_start'], '0','22'));
				}else if ($value['nums'] == 20) {
					$start = substr($value['code_start'],9,-3);
					$yemo = trim(substr($value['code_start'], '0','9'));
				}
				$goolist = DB::table('goods')->where('goo_id',$value['gro_gid'])->select('goo_id','goo_pro')->first();
				$strss=json_decode($goolist['goo_pro'],true);
				foreach($strss as $ks=>$vs){
					$strss[$ks]['len']=mb_strlen($vs['key'],"utf-8");
				}
				$arraylist[0]["goo_pro"]=$strss;
				if (empty($request['this_print_num']) || !is_numeric($request['this_print_num'])) {
					return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入要打印的数量']);
				}
				$i="0";
				while($i<$request['this_print_num']){
					$x=$start+$value['print_num']+$i;
					// 需补充码位数
					$numbernums = 8 - strlen($x);
					$starts = $yemo . str_pad(strval(''), $numbernums, '0', STR_PAD_LEFT);
					$codes = "$starts$x";
					// 生成校验位
					$verify_code = VerifyCodeController::generateVerify($codes, 3);
					if(!$verify_code) {
						return response()->json(['code'=> 500,'msg'=>'error','data'=>'校验位生成失败']);
					}else {
						$codes .= $verify_code;
					}
					$array[$i]["code"]='http://www.7cha.co?' . $codes . '&';					
					$i=$i+1;
				}
				$print_num = DB::table('group')->where('gro_id',$value['gro_id'])->value('print_num');
				$print_num = $print_num + $request['this_print_num'];
				$result = DB::table('group')->where('gro_id',$value['gro_id'])->update(['print_num'=>$print_num,'gro_stase'=>2]);
				return response()->json(['code'=>200,'msg'=>'success','data'=>$array]);
			} else {
				return response()->json(['code'=>500,'msg'=>'error','data'=>'当前没有码号！']);
			}
		}
	}
}
	
