<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use App\Http\Models\Coperationa;
/**
 * 码上修改
 */
class CodeEditController extends Controller
{
    // 列表查询
    public function index(Request $request)
    {
		// 根据token获取用户信息
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        // 环境信息

        // 摄像头信息
        
        $list['env_list'] = '';//环境信息
        $list['camera_list'] = '';//摄像头信息
        return response()->json(['code'=>200,'msg'=>'success','data'=>$list]);
    }

    // 二维码查询,修改
    public function edit(Request $request)
    {
    	if (!in_array($request->input('type'),[1,2]) || empty($request->input('code'))) {
        	return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
    	}
    	if ($request->input('type') == 1) {
    		// 通过二维码获取商品、防窜、溯源信息
            $res = $this->getCodeInfo($request->input('code'));
            if ($res == 1) {
        		return response()->json(['code'=>500,'msg'=>'error','data'=>'操作失败']);
            }else if($res == 2){
        		return response()->json(['code'=>500,'msg'=>'error','data'=>'操作失败']);
            }else if($res == 3){
        		return response()->json(['code'=>500,'msg'=>'error','data'=>'操作失败']);
            }else {
        		return response()->json(['code'=>200,'msg'=>'success','data'=>$res]);
            }
    	}else{
    		// 码上修改
            // 获取二维码所在表
            $find_table = $this->getCode($request->input('code'));
             if ($find_table == 1) {
        		return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码参数错误']);
            }else if($find_table == 2){
        		return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码参数错误']);
            }
            // 验证数据
            if (empty($request->input('goo_id')) && empty($request->input('isUpdate'))) {
            	return response()->json(['code'=>500,'msg'=>'error','data'=>'请选择要修改的溯源信息']);
            }
    		// 二维码详情
	        $find_group = DB::table($find_table)
				      ->where('gco_number', $request->input('code'))
				      ->select('gco_group','gco_op_id','gco_temstr','gco_gid')
				      ->first();

	        // 根据token获取用户信息
	        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            //更新商品。如果为商品，只更新当前二维码对应的数据
            if (!empty($request->input('goo_id')) && is_numeric($request->input('goo_id'))) {
				DB::beginTransaction();
            	$goo_res = DB::update('UPDATE `trace_'.$find_table.'` SET `gco_gid`=?  WHERE `gco_number`=? ',[$request->input('goo_id'),$request->input('code')]);
            	if ($goo_res) {
            		// 查询更改商品名称
            		$find_goods = DB::table('goods')
				      ->whereIn('goo_id', [$find_group['gco_gid'],$request->input('goo_id')])
				      ->select('goo_name','goo_id')->get();
				    foreach ($find_goods as $key => $value) {
				    	$good_name[$value['goo_id']] = $value['goo_name'];
				    }
            		$old_goo_name = empty($find_group['gco_gid']) ? '' : $good_name[$find_group['gco_gid']];
            		Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'码上修改','编辑','更改二维码商品,二维码:'.$request->input('code').',(旧)'.$old_goo_name.'->(新)'.$good_name[$request->input('goo_id')] );
					DB::commit();
            	}else{
					DB::rollBack();
        			return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码信息修改失败']);
            	}
            }
           	//$isUpdate值不为空，说明前端有修改溯源模板内容
            $isUpdate = $request->input('isUpdate');
            if(!empty($isUpdate)){
				$types = $request->input('fom_types');
				$values = $request->input('fom_values');
				$keys = $request->input('fom_keys');
				$fom_title = $request->input('fom_titles');
				// $record_fom_id = '2,21';
				$record_fom_id = explode(',',$request->input('record_fom_id'));//模板id

				DB::beginTransaction();
                //拼装模板内容
                foreach ($isUpdate as $k => $fomId){
                    $content = [];
                    foreach ($values[$k] as $key => $v){
                        $content[$key]['key'] = $keys[$k][$key];
                        $content[$key]['type'] = $types[$k][$key];
                        $content[$key]['value'] = $v;
                        $content[$key]['show'] = 1;
                    }
                    $content = json_encode($content);

                    //新增模板
                    $fom_data = [
                    	$fom_title[$k],
                    	$content,
                    	$find_adm['adm_cid'],
                    	$find_adm['adm_id'],
                    	1
                    ];
                    $insert_res = DB::insert('INSERT INTO `trace_formwork` (`fom_title`, `fom_content`, `fom_cid`, `fom_aid`, `fom_stase`) VALUES (?,?,?,?,?) ',$fom_data);
                    if (false === $insert_res) {
                    	DB::rollBack();
        				return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码信息修改失败']);
                    }
					$insert_id = DB::getPdo()->lastInsertId();
                    // 标识旧的模板为禁用状态，状态1正常2停用3禁用
                    $update_res = DB::update('UPDATE `trace_formwork` SET `fom_stase`=? WHERE `fom_id`=? ',[3,$fomId]);
                    if (false === $update_res) {
                    	DB::rollBack();
        				return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码信息修改失败']);
                    }
                    //把旧数据中的模板ID替换为新的模板ID
                	$record_fom_key = array_search($fomId,$record_fom_id);
                	$record_fom_id[$record_fom_key] = $insert_id;
                	$record_fom_id = implode(',',$record_fom_id);
                }

                // 更新二维码表,溯源按批次更改
                $code_res = DB::update('UPDATE `trace_'.$find_table.'` SET `gco_temstr`=?, `gco_cid`=? WHERE `gco_group`=? ',[$record_fom_id,$find_adm['adm_id'],$find_group['gco_group']]);
                if (false === $code_res) {
                	DB::rollBack();
    				return response()->json(['code'=>500,'msg'=>'error','data'=>'二维码信息修改失败']);
                }else{
                	Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'码上修改','编辑','更改二维码溯源,批次号:'.$find_group['gco_group'].'修改成功');
					DB::commit();
                }

                $oldTemStr = explode(",",trim($find_group['gco_temstr'],','));
                $newTemStr = explode(",",trim($record_fom_id));
                $diffArr = array_diff($oldTemStr,$newTemStr);
                //有差级,则说明有修改,则用现有模板覆盖base_op表里原有的模板ID
                if(!empty($diffArr)){
                	$op_res = DB::update('UPDATE `trace_base_op` SET `form_id`=?  WHERE `id` IN (?) ',[$record_fom_id,trim($find_group['gco_op_id'],',')]);
                }
            }
    	}
		
    }

    /**
     * 获取二维码所在表
     * @param  string $codeData 二维码参数
     * @return [type]           二维码所在表
     */
	 private function getCode($codeData = "")
    {
        if (!$codeData){
			return "1";exit;
		}
        //编辑录入，只能录入同一批次
        $codePrefix = substr($codeData, 0, 5);    //二维码标识
        $codeYm = substr($codeData, 5, 4);       //年月

        //根据二维码标识和二维码年月获取二维码所在表
        $codeTableName = DB::table('table_link')
				->where('tab_codeid', $codePrefix)
				->where('tab_yemo', $codeYm)
				->select('tab_tablenam')->first();

        if (!$codeTableName){
			return "2";exit;
		}
        return $codeTableName['tab_tablenam'] . "_code";
    }
    /**
     * 根据二维码查询二位的详情，包括模板信息、系统生成的信息(操作时间、操作人)
     * @param $code
     * @return mixed
     * @throws Exception
     */
    private function getCodeInfo($code){
        //获取二维码所在表
		$codetable=$this->getCode($code);
		if($codetable=="1"){
			return "1";exit;
		}else if($codetable=="2"){
			return "2";exit;
		}
		$res = DB::table($codetable)
				->where('gco_number', trim($code,'&'))
				->first();
		if(!$res){
			return "3";exit;
		}
		// 查询商品信息
		if ($res['gco_gid']) {
			$res['goods'] = DB::table('goods')
				->where('goo_id', $res['gco_gid'])
				->select('goo_name','goo_number')
				->first();
		}
        $res['gco_temstr'] = trim($res['gco_temstr'],",");
		if (!empty($res['gco_temstr'])) {
	        $res['gco_temstr'] = explode(",",$res['gco_temstr']);
	        $res['gco_temstr'] = array_unique($res['gco_temstr']);
	        //获取所有模板
			$formworkRes = DB::table('formwork')
					->whereIn('fom_id', $res['gco_temstr'])
					->select('fom_id','fom_title','fom_content')
					->get();
			 //反序列化fom_content
	        $res['formwork'] = array_map(function ($val){
	            $val['fom_content'] = json_decode($val['fom_content'],true);
	            return $val;
	        },$formworkRes);

	        //获取操作人、操作时间
	        if($res['gco_op_id']){
	            $res['gco_op_id'] = trim($res['gco_op_id'],",");

	            //按ID的升序查询。如果模板ID相同，则后面的会覆盖前面的
	            $baseOp = DB::table('base_op')
					->whereIn('id', explode(',',$res['gco_op_id']))
					->select('id','form_id','op_man','op_date')
					->orderBy('id', 'asc')
					->get();
	            /**
	             * 拼接操作人、操作时间
	             * $res[op_man][模板ID][操作人]
	             * $res[op_date][模板ID][操作时间]
	             */
	            foreach ($baseOp as $val){
	                $keyArr = explode(",",$val['form_id']);
	                foreach($keyArr as $v){
	                    $res['op_man'][$v] = $val['op_man'];
	                    $res['op_date'][$v] = $val['op_date'];
	                }
	            }
	        }
		}
        return $res;
    }

}