<?php

namespace App\Http\Controllers\Channels;

use App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Session;
use App\Http\Models\Coperationa;
use App\Http\Controllers\Verify\Channels\VerifyTechnicianController;

// 技师列表
class TechnicianController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // 技师列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $search_data = $request->all();
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $userinfo = DB::table('technician as a')
                        ->leftJoin('channels as b', 'b.chan_id', '=', 'a.tech_chan_id')
                        ->where('a.tech_cid',$find_adm['adm_cid'])
                        ->where('a.tech_audit_state',$search_data['tech_audit_state'])
                        ->where(function($query) use($find_adm) {
                            if ($find_adm['adm_chan_id'] > 0) {
                                $query->where('a.tech_chan_id', $find_adm['adm_chan_id']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['tech_id'])) {
                                $query->where('a.tech_id', $search_data['tech_id']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            // 隶属渠道商
                            if (!empty($search_data['tech_chan_id'])) {
                                $query->where('b.chan_enterprise_name', 'like' , '%'.$search_data['tech_chan_id'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['tech_name'])) {
                                $query->where('a.tech_name', 'like' , '%'.$search_data['tech_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['tech_phone'])) {
                                $query->where('a.tech_phone', 'like' , '%'.$search_data['tech_phone'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['tech_state'])) {
                                $query->where('a.tech_state', $search_data['tech_state']);
                            }
                        })
                        ->select('a.tech_id','b.chan_enterprise_name as parent_enterprise_name','a.tech_name','a.tech_phone','a.tech_state','a.tech_policy_number','a.tech_integral','a.tech_addtime','a.tech_audit_state','a.tech_identity_card','a.tech_address','a.tech_remark','a.tech_mount_number','a.tech_employer_address')
                        ->orderBy('a.tech_id','desc')
                        ->paginate($this->show_count);
        
        // 判断是否是渠道商
        $adm_chan_type = DB::table('admin')
            ->where('adm_cid',$find_adm['adm_cid'])
            ->where('adm_chan_id',$find_adm['adm_chan_id'])
            ->value('adm_chan_type');
        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据
        $data_info['adm_chan_type'] = $adm_chan_type;           //返回数据

        if ($request['tech_audit_state'] != 3) {
            // 获取当前列表下的按钮
            $button = wherebutton($request['api_token'],$request['pri_id']);
        }else{
            $button = '';
        }

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 获取渠道商信息
    public function getChannels(Request $request)
    {
        // 获取当前操作账号
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $find_data = DB::table('channels as a')
                ->leftJoin('channels as c', 'c.chan_id', '=', 'a.chan_parent_id')
                ->where('a.chan_cid',$find_adm['adm_cid'])
                ->where('a.chan_state',1)
                ->where(function($query) use($find_adm) {
                    if ($find_adm['adm_chan_id'] > 0) {
                        $query->where('a.chan_parent_id', $find_adm['adm_chan_id']);
                    }
                })
                ->orWhere('a.chan_id',$find_adm['adm_chan_id'])
                // ->select('chan_id','chan_enterprise_name')
                ->select('a.chan_id','c.chan_enterprise_name as parent_enterprise_name','a.chan_enterprise_name')
                ->get();
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$find_data]);
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 判断手机号是否存在
        $phone = DB::table('technician')->
                    where('tech_phone',$request['tech_phone'])->first();
        if ($phone) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'手机号已存在']);
        }

        // $identity_card = DB::table('technician')->
        //             where('tech_identity_card',$request['tech_identity_card'])->first();
        // if ($identity_card) {
        //     return response()->json(["code"=>500,'msg'=>'error','data'=>'身份证号已存在']);
        // }
        if ($adm_info['adm_chan_id']) {
            $tech_chan_id = $adm_info['adm_chan_id'];
        }else{
            $tech_chan_id = $request['tech_chan_id'];
        }
        $password = substr($request['tech_phone'], 0, 6);
        $tech_add_data = [
                'tech_cid'=>$adm_info['adm_cid'],
                'tech_chan_id'=>$tech_chan_id,
                'tech_password'=>md5(md5(trim($password.'admin'))),
                'tech_name'=>$request['tech_name'],
                'tech_phone'=>$request['tech_phone'],
                'tech_identity_card'=>$request['tech_identity_card'] ? $request['tech_identity_card'] : '',
                'tech_address'=>$request['tech_address'],
                'tech_audit_state'=>2,
                'tech_adm_id'=>$adm_info['adm_id']
            ];
        // 新增技师
        $tech_res =  DB::table('technician')->insert($tech_add_data);
        
        if ($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','新增','新增技师：'.$request['tech_name'].'成功');
            $data['tech_identity_card'] = $tech_add_data['tech_identity_card'];
            $data['tech_chan_id'] = $tech_add_data['tech_chan_id'];
            return response()->json(["code"=>200,'msg'=>'success','data'=>'新增成功', 'tech_data'=>$data]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增失败']);
        }
    }

    // 编辑渠道商
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->editValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 判断手机号是否存在
        $phone = DB::table('technician')->
                    where('tech_id','<>',$request['tech_id'])->
                    where('tech_phone',$request['tech_phone'])->first();
        if ($phone) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'手机号已存在']);
        }

        // // 判断身份证号是否存在
        // $phone = DB::table('technician')->
        //             where('tech_id','<>',$request['tech_id'])->
        //             where('tech_identity_card',$request['tech_identity_card'])->first();
        // if ($phone) {
        //     return response()->json(["code"=>500,'msg'=>'error','data'=>'身份证号已存在']);
        // }

        $tech_chan_id = $request['tech_chan_id'];
        if ($adm_info['adm_chan_id']) {
            $tech_chan_id = $adm_info['adm_chan_id'];
        }
        $password = substr($request['tech_phone'], 0,6);
        $tech_password = md5(md5(trim($password).'admin'));
        $tech_add_data = [
                'tech_phone'=>$request['tech_phone'],
                'tech_name'=>$request['tech_name'],
                'tech_updatetime'=>date('Y-m-d H:i:s'),
                'tech_adm_id'=>$adm_info['adm_id'],
                'tech_chan_id'=>$tech_chan_id,
                'tech_identity_card'=>$request['tech_identity_card'] ? $request['tech_identity_card'] : '',
                'tech_address'=>$request['tech_address'],
                'tech_adm_id'=>$adm_info['adm_id'],
                'tech_password'=>$tech_password,
            ];
        // 编辑技师
        $tech_res =  DB::table('technician')->where('tech_id',$request['tech_id'])->update($tech_add_data);
        
        if ($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','编辑','编辑技师：'.$request['tech_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑失败']);
        }
    }

    // 启用
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询手机号
        $chan_data = DB::table('technician')->whereIn('tech_id',$request['tech_id'])->select('tech_name')->get();
        foreach ($chan_data as $key => $value) {
            $phone[] = $value['tech_name'];
        }

        $update_data['tech_state'] = 1;//状态:1启用2停用
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->whereIn('tech_id',$request['tech_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','启用','启用('.implode(',', $phone).')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

    // 停用
    public function stop(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 查询手机号
        $chan_data = DB::table('technician')->whereIn('tech_id',$request['tech_id'])->select('tech_name')->get();
        foreach ($chan_data as $key => $value) {
            $phone[] = $value['tech_name'];
        }
        
        $update_data['tech_state'] = 2;//状态:1启用2停用
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->whereIn('tech_id',$request['tech_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','停用','停用('.implode(',', $phone).')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'停用成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用失败']);
        }
    }

    // 加积分
    public function addIntegral(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->integralValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询操作技师的信息
        $tech_data = DB::table('technician')->where('tech_id',$request['tech_id'])->
                    select('tech_name','tech_cid','tech_chan_id','tech_phone','tech_integral')->first();

        // 剩余积分
        $remain_integral = $tech_data['tech_integral'] + $request['integral_number'];

        DB::beginTransaction();
        // 技师积分增加
        $update_data['tech_integral'] = $remain_integral;
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->where('tech_id',$request['tech_id'])->update($update_data);

        // 添加积分操作记录
        $integral_data = [
                'inte_cid'=>$tech_data['tech_cid'],
                'inte_chan_id'=>$tech_data['tech_chan_id'],
                'inte_userid'=>$request['tech_id'],
                'inte_user_phone'=>$tech_data['tech_phone'],
                'inte_user_name'=>$tech_data['tech_name'],
                'inte_state'=>1,
                'inte_integral_number'=>$request['integral_number'],
                'inte_content'=>$request['content'],
                'inte_type'=>2,
                'inte_remain_integral'=>$remain_integral,
                'inte_operation_name'=>$adm_info['adm_name'],
                'inte_operation_id'=>$adm_info['adm_id'],
                'inte_audit_state'=>2
            ];
        $inte_res =  DB::table('integral_record')->insert($integral_data);

        if($tech_res && $inte_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','加积分', $tech_data['tech_phone'].'账号加'.$request['integral_number'].'积分成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'加积分成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'加积分失败']);
        }
    }

    // 积分兑换
    public function reduceIntegral(Request $request)
    {
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        if ($request['type'] == 1){
            $forminfo = $request->all();
            //兑换物品
            $foritems = DB::table('for_items')
                ->where(['fori_cid'=>$adm_info['adm_cid'],'fori_state'=>2])
                ->where('fori_remain_integral', '>', 0)
                ->where(function($query) use($forminfo) {
                    if (!empty($forminfo['fori_item_name'] )) {
                        $query->where('fori_item_name', 'like' , '%'.$forminfo['fori_item_name'].'%' );
                    }
                })
                ->get(['fori_id','fori_item_name','fori_integral_number','fori_number','fori_remain_integral']);
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$foritems]);
        }

        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->integralValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 查询操作技师的信息
        $tech_data = DB::table('technician')->where('tech_id',$request['tech_id'])->
                    select('tech_name','tech_cid','tech_chan_id','tech_phone','tech_integral')->first();
        // 剩余积分
        $forr = DB::table('for_items')
            ->where(['fori_id'=>$request['fori_id']])
            ->first(['fori_id','fori_item_name','fori_integral_number','fori_number','fori_remain_integral']);
        $remain_integral = $tech_data['tech_integral'] - $forr['fori_integral_number'];
        if ($remain_integral<0) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'消耗积分值超过剩余积分值']);
        }

        DB::beginTransaction();
        // 技师积分减少
        // $update_data['tech_integral'] = $remain_integral;
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->where('tech_id',$request['tech_id'])->update($update_data);
        //物品数量减少
        $update_dates['fori_remain_integral'] = $forr['fori_remain_integral'] - 1;
        $update_dates['fori_updatetime'] = date('Y-m-d H:i:s');
        $fori_res = DB::table('for_items')->where(['fori_id'=>$request['fori_id']])->update($update_dates);
        // 添加积分操作记录
        $integral_data = [
                'inte_cid'=>$tech_data['tech_cid'],
                'inte_chan_id'=>$tech_data['tech_chan_id'],
                'inte_userid'=>$request['tech_id'],
                'inte_user_phone'=>$tech_data['tech_phone'],
                'inte_user_name'=>$tech_data['tech_name'],
                'inte_state'=>2,//操作类型1增加积分2消耗积分
                'inte_integral_number'=>'-'.$forr['fori_integral_number'],
                'inte_content'=>'技师兑换['.$forr['fori_item_name'].']减少积分',
                'inte_type'=>2,
                // 'inte_remain_integral'=>$remain_integral,
                'inte_remain_integral'=>$tech_data['tech_integral'],
                'inte_operation_name'=>$adm_info['adm_name'],
                'inte_operation_id'=>$adm_info['adm_id'],
                'inte_audit_state'=>1,  //审核状态1待审核2通过3驳回
                'inte_fori_id'=>$forr['fori_id'],   //物品id
            ];
        $inte_res =  DB::table('integral_record')->insertGetId($integral_data);

        // 添加兑换记录
        $aure_data = [
                'aure_cid'=>$tech_data['tech_cid'], //公司id
                'aure_chan_id'=>$tech_data['tech_chan_id'], //渠道id
                'aure_userid'=>$request['tech_id'], //用户id
                'aure_user_phone'=>$tech_data['tech_phone'],    //联系电话
                'aure_user_name'=>$tech_data['tech_name'],  //姓名
                'aure_integral_number'=>'-'.$forr['fori_integral_number'],  //消耗积分数量
                'aure_content'=>'技师兑换['.$forr['fori_item_name'].']减少积分',    //兑换内容
                'aure_type'=>2, //1渠道积分2技师积分
                // 'aure_remain_auregral'=>$remain_integral,   //剩余积分
                'aure_remain_auregral'=>$tech_data['tech_integral'],   //剩余积分
                'aure_operation_name'=>$adm_info['adm_name'],   //操作人姓名
                'aure_operation_id'=>$adm_info['adm_id'],   //操作人id
                'aure_audit_state'=>1,  //审核状态1待审核2通过3驳回
                'aure_fori_id'=>$forr['fori_id'],   //物品id
                'aure_inte_id'=>$inte_res,   //记录id
            ];
        $aure_res = DB::table('audit_record')->insert($aure_data);

        if($tech_res && $inte_res && $fori_res && $aure_res) {
            DB::commit();
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','积分兑换', $tech_data['tech_phone'].'账号消耗'.$request['integral_number'].'积分成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'积分兑换成功']);
        }else{
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'积分兑换失败']);
        }
    }

    // 通过
    public function pass(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->passValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 查询技师信息
        $find_data = DB::table('technician')
                    ->where('tech_id',$request['tech_id'])
                    ->select('tech_name')
                    ->first();
        
        $update_data['tech_audit_state'] = 2;//状态:1待审核2已通过3已驳回
        $update_data['tech_chan_id'] = $request['tech_chan_id'];//渠道商id
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->where('tech_id',$request['tech_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','通过','通过('.$find_data['tech_name'].')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'通过成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'通过失败']);
        }
    }

    // 驳回
    public function reject(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyTechnicianController;
        $error_message = $verify_data->rejectValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        // 查询手机号
        $chan_data = DB::table('technician')->where('tech_id',$request['tech_id'])->select('tech_name')->first();
        
        $update_data['tech_audit_state'] = 3;//状态:1待审核2已通过3已驳回
        $update_data['tech_remark'] = $request['tech_remark'];//驳回备注
        $update_data['tech_updatetime'] = date('Y-m-d H:i:s');
        $tech_res =  DB::table('technician')->where('tech_id',$request['tech_id'])->update($update_data);
        if($tech_res) {
            Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'技师列表','驳回','驳回('.$chan_data['tech_name'].')账号成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'驳回成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'驳回失败']);
        }
    }
}
