<?php

namespace App\Http\Controllers\Channels;

use App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Session;
use App\Http\Models\Coperationa;

class ChannelsLabelController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    // 标签列表
    public function index(Request $request)
    {
        // 获取操作人
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $label_info = $request->all();
        $userinfo = DB::table('channels_label')
                        ->where(function($query) use($label_info) {
                            if (!empty($label_info['label_name'])) {
                                $query->where('label_name', 'like' , '%'.$label_info['label_name'].'%' );
                            }
                        })
                        ->where(function($query) use($label_info) {
                            if (!empty($label_info['label_state'])) {
                                $query->where('label_state','=',$label_info['label_state']);
                            }
                        })
                        ->where('label_cid',$find_adm['adm_cid'])
                        ->select('label_id','label_name','label_state','label_addtime','label_total')
                        ->orderBy('label_id','desc')
                        ->paginate($this->show_count);

        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $userinfo->items();                //返回数据

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 新增渠道标签
    public function add(Request $request)
    {
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));
        $input = $request->all();
        // 验证数据
        if ( empty($input['label_name']) || !in_array($input['label_state'], [1,2]) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 判断渠道标签名称是否重复
        $channels_label = DB::table('channels_label');
        $label_name = $channels_label->
                    where('label_cid',$adm_info['adm_cid'])->
                    where('label_name',$input['label_name'])->first();
        if ($label_name) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'渠道标签名称已存在']);
        }

        $add_data = [
                'label_cid'=>$adm_info['adm_cid'],
                'label_name'=>$input['label_name'],
                'label_state'=>$input['label_state']
            ];
        // 新增渠道标签
        $res =  $channels_label->insert($add_data);
        if (!$res) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增渠道标签失败']);
        }

        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','添加','添加'.$input['label_name']);
        return response()->json(["code"=>200,'msg'=>'success','data'=>'新增渠道标签成功']);
    }

    // 编辑渠道标签
    public function edit(Request $request)
    {
        $input = $request->only('label_name','label_state','edit_id');
        // 验证数据
        if ( empty($input['label_name']) || !in_array($input['label_state'], [1,2]) || !is_numeric($input['edit_id']) ) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        $save_data['label_name'] = $input['label_name'];
        $save_data['label_state'] = $input['label_state'];
        $save_data['label_edittime'] = date('Y-m-d H:i:s');
        $res = DB::table('channels_label')->where('label_id', '=', $input['edit_id'])->update($save_data);

        if (!$res) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','编辑','编辑'.$input['label_name']);
        return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑渠道标签成功']);
    }

    // 启用标签
    public function start(Request $request)
    {
        $label_id = $request['edit_id'];
        if(empty($label_id) || !is_array($label_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询渠道标签名称
        $label_data = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name')->get();
        $label_name = '';
        foreach ($label_data as $key => $value) {
            $label_name .= $value['label_name'].',';
        }

        $update_data['label_state'] = 1;//状态:1启用2停用
        $update_data['label_edittime'] = date('Y-m-d H:i:s');
        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->update($update_data);
        if(!$res) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'启用渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','启用','启用('.trim($label_name,',').')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'启用渠道标签成功']);
    }

    // 停用标签
    public function stop(Request $request)
    {
        $label_id = $request['edit_id'];
        if(empty($label_id) || !is_array($label_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }

        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询渠道标签名称
        $label_data = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name')->get();
        $label_name = '';
        foreach ($label_data as $key => $value) {
            $label_name .= $value['label_name'].',';
        }

        $update_data['label_state'] = 2;//状态:1启用2停用
        $update_data['label_edittime'] = date('Y-m-d H:i:s');
        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->update($update_data);
        if(!$res) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用渠道标签失败']);
        }

        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','停用','停用('.trim($label_name,',').')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'停用渠道标签成功']);
    }

    // 删除标签
    public function delete(Request $request)
    {
        $label_id = $request['del_id'];
        if(empty($label_id) || !is_array($label_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取当前操作账号
        $adm_info = Coperationa::getUserInfo($request->input('api_token'));

        // 查询渠道标签名称
        $label_data = DB::table('channels_label')->whereIn('label_id',$label_id)->select('label_name','label_total')->get();
        $label_name = '';
        foreach ($label_data as $key => $value) {
            if ($value['label_total'] > 0) {
                return response()->json(["code"=>500,'msg'=>'error','data'=>'下属渠道商数量不为0，不允许删除']);
            }
            $label_name .= $value['label_name'].',';
        }

        $res = DB::table('channels_label')->whereIn('label_id',$label_id)->delete();
        if(!$res){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'删除渠道标签失败']);
        }
        Coperationa::add($adm_info['adm_id'],$request->getClientIp(),'渠道标签','删除','删除('.$label_name.')渠道标签');
        return response()->json(["code"=>200,'msg'=>'success','data'=>'删除渠道标签成功']);
    }
}
