<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Crypt;
use Illuminate\Support\Facades\Storage;
use Session;
use App\Http\Models\Coperationa;
class AdminController extends Controller
{

    // 列表每页显示数据个数
    protected $show_count = 10;
    // 账号列表
    public function index(Request $request)
    {
        $admin_info = $request->all();
        if (empty($request->input('pri_id')) || !is_numeric($request->input('pri_id'))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }

        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        $roleinfo = DB::table('role')
                            ->select('rol_name','rol_id')
                            ->where('rol_sta','=',1)
                            ->where('rol_cid',$find_adm['adm_cid'])
                            ->orWhere('rol_cid',0)
                            ->where('rol_chan_id',$find_adm['adm_chan_id'])
                            ->where('rol_creator',$find_adm['adm_id'])
                            ->get();
        $userinfo = DB::table('admin as a')
                        ->leftjoin('role as r', 'r.rol_id', '=', 'a.adm_pre')
                        ->where('a.adm_cid',$find_adm['adm_cid'])
                        ->where('a.adm_chan_id',$find_adm['adm_chan_id'])
                        ->where(function($query) use($admin_info) {
                            if (!empty($admin_info['adm_name'] )) {
                                $query->where('a.adm_name', 'like' , '%'.$admin_info['adm_name'].'%' );
                            }
                        })
                        ->where(function($query) use($admin_info) {
                            if (!empty($admin_info['adm_acc'] )) {
                                $query->where('a.adm_acc', 'like' , '%'.$admin_info['adm_acc'].'%' );
                            }
                        })
                        ->where(function($query) use($admin_info) {
                            if (!empty($admin_info['adm_mobile'] )) {
                                $query->where('a.adm_mobile', 'like' , '%'.$admin_info['adm_mobile'].'%' );
                            }
                        })
                        ->where(function($query) use($admin_info) {
                            if (!empty($admin_info['adm_stase'] )) {
                                $query->where('a.adm_stase','=',$admin_info['adm_stase']);
                            }
                        })
                        ->where(function($query) use($admin_info) {
                            if (!empty($admin_info['rol_name'] )) {
                                $query->where('a.adm_pre','=',$admin_info['rol_name']);
                            }
                        })
                        ->select('a.adm_id','a.adm_name','a.adm_acc','r.rol_name','a.adm_stase','a.adm_creator','a.adm_mobile','a.adm_pre','adm_account_type')
                        ->orderBy('a.adm_id','desc')
                        ->paginate($this->show_count);

        $data_info['current_page'] = $userinfo->currentPage();  //当前页面页码
        $data_info['last_page'] = $userinfo->lastPage();        //表示最后一页的页码
        $data_info['total'] = $userinfo->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['adm_leave'] = 1;                            //当前账号管理级别
        $data_info['data'] = $userinfo->items();                //返回数据
        $data_info['role'] = $roleinfo;                         //返回数据

        // 动态获取操作人姓名
        if($data_info['data'])
        {
            foreach($data_info['data'] as $k=>$v)
            {
                $adm_creator[] = $v['adm_creator'];
            }
            $adm_creator = DB::table('admin')
                ->whereIn('adm_id',$adm_creator)
                ->select('adm_id','adm_name')
                ->get();

            foreach($data_info['data'] as $k=>$v)
            {
                foreach($adm_creator as $key=>$value)
                {
                    if($v['adm_creator'] == $adm_creator[$key]['adm_id'])
                    {
                        $data_info['data'][$k]['adm_creator'] = $adm_creator[$key]['adm_name'];
                    }
                }
            }
        }
        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);

        if($data_info){
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'账号列表获取成功','data_info'=>$data_info,'button'=>$button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'账号列表获取失败']);
        }
    }

    public function get_roleinfo(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $roleinfo = DB::table('role')
            ->where('rol_sta',1)
            ->where('rol_cid',$find_adm['adm_cid'])
            ->orWhere('rol_cid',0)
            ->where(function($query) use($request) {
                if (!empty($request['keywords'] )) {
                    $query->where('rol_name', 'like' , '%'.$data['keywords'].'%' );
                }
            })
            ->where('rol_chan_id',$find_adm['adm_chan_id'])
            ->where('rol_creator',$find_adm['adm_id'])
            ->select('rol_name','rol_id')
            ->get();
        return response()->json(['code'=> 200,'msg'=>'success','data'=>'角色列表','roleinfo'=>$roleinfo]);
    }

    // 添加账号
    public function addadmin(Request $request)
    {
        // 获取当前操作账号
        $adm_creator = Coperationa::getUserInfo($request->input('api_token'));

        $input = $request->only('adm_name','adm_acc','adm_mobile','adm_pre','adm_stase','adm_pas','adm_account_type');
        $adm_endtime = '0';     //到期时间
        $adm_leave = '2';       //管理级别

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$input['adm_pas'])){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }
        $phone_preg = "/^1[345768]\d{9}$/";
        if(!preg_match($phone_preg,$input['adm_mobile'])){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'手机号不合法！']);
        }

        $adm_pas = md5(md5(trim($input['adm_pas'].'admin')));
        // 判断是否有登录账号
        $adm_acc = DB::table('admin')
                    ->where('adm_cid',$adm_creator['adm_cid'])
                    ->where('adm_type',$adm_creator['adm_type'])
                    ->where('adm_acc',$request['adm_acc'])
                    ->value('adm_acc');
        if ($adm_acc) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'登录账号已存在']);
        }
        // 判断手机号是否存在
        $admin = DB::table('admin');
        $phone = $admin->where('adm_mobile',$input['adm_mobile'])->first();
        if ($phone) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'手机号已存在']);
        }
        $adm_chan_type = $adm_creator['adm_chan_id'] ? 2 : 0;
        $res =  DB::table('admin')->insert([
                                'adm_name'           => $input['adm_name'],         //员工姓名
                                'adm_leave'          => $adm_leave,                 //管理级别
                                'adm_cid'            => $adm_creator['adm_cid'],    //所属企业
                                'adm_chan_id'        => $adm_creator['adm_chan_id'],    //所属渠道商
                                'adm_chan_type'      => $adm_chan_type,    //所属渠道类型
                                'adm_acc'            => $input['adm_acc'],          //用户名
                                'adm_pas'            => $adm_pas,                   //用户密码
                                'adm_mobile'         => $input['adm_mobile'],       //联系电话
                                'adm_pre'            => $input['adm_pre'],          //角色
                                'adm_stase'          => 1,                          //状态
                                'adm_creator'        => $adm_creator['adm_id'],     //操作人
                                'adm_account_type'   => $input['adm_account_type'], //操作类型
                                'adm_identifies'     => $request['adm_identifies'], //身份标识
                                'adm_flow'           => 3,                          
                                'adm_nature'         => 2,                          //付费
                                'adm_payment_status' => 2,
                                'adm_types' => 1
                                ]);
        if($res) {
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'新增账号','新增','新增'.$input['adm_name']);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'添加账号成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'添加账号失败']);
        } 
    }

    // 编辑账号
    public function editadmin(Request $request)
    {
        $adm_id = $this->where_admid($request['api_token']);
        $input = $request->only('adm_id','adm_mobile','adm_name','adm_pre','adm_stase','adm_account_type','adm_acc');

        if($input['adm_id'] == 1) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'root账号不能被编辑']);
        }
        if (empty($input['adm_id'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'缺少参数']);
        }
        // 检测手机号
        $phone_preg = "/^1[345768]\d{9}$/";
        if(!preg_match($phone_preg,$input['adm_mobile'])){
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'手机号不合法！']);
        }
        $find_phone = DB::table('admin')
            ->where('adm_id', '!=', $input['adm_id'])
            ->where('adm_mobile', $input['adm_mobile'])
            ->exists();
        if ($find_phone) {
            return response()->json(['code'=> 500,'msg'=>'手机号已存在！','data'=>'手机号已存在！']);
        }

        $find_adm_acc = DB::table('admin')
            ->where('adm_id', '!=', $input['adm_id'])
            ->where('adm_acc', $input['adm_acc'])
            ->exists();
        if ($find_adm_acc) {
            return response()->json(['code'=> 500,'msg'=>'用户名已存在！','data'=>'用户名已存在！']);
        }

        $update_data['adm_name'] = $input['adm_name'];  //员工姓名
        $update_data['adm_mobile'] = $input['adm_mobile'];        //联系电话
        $update_data['adm_acc'] = $input['adm_acc'];           //用户名
        $update_data['adm_pre'] = $input['adm_pre'];           //角色权限
        $update_data['adm_creator'] = $adm_id['adm_id'];
        $update_data['adm_account_type'] = $input['adm_account_type'];   //登录设备
        $update_data['update_time'] = date('Y-m-d H:i:s');  //修改时间

        $res = DB::table('admin')
            ->where('adm_id',$input['adm_id'])
            ->update($update_data);

        if($res) {
            Coperationa::add($adm_id['adm_id'],$request->getClientIp(),'编辑账号','编辑','编辑'.$input['adm_name']);
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑账号成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑账号失败']);
        }
    }

    // 启用账号
    public function startstase(Request $request)
    {
        $adm_creator = $this->where_admid($request['api_token']);
        $adm_id = $request['adm_id'];
        $update_data['adm_stase'] = 1;
        $update_data['update_time'] = date('Y-m-d H:i:s');
        $adm_name = DB::table('admin')
            ->whereIn('adm_id',$adm_id)
            ->select('adm_name')
            ->get();
        foreach($adm_name as $k=>$v) {
            $name[] = $v['adm_name'];
        }
        $name = implode($name,',');

        $res = DB::table('admin')
            ->whereIn('adm_id',$adm_id)
            ->update($update_data);
        if($res) {
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'启用账号','启用',"启用(".$name.")账号");
            return response()->json(["code"=>200,'msg'=>'success','data'=>'开启账号成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'开启账号失败']);
        }
    }
    // 停用账号
    public function shopstase(Request $request)
    {
        $adm_creator = $this->where_admid($request['api_token']);
        $adm_id = $request['adm_id'];

        if(in_array(1,$adm_id)) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'root账号不能被停用']);
        }
        $adm_names = DB::table('admin')
            ->where('adm_id',$adm_id)
            ->value('adm_id');
        if ($adm_names == $adm_creator['adm_id']) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'当前登录的账号无法停用']);
        }
        $adm_name = DB::table('admin')
            ->whereIn('adm_id',$adm_id)
            ->select('adm_name')
            ->get();
        foreach($adm_name as $k=>$v) {
            $name[] = $v['adm_name'];
        }
        $name = implode($name,',');

        $update_data['adm_stase'] = 2;
        $update_data['update_time'] = date('Y-m-d H:i:s');

        $res = DB::table('admin')
            ->whereIn('adm_id',$adm_id)
            ->update($update_data);
        if($res) {
            Coperationa::add($adm_creator['adm_id'],$request->getClientIp(),'停用账号','停用',"停用(".$name.")账号");
            return response()->json(["code"=>200,'msg'=>'success','data'=>'停用账号成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'停用账号失败']);
        }
    }
    // 用户列表重置密码
    public function resetpwd(Request $request)
    {
        $adm_id = $request['adm_id'];
        $password = 111111;
        $update_data['adm_pas'] = md5(md5($password.'admin'));
        $update_data['update_time'] = date('Y-m-d H:i:s');

        $res = DB::table('admin')
            ->where('adm_id',$adm_id)
            ->update($update_data);
        if ($res) {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'重置密码成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'与原密码相同,无需重置']);
        }
    }

    // 个人中心接口
    public function personal(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $admin = DB::table('login_temporary as lt')
            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
            ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'a.adm_cid')
            ->where('lt.api_token','=',$api_token)
            ->select('a.adm_acc','a.adm_name','a.adm_mobile','a.adm_leave','adm_endtime','com_expiretime','adm_pre','c.com_name','c.com_logo','ci.info_address','ci.info_telephone','ci.info_license','c.com_id','a.adm_module','c.is_agent')
            ->first();
$admin['adm_endtime']=$admin['com_expiretime'];
        // $service_price = DB::table('role')->where("rol_id",trim($admin['adm_pre']))->sum('rol_price');
        $service_price = DB::table('role')->where("rol_id",trim($admin['adm_module']))->sum('rol_price');

        // 获取当前列表下的按钮
        $button = wherebutton($request['api_token'],$request['pri_id']);
        if($admin){
            return response()->json(["code"=>200, 'msg'=>'success', 'data'=>'个人及公司信息获取成功', 'admin'=>$admin, 'service_price'=>$service_price, 'button'=>$button]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'个人及公司信息获取失败']);
        }
    }

    // 个人中心修改公司logo
    function editlogo(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        if(!empty($request['logophoto']))
        {
            $image = $request['logophoto'];
            $imageName = "LOGO_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $upload_files = $_SERVER['DOCUMENT_ROOT'].'/public/';

            $path = "uploads/logo/".date("Ymd",time());
            // 获取原logo文件名
            $oldphoto = DB::table('login_temporary as lt')
                ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
                ->where('lt.api_token','=',$api_token)
                ->select('c.com_logo','c.com_id')
                ->first();


            if (!is_dir($path)){ //判断目录是否存在 不存在就创建
                mkdir($path,0777,true);
            }
            $imageSrc=  $path."/". $imageName;  //图片名字
            if(is_file($upload_files.$oldphoto['com_logo']))
            {
                // 修改新logo文件名
                $newphoto = DB::table('company')
                            ->where('com_id','=',$oldphoto['com_id'])
                            ->update(['com_logo'=>$imageSrc]);
                // 修改原图片权限
                chmod($upload_files.$oldphoto['com_logo'],0777);
                // 删除原图片
                unlink($upload_files.$oldphoto['com_logo']); 
            }else{
                $newphoto = DB::table('company')
                            ->where('com_id','=',$oldphoto['com_id'])
                            ->update(['com_logo'=>$imageSrc]);
            }
            file_put_contents($upload_files.$imageSrc, base64_decode($image));//返回的是字节数
            return response()->json(["code"=>200,'msg'=>'success','data'=>'上传logo成功','path'=>$imageSrc]);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'还未选择logo']);
        }
    }

    // 个人中心修改公司内容
    public function companyedit(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $input = $request->only('com_name','info_telephone','info_address','info_license');
        $company = DB::table('login_temporary as lt')
            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
            ->leftjoin('company as c', 'c.com_id', '=', 'a.adm_cid')
            ->leftjoin('company_info as ci', 'ci.info_cid', '=', 'a.adm_cid')
            ->where('lt.api_token','=',$api_token)
            ->update(['c.com_name'=>$input['com_name'],'ci.info_telephone'=>$input['info_telephone'],'ci.info_address'=>$input['info_address'],'c.com_updatetime'=>date('Y-m-d H:i:s')]);
        if($company) {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'公司信息修改成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'公司信息修改失败']);
        }
    }

    // 个人中心原密码确认
    public function oldpwd(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $input = $request->only('old_pwd');
        $adm_pas = DB::table('login_temporary as lt')
            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
            ->where('lt.api_token','=',$api_token)
            ->select('a.adm_pas')
            ->first();

        $old_pwd = md5(md5(trim($input['old_pwd']).'admin'));
        if($old_pwd !== $adm_pas['adm_pas']) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'原密码错误']);
        } else {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'原密码正确']);
        }      
    }
    //个人中心新密码确认
    public function newpwd(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $input = $request->only('new_password','renew_password');

        if(trim($input['new_password']) !== trim($input['renew_password'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'两次密码输入不一致']);
        }

        $pwd_preg='/^[\w\_]{6,15}$/u';
        if(!preg_match($pwd_preg,$input['new_password'])) {
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'密码由6-15位数字或字母,或下划线组成！']);
        }

        $new_password = md5(md5(trim($input['new_password']).'admin'));
    
        $res = DB::table('login_temporary as lt')
                            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                            ->where('lt.api_token','=',$api_token)
                            ->update(['a.adm_pas'=>$new_password]);
        if($res) {
            DB::table('login_temporary')->where('api_token',$api_token)->delete();
            return response()->json(["code"=>200,'msg'=>'success','data'=>'密码修改成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'密码修改失败']);
        }
    }

    // 个人中心修改当前账号资料
    public function personaledit(Request $request)
    {
        try{
            $api_token = Crypt::decrypt($request['api_token']);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }

        $input = $request->only('adm_name','adm_mobile');
        $personal = DB::table('login_temporary as lt')
                            ->leftjoin('admin as a', 'lt.adm_id', '=', 'a.adm_id')
                            ->where('lt.api_token','=',$api_token)
                            ->update(['a.adm_name'=>$input['adm_name'],'a.adm_mobile'=>$input['adm_mobile'],'lt.adm_name'=>$input['adm_name']]);
        if($personal) {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'个人信息修改成功']);
        } else {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'个人信息修改失败']);
        }
    }

    // 更改电话--原有电话验证
    public function agoTel(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));

        if (!in_array($request->input('type'),array(1,2,3))) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
        }
        // 获取到原有电话
        if($request->input('type') == 1){
            $ago_tel = DB::table('admin')
                    ->where('adm_id',$find_adm['adm_id'])
                    ->first(['adm_mobile']);
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'原有电话获取成功','data_info'=>$ago_tel]);
        }

        // 原有手机号获取验证码
        if($request->input('type') == 2){
            // 验证数据
            if (empty($request->input('phone'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入手机号']);
            }
            $ago_tel = DB::table('admin')
                    ->where('adm_id',$find_adm['adm_id'])
                    ->first(['adm_mobile']);
            if($request->input('phone') != $ago_tel['adm_mobile']){
                return response()->json(['code'=> 500,'msg'=>'error','data'=>'请输入正确的原有电话']);
            }


            $code = mt_rand(1000, 9999);//生成四位验证码
            $message = "您注册的\"云溯源管理系统\"账号的验证码为{$code}，十分钟内有效。";//短信信息
            $this->sendSmsCode($request->input('phone'),$message);//发送短信
            DB::table('telcode')->insert(['tel_phone'=> $request->input('phone'),'tel_code'=>$code]);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '发送成功']);
        }

        // 比对验证码
        if($request->input('type') == 3){
            // 验证数据
            if (empty($request->input('phone'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入手机号']);
            }
            if (empty($request->input('code'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'请输入验证码']);
            }
            $tel = DB::table('telcode')
                    ->where('tel_phone',"=",$request->input('phone'))
                    ->orderBy('tel_id','desc')
                    ->first(['tel_created_at','tel_code']);
            // var_dump($tel);
            // $tel = $this->objectToArray($tel);
            // var_dump($tel);exit;
            $code_time = strtotime($tel['tel_created_at']);
            if($code_time < time()-600){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码超时']);
            }
            if($tel['tel_code'] != $request->input('code')){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码错误']);
            }
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '手机验证码正确']);
        }
    }

    // 更改电话--新手机号验证
    public function newTel(Request $request)
    {
        // 新手机号获取验证码
        if($request->input('type') == 1){
            // 验证数据
            if (empty($request->input('phone'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            // 验证手机号的正确性     
            if(!preg_match("/^1[345678]{1}\d{9}$/",$request->input('phone'))){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '请输入正确的手机号']);
            }
            $is_tel = DB::table('admin')
                    ->where('adm_mobile',$request->input('phone'))
                    ->first();
            if($is_tel){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '该手机号已经注册过,请更换手机号']);
            }
            $code = mt_rand(1000, 9999);//生成四位验证码
            $message = "您注册的\"云溯源管理系统\"账号的验证码为{$code}，十分钟内有效。";//短信信息
            $this->sendSmsCode($request->input('phone'),$message);//发送短信
            DB::table('telcode')->insert(['tel_phone'=> $request->input('phone'),'tel_code'=>$code]);
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => '发送成功']);
        }

        // 比对验证码
        if($request->input('type') == 2){
            // 验证数据
            if (empty($request->input('phone')) || empty($request->input('code'))) {
                return response()->json(['code'=>500,'msg'=>'error','data'=>'参数错误']);
            }
            $tel = DB::table('telcode')
                    ->where('tel_phone',"=",$request->input('phone'))
                    ->orderBy('tel_id','desc')
                    ->first(['tel_created_at','tel_code']);
            // $tel = $this->objectToArray($tel);
            $code_time = strtotime($tel['tel_created_at']);
            if($code_time < time()-600){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码超时']);
            }
            if($tel['tel_code'] != $request->input('code')){
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机验证码错误']);
            }
            // 验证码正确，将admin中的联系电话修改
            $find_adm = Coperationa::getUserInfo($request->input('api_token'));
            $update_admin = DB::table('admin')
                    ->where('adm_id',$find_adm['adm_id'])
                    ->update(['adm_mobile'=>$request->input('phone'),'adm_acc'=>$request->input('phone')]);
            if($update_admin){
               Coperationa::add($find_adm['adm_id'],$request->getClientIp(),'个人中心','修改密码','“'.$find_adm['adm_mobile'].'”更换手机号为'.$request->input('phone').'成功');
                return response()->json(['code' => 200, 'msg' => 'success', 'data' => '手机号更换成功']);
            }else{
                return response()->json(['code' => 500, 'msg' => 'error', 'data' => '手机号更换失败']);
            }  
        }
    }

    // 获取验证码接口
    private function sendSmsCode($mobile, $content)
    {
        $username = "lksy";
        $pwd = "19r1rt22";
        $password = md5($username . "" . md5($pwd));

        $url = "http://www1.jc-chn.cn/smsSend.do?";

        $param = http_build_query(
            array(
                'username' => $username,
                'password' => $password,
                'mobile' => $mobile,
                // 'content'=>iconv("GB2312","UTF-8",$content)
                'content' => $content
            )
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    // 交易记录
    public function order(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        $adm_id = $this->where_admid($request['api_token']);
        $order = DB::table('order')
                ->leftjoin('admin as a','a.adm_id','=','order.order_adm_id')
                ->where('adm_cid',$find_adm['adm_cid'])
                ->selectRaw('order_id,order_no,order_valid,order_money,created_at,payment_at,order_status')
                ->orderBy('payment_at','desc')
                ->paginate($this->show_count);
        $data_info['current_page'] = $order->currentPage();  //当前页面页码
        $data_info['last_page'] = $order->lastPage();        //表示最后一页的页码
        $data_info['total'] = $order->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['adm_leave'] = 1;                            //当前账号管理级别
        $data_info['data'] = $order->items();                //返回数据
        if($data_info)
        {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>'交易记录获取成功','data_info'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'交易记录获取失败']);
        }
    }
    // 索要发票
    public function invoice(Request $request)
    {
        $find_adm = Coperationa::getUserInfo($request->input('api_token'));
        DB::beginTransaction(); //开启事务
        $invoice = DB::table('invoice')->insert([
                                            'invoice_price'            => $request['invoice_price'],            //金额
                                            'invoice_type'             => $request['invoice_type'],             //开票类型
                                            'invoice_company_name'     => $request['invoice_company_name'],     //公司名称
                                            'invoice_number'           => $request['invoice_number'],           //统一社会代码证
                                            'invoice_bank_info'        => $request['invoice_bank_info'],        //开户行
                                            'invoice_bank_card'        => $request['invoice_bank_card'],        //开户行卡号
                                            'invoice_phone'            => $request['invoice_phone'],            //联系电话
                                            'invoice_register_address' => $request['invoice_register_address'], //注册地址
                                            'invoice_addressee_name'   => $request['invoice_addressee_name'],   //收件人
                                            'invoice_addressee_phone'  => $request['invoice_addressee_phone'],  //联系电话
                                            'invoice_address'          => $request['invoice_address'],          //收件地址
                                            'invoice_order_id'         => $request['order_id']
                                            ]);
        $order = DB::table('order')->where(['order_id' => $request['order_id']])->update(['order_status' => 2, 'order_invoice' => 1]);
        $admin = DB::table('admin')->where('adm_id',$find_adm['adm_id'])->update(['adm_flow'=>4]);
        if($invoice && $order && $admin)
        {
            DB::commit();  //提交
            return response()->json(["code"=>200,'msg'=>'success','data'=>'您的资料提交成功']);
        }else{
            DB::rollback();  //回滚
            return response()->json(["code"=>500,'msg'=>'error','data'=>'您的资料提交失败']);
        }
    }
    // 查看资料
    public function checkingdata(Request $request)
    {
        if (empty($request['order_id'])) {
            return response()->json(['code'=>500,'msg'=>'error','data'=>"参数错误"]);
        }
        $invoice = DB::table('invoice')
                    ->where('invoice_order_id',$request['order_id'])
                    ->selectRaw('invoice_id,invoice_type,invoice_company_name,invoice_bank_info,invoice_bank_card,invoice_phone,invoice_register_address,invoice_addressee_name,invoice_addressee_phone,invoice_address,invoice_number,invoice_price')->first();
        return response()->json(['code'=>200,'msg'=>'success','data'=>$invoice]);
    }
    // 修改资料
    public function editInvoice(Request $request){
        if ($request['type'] == '1') {
            $invoice = DB::table('invoice')->selectRaw('invoice_id,invoice_type,invoice_company_name,invoice_bank_info,invoice_bank_card,invoice_phone,invoice_register_address,invoice_addressee_name,invoice_addressee_phone,invoice_address,invoice_number,invoice_price');
            return response()->json(['code'=>200,'msg'=>'success','data'=>$invoice]);
        }
        $editinvoices = DB::table('invoice')
                        ->where('invoice_order_id',$request['order_id'])
                        ->update([
                            'invoice_price'            => $request['invoice_price'],            //金额
                            'invoice_type'             => $request['invoice_type'],             //开票类型
                            'invoice_company_name'     => $request['invoice_company_name'],     //公司名称
                            'invoice_number'           => $request['invoice_number'],           //统一社会代码证
                            'invoice_bank_info'        => $request['invoice_bank_info'],        //开户行
                            'invoice_bank_card'        => $request['invoice_bank_card'],        //开户行卡号
                            'invoice_phone'            => $request['invoice_phone'],            //联系电话
                            'invoice_register_address' => $request['invoice_register_address'], //注册地址
                            'invoice_addressee_name'   => $request['invoice_addressee_name'],   //收件人
                            'invoice_addressee_phone'  => $request['invoice_addressee_phone'],  //联系电话
                            'invoice_address'          => $request['invoice_address'],          //收件地址
                            ]);
        if($editinvoices)
        {
            return response()->json(["code"=>200,'msg'=>'success','data'=>'您的资料提交成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'您的资料提交失败']);
        }
    }
    // 查看发票
    public function viewinvoice(Request $request)
    {
        if (empty($request['order_id'])) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'参数错误']);
        }
        $viewinvoices = DB::table('order as ord')
                        ->leftjoin('invoice as inv','inv.invoice_order_id','=','ord.order_id')
                        ->where('order_id',$request['order_id'])
                        ->selectRaw('order_id,order_no,invoice_price,invoice_type')
                        ->first();
        return response()->json(['code'=>200,'msg'=>'success','data'=>$viewinvoices]);
    }
    public function where_admid($api_token)
    {
        try{
            $api_token = Crypt::decrypt($api_token);
        }catch (\Exception $e){
            return response()->json(["code"=>500,'msg'=>'error','data'=>'非法api_token']);
        }
        $adm_id = DB::table('login_temporary')
                            ->where('api_token','=',$api_token)
                            ->select('adm_id')
                            ->first();
        return $adm_id;
    }
}
